/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class YesNoCancelDialog
extends Dialog
implements ActionListener,
KeyListener {
    private Button yesB;
    private Button noB;
    private Button cancelB;
    private boolean cancelPressed;
    private boolean yesPressed;
    private boolean firstPaint = true;

    public YesNoCancelDialog(Frame frame, String string, String string2) {
        super(frame, string, true);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 10, 10));
        MultiLineLabel multiLineLabel = new MultiLineLabel(string2);
        multiLineLabel.setFont(new Font("Dialog", 0, 12));
        panel.add(multiLineLabel);
        this.add("North", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout(2, 15, 8));
        if (IJ.isMacintosh() && string2.startsWith("Save")) {
            this.yesB = new Button("  Save  ");
            this.noB = new Button("Don't Save");
            this.cancelB = new Button("  Cancel  ");
        } else {
            this.yesB = new Button("  Yes  ");
            this.noB = new Button("  No  ");
            this.cancelB = new Button(" Cancel ");
        }
        this.yesB.addActionListener(this);
        this.noB.addActionListener(this);
        this.cancelB.addActionListener(this);
        this.yesB.addKeyListener(this);
        this.noB.addKeyListener(this);
        this.cancelB.addKeyListener(this);
        if (IJ.isMacintosh()) {
            panel.add(this.noB);
            panel.add(this.cancelB);
            panel.add(this.yesB);
            this.setResizable(false);
        } else {
            panel.add(this.yesB);
            panel.add(this.noB);
            panel.add(this.cancelB);
        }
        this.add("South", panel);
        this.pack();
        GUI.center(this);
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelB) {
            this.cancelPressed = true;
        } else if (actionEvent.getSource() == this.yesB) {
            this.yesPressed = true;
        }
        this.closeDialog();
    }

    public boolean cancelPressed() {
        return this.cancelPressed;
    }

    public boolean yesPressed() {
        return this.yesPressed;
    }

    void closeDialog() {
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        IJ.setKeyDown(n);
        if (n == 10 || n == 89 || n == 83) {
            this.yesPressed = true;
            this.closeDialog();
        } else if (n == 78 || n == 68) {
            this.closeDialog();
        } else if (n == 27 || n == 67) {
            this.cancelPressed = true;
            this.closeDialog();
            IJ.resetEscape();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        IJ.setKeyUp(n);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.firstPaint) {
            this.yesB.requestFocus();
            this.firstPaint = false;
        }
    }
}

