/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.VirtualStack;
import java.io.InputStream;

public class FileInfo
implements Cloneable {
    public static final int GRAY8 = 0;
    public static final int GRAY16_SIGNED = 1;
    public static final int GRAY16_UNSIGNED = 2;
    public static final int GRAY32_INT = 3;
    public static final int GRAY32_FLOAT = 4;
    public static final int COLOR8 = 5;
    public static final int RGB = 6;
    public static final int RGB_PLANAR = 7;
    public static final int BITMAP = 8;
    public static final int ARGB = 9;
    public static final int BGR = 10;
    public static final int GRAY32_UNSIGNED = 11;
    public static final int RGB48 = 12;
    public static final int GRAY12_UNSIGNED = 13;
    public static final int GRAY24_UNSIGNED = 14;
    public static final int BARG = 15;
    public static final int GRAY64_FLOAT = 16;
    public static final int RGB48_PLANAR = 17;
    public static final int ABGR = 18;
    public static final int UNKNOWN = 0;
    public static final int RAW = 1;
    public static final int TIFF = 2;
    public static final int GIF_OR_JPG = 3;
    public static final int FITS = 4;
    public static final int BMP = 5;
    public static final int DICOM = 6;
    public static final int ZIP_ARCHIVE = 7;
    public static final int PGM = 8;
    public static final int IMAGEIO = 9;
    public static final int COMPRESSION_UNKNOWN = 0;
    public static final int COMPRESSION_NONE = 1;
    public static final int LZW = 2;
    public static final int LZW_WITH_DIFFERENCING = 3;
    public static final int JPEG = 4;
    public static final int PACK_BITS = 5;
    public static final int ZIP = 6;
    public int fileFormat = 0;
    public int fileType = 0;
    public String fileName = "Untitled";
    public String directory = "";
    public String url = "";
    public int width;
    public int height;
    public int offset = 0;
    public int nImages = 1;
    public int gapBetweenImages;
    public boolean whiteIsZero;
    public boolean intelByteOrder;
    public int compression = 1;
    public int[] stripOffsets;
    public int[] stripLengths;
    public int rowsPerStrip;
    public int lutSize;
    public byte[] reds;
    public byte[] greens;
    public byte[] blues;
    public Object pixels;
    public String debugInfo;
    public String[] sliceLabels;
    public String info;
    public InputStream inputStream;
    public VirtualStack virtualStack;
    public double pixelWidth = 1.0;
    public double pixelHeight = 1.0;
    public double pixelDepth = 1.0;
    public String unit;
    public int calibrationFunction;
    public double[] coefficients;
    public String valueUnit;
    public double frameInterval;
    public String description;
    public long longOffset;
    public int[] metaDataTypes;
    public byte[][] metaData;
    public double[] displayRanges;
    public byte[][] channelLuts;
    public byte[] roi;
    public byte[][] overlay;
    public int samplesPerPixel = 1;
    public String openNextDir;
    public String openNextName;

    public final long getOffset() {
        return this.longOffset > 0L ? this.longOffset : (long)this.offset & 0xFFFFFFFFL;
    }

    public int getBytesPerPixel() {
        switch (this.fileType) {
            case 0: 
            case 5: 
            case 8: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                return 4;
            }
            case 6: 
            case 7: 
            case 10: {
                return 3;
            }
            case 12: 
            case 17: {
                return 6;
            }
            case 16: {
                return 8;
            }
        }
        return 0;
    }

    public String toString() {
        return "name=" + this.fileName + ", dir=" + this.directory + ", url=" + this.url + ", width=" + this.width + ", height=" + this.height + ", nImages=" + this.nImages + ", type=" + this.getType() + ", format=" + this.fileFormat + ", offset=" + this.getOffset() + ", whiteZero=" + (this.whiteIsZero ? "t" : "f") + ", Intel=" + (this.intelByteOrder ? "t" : "f") + ", lutSize=" + this.lutSize + ", comp=" + this.compression + ", ranges=" + (this.displayRanges != null ? "" + this.displayRanges.length / 2 : "null") + ", samples=" + this.samplesPerPixel;
    }

    private String getType() {
        switch (this.fileType) {
            case 0: {
                return "byte";
            }
            case 1: {
                return "short";
            }
            case 2: {
                return "ushort";
            }
            case 3: {
                return "int";
            }
            case 11: {
                return "uint";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "byte+lut";
            }
            case 6: {
                return "RGB";
            }
            case 7: {
                return "RGB(p)";
            }
            case 12: {
                return "RGB48";
            }
            case 8: {
                return "bitmap";
            }
            case 9: {
                return "ARGB";
            }
            case 18: {
                return "ABGR";
            }
            case 10: {
                return "BGR";
            }
            case 15: {
                return "BARG";
            }
            case 16: {
                return "double";
            }
            case 17: {
                return "RGB48(p)";
            }
        }
        return "";
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

