/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.VirtualStack;
import ij.io.FileInfo;
import ij.process.ImageProcessor;
import java.io.IOException;
import java.io.OutputStream;

public class ImageWriter {
    private FileInfo fi;
    private boolean showProgressBar = true;

    public ImageWriter(FileInfo fileInfo) {
        this.fi = fileInfo;
    }

    private void showProgress(double d) {
        if (this.showProgressBar) {
            IJ.showProgress(d);
        }
    }

    void write8BitImage(OutputStream outputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = this.fi.width * this.fi.height;
        int n3 = 8192;
        while (n < n2) {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            outputStream.write(byArray, n, n3);
            this.showProgress((double)(n += n3) / (double)n2);
        }
    }

    void write8BitStack(OutputStream outputStream, Object[] objectArray) throws IOException {
        this.showProgressBar = false;
        for (int i = 0; i < this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.write8BitImage(outputStream, (byte[])objectArray[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
        }
    }

    void write8BitVirtualStack(OutputStream outputStream, VirtualStack virtualStack) throws IOException {
        this.showProgressBar = false;
        boolean bl = "FlipTheseImages".equals(this.fi.fileName);
        for (int i = 1; i <= this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + i + "/" + this.fi.nImages);
            ImageProcessor imageProcessor = virtualStack.getProcessor(i);
            if (bl) {
                imageProcessor.flipVertical();
            }
            byte[] byArray = (byte[])imageProcessor.getPixels();
            this.write8BitImage(outputStream, byArray);
            IJ.showProgress((double)i / (double)this.fi.nImages);
        }
    }

    void write16BitImage(OutputStream outputStream, short[] sArray) throws IOException {
        long l = 0L;
        long l2 = 2L * (long)this.fi.width * (long)this.fi.height;
        int n = 8192;
        byte[] byArray = new byte[n];
        while (l < l2) {
            short s;
            int n2;
            if (l + (long)n > l2) {
                n = (int)(l2 - l);
            }
            int n3 = (int)(l / 2L);
            if (this.fi.intelByteOrder) {
                for (n2 = 0; n2 < n; n2 += 2) {
                    s = sArray[n3];
                    byArray[n2] = (byte)s;
                    byArray[n2 + 1] = (byte)(s >>> 8);
                    ++n3;
                }
            } else {
                for (n2 = 0; n2 < n; n2 += 2) {
                    s = sArray[n3];
                    byArray[n2] = (byte)(s >>> 8);
                    byArray[n2 + 1] = (byte)s;
                    ++n3;
                }
            }
            outputStream.write(byArray, 0, n);
            this.showProgress((double)(l += (long)n) / (double)l2);
        }
    }

    void write16BitStack(OutputStream outputStream, Object[] objectArray) throws IOException {
        this.showProgressBar = false;
        for (int i = 0; i < this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.write16BitImage(outputStream, (short[])objectArray[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
        }
    }

    void write16BitVirtualStack(OutputStream outputStream, VirtualStack virtualStack) throws IOException {
        this.showProgressBar = false;
        boolean bl = "FlipTheseImages".equals(this.fi.fileName);
        for (int i = 1; i <= this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + i + "/" + this.fi.nImages);
            ImageProcessor imageProcessor = virtualStack.getProcessor(i);
            if (bl) {
                imageProcessor.flipVertical();
            }
            short[] sArray = (short[])imageProcessor.getPixels();
            this.write16BitImage(outputStream, sArray);
            IJ.showProgress((double)i / (double)this.fi.nImages);
        }
    }

    void writeRGB48Image(OutputStream outputStream, Object[] objectArray) throws IOException {
        short[] sArray = (short[])objectArray[0];
        short[] sArray2 = (short[])objectArray[1];
        short[] sArray3 = (short[])objectArray[2];
        int n = this.fi.width * this.fi.height;
        int n2 = this.fi.width * 6;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < this.fi.height; ++i) {
            short s;
            int n3;
            int n4 = 0;
            int n5 = i * this.fi.width;
            if (this.fi.intelByteOrder) {
                for (n3 = 0; n3 < this.fi.width; ++n3) {
                    s = sArray[n5];
                    byArray[n4++] = (byte)s;
                    byArray[n4++] = (byte)(s >>> 8);
                    s = sArray2[n5];
                    byArray[n4++] = (byte)s;
                    byArray[n4++] = (byte)(s >>> 8);
                    s = sArray3[n5];
                    byArray[n4++] = (byte)s;
                    byArray[n4++] = (byte)(s >>> 8);
                    ++n5;
                }
            } else {
                for (n3 = 0; n3 < this.fi.width; ++n3) {
                    s = sArray[n5];
                    byArray[n4++] = (byte)(s >>> 8);
                    byArray[n4++] = (byte)s;
                    s = sArray2[n5];
                    byArray[n4++] = (byte)(s >>> 8);
                    byArray[n4++] = (byte)s;
                    s = sArray3[n5];
                    byArray[n4++] = (byte)(s >>> 8);
                    byArray[n4++] = (byte)s;
                    ++n5;
                }
            }
            outputStream.write(byArray, 0, n2);
        }
    }

    void writeFloatImage(OutputStream outputStream, float[] fArray) throws IOException {
        long l = 0L;
        long l2 = 4L * (long)this.fi.width * (long)this.fi.height;
        int n = 8192;
        byte[] byArray = new byte[n];
        while (l < l2) {
            int n2;
            int n3;
            if (l + (long)n > l2) {
                n = (int)(l2 - l);
            }
            int n4 = (int)(l / 4L);
            if (this.fi.intelByteOrder) {
                for (n3 = 0; n3 < n; n3 += 4) {
                    n2 = Float.floatToRawIntBits(fArray[n4]);
                    byArray[n3] = (byte)n2;
                    byArray[n3 + 1] = (byte)(n2 >> 8);
                    byArray[n3 + 2] = (byte)(n2 >> 16);
                    byArray[n3 + 3] = (byte)(n2 >> 24);
                    ++n4;
                }
            } else {
                for (n3 = 0; n3 < n; n3 += 4) {
                    n2 = Float.floatToRawIntBits(fArray[n4]);
                    byArray[n3] = (byte)(n2 >> 24);
                    byArray[n3 + 1] = (byte)(n2 >> 16);
                    byArray[n3 + 2] = (byte)(n2 >> 8);
                    byArray[n3 + 3] = (byte)n2;
                    ++n4;
                }
            }
            outputStream.write(byArray, 0, n);
            this.showProgress((double)(l += (long)n) / (double)l2);
        }
    }

    void writeFloatStack(OutputStream outputStream, Object[] objectArray) throws IOException {
        this.showProgressBar = false;
        for (int i = 0; i < this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.writeFloatImage(outputStream, (float[])objectArray[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
        }
    }

    void writeFloatVirtualStack(OutputStream outputStream, VirtualStack virtualStack) throws IOException {
        this.showProgressBar = false;
        boolean bl = "FlipTheseImages".equals(this.fi.fileName);
        for (int i = 1; i <= this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + i + "/" + this.fi.nImages);
            ImageProcessor imageProcessor = virtualStack.getProcessor(i);
            if (bl) {
                imageProcessor.flipVertical();
            }
            float[] fArray = (float[])imageProcessor.getPixels();
            this.writeFloatImage(outputStream, fArray);
            IJ.showProgress((double)i / (double)this.fi.nImages);
        }
    }

    void writeRGBImage(OutputStream outputStream, int[] nArray) throws IOException {
        long l = 0L;
        long l2 = 3L * (long)this.fi.width * (long)this.fi.height;
        int n = this.fi.width * 24;
        byte[] byArray = new byte[n];
        while (l < l2) {
            if (l + (long)n > l2) {
                n = (int)(l2 - l);
            }
            int n2 = (int)(l / 3L);
            for (int i = 0; i < n; i += 3) {
                byArray[i] = (byte)(nArray[n2] >> 16);
                byArray[i + 1] = (byte)(nArray[n2] >> 8);
                byArray[i + 2] = (byte)nArray[n2];
                ++n2;
            }
            outputStream.write(byArray, 0, n);
            this.showProgress((double)(l += (long)n) / (double)l2);
        }
    }

    void writeRGBStack(OutputStream outputStream, Object[] objectArray) throws IOException {
        this.showProgressBar = false;
        for (int i = 0; i < this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.writeRGBImage(outputStream, (int[])objectArray[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
        }
    }

    void writeRGBVirtualStack(OutputStream outputStream, VirtualStack virtualStack) throws IOException {
        this.showProgressBar = false;
        boolean bl = "FlipTheseImages".equals(this.fi.fileName);
        for (int i = 1; i <= this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + i + "/" + this.fi.nImages);
            ImageProcessor imageProcessor = virtualStack.getProcessor(i);
            if (bl) {
                imageProcessor.flipVertical();
            }
            int[] nArray = (int[])imageProcessor.getPixels();
            this.writeRGBImage(outputStream, nArray);
            IJ.showProgress((double)i / (double)this.fi.nImages);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.fi.pixels == null && this.fi.virtualStack == null) {
            throw new IOException("ImageWriter: fi.pixels==null");
        }
        if (this.fi.nImages > 1 && this.fi.virtualStack == null && !(this.fi.pixels instanceof Object[])) {
            throw new IOException("ImageWriter: fi.pixels not a stack");
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: {
                if (this.fi.nImages > 1 && this.fi.virtualStack != null) {
                    this.write8BitVirtualStack(outputStream, this.fi.virtualStack);
                    break;
                }
                if (this.fi.nImages > 1) {
                    this.write8BitStack(outputStream, (Object[])this.fi.pixels);
                    break;
                }
                this.write8BitImage(outputStream, (byte[])this.fi.pixels);
                break;
            }
            case 1: 
            case 2: {
                if (this.fi.nImages > 1 && this.fi.virtualStack != null) {
                    this.write16BitVirtualStack(outputStream, this.fi.virtualStack);
                    break;
                }
                if (this.fi.nImages > 1) {
                    this.write16BitStack(outputStream, (Object[])this.fi.pixels);
                    break;
                }
                this.write16BitImage(outputStream, (short[])this.fi.pixels);
                break;
            }
            case 12: {
                this.writeRGB48Image(outputStream, (Object[])this.fi.pixels);
                break;
            }
            case 4: {
                if (this.fi.nImages > 1 && this.fi.virtualStack != null) {
                    this.writeFloatVirtualStack(outputStream, this.fi.virtualStack);
                    break;
                }
                if (this.fi.nImages > 1) {
                    this.writeFloatStack(outputStream, (Object[])this.fi.pixels);
                    break;
                }
                this.writeFloatImage(outputStream, (float[])this.fi.pixels);
                break;
            }
            case 6: {
                if (this.fi.nImages > 1 && this.fi.virtualStack != null) {
                    this.writeRGBVirtualStack(outputStream, this.fi.virtualStack);
                    break;
                }
                if (this.fi.nImages > 1) {
                    this.writeRGBStack(outputStream, (Object[])this.fi.pixels);
                    break;
                }
                this.writeRGBImage(outputStream, (int[])this.fi.pixels);
                break;
            }
        }
    }
}

