/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.ImagePlus;
import ij.gui.Arrow;
import ij.gui.EllipseRoi;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.io.Opener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RoiDecoder {
    public static final int VERSION_OFFSET = 4;
    public static final int TYPE = 6;
    public static final int TOP = 8;
    public static final int LEFT = 10;
    public static final int BOTTOM = 12;
    public static final int RIGHT = 14;
    public static final int N_COORDINATES = 16;
    public static final int X1 = 18;
    public static final int Y1 = 22;
    public static final int X2 = 26;
    public static final int Y2 = 30;
    public static final int STROKE_WIDTH = 34;
    public static final int SHAPE_ROI_SIZE = 36;
    public static final int STROKE_COLOR = 40;
    public static final int FILL_COLOR = 44;
    public static final int SUBTYPE = 48;
    public static final int OPTIONS = 50;
    public static final int ARROW_STYLE = 52;
    public static final int ELLIPSE_ASPECT_RATIO = 52;
    public static final int ARROW_HEAD_SIZE = 53;
    public static final int ROUNDED_RECT_ARC_SIZE = 54;
    public static final int POSITION = 56;
    public static final int HEADER2_OFFSET = 60;
    public static final int COORDINATES = 64;
    public static final int C_POSITION = 4;
    public static final int Z_POSITION = 8;
    public static final int T_POSITION = 12;
    public static final int NAME_OFFSET = 16;
    public static final int NAME_LENGTH = 20;
    public static final int OVERLAY_LABEL_COLOR = 24;
    public static final int OVERLAY_FONT_SIZE = 28;
    public static final int AVAILABLE_BYTE1 = 30;
    public static final int IMAGE_OPACITY = 31;
    public static final int IMAGE_SIZE = 32;
    public static final int TEXT = 1;
    public static final int ARROW = 2;
    public static final int ELLIPSE = 3;
    public static final int IMAGE = 4;
    public static final int SPLINE_FIT = 1;
    public static final int DOUBLE_HEADED = 2;
    public static final int OUTLINE = 4;
    public static final int OVERLAY_LABELS = 8;
    public static final int OVERLAY_NAMES = 16;
    public static final int OVERLAY_BACKGROUNDS = 32;
    public static final int OVERLAY_BOLD = 64;
    private final int polygon = 0;
    private final int rect = 1;
    private final int oval = 2;
    private final int line = 3;
    private final int freeline = 4;
    private final int polyline = 5;
    private final int noRoi = 6;
    private final int freehand = 7;
    private final int traced = 8;
    private final int angle = 9;
    private final int point = 10;
    private byte[] data;
    private String path;
    private InputStream is;
    private String name;
    private int size;

    public RoiDecoder(String string) {
        this.path = string;
    }

    public RoiDecoder(byte[] byArray, String string) {
        this.is = new ByteArrayInputStream(byArray);
        this.name = string;
        this.size = byArray.length;
    }

    public Roi getRoi() throws IOException {
        int n;
        if (this.path != null) {
            File file = new File(this.path);
            this.size = (int)file.length();
            if (!this.path.endsWith(".roi") && this.size > 0x500000) {
                throw new IOException("This is not an ROI or file size>5MB)");
            }
            this.name = file.getName();
            this.is = new FileInputStream(this.path);
        }
        this.data = new byte[this.size];
        for (int i = 0; i < this.size; i += this.is.read(this.data, i, this.size - i)) {
        }
        this.is.close();
        if (this.getByte(0) != 73 || this.getByte(1) != 111) {
            throw new IOException("This is not an ImageJ ROI");
        }
        int n2 = this.getShort(4);
        int n3 = this.getByte(6);
        int n4 = this.getShort(48);
        int n5 = this.getShort(8);
        int n6 = this.getShort(10);
        int n7 = this.getShort(12);
        int n8 = this.getShort(14);
        int n9 = n8 - n6;
        int n10 = n7 - n5;
        int n11 = this.getShort(16);
        int n12 = this.getShort(50);
        int n13 = this.getInt(56);
        int n14 = this.getInt(60);
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (n14 > 0 && n14 + 32 + 4 <= this.size) {
            n15 = this.getInt(n14 + 4);
            n16 = this.getInt(n14 + 8);
            n17 = this.getInt(n14 + 12);
            n18 = this.getInt(n14 + 24);
            n19 = this.getShort(n14 + 28);
            n20 = this.getByte(n14 + 31);
            n21 = this.getInt(n14 + 32);
        }
        if (this.name != null && this.name.endsWith(".roi")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        boolean bl = this.getInt(36) > 0;
        Roi roi = null;
        if (bl) {
            roi = this.getShapeRoi();
            if (n2 >= 218) {
                this.getStrokeWidthAndColor(roi);
            }
            roi.setPosition(n13);
            if (n15 > 0 || n16 > 0 || n17 > 0) {
                roi.setPosition(n15, n16, n17);
            }
            this.decodeOverlayOptions(roi, n2, n12, n18, n19);
            return roi;
        }
        switch (n3) {
            case 1: {
                roi = new Roi(n6, n5, n9, n10);
                n = this.getShort(54);
                if (n <= 0) break;
                roi.setCornerDiameter(n);
                break;
            }
            case 2: {
                roi = new OvalRoi(n6, n5, n9, n10);
                break;
            }
            case 3: {
                int n22 = (int)this.getFloat(18);
                int n23 = (int)this.getFloat(22);
                int n24 = (int)this.getFloat(26);
                int n25 = (int)this.getFloat(30);
                if (n4 == 2) {
                    int n26;
                    roi = new Arrow((double)n22, (double)n23, (double)n24, (double)n25);
                    ((Arrow)roi).setDoubleHeaded((n12 & 2) != 0);
                    ((Arrow)roi).setOutline((n12 & 4) != 0);
                    int n27 = this.getByte(52);
                    if (n27 >= 0 && n27 <= 3) {
                        ((Arrow)roi).setStyle(n27);
                    }
                    if ((n26 = this.getByte(53)) < 0 || n27 > 30) break;
                    ((Arrow)roi).setHeadSize(n26);
                    break;
                }
                roi = new Line(n22, n23, n24, n25);
                break;
            }
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                int n28;
                if (n11 == 0) break;
                int[] nArray = new int[n11];
                int[] nArray2 = new int[n11];
                int n29 = 64;
                int n30 = n29 + 2 * n11;
                for (n28 = 0; n28 < n11; ++n28) {
                    int n31;
                    int n32 = this.getShort(n29 + n28 * 2);
                    if (n32 < 0) {
                        n32 = 0;
                    }
                    if ((n31 = this.getShort(n30 + n28 * 2)) < 0) {
                        n31 = 0;
                    }
                    nArray[n28] = n6 + n32;
                    nArray2[n28] = n5 + n31;
                }
                if (n3 == 10) {
                    roi = new PointRoi(nArray, nArray2, n11);
                    break;
                }
                if (n3 == 0) {
                    n28 = 2;
                } else if (n3 == 7) {
                    n28 = 3;
                    if (n4 == 3) {
                        double d = this.getFloat(18);
                        double d2 = this.getFloat(22);
                        double d3 = this.getFloat(26);
                        double d4 = this.getFloat(30);
                        double d5 = this.getFloat(52);
                        roi = new EllipseRoi(d, d2, d3, d4, d5);
                        break;
                    }
                } else {
                    n28 = n3 == 8 ? 4 : (n3 == 5 ? 6 : (n3 == 4 ? 7 : (n3 == 9 ? 8 : 3)));
                }
                roi = new PolygonRoi(nArray, nArray2, n11, n28);
                break;
            }
            default: {
                throw new IOException("Unrecognized ROI type: " + n3);
            }
        }
        roi.setName(this.getRoiName());
        if (n2 >= 218) {
            this.getStrokeWidthAndColor(roi);
            int n33 = n = (n12 & 1) != 0 ? 1 : 0;
            if (n != 0 && roi instanceof PolygonRoi) {
                ((PolygonRoi)roi).fitSpline();
            }
        }
        if (n2 >= 218 && n4 == 1) {
            roi = this.getTextRoi(roi);
        }
        if (n2 >= 221 && n4 == 4) {
            roi = this.getImageRoi(roi, n20, n21);
        }
        roi.setPosition(n13);
        if (n15 > 0 || n16 > 0 || n17 > 0) {
            roi.setPosition(n15, n16, n17);
        }
        this.decodeOverlayOptions(roi, n2, n12, n18, n19);
        return roi;
    }

    void decodeOverlayOptions(Roi roi, int n, int n2, int n3, int n4) {
        boolean bl;
        Overlay overlay = new Overlay();
        overlay.drawLabels((n2 & 8) != 0);
        overlay.drawNames((n2 & 0x10) != 0);
        overlay.drawBackgrounds((n2 & 0x20) != 0);
        if (n >= 220) {
            overlay.setLabelColor(new Color(n3));
        }
        boolean bl2 = bl = (n2 & 0x40) != 0;
        if (n4 > 0 || bl) {
            overlay.setLabelFont(new Font("SansSerif", bl ? 1 : 0, n4));
        }
        roi.setPrototypeOverlay(overlay);
    }

    void getStrokeWidthAndColor(Roi roi) {
        int n;
        int n2;
        int n3 = this.getShort(34);
        if (n3 > 0) {
            roi.setStrokeWidth(n3);
        }
        if ((n2 = this.getInt(40)) != 0) {
            n = n2 >> 24 & 0xFF;
            roi.setStrokeColor(new Color(n2, n != 255));
        }
        if ((n = this.getInt(44)) != 0) {
            int n4 = n >> 24 & 0xFF;
            roi.setFillColor(new Color(n, n4 != 255));
        }
    }

    public Roi getShapeRoi() throws IOException {
        int n = this.getByte(6);
        if (n != 1) {
            throw new IllegalArgumentException("Invalid composite ROI type");
        }
        int n2 = this.getShort(8);
        int n3 = this.getShort(10);
        int n4 = this.getShort(12);
        int n5 = this.getShort(14);
        int n6 = n5 - n3;
        int n7 = n4 - n2;
        int n8 = this.getInt(36);
        ShapeRoi shapeRoi = null;
        float[] fArray = new float[n8];
        int n9 = 64;
        for (int i = 0; i < n8; ++i) {
            fArray[i] = this.getFloat(n9);
            n9 += 4;
        }
        shapeRoi = new ShapeRoi(fArray);
        shapeRoi.setName(this.getRoiName());
        return shapeRoi;
    }

    Roi getTextRoi(Roi roi) {
        int n;
        Rectangle rectangle = roi.getBounds();
        int n2 = 64;
        int n3 = this.getInt(n2);
        int n4 = this.getInt(n2 + 4);
        int n5 = this.getInt(n2 + 8);
        int n6 = this.getInt(n2 + 12);
        char[] cArray = new char[n5];
        char[] cArray2 = new char[n6];
        for (n = 0; n < n5; ++n) {
            cArray[n] = (char)this.getShort(n2 + 16 + n * 2);
        }
        for (n = 0; n < n6; ++n) {
            cArray2[n] = (char)this.getShort(n2 + 16 + n5 * 2 + n * 2);
        }
        Font font = new Font(new String(cArray), n4, n3);
        TextRoi textRoi = new TextRoi(rectangle.x, rectangle.y, new String(cArray2), font);
        textRoi.setStrokeColor(roi.getStrokeColor());
        textRoi.setFillColor(roi.getFillColor());
        textRoi.setName(this.getRoiName());
        return textRoi;
    }

    Roi getImageRoi(Roi roi, int n, int n2) {
        if (n2 <= 0) {
            return roi;
        }
        Rectangle rectangle = roi.getBounds();
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)this.getByte(64 + i);
        }
        ImagePlus imagePlus = new Opener().deserialize(byArray);
        ImageRoi imageRoi = new ImageRoi(rectangle.x, rectangle.y, imagePlus.getProcessor());
        imageRoi.setOpacity((double)n / 255.0);
        return imageRoi;
    }

    String getRoiName() {
        String string = this.name;
        int n = this.getInt(60);
        if (n == 0) {
            return string;
        }
        int n2 = this.getInt(n + 16);
        int n3 = this.getInt(n + 20);
        if (n2 == 0 || n3 == 0) {
            return string;
        }
        if (n2 + n3 * 2 > this.size) {
            return string;
        }
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            cArray[i] = (char)this.getShort(n2 + i * 2);
        }
        return new String(cArray);
    }

    int getByte(int n) {
        return this.data[n] & 0xFF;
    }

    int getShort(int n) {
        int n2 = this.data[n] & 0xFF;
        int n3 = this.data[n + 1] & 0xFF;
        int n4 = (n2 << 8) + n3;
        if (n4 < -5000) {
            n4 = (n2 << 8) + n3;
        }
        return n4;
    }

    int getInt(int n) {
        int n2 = this.data[n] & 0xFF;
        int n3 = this.data[n + 1] & 0xFF;
        int n4 = this.data[n + 2] & 0xFF;
        int n5 = this.data[n + 3] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public static Roi openFromByteArray(byte[] byArray) {
        Roi roi = null;
        try {
            RoiDecoder roiDecoder = new RoiDecoder(byArray, null);
            roi = roiDecoder.getRoi();
        }
        catch (IOException iOException) {
            return null;
        }
        return roi;
    }
}

