/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import ij.io.RandomAccessStream;
import ij.util.Tools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class TiffDecoder {
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTO_INTERP = 262;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int STRIP_OFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNT = 279;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int RESOLUTION_UNIT = 296;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int ARTEST = 315;
    public static final int HOST_COMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int COLOR_MAP = 320;
    public static final int TILE_WIDTH = 322;
    public static final int SAMPLE_FORMAT = 339;
    public static final int JPEG_TABLES = 347;
    public static final int METAMORPH1 = 33628;
    public static final int METAMORPH2 = 33629;
    public static final int IPLAB = 34122;
    public static final int NIH_IMAGE_HDR = 43314;
    public static final int META_DATA_BYTE_COUNTS = 50838;
    public static final int META_DATA = 50839;
    static final int UNSIGNED = 1;
    static final int SIGNED = 2;
    static final int FLOATING_POINT = 3;
    static final int SHORT = 3;
    static final int LONG = 4;
    static final int MAGIC_NUMBER = 0x494A494A;
    static final int INFO = 1768842863;
    static final int LABELS = 1818321516;
    static final int RANGES = 1918987879;
    static final int LUTS = 1819636851;
    static final int ROI = 1919904032;
    static final int OVERLAY = 1870030194;
    private String directory;
    private String name;
    private String url;
    protected RandomAccessStream in;
    protected boolean debugMode;
    private boolean littleEndian;
    private String dInfo;
    private int ifdCount;
    private int[] metaDataCounts;
    private String tiffMetadata;

    public TiffDecoder(String string, String string2) {
        this.directory = string;
        this.name = string2;
    }

    public TiffDecoder(InputStream inputStream, String string) {
        this.directory = "";
        this.name = string;
        this.url = "";
        this.in = new RandomAccessStream(inputStream);
    }

    final int getInt() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    final int getShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (this.littleEndian) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    final long readLong() throws IOException {
        if (this.littleEndian) {
            return ((long)this.getInt() & 0xFFFFFFFFL) + ((long)this.getInt() << 32);
        }
        return ((long)this.getInt() << 32) + ((long)this.getInt() & 0xFFFFFFFFL);
    }

    final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    long OpenImageFileHeader() throws IOException {
        short s = this.in.readShort();
        if (s == 18761) {
            this.littleEndian = true;
        } else if (s == 19789) {
            this.littleEndian = false;
        } else {
            this.in.close();
            return -1L;
        }
        int n = this.getShort();
        long l = (long)this.getInt() & 0xFFFFFFFFL;
        return l;
    }

    int getValue(int n, int n2) throws IOException {
        int n3 = 0;
        if (n == 3 && n2 == 1) {
            n3 = this.getShort();
            int n4 = this.getShort();
        } else {
            n3 = this.getInt();
        }
        return n3;
    }

    void getColorMap(long l, FileInfo fileInfo) throws IOException {
        byte[] byArray = new byte[1536];
        long l2 = this.in.getLongFilePointer();
        this.in.seek(l);
        this.in.readFully(byArray);
        this.in.seek(l2);
        fileInfo.lutSize = 256;
        fileInfo.reds = new byte[256];
        fileInfo.greens = new byte[256];
        fileInfo.blues = new byte[256];
        int n = 0;
        if (this.littleEndian) {
            ++n;
        }
        int n2 = 0;
        for (int i = 0; i < 256; ++i) {
            fileInfo.reds[i] = byArray[n];
            n2 += fileInfo.reds[i];
            fileInfo.greens[i] = byArray[512 + n];
            n2 += fileInfo.greens[i];
            fileInfo.blues[i] = byArray[1024 + n];
            n2 += fileInfo.blues[i];
            n += 2;
        }
        if (n2 != 0) {
            fileInfo.fileType = 5;
        }
    }

    byte[] getString(int n, long l) throws IOException {
        if (--n <= 3) {
            return null;
        }
        byte[] byArray = new byte[n];
        long l2 = this.in.getLongFilePointer();
        this.in.seek(l);
        this.in.readFully(byArray);
        this.in.seek(l2);
        return byArray;
    }

    public void saveImageDescription(byte[] byArray, FileInfo fileInfo) {
        String string;
        int n;
        int n2;
        String string2 = new String(byArray);
        if (!string2.startsWith("ImageJ")) {
            this.saveMetadata(this.getName(270), string2);
        }
        if (string2.length() < 7) {
            return;
        }
        fileInfo.description = string2;
        int n3 = string2.indexOf("images=");
        if (n3 > 0 && (n2 = string2.indexOf("\n", n3)) > 0 && (n = (int)Tools.parseDouble(string = string2.substring(n3 + 7, n2), 0.0)) > 1) {
            fileInfo.nImages = n;
        }
    }

    public void saveMetadata(String string, String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = string + ": " + string2 + "\n";
        this.tiffMetadata = this.tiffMetadata == null ? string3 : this.tiffMetadata + string3;
    }

    void decodeNIHImageHeader(int n, FileInfo fileInfo) throws IOException {
        int n2;
        long l = this.in.getLongFilePointer();
        this.in.seek(n + 12);
        short s = this.in.readShort();
        this.in.seek(n + 160);
        double d = this.in.readDouble();
        if (s > 106 && d != 0.0) {
            fileInfo.pixelHeight = fileInfo.pixelWidth = 1.0 / d;
        }
        this.in.seek(n + 172);
        int n3 = this.in.readShort();
        if (s <= 153) {
            n3 += 5;
        }
        switch (n3) {
            case 5: {
                fileInfo.unit = "nanometer";
                break;
            }
            case 6: {
                fileInfo.unit = "micrometer";
                break;
            }
            case 7: {
                fileInfo.unit = "mm";
                break;
            }
            case 8: {
                fileInfo.unit = "cm";
                break;
            }
            case 9: {
                fileInfo.unit = "meter";
                break;
            }
            case 10: {
                fileInfo.unit = "km";
                break;
            }
            case 11: {
                fileInfo.unit = "inch";
                break;
            }
            case 12: {
                fileInfo.unit = "ft";
                break;
            }
            case 13: {
                fileInfo.unit = "mi";
            }
        }
        this.in.seek(n + 182);
        int n4 = this.in.read();
        int n5 = this.in.read();
        int n6 = this.in.readShort();
        if (n4 == 11) {
            fileInfo.calibrationFunction = 21;
            fileInfo.valueUnit = "U. OD";
        } else if (n4 >= 0 && n4 <= 8 && n6 >= 1 && n6 <= 5) {
            switch (n4) {
                case 0: {
                    fileInfo.calibrationFunction = 0;
                    break;
                }
                case 1: {
                    fileInfo.calibrationFunction = 1;
                    break;
                }
                case 2: {
                    fileInfo.calibrationFunction = 2;
                    break;
                }
                case 3: {
                    fileInfo.calibrationFunction = 3;
                    break;
                }
                case 5: {
                    fileInfo.calibrationFunction = 4;
                    break;
                }
                case 6: {
                    fileInfo.calibrationFunction = 5;
                    break;
                }
                case 7: {
                    fileInfo.calibrationFunction = 6;
                    break;
                }
                case 8: {
                    fileInfo.calibrationFunction = 10;
                }
            }
            fileInfo.coefficients = new double[n6];
            for (n2 = 0; n2 < n6; ++n2) {
                fileInfo.coefficients[n2] = this.in.readDouble();
            }
            this.in.seek(n + 234);
            n2 = this.in.read();
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 >= 1 && n2 <= 16) {
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append((char)this.in.read());
                }
                fileInfo.valueUnit = new String(stringBuffer);
            } else {
                fileInfo.valueUnit = " ";
            }
        }
        this.in.seek(n + 260);
        n2 = this.in.readShort();
        if (n2 >= 2 && (fileInfo.fileType == 0 || fileInfo.fileType == 5)) {
            fileInfo.nImages = n2;
            fileInfo.pixelDepth = this.in.readFloat();
            short s2 = this.in.readShort();
            fileInfo.frameInterval = this.in.readFloat();
        }
        this.in.seek(n + 272);
        float f = this.in.readFloat();
        if (s > 140 && (double)f != 0.0) {
            fileInfo.pixelHeight = fileInfo.pixelWidth / (double)f;
        }
        this.in.seek(l);
    }

    void dumpTag(int n, int n2, int n3, FileInfo fileInfo) {
        long l = (long)n3 & 0xFFFFFFFFL;
        String string = this.getName(n);
        String string2 = n2 == 1 ? "" : ", count=" + n2;
        this.dInfo = this.dInfo + "    " + n + ", \"" + string + "\", value=" + l + string2 + "\n";
    }

    String getName(int n) {
        String string;
        switch (n) {
            case 254: {
                string = "NewSubfileType";
                break;
            }
            case 256: {
                string = "ImageWidth";
                break;
            }
            case 257: {
                string = "ImageLength";
                break;
            }
            case 273: {
                string = "StripOffsets";
                break;
            }
            case 274: {
                string = "Orientation";
                break;
            }
            case 262: {
                string = "PhotoInterp";
                break;
            }
            case 270: {
                string = "ImageDescription";
                break;
            }
            case 258: {
                string = "BitsPerSample";
                break;
            }
            case 277: {
                string = "SamplesPerPixel";
                break;
            }
            case 278: {
                string = "RowsPerStrip";
                break;
            }
            case 279: {
                string = "StripByteCount";
                break;
            }
            case 282: {
                string = "XResolution";
                break;
            }
            case 283: {
                string = "YResolution";
                break;
            }
            case 296: {
                string = "ResolutionUnit";
                break;
            }
            case 305: {
                string = "Software";
                break;
            }
            case 306: {
                string = "DateTime";
                break;
            }
            case 315: {
                string = "Artest";
                break;
            }
            case 316: {
                string = "HostComputer";
                break;
            }
            case 284: {
                string = "PlanarConfiguration";
                break;
            }
            case 259: {
                string = "Compression";
                break;
            }
            case 317: {
                string = "Predictor";
                break;
            }
            case 320: {
                string = "ColorMap";
                break;
            }
            case 339: {
                string = "SampleFormat";
                break;
            }
            case 347: {
                string = "JPEGTables";
                break;
            }
            case 43314: {
                string = "NIHImageHeader";
                break;
            }
            case 50838: {
                string = "MetaDataByteCounts";
                break;
            }
            case 50839: {
                string = "MetaData";
                break;
            }
            default: {
                string = "???";
            }
        }
        return string;
    }

    double getRational(long l) throws IOException {
        long l2 = this.in.getLongFilePointer();
        this.in.seek(l);
        int n = this.getInt();
        int n2 = this.getInt();
        this.in.seek(l2);
        if (n2 != 0) {
            return (double)n / (double)n2;
        }
        return 0.0;
    }

    FileInfo OpenIFD() throws IOException {
        int n = this.getShort();
        if (n < 1 || n > 1000) {
            return null;
        }
        ++this.ifdCount;
        if (this.ifdCount % 100 == 0 && this.ifdCount > 0) {
            IJ.showStatus("" + this.ifdCount);
        }
        FileInfo fileInfo = new FileInfo();
        block28: for (int i = 0; i < n; ++i) {
            int n2 = this.getShort();
            int n3 = this.getShort();
            int n4 = this.getInt();
            int n5 = this.getValue(n3, n4);
            long l = (long)n5 & 0xFFFFFFFFL;
            if (this.debugMode && this.ifdCount < 10) {
                this.dumpTag(n2, n4, n5, fileInfo);
            }
            switch (n2) {
                case 256: {
                    fileInfo.width = n5;
                    fileInfo.intelByteOrder = this.littleEndian;
                    continue block28;
                }
                case 257: {
                    fileInfo.height = n5;
                    continue block28;
                }
                case 273: {
                    if (n4 == 1) {
                        fileInfo.stripOffsets = new int[]{n5};
                    } else {
                        long l2 = this.in.getLongFilePointer();
                        this.in.seek(l);
                        fileInfo.stripOffsets = new int[n4];
                        for (int j = 0; j < n4; ++j) {
                            fileInfo.stripOffsets[j] = this.getInt();
                        }
                        this.in.seek(l2);
                    }
                    int n6 = fileInfo.offset = n4 > 0 ? fileInfo.stripOffsets[0] : n5;
                    if (n4 <= 1 || fileInfo.stripOffsets[n4 - 1] >= fileInfo.stripOffsets[0]) continue block28;
                    fileInfo.offset = fileInfo.stripOffsets[n4 - 1];
                    continue block28;
                }
                case 279: {
                    if (n4 == 1) {
                        fileInfo.stripLengths = new int[]{n5};
                        continue block28;
                    }
                    long l3 = this.in.getLongFilePointer();
                    this.in.seek(l);
                    fileInfo.stripLengths = new int[n4];
                    for (int j = 0; j < n4; ++j) {
                        fileInfo.stripLengths[j] = n3 == 3 ? this.getShort() : this.getInt();
                    }
                    this.in.seek(l3);
                    continue block28;
                }
                case 262: {
                    fileInfo.whiteIsZero = n5 == 0;
                    continue block28;
                }
                case 258: {
                    if (n4 == 1) {
                        if (n5 == 8) {
                            fileInfo.fileType = 0;
                            continue block28;
                        }
                        if (n5 == 16) {
                            fileInfo.fileType = 2;
                            continue block28;
                        }
                        if (n5 == 32) {
                            fileInfo.fileType = 3;
                            continue block28;
                        }
                        if (n5 == 12) {
                            fileInfo.fileType = 13;
                            continue block28;
                        }
                        if (n5 == 1) {
                            fileInfo.fileType = 8;
                            continue block28;
                        }
                        this.error("Unsupported BitsPerSample: " + n5);
                        continue block28;
                    }
                    if (n4 != 3) continue block28;
                    long l4 = this.in.getLongFilePointer();
                    this.in.seek(l);
                    int n7 = this.getShort();
                    if (n7 != 8 && n7 != 16) {
                        this.error("ImageJ can only open 8 and 16 bit/channel RGB images (" + n7 + ")");
                    }
                    if (n7 == 16) {
                        fileInfo.fileType = 12;
                    }
                    this.in.seek(l4);
                    continue block28;
                }
                case 277: {
                    fileInfo.samplesPerPixel = n5;
                    if (n5 == 3 && fileInfo.fileType != 12) {
                        fileInfo.fileType = fileInfo.fileType == 2 ? 12 : 6;
                        continue block28;
                    }
                    if (n5 != 4 || fileInfo.fileType != 0) continue block28;
                    fileInfo.fileType = 9;
                    continue block28;
                }
                case 278: {
                    fileInfo.rowsPerStrip = n5;
                    continue block28;
                }
                case 282: {
                    double d = this.getRational(l);
                    if (d == 0.0) continue block28;
                    fileInfo.pixelWidth = 1.0 / d;
                    continue block28;
                }
                case 283: {
                    double d = this.getRational(l);
                    if (d == 0.0) continue block28;
                    fileInfo.pixelHeight = 1.0 / d;
                    continue block28;
                }
                case 296: {
                    if (n5 == 1 && fileInfo.unit == null) {
                        fileInfo.unit = " ";
                        continue block28;
                    }
                    if (n5 == 2) {
                        if (fileInfo.pixelWidth == 0.013888888888888888) {
                            fileInfo.pixelWidth = 1.0;
                            fileInfo.pixelHeight = 1.0;
                            continue block28;
                        }
                        fileInfo.unit = "inch";
                        continue block28;
                    }
                    if (n5 != 3) continue block28;
                    fileInfo.unit = "cm";
                    continue block28;
                }
                case 284: {
                    if (n5 == 2 && fileInfo.fileType == 12) {
                        fileInfo.fileType = 2;
                        continue block28;
                    }
                    if (n5 == 2 && fileInfo.fileType == 6) {
                        fileInfo.fileType = 7;
                        continue block28;
                    }
                    if (n5 == 1 && fileInfo.samplesPerPixel == 4) {
                        fileInfo.fileType = 9;
                        continue block28;
                    }
                    if (n5 == 2 || fileInfo.samplesPerPixel == 1 || fileInfo.samplesPerPixel == 3) continue block28;
                    String string = "Unsupported SamplesPerPixel: " + fileInfo.samplesPerPixel;
                    this.error(string);
                    continue block28;
                }
                case 259: {
                    if (n5 == 5) {
                        fileInfo.compression = 2;
                        continue block28;
                    }
                    if (n5 == 32773) {
                        fileInfo.compression = 5;
                        continue block28;
                    }
                    if (n5 == 32946 || n5 == 8) {
                        fileInfo.compression = 6;
                        continue block28;
                    }
                    if (n5 == 1 || n5 == 0 || n5 == 7 && fileInfo.width < 500) continue block28;
                    fileInfo.compression = 0;
                    this.error("ImageJ cannot open TIFF files compressed in this fashion (" + n5 + ")");
                    continue block28;
                }
                case 305: 
                case 306: 
                case 315: 
                case 316: {
                    if (this.ifdCount != 1) continue block28;
                    byte[] byArray = this.getString(n4, l);
                    String string = byArray != null ? new String(byArray) : null;
                    this.saveMetadata(this.getName(n2), string);
                    continue block28;
                }
                case 317: {
                    if (n5 != 2 || fileInfo.compression != 2) continue block28;
                    fileInfo.compression = 3;
                    continue block28;
                }
                case 320: {
                    if (n4 != 768) continue block28;
                    if (fileInfo.fileType != 0) continue block28;
                    this.getColorMap(l, fileInfo);
                    continue block28;
                }
                case 322: {
                    this.error("ImageJ cannot open tiled TIFFs");
                    continue block28;
                }
                case 339: {
                    if (fileInfo.fileType == 3 && n5 == 3) {
                        fileInfo.fileType = 4;
                    }
                    if (fileInfo.fileType != 2) continue block28;
                    if (n5 == 2) {
                        fileInfo.fileType = 1;
                    }
                    if (n5 != 3) continue block28;
                    this.error("ImageJ cannot open 16-bit float TIFFs");
                    continue block28;
                }
                case 347: {
                    if (fileInfo.compression != 4) continue block28;
                    this.error("Cannot open JPEG-compressed TIFFs with separate tables");
                    continue block28;
                }
                case 270: {
                    byte[] byArray;
                    if (this.ifdCount != 1 || (byArray = this.getString(n4, l)) == null) continue block28;
                    this.saveImageDescription(byArray, fileInfo);
                    continue block28;
                }
                case 274: {
                    fileInfo.nImages = 0;
                    continue block28;
                }
                case 33628: 
                case 33629: {
                    if (this.name.indexOf(".STK") <= 0 && this.name.indexOf(".stk") <= 0 || fileInfo.compression != 1) continue block28;
                    if (n2 == 33629) {
                        fileInfo.nImages = n4;
                        continue block28;
                    }
                    fileInfo.nImages = 9999;
                    continue block28;
                }
                case 34122: {
                    fileInfo.nImages = n5;
                    continue block28;
                }
                case 43314: {
                    if (n4 != 256) continue block28;
                    this.decodeNIHImageHeader(n5, fileInfo);
                    continue block28;
                }
                case 50838: {
                    long l5 = this.in.getLongFilePointer();
                    this.in.seek(l);
                    this.metaDataCounts = new int[n4];
                    for (int j = 0; j < n4; ++j) {
                        this.metaDataCounts[j] = this.getInt();
                    }
                    this.in.seek(l5);
                    continue block28;
                }
                case 50839: {
                    this.getMetaData(n5, fileInfo);
                    continue block28;
                }
                default: {
                    if (n2 <= 10000 || n2 >= 32768 || this.ifdCount <= 1) continue block28;
                    return null;
                }
            }
        }
        fileInfo.fileFormat = 2;
        fileInfo.fileName = this.name;
        fileInfo.directory = this.directory;
        if (this.url != null) {
            fileInfo.url = this.url;
        }
        return fileInfo;
    }

    void getMetaData(int n, FileInfo fileInfo) throws IOException {
        int n2;
        if (this.metaDataCounts == null || this.metaDataCounts.length == 0) {
            return;
        }
        int n3 = 10;
        long l = this.in.getLongFilePointer();
        this.in.seek(n);
        int n4 = this.metaDataCounts.length;
        int n5 = this.metaDataCounts[0];
        if (n5 < 12 || n5 > 804) {
            this.in.seek(l);
            return;
        }
        int n6 = this.getInt();
        if (n6 != 0x494A494A) {
            this.in.seek(l);
            return;
        }
        int n7 = (n5 - 4) / 8;
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        if (this.debugMode) {
            this.dInfo = this.dInfo + "Metadata:\n";
        }
        int n8 = 0;
        for (n2 = 0; n2 < n7; ++n2) {
            nArray[n2] = this.getInt();
            nArray2[n2] = this.getInt();
            if (nArray[n2] < 0xFFFFFF) {
                n8 += nArray2[n2];
            }
            if (!this.debugMode) continue;
            String string = "";
            if (nArray[n2] == 1768842863) {
                string = " (Info property)";
            }
            if (nArray[n2] == 1818321516) {
                string = " (slice labels)";
            }
            if (nArray[n2] == 1918987879) {
                string = " (display ranges)";
            }
            if (nArray[n2] == 1819636851) {
                string = " (luts)";
            }
            if (nArray[n2] == 1919904032) {
                string = " (roi)";
            }
            if (nArray[n2] == 1870030194) {
                string = " (overlay)";
            }
            this.dInfo = this.dInfo + "   " + n2 + " " + Integer.toHexString(nArray[n2]) + " " + nArray2[n2] + string + "\n";
        }
        fileInfo.metaDataTypes = new int[n8];
        fileInfo.metaData = new byte[n8][];
        n2 = 1;
        int n9 = 0;
        for (int i = 0; i < n7; ++i) {
            if (nArray[i] == 1768842863) {
                this.getInfoProperty(n2, fileInfo);
            } else if (nArray[i] == 1818321516) {
                this.getSliceLabels(n2, n2 + nArray2[i] - 1, fileInfo);
            } else if (nArray[i] == 1918987879) {
                this.getDisplayRanges(n2, fileInfo);
            } else if (nArray[i] == 1819636851) {
                this.getLuts(n2, n2 + nArray2[i] - 1, fileInfo);
            } else if (nArray[i] == 1919904032) {
                this.getRoi(n2, fileInfo);
            } else if (nArray[i] == 1870030194) {
                this.getOverlay(n2, n2 + nArray2[i] - 1, fileInfo);
            } else if (nArray[i] < 0xFFFFFF) {
                for (int j = n2; j < n2 + nArray2[i]; ++j) {
                    int n10 = this.metaDataCounts[j];
                    fileInfo.metaData[n9] = new byte[n10];
                    this.in.readFully(fileInfo.metaData[n9], n10);
                    fileInfo.metaDataTypes[n9] = nArray[i];
                    ++n9;
                }
            } else {
                this.skipUnknownType(n2, n2 + nArray2[i] - 1);
            }
            n2 += nArray2[i];
        }
        this.in.seek(l);
    }

    void getInfoProperty(int n, FileInfo fileInfo) throws IOException {
        int n2 = this.metaDataCounts[n];
        byte[] byArray = new byte[n2];
        this.in.readFully(byArray, n2);
        char[] cArray = new char[n2 /= 2];
        if (this.littleEndian) {
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                cArray[i] = (char)(byArray[n3++] & 255 + ((byArray[n3++] & 0xFF) << 8));
            }
        } else {
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                cArray[i] = (char)(((byArray[n4++] & 0xFF) << 8) + byArray[n4++] & 0xFF);
            }
        }
        fileInfo.info = new String(cArray);
    }

    void getSliceLabels(int n, int n2, FileInfo fileInfo) throws IOException {
        fileInfo.sliceLabels = new String[n2 - n + 1];
        int n3 = 0;
        byte[] byArray = new byte[this.metaDataCounts[n]];
        for (int i = n; i <= n2; ++i) {
            int n4 = this.metaDataCounts[i];
            if (n4 > 0) {
                int n5;
                int n6;
                if (n4 > byArray.length) {
                    byArray = new byte[n4];
                }
                this.in.readFully(byArray, n4);
                char[] cArray = new char[n4 /= 2];
                if (this.littleEndian) {
                    n6 = 0;
                    for (n5 = 0; n5 < n4; ++n5) {
                        cArray[n5] = (char)(byArray[n6++] & 255 + ((byArray[n6++] & 0xFF) << 8));
                    }
                } else {
                    n6 = 0;
                    for (n5 = 0; n5 < n4; ++n5) {
                        cArray[n5] = (char)(((byArray[n6++] & 0xFF) << 8) + byArray[n6++] & 0xFF);
                    }
                }
                fileInfo.sliceLabels[n3++] = new String(cArray);
                continue;
            }
            fileInfo.sliceLabels[n3++] = null;
        }
    }

    void getDisplayRanges(int n, FileInfo fileInfo) throws IOException {
        int n2 = this.metaDataCounts[n] / 8;
        fileInfo.displayRanges = new double[n2];
        for (int i = 0; i < n2; ++i) {
            fileInfo.displayRanges[i] = this.readDouble();
        }
    }

    void getLuts(int n, int n2, FileInfo fileInfo) throws IOException {
        fileInfo.channelLuts = new byte[n2 - n + 1][];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            int n4 = this.metaDataCounts[i];
            fileInfo.channelLuts[n3] = new byte[n4];
            this.in.readFully(fileInfo.channelLuts[n3], n4);
            ++n3;
        }
    }

    void getRoi(int n, FileInfo fileInfo) throws IOException {
        int n2 = this.metaDataCounts[n];
        fileInfo.roi = new byte[n2];
        this.in.readFully(fileInfo.roi, n2);
    }

    void getOverlay(int n, int n2, FileInfo fileInfo) throws IOException {
        fileInfo.overlay = new byte[n2 - n + 1][];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            int n4 = this.metaDataCounts[i];
            fileInfo.overlay[n3] = new byte[n4];
            this.in.readFully(fileInfo.overlay[n3], n4);
            ++n3;
        }
    }

    void error(String string) throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        throw new IOException(string);
    }

    void skipUnknownType(int n, int n2) throws IOException {
        byte[] byArray = new byte[this.metaDataCounts[n]];
        for (int i = n; i <= n2; ++i) {
            int n3 = this.metaDataCounts[i];
            if (n3 > byArray.length) {
                byArray = new byte[n3];
            }
            this.in.readFully(byArray, n3);
        }
    }

    public void enableDebugging() {
        this.debugMode = true;
    }

    public FileInfo[] getTiffInfo() throws IOException {
        FileInfo[] fileInfoArray;
        if (this.in == null) {
            this.in = new RandomAccessStream(new RandomAccessFile(new File(this.directory, this.name), "r"));
        }
        Vector<FileInfo[]> vector = new Vector<FileInfo[]>();
        long l = this.OpenImageFileHeader();
        if (l < 0L) {
            this.in.close();
            return null;
        }
        if (this.debugMode) {
            this.dInfo = "\n  " + this.name + ": opening\n";
        }
        while (l > 0L) {
            this.in.seek(l);
            fileInfoArray = this.OpenIFD();
            if (fileInfoArray != null) {
                vector.addElement(fileInfoArray);
                l = (long)this.getInt() & 0xFFFFFFFFL;
            } else {
                l = 0L;
            }
            if (this.debugMode && this.ifdCount < 10) {
                this.dInfo = this.dInfo + "  nextIFD=" + l + "\n";
            }
            if (fileInfoArray == null || fileInfoArray.nImages <= 1) continue;
            l = 0L;
        }
        if (vector.size() == 0) {
            this.in.close();
            return null;
        }
        fileInfoArray = new FileInfo[vector.size()];
        vector.copyInto(fileInfoArray);
        if (this.debugMode) {
            fileInfoArray[0].debugInfo = this.dInfo;
        }
        if (this.url != null) {
            this.in.seek(0);
            fileInfoArray[0].inputStream = this.in;
        } else {
            this.in.close();
        }
        if (fileInfoArray[0].info == null) {
            fileInfoArray[0].info = this.tiffMetadata;
        }
        if (this.debugMode) {
            int n = fileInfoArray.length;
            fileInfoArray[0].debugInfo = fileInfoArray[0].debugInfo + "number of images: " + n + "\n";
            fileInfoArray[0].debugInfo = fileInfoArray[0].debugInfo + "offset to first image: " + fileInfoArray[0].getOffset() + "\n";
            fileInfoArray[0].debugInfo = fileInfoArray[0].debugInfo + "gap between images: " + this.getGapInfo(fileInfoArray) + "\n";
            fileInfoArray[0].debugInfo = fileInfoArray[0].debugInfo + "little-endian byte order: " + fileInfoArray[0].intelByteOrder + "\n";
        }
        return fileInfoArray;
    }

    String getGapInfo(FileInfo[] fileInfoArray) {
        if (fileInfoArray.length < 2) {
            return "0";
        }
        long l = Long.MAX_VALUE;
        long l2 = -9223372036854775807L;
        for (int i = 1; i < fileInfoArray.length; ++i) {
            long l3 = fileInfoArray[i].getOffset() - fileInfoArray[i - 1].getOffset();
            if (l3 < l) {
                l = l3;
            }
            if (l3 <= l2) continue;
            l2 = l3;
        }
        long l4 = fileInfoArray[0].width * fileInfoArray[0].height * fileInfoArray[0].getBytesPerPixel();
        if ((l -= l4) == (l2 -= l4)) {
            return "" + l;
        }
        return "varies (" + l + " to " + l2 + ")";
    }
}

