/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.MacroConstants;

class Variable
implements MacroConstants,
Cloneable {
    static final int VALUE = 0;
    static final int ARRAY = 1;
    static final int STRING = 2;
    int symTabIndex;
    private double value;
    private String str;
    private Variable[] array;
    private int arraySize;

    Variable() {
    }

    Variable(double d) {
        this.value = d;
    }

    Variable(int n, double d, String string) {
        this.symTabIndex = n;
        this.value = d;
        this.str = string;
    }

    Variable(int n, double d, String string, Variable[] variableArray) {
        this.symTabIndex = n;
        this.value = d;
        this.str = string;
        this.array = variableArray;
    }

    Variable(byte[] byArray) {
        this.array = new Variable[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.array[i] = new Variable(byArray[i] & 0xFF);
        }
    }

    Variable(int[] nArray) {
        this.array = new Variable[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.array[i] = new Variable(nArray[i]);
        }
    }

    Variable(double[] dArray) {
        this.array = new Variable[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.array[i] = new Variable(dArray[i]);
        }
    }

    double getValue() {
        if (this.str != null) {
            return this.convertToDouble();
        }
        return this.value;
    }

    double convertToDouble() {
        try {
            Double d = new Double(this.str);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    void setValue(double d) {
        this.value = d;
        this.str = null;
        this.array = null;
    }

    String getString() {
        return this.str;
    }

    void setString(String string) {
        this.str = string;
        this.value = 0.0;
        this.array = null;
    }

    Variable[] getArray() {
        return this.array;
    }

    void setArray(Variable[] variableArray) {
        this.array = variableArray;
        this.value = 0.0;
        this.str = null;
        this.arraySize = 0;
    }

    void setArraySize(int n) {
        if (this.array == null) {
            n = 0;
        } else if (n > this.array.length) {
            n = this.array.length;
        }
        this.arraySize = n;
    }

    int getArraySize() {
        int n;
        int n2 = n = this.array != null ? this.array.length : 0;
        if (this.arraySize > 0) {
            n = this.arraySize;
        }
        return n;
    }

    int getType() {
        if (this.array != null) {
            return 1;
        }
        if (this.str != null) {
            return 2;
        }
        return 0;
    }

    public String toString() {
        String string = "";
        if (this.array != null) {
            string = string + "array[" + this.array.length + "]";
        } else if (this.str != null) {
            string = this.str;
            if (string.length() > 80) {
                string = string.substring(0, 80) + "...";
            }
            string = string.replaceAll("\n", " | ");
            string = "\"" + string + "\"";
        } else {
            string = this.value == (double)((int)this.value) ? string + (int)this.value : string + IJ.d2s(this.value, 4);
        }
        return string;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

