/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ResultsTable
implements Cloneable {
    public static final int MAX_COLUMNS = 150;
    public static final int COLUMN_NOT_FOUND = -1;
    public static final int COLUMN_IN_USE = -2;
    public static final int TABLE_FULL = -3;
    public static final int AREA = 0;
    public static final int MEAN = 1;
    public static final int STD_DEV = 2;
    public static final int MODE = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int X_CENTROID = 6;
    public static final int Y_CENTROID = 7;
    public static final int X_CENTER_OF_MASS = 8;
    public static final int Y_CENTER_OF_MASS = 9;
    public static final int PERIMETER = 10;
    public static final int ROI_X = 11;
    public static final int ROI_Y = 12;
    public static final int ROI_WIDTH = 13;
    public static final int ROI_HEIGHT = 14;
    public static final int MAJOR = 15;
    public static final int MINOR = 16;
    public static final int ANGLE = 17;
    public static final int CIRCULARITY = 18;
    public static final int FERET = 19;
    public static final int INTEGRATED_DENSITY = 20;
    public static final int MEDIAN = 21;
    public static final int SKEWNESS = 22;
    public static final int KURTOSIS = 23;
    public static final int AREA_FRACTION = 24;
    public static final int RAW_INTEGRATED_DENSITY = 25;
    public static final int CHANNEL = 26;
    public static final int SLICE = 27;
    public static final int FRAME = 28;
    public static final int FERET_X = 29;
    public static final int FERET_Y = 30;
    public static final int FERET_ANGLE = 31;
    public static final int MIN_FERET = 32;
    public static final int ASPECT_RATIO = 33;
    public static final int ROUNDNESS = 34;
    public static final int SOLIDITY = 35;
    public static final int LAST_HEADING = 35;
    private static final String[] defaultHeadings = new String[]{"Area", "Mean", "StdDev", "Mode", "Min", "Max", "X", "Y", "XM", "YM", "Perim.", "BX", "BY", "Width", "Height", "Major", "Minor", "Angle", "Circ.", "Feret", "IntDen", "Median", "Skew", "Kurt", "%Area", "RawIntDen", "Ch", "Slice", "Frame", "FeretX", "FeretY", "FeretAngle", "MinFeret", "AR", "Round", "Solidity"};
    private int maxRows = 100;
    private int maxColumns = 150;
    private String[] headings = new String[this.maxColumns];
    private boolean[] keep = new boolean[this.maxColumns];
    private int counter;
    private double[][] columns = new double[this.maxColumns][];
    private String[] rowLabels;
    private int lastColumn = -1;
    private StringBuffer sb;
    private int precision = 3;
    private String rowLabelHeading = "";
    private char delimiter = (char)9;
    private boolean headingSet;
    private boolean showRowNumbers = true;
    private static DecimalFormat[] df;
    private static DecimalFormat[] sf;
    private static DecimalFormatSymbols dfs;

    public static ResultsTable getResultsTable() {
        return Analyzer.getResultsTable();
    }

    public static TextWindow getResultsWindow() {
        Frame frame = WindowManager.getFrame("Results");
        if (frame == null || !(frame instanceof TextWindow)) {
            return null;
        }
        return (TextWindow)frame;
    }

    public synchronized void incrementCounter() {
        ++this.counter;
        if (this.counter == this.maxRows) {
            if (this.rowLabels != null) {
                String[] stringArray = new String[this.maxRows * 2];
                System.arraycopy(this.rowLabels, 0, stringArray, 0, this.maxRows);
                this.rowLabels = stringArray;
            }
            for (int i = 0; i <= this.lastColumn; ++i) {
                if (this.columns[i] == null) continue;
                double[] dArray = new double[this.maxRows * 2];
                System.arraycopy(this.columns[i], 0, dArray, 0, this.maxRows);
                this.columns[i] = dArray;
            }
            this.maxRows *= 2;
        }
    }

    public synchronized void addColumns() {
        String[] stringArray = new String[this.maxColumns * 2];
        System.arraycopy(this.headings, 0, stringArray, 0, this.maxColumns);
        this.headings = stringArray;
        double[][] dArrayArray = new double[this.maxColumns * 2][];
        for (int i = 0; i < this.maxColumns; ++i) {
            dArrayArray[i] = this.columns[i];
        }
        this.columns = dArrayArray;
        boolean[] blArray = new boolean[this.maxColumns * 2];
        System.arraycopy(this.keep, 0, blArray, 0, this.maxColumns);
        this.keep = blArray;
        this.maxColumns *= 2;
    }

    public int getCounter() {
        return this.counter;
    }

    public void addValue(int n, double d) {
        if (n >= this.maxColumns) {
            this.addColumns();
        }
        if (n < 0 || n >= this.maxColumns) {
            throw new IllegalArgumentException("Column out of range");
        }
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.columns[n] == null) {
            this.columns[n] = new double[this.maxRows];
            if (this.headings[n] == null) {
                this.headings[n] = "---";
            }
            if (n > this.lastColumn) {
                this.lastColumn = n;
            }
        }
        this.columns[n][this.counter - 1] = d;
    }

    public void addValue(String string, double d) {
        if (string == null) {
            throw new IllegalArgumentException("Column is null");
        }
        int n = this.getColumnIndex(string);
        if (n == -1) {
            n = this.getFreeColumn(string);
        }
        this.addValue(n, d);
        this.keep[n] = true;
    }

    public void addLabel(String string) {
        if (this.rowLabelHeading.equals("")) {
            this.rowLabelHeading = "Label";
        }
        this.addLabel(this.rowLabelHeading, string);
    }

    public void addLabel(String string, String string2) {
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
        }
        this.rowLabels[this.counter - 1] = string2;
        if (string != null) {
            this.rowLabelHeading = string;
        }
    }

    public void setLabel(String string, int n) {
        if (n < 0 || n >= this.counter) {
            throw new IllegalArgumentException("row>=counter");
        }
        if (this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
        }
        if (this.rowLabelHeading.equals("")) {
            this.rowLabelHeading = "Label";
        }
        this.rowLabels[n] = string;
    }

    public void disableRowLabels() {
        if (this.rowLabelHeading.equals("Label")) {
            this.rowLabels = null;
        }
    }

    public float[] getColumn(int n) {
        if (n < 0 || n >= this.maxColumns) {
            throw new IllegalArgumentException("Index out of range: " + n);
        }
        if (this.columns[n] == null) {
            return null;
        }
        float[] fArray = new float[this.counter];
        for (int i = 0; i < this.counter; ++i) {
            fArray[i] = (float)this.columns[n][i];
        }
        return fArray;
    }

    public double[] getColumnAsDoubles(int n) {
        if (n < 0 || n >= this.maxColumns) {
            throw new IllegalArgumentException("Index out of range: " + n);
        }
        if (this.columns[n] == null) {
            return null;
        }
        double[] dArray = new double[this.counter];
        for (int i = 0; i < this.counter; ++i) {
            dArray[i] = this.columns[n][i];
        }
        return dArray;
    }

    public boolean columnExists(int n) {
        if (n < 0 || n >= this.maxColumns) {
            return false;
        }
        return this.columns[n] != null;
    }

    public int getColumnIndex(String string) {
        for (int i = 0; i < this.headings.length; ++i) {
            if (this.headings[i] == null) {
                return -1;
            }
            if (!this.headings[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getFreeColumn(String string) {
        for (int i = 0; i < this.headings.length; ++i) {
            if (this.headings[i] == null) {
                this.columns[i] = new double[this.maxRows];
                this.headings[i] = string;
                if (i > this.lastColumn) {
                    this.lastColumn = i;
                }
                return i;
            }
            if (!this.headings[i].equals(string)) continue;
            return -2;
        }
        this.addColumns();
        ++this.lastColumn;
        this.columns[this.lastColumn] = new double[this.maxRows];
        this.headings[this.lastColumn] = string;
        return this.lastColumn;
    }

    public double getValueAsDouble(int n, int n2) {
        if (n >= this.maxColumns || n2 >= this.counter) {
            throw new IllegalArgumentException("Index out of range: " + n + "," + n2);
        }
        if (this.columns[n] == null) {
            throw new IllegalArgumentException("Column not defined: " + n);
        }
        return this.columns[n][n2];
    }

    public float getValue(int n, int n2) {
        return (float)this.getValueAsDouble(n, n2);
    }

    public double getValue(String string, int n) {
        if (n < 0 || n >= this.getCounter()) {
            throw new IllegalArgumentException("Row out of range");
        }
        int n2 = this.getColumnIndex(string);
        if (n2 == -1) {
            throw new IllegalArgumentException("\"" + string + "\" column not found");
        }
        return this.getValueAsDouble(n2, n);
    }

    public String getLabel(int n) {
        if (n < 0 || n >= this.getCounter()) {
            throw new IllegalArgumentException("Row out of range");
        }
        String string = null;
        if (this.rowLabels != null && this.rowLabels[n] != null) {
            string = this.rowLabels[n];
        }
        return string;
    }

    public void setValue(String string, int n, double d) {
        if (string == null) {
            throw new IllegalArgumentException("Column is null");
        }
        int n2 = this.getColumnIndex(string);
        if (n2 == -1) {
            n2 = this.getFreeColumn(string);
        }
        this.setValue(n2, n, d);
    }

    public void setValue(int n, int n2, double d) {
        if (n >= this.maxColumns) {
            this.addColumns();
        }
        if (n < 0 || n >= this.maxColumns) {
            throw new IllegalArgumentException("Column out of range");
        }
        if (n2 >= this.counter) {
            throw new IllegalArgumentException("row>=counter");
        }
        if (this.columns[n] == null) {
            this.columns[n] = new double[this.maxRows];
            if (n > this.lastColumn) {
                this.lastColumn = n;
            }
        }
        this.columns[n][n2] = d;
    }

    public String getColumnHeadings() {
        if (this.headingSet && !this.rowLabelHeading.equals("")) {
            for (int i = 0; i <= this.lastColumn; ++i) {
                if (this.columns[i] == null || !this.rowLabelHeading.equals(this.headings[i])) continue;
                this.headings[i] = null;
                this.columns[i] = null;
            }
            this.headingSet = false;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        if (this.showRowNumbers) {
            stringBuffer.append(" " + this.delimiter);
        }
        if (this.rowLabels != null) {
            stringBuffer.append(this.rowLabelHeading + this.delimiter);
        }
        for (int i = 0; i <= this.lastColumn; ++i) {
            if (this.columns[i] == null) continue;
            String string = this.headings[i];
            if (string == null) {
                string = "---";
            }
            stringBuffer.append(string);
            if (i == this.lastColumn) continue;
            stringBuffer.append(this.delimiter);
        }
        return new String(stringBuffer);
    }

    public String getColumnHeading(int n) {
        if (n < 0 || n >= this.maxColumns) {
            throw new IllegalArgumentException("Index out of range: " + n);
        }
        return this.headings[n];
    }

    public String getRowAsString(int n) {
        if (n < 0 || n >= this.counter) {
            throw new IllegalArgumentException("Row out of range: " + n);
        }
        if (this.sb == null) {
            this.sb = new StringBuffer(200);
        } else {
            this.sb.setLength(0);
        }
        if (this.showRowNumbers) {
            this.sb.append(Integer.toString(n + 1));
            this.sb.append(this.delimiter);
        }
        if (this.rowLabels != null) {
            if (this.rowLabels[n] != null) {
                String string = this.rowLabels[n];
                if (this.delimiter == ',') {
                    string = string.replaceAll(",", ";");
                }
                this.sb.append(string);
            }
            this.sb.append(this.delimiter);
        }
        for (int i = 0; i <= this.lastColumn; ++i) {
            if (this.columns[i] == null) continue;
            this.sb.append(this.n(this.columns[i][n]));
            if (i == this.lastColumn) continue;
            this.sb.append(this.delimiter);
        }
        return new String(this.sb);
    }

    public void setHeading(int n, String string) {
        if (n < 0 || n >= this.headings.length) {
            throw new IllegalArgumentException("Column out of range: " + n);
        }
        this.headings[n] = string;
        if (this.columns[n] == null) {
            this.columns[n] = new double[this.maxRows];
        }
        if (n > this.lastColumn) {
            this.lastColumn = n;
        }
        this.headingSet = true;
    }

    public void setDefaultHeadings() {
        for (int i = 0; i < defaultHeadings.length; ++i) {
            this.headings[i] = defaultHeadings[i];
        }
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void showRowNumbers(boolean bl) {
        this.showRowNumbers = bl;
    }

    String n(double d) {
        String string = (double)Math.round(d) == d && this.precision >= 0 ? ResultsTable.d2s(d, 0) : ResultsTable.d2s(d, this.precision);
        return string;
    }

    public static String d2s(double d, int n) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return "" + d;
        }
        if (d == 3.4028234663852886E38) {
            return "3.4e38";
        }
        double d2 = d;
        if (d < 0.0) {
            d2 = -d;
        }
        if (df == null) {
            dfs = new DecimalFormatSymbols(Locale.US);
            df = new DecimalFormat[10];
            ResultsTable.df[0] = new DecimalFormat("0", dfs);
            ResultsTable.df[1] = new DecimalFormat("0.0", dfs);
            ResultsTable.df[2] = new DecimalFormat("0.00", dfs);
            ResultsTable.df[3] = new DecimalFormat("0.000", dfs);
            ResultsTable.df[4] = new DecimalFormat("0.0000", dfs);
            ResultsTable.df[5] = new DecimalFormat("0.00000", dfs);
            ResultsTable.df[6] = new DecimalFormat("0.000000", dfs);
            ResultsTable.df[7] = new DecimalFormat("0.0000000", dfs);
            ResultsTable.df[8] = new DecimalFormat("0.00000000", dfs);
            ResultsTable.df[9] = new DecimalFormat("0.000000000", dfs);
        }
        if (d2 < 0.001 && d2 != 0.0 && d2 < 1.0 / Math.pow(10.0, n) || d2 > 9.99999999999E11 || n < 0) {
            if (n < 0) {
                if ((n = -n) > 9) {
                    n = 9;
                }
            } else {
                n = 3;
            }
            if (sf == null) {
                sf = new DecimalFormat[10];
                ResultsTable.sf[1] = new DecimalFormat("0.0E0", dfs);
                ResultsTable.sf[2] = new DecimalFormat("0.00E0", dfs);
                ResultsTable.sf[3] = new DecimalFormat("0.000E0", dfs);
                ResultsTable.sf[4] = new DecimalFormat("0.0000E0", dfs);
                ResultsTable.sf[5] = new DecimalFormat("0.00000E0", dfs);
                ResultsTable.sf[6] = new DecimalFormat("0.000000E0", dfs);
                ResultsTable.sf[7] = new DecimalFormat("0.0000000E0", dfs);
                ResultsTable.sf[8] = new DecimalFormat("0.00000000E0", dfs);
                ResultsTable.sf[9] = new DecimalFormat("0.000000000E0", dfs);
            }
            return sf[n].format(d);
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 9) {
            n = 9;
        }
        return df[n].format(d);
    }

    public synchronized void deleteRow(int n) {
        int n2;
        if (this.counter == 0 || n < 0 || n > this.counter - 1) {
            return;
        }
        if (this.rowLabels != null) {
            for (n2 = n; n2 < this.counter - 1; ++n2) {
                this.rowLabels[n2] = this.rowLabels[n2 + 1];
            }
        }
        for (n2 = 0; n2 <= this.lastColumn; ++n2) {
            if (this.columns[n2] == null) continue;
            for (int i = n; i < this.counter - 1; ++i) {
                this.columns[n2][i] = this.columns[n2][i + 1];
            }
        }
        --this.counter;
    }

    public synchronized void reset() {
        this.counter = 0;
        this.maxRows = 100;
        for (int i = 0; i < this.maxColumns; ++i) {
            this.columns[i] = null;
            this.headings[i] = null;
            this.keep[i] = false;
        }
        this.lastColumn = -1;
        this.rowLabels = null;
    }

    public int getLastColumn() {
        return this.lastColumn;
    }

    public void addResults() {
        if (this.counter == 1) {
            IJ.setColumnHeadings(this.getColumnHeadings());
        }
        TextPanel textPanel = IJ.getTextPanel();
        String string = this.getRowAsString(this.counter - 1);
        if (textPanel != null) {
            textPanel.appendWithoutUpdate(string);
        } else {
            System.out.println(string);
        }
    }

    public void updateResults() {
        TextPanel textPanel = IJ.getTextPanel();
        if (textPanel != null) {
            textPanel.updateColumnHeadings(this.getColumnHeadings());
            textPanel.updateDisplay();
        }
    }

    public void show(String string) {
        Serializable serializable;
        TextPanel textPanel;
        if (!string.equals("Results") && this == Analyzer.getResultsTable()) {
            IJ.log("ResultsTable.show(): the system ResultTable should only be displayed in the \"Results\" window.");
        }
        String string2 = this.getColumnHeadings();
        boolean bl = false;
        if (string.equals("Results")) {
            textPanel = IJ.getTextPanel();
            if (textPanel == null) {
                return;
            }
            bl = textPanel.getLineCount() == 0;
            IJ.setColumnHeadings(string2);
            if (this != Analyzer.getResultsTable()) {
                Analyzer.setResultsTable(this);
            }
            if (this.getCounter() > 0) {
                Analyzer.setUnsavedMeasurements(true);
            }
        } else {
            Frame frame = WindowManager.getFrame(string);
            serializable = frame != null && frame instanceof TextWindow ? (TextWindow)frame : new TextWindow(string, "", 400, 300);
            textPanel = ((TextWindow)serializable).getTextPanel();
            textPanel.setColumnHeadings(string2);
            bl = textPanel.getLineCount() == 0;
        }
        textPanel.setResultsTable(this);
        int n = this.getCounter();
        if (n > 0) {
            if (textPanel.getLineCount() > 0) {
                textPanel.clear();
            }
            serializable = new StringBuffer(n * string2.length());
            for (int i = 0; i < n; ++i) {
                ((StringBuffer)serializable).append(this.getRowAsString(i) + "\n");
            }
            textPanel.append(new String((StringBuffer)serializable));
        }
        if (bl) {
            textPanel.scrollToTop();
        }
    }

    public void update(int n, ImagePlus imagePlus, Roi roi) {
        if (roi == null && imagePlus != null) {
            roi = imagePlus.getRoi();
        }
        ResultsTable resultsTable = new ResultsTable();
        Analyzer analyzer = new Analyzer(imagePlus, n, resultsTable);
        ByteProcessor byteProcessor = new ByteProcessor(1, 1);
        ByteStatistics byteStatistics = new ByteStatistics(byteProcessor, n, null);
        analyzer.saveResults(byteStatistics, roi);
        int n2 = resultsTable.getLastColumn();
        while (n2 + 1 >= this.getMaxColumns()) {
            this.addColumns();
        }
        if (n2 < this.getLastColumn() && (n2 = this.getLastColumn()) >= resultsTable.getMaxColumns()) {
            n2 = resultsTable.getMaxColumns() - 1;
        }
        for (int i = 0; i <= n2; ++i) {
            if (resultsTable.getColumn(i) != null && this.columns[i] == null) {
                this.columns[i] = new double[this.maxRows];
                this.headings[i] = resultsTable.getColumnHeading(i);
                if (i <= this.lastColumn) continue;
                this.lastColumn = i;
                continue;
            }
            if (resultsTable.getColumn(i) != null || this.columns[i] == null || this.keep[i]) continue;
            this.columns[i] = null;
        }
        if (resultsTable.getRowLabels() == null) {
            this.rowLabels = null;
        } else if (resultsTable.getRowLabels() != null && this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
            this.rowLabelHeading = "Label";
        }
        if (this.getCounter() > 0) {
            this.show("Results");
        }
    }

    int getMaxColumns() {
        return this.maxColumns;
    }

    String[] getRowLabels() {
        return this.rowLabels;
    }

    public static ResultsTable open(String string) throws IOException {
        int n;
        String[] stringArray;
        int n2;
        int n3;
        int n4;
        String string2 = IJ.openAsString(string);
        if (string2.startsWith("Error:")) {
            throw new IOException("text.substring(7)");
        }
        String[] stringArray2 = Tools.split(string2, "\n");
        if (stringArray2.length == 0) {
            throw new IOException("Table is empty or invalid");
        }
        String[] stringArray3 = Tools.split(stringArray2[0], ",\t");
        if (stringArray3.length == 1) {
            throw new IOException("This is not a tab or comma delimited text file.");
        }
        int n5 = 0;
        for (n4 = 0; n4 < stringArray3.length; ++n4) {
            if (!stringArray3[n4].equals("NaN") && Double.isNaN(Tools.parseDouble(stringArray3[n4]))) continue;
            ++n5;
        }
        int n6 = n4 = n5 == stringArray3.length ? 1 : 0;
        if (n4 != 0) {
            for (n3 = 0; n3 < stringArray3.length; ++n3) {
                stringArray3[n3] = "C" + (n3 + 1);
            }
        }
        n3 = stringArray3[0].equals(" ") ? 1 : 0;
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            stringArray3[n2] = stringArray3[n2].trim();
        }
        n2 = n4 != 0 ? 0 : 1;
        boolean bl = n3 == 1 && stringArray3[1].equals("Label");
        int n7 = 0;
        if (!bl && (n7 = ResultsTable.openNonNumericTable(string, stringArray2, n2, ",\t")) == 2) {
            return null;
        }
        if (!bl && n7 == 1) {
            bl = true;
        }
        if (stringArray2[0].startsWith("\t")) {
            stringArray = new String[stringArray3.length + 1];
            stringArray[0] = " ";
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray[n + 1] = stringArray3[n];
            }
            stringArray3 = stringArray;
            n3 = 1;
        }
        stringArray = new ResultsTable();
        for (n = n2; n < stringArray2.length; ++n) {
            stringArray.incrementCounter();
            String[] stringArray4 = Tools.split(stringArray2[n], ",\t");
            for (int i = n3; i < stringArray4.length; ++i) {
                if (i == 1 && bl) {
                    stringArray.addLabel(stringArray3[1], stringArray4[1]);
                    continue;
                }
                if (i >= stringArray3.length) continue;
                stringArray.addValue(stringArray3[i], Tools.parseDouble(stringArray4[i]));
            }
        }
        return stringArray;
    }

    static int openNonNumericTable(String string, String[] stringArray, int n, String string2) {
        int n2;
        if (stringArray.length < 2) {
            return 0;
        }
        String[] stringArray2 = Tools.split(stringArray[1], string2);
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (stringArray2[n2].equals("NaN") || !Double.isNaN(Tools.parseDouble(stringArray2[n2]))) continue;
            ++n3;
            n4 = n2;
        }
        n2 = string.endsWith(".csv") ? 1 : 0;
        if (n3 == 0) {
            return 0;
        }
        if (n3 == 1 && n4 == 1) {
            return 1;
        }
        if (n2 != 0) {
            stringArray[0] = stringArray[0].replaceAll(",", "\t");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\n");
        }
        String string3 = stringBuffer.toString();
        if (n2 != 0) {
            string3 = string3.replaceAll(",", "\t");
        }
        new TextWindow(new File(string).getName(), stringArray[0], string3, 500, 400);
        return 2;
    }

    public void saveAs(String string) throws IOException {
        Object object;
        Object object2;
        if (this.getCounter() == 0 && this.lastColumn < 0) {
            return;
        }
        if (string == null || string.equals("")) {
            object2 = new SaveDialog("Save Results", "Results", Prefs.get("options.ext", ".xls"));
            object = ((SaveDialog)object2).getFileName();
            if (object == null) {
                return;
            }
            string = ((SaveDialog)object2).getDirectory() + (String)object;
        }
        this.delimiter = (char)(string.endsWith(".csv") ? 44 : 9);
        object2 = null;
        object = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
        object2 = new PrintWriter(bufferedOutputStream);
        boolean bl = this.showRowNumbers;
        if (Prefs.dontSaveRowNumbers) {
            this.showRowNumbers = false;
        }
        if (!Prefs.dontSaveHeaders) {
            String string2 = this.getColumnHeadings();
            ((PrintWriter)object2).println(string2);
        }
        for (int i = 0; i < this.getCounter(); ++i) {
            ((PrintWriter)object2).println(this.getRowAsString(i));
        }
        this.showRowNumbers = bl;
        ((PrintWriter)object2).close();
        this.delimiter = (char)9;
    }

    public static String getDefaultHeading(int n) {
        if (n >= 0 && n < defaultHeadings.length) {
            return defaultHeadings[n];
        }
        return "null";
    }

    public synchronized Object clone() {
        try {
            int n;
            ResultsTable resultsTable = (ResultsTable)super.clone();
            resultsTable.headings = new String[this.headings.length];
            for (n = 0; n <= this.lastColumn; ++n) {
                resultsTable.headings[n] = this.headings[n];
            }
            resultsTable.columns = new double[this.columns.length][];
            for (n = 0; n <= this.lastColumn; ++n) {
                if (this.columns[n] == null) continue;
                double[] dArray = new double[this.maxRows];
                for (int i = 0; i < this.counter; ++i) {
                    dArray[i] = this.columns[n][i];
                }
                resultsTable.columns[n] = dArray;
            }
            if (this.rowLabels != null) {
                resultsTable.rowLabels = new String[this.rowLabels.length];
                for (n = 0; n < this.counter; ++n) {
                    resultsTable.rowLabels[n] = this.rowLabels[n];
                }
            }
            return resultsTable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "ctr=" + this.counter + ", hdr=" + this.getColumnHeadings();
    }
}

