/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class BrowserLauncher
implements PlugIn {
    private static Class mrjFileUtilsClass;
    private static Method openURL;
    private static boolean error;

    @Override
    public void run(String string) {
        Applet applet;
        if (error) {
            return;
        }
        if (string == null || string.equals("")) {
            string = "http://imagej.nih.gov/ij";
        }
        if ((applet = IJ.getApplet()) != null) {
            try {
                applet.getAppletContext().showDocument(new URL(string), "_blank");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            BrowserLauncher.openURL(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void openURL(String string) throws IOException {
        String string2 = "";
        if (IJ.isMacOSX()) {
            if (IJ.isJava16()) {
                IJ.runMacro("exec('open', '" + string + "')");
            } else {
                try {
                    Method method = mrjFileUtilsClass.getDeclaredMethod("sharedWorkspace", new Class[0]);
                    Object object = method.invoke((Object)mrjFileUtilsClass, new Object[0]);
                    openURL.invoke(object, new URL(string));
                }
                catch (Exception exception) {
                    string2 = "" + exception;
                }
            }
        } else {
            if (IJ.isWindows()) {
                String string3 = "rundll32 url.dll,FileProtocolHandler " + string;
                if (System.getProperty("os.name").startsWith("Windows 2000")) {
                    string3 = "rundll32 shell32.dll,ShellExec_RunDLL " + string;
                }
                Process process = Runtime.getRuntime().exec(string3);
                try {
                    process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("InterruptedException while launching browser: " + interruptedException.getMessage());
                }
            }
            String[] stringArray = new String[]{"xdg-open", "netscape", "firefox", "konqueror", "mozilla", "opera", "epiphany", "lynx"};
            String string4 = null;
            try {
                for (int i = 0; i < stringArray.length && string4 == null; ++i) {
                    String[] stringArray2 = new String[]{"which", stringArray[i]};
                    if (Runtime.getRuntime().exec(stringArray2).waitFor() != 0) continue;
                    string4 = stringArray[i];
                }
                if (string4 == null) {
                    IJ.error("BrowserLauncher", "Could not find a browser");
                } else {
                    Runtime.getRuntime().exec(new String[]{string4, string});
                }
            }
            catch (Exception exception) {
                throw new IOException("Exception while launching browser: " + exception.getMessage());
            }
        }
    }

    private static void loadClasses() {
        if (IJ.isMacOSX() && !IJ.isJava16() && IJ.getApplet() == null) {
            try {
                if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                    URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                    mrjFileUtilsClass = Class.forName("com.apple.cocoa.application.NSWorkspace", true, uRLClassLoader);
                } else {
                    mrjFileUtilsClass = Class.forName("com.apple.cocoa.application.NSWorkspace");
                }
                openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", URL.class);
            }
            catch (Exception exception) {
                IJ.log("BrowserLauncher" + exception);
                error = true;
            }
        }
    }

    static {
        BrowserLauncher.loadClasses();
    }
}

