/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.util.Vector;

public class ClassChecker
implements PlugIn {
    String[] paths;
    String[] names;

    @Override
    public void run(String string) {
        this.deleteDuplicates();
    }

    void deleteDuplicates() {
        int n;
        this.getPathsAndNames();
        if (this.paths == null || this.paths.length < 2) {
            return;
        }
        String[] stringArray = new String[this.names.length];
        for (n = 0; n < this.names.length; ++n) {
            stringArray[n] = this.names[n];
        }
        StringSorter.sort(stringArray);
        for (n = 0; n < stringArray.length - 1; ++n) {
            if (!stringArray[n].equals(stringArray[n + 1])) continue;
            this.delete(stringArray[n]);
        }
    }

    void delete(String string) {
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < this.names.length; ++i) {
            long l;
            if (string2 == null && this.names[i].equals(string)) {
                string2 = this.paths[i] + this.names[i];
            } else if (string3 == null && this.names[i].equals(string)) {
                string3 = this.paths[i] + this.names[i];
            }
            if (string2 == null || string3 == null) continue;
            File file = new File(string2);
            File file2 = new File(string3);
            if (file == null || file2 == null) {
                return;
            }
            long l2 = file.lastModified();
            if (l2 < (l = file2.lastModified())) {
                this.write(string2);
                file.delete();
                break;
            }
            this.write(string3);
            file2.delete();
            break;
        }
    }

    void write(String string) {
        IJ.log("Deleting duplicate plugin: " + string);
    }

    void getPathsAndNames() {
        String string = Menus.getPlugInsPath();
        if (string == null) {
            return;
        }
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        Vector<String> vector = new Vector<String>(1000);
        Vector<String> vector2 = new Vector<String>(1000);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.endsWith(".class") || string2.endsWith(".jar")) {
                vector.addElement(string);
                vector2.addElement(string2);
                continue;
            }
            this.getSubdirectoryFiles(string, string2, vector, vector2);
        }
        this.paths = new String[vector.size()];
        vector.copyInto(this.paths);
        this.names = new String[vector2.size()];
        vector2.copyInto(this.names);
    }

    void getSubdirectoryFiles(String string, String string2, Vector vector, Vector vector2) {
        if (string2.endsWith(".java")) {
            return;
        }
        File file = new File(string, string2);
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        string2 = string2 + Prefs.separator;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.endsWith(".class") && !string3.endsWith(".jar")) continue;
            vector.addElement(string + string2);
            vector2.addElement(string3);
        }
    }
}

