/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;

public class Clipboard
implements PlugIn,
Transferable {
    static java.awt.datatransfer.Clipboard clipboard;

    @Override
    public void run(String string) {
        if (IJ.altKeyDown()) {
            if (string.equals("copy")) {
                string = "scopy";
            } else if (string.equals("paste")) {
                string = "spaste";
            }
        }
        if (string.equals("copy")) {
            this.copy(false);
        } else if (string.equals("paste")) {
            this.paste();
        } else if (string.equals("cut")) {
            this.copy(true);
        } else if (string.equals("scopy")) {
            this.copyToSystem();
        } else if (string.equals("showsys")) {
            this.showSystemClipboard();
        } else if (string.equals("show")) {
            this.showInternalClipboard();
        }
    }

    void copy(boolean bl) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            imagePlus.copy(bl);
        } else {
            IJ.noImage();
        }
    }

    void paste() {
        if (ImagePlus.getClipboard() == null) {
            this.showSystemClipboard();
        } else {
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.paste();
            } else {
                this.showInternalClipboard();
            }
        }
    }

    void setup() {
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }

    void copyToSystem() {
        this.setup();
        try {
            clipboard.setContents(this, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void showSystemClipboard() {
        this.setup();
        IJ.showStatus("Opening system clipboard...");
        try {
            Object object;
            Transferable transferable = clipboard.getContents(null);
            boolean bl = transferable.isDataFlavorSupported(DataFlavor.imageFlavor);
            boolean bl2 = transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (!bl && IJ.isMacOSX() && !IJ.isJava16() && (object = IJ.runPlugIn("MacClipboard", "")) != null && object instanceof ImagePlus && ((ImagePlus)object).getImage() != null) {
                return;
            }
            if (bl) {
                object = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                if (object == null) {
                    IJ.error("Unable to convert image on system clipboard");
                    IJ.showStatus("");
                    return;
                }
                int n = ((Image)object).getWidth(null);
                int n2 = ((Image)object).getHeight(null);
                BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage((Image)object, 0, 0, null);
                graphics2D.dispose();
                WindowManager.checkForDuplicateName = true;
                new ImagePlus("Clipboard", bufferedImage).show();
            } else if (bl2) {
                object = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (IJ.isMacintosh()) {
                    object = Tools.fixNewLines((String)object);
                }
                Editor editor = new Editor();
                editor.setSize(600, 300);
                editor.create("Clipboard", (String)object);
                IJ.showStatus("");
            } else {
                IJ.error("Unable to find an image on the system clipboard");
            }
        }
        catch (Throwable throwable) {
            IJ.handleException(throwable);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DataFlavor.imageFlavor.equals(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            ImageProcessor imageProcessor;
            if (imagePlus.isComposite()) {
                imageProcessor = new ColorProcessor(imagePlus.getImage());
                imageProcessor.setRoi(imagePlus.getRoi());
            } else {
                imageProcessor = imagePlus.getProcessor();
            }
            imageProcessor = imageProcessor.crop();
            int n = imageProcessor.getWidth();
            int n2 = imageProcessor.getHeight();
            IJ.showStatus(n + "x" + n2 + " image copied to system clipboard");
            Image image = IJ.getInstance().createImage(n, n2);
            Graphics graphics = image.getGraphics();
            graphics.drawImage(imageProcessor.createImage(), 0, 0, null);
            graphics.dispose();
            return image;
        }
        return null;
    }

    void showInternalClipboard() {
        ImagePlus imagePlus = ImagePlus.getClipboard();
        if (imagePlus != null) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            ImagePlus imagePlus2 = new ImagePlus("Clipboard", imageProcessor.duplicate());
            Roi roi = imagePlus.getRoi();
            imagePlus2.killRoi();
            if (roi != null && roi.isArea() && roi.getType() != 0) {
                roi = (Roi)roi.clone();
                roi.setLocation(0, 0);
                imagePlus2.setRoi(roi);
                IJ.run(imagePlus2, "Clear Outside", null);
                imagePlus2.killRoi();
            }
            WindowManager.checkForDuplicateName = true;
            imagePlus2.show();
        } else {
            IJ.error("The internal clipboard is empty.");
        }
    }
}

