/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ColorChooser;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.measure.SplineFitter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;

class ColorPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    static final int entryWidth = 12;
    static final int entryHeight = 12;
    int rows = 16;
    int columns = 16;
    Color[] c = new Color[256];
    Color b;
    ColorProcessor cp;
    IndexColorModel origin;
    private ImagePlus imp;
    private int[] xSize = new int[256];
    private int[] redY;
    private int[] greenY;
    private int[] blueY;
    private int mapSize;
    private int x;
    private int y;
    private int initialC = -1;
    private int finalC = -1;
    private byte[] reds;
    private byte[] greens;
    private byte[] blues;
    private boolean updateLut;
    private static String[] choices = new String[]{"Replication", "Interpolation", "Spline Fitting"};
    private static String scaleMethod = choices[1];
    private int bitDepth;

    ColorPanel(ImagePlus imagePlus) {
        this.setup(imagePlus);
    }

    public void setup(ImagePlus imagePlus) {
        IndexColorModel indexColorModel;
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        this.imp = imagePlus;
        this.bitDepth = imagePlus.getBitDepth();
        ImageProcessor imageProcessor = imagePlus.getChannelProcessor();
        this.origin = indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        this.mapSize = indexColorModel.getMapSize();
        this.reds = new byte[256];
        this.greens = new byte[256];
        this.blues = new byte[256];
        indexColorModel.getReds(this.reds);
        indexColorModel.getGreens(this.greens);
        indexColorModel.getBlues(this.blues);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        for (int i = 0; i < this.mapSize; ++i) {
            this.c[i] = new Color(this.reds[i] & 0xFF, this.greens[i] & 0xFF, this.blues[i] & 0xFF);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.columns * 12, this.rows * 12);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.columns * 12, this.rows * 12);
    }

    int getMouseZone(int n, int n2) {
        int n3 = n / 12;
        int n4 = n2 / 12;
        int n5 = this.columns * n4 + n3;
        return n5;
    }

    public void colorRamp() {
        int n;
        if (this.initialC > this.finalC) {
            int n2 = this.initialC;
            this.initialC = this.finalC;
            this.finalC = n2;
        }
        float f = this.finalC - this.initialC + 1;
        int n3 = (byte)this.c[this.initialC].getRed() & 0xFF;
        int n4 = (byte)this.c[this.finalC].getRed() & 0xFF;
        float f2 = (float)(n4 - n3) / f;
        for (int i = this.initialC; i <= this.finalC; ++i) {
            this.reds[i] = (byte)((float)n3 + (float)(i - this.initialC) * f2);
        }
        n3 = (byte)this.c[this.initialC].getGreen() & 0xFF;
        n4 = (byte)this.c[this.finalC].getGreen() & 0xFF;
        float f3 = (float)(n4 - n3) / f;
        for (int i = this.initialC; i <= this.finalC; ++i) {
            this.greens[i] = (byte)((float)n3 + (float)(i - this.initialC) * f3);
        }
        n3 = (byte)this.c[this.initialC].getBlue() & 0xFF;
        n4 = (byte)this.c[this.finalC].getBlue() & 0xFF;
        float f4 = (float)(n4 - n3) / f;
        for (n = this.initialC; n <= this.finalC; ++n) {
            this.blues[n] = (byte)((float)n3 + (float)(n - this.initialC) * f4);
        }
        for (n = this.initialC; n <= this.finalC; ++n) {
            this.c[n] = new Color(this.reds[n] & 0xFF, this.greens[n] & 0xFF, this.blues[n] & 0xFF);
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        this.initialC = this.getMouseZone(this.x, this.y);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        this.finalC = this.getMouseZone(this.x, this.y);
        if (this.initialC >= this.mapSize && this.finalC >= this.mapSize) {
            this.finalC = -1;
            this.initialC = -1;
            return;
        }
        if (this.initialC >= this.mapSize) {
            this.initialC = this.mapSize - 1;
        }
        if (this.finalC >= this.mapSize) {
            this.finalC = this.mapSize - 1;
        }
        if (this.finalC < 0) {
            this.finalC = 0;
        }
        if (this.initialC == this.finalC) {
            this.b = this.c[this.finalC];
            ColorChooser colorChooser = new ColorChooser("Color at Entry " + this.finalC, this.c[this.finalC], false);
            this.c[this.finalC] = colorChooser.getColor();
            if (this.c[this.finalC] == null) {
                this.c[this.finalC] = this.b;
            }
            this.colorRamp();
        } else {
            this.b = this.c[this.initialC];
            ColorChooser colorChooser = new ColorChooser("Initial Entry (" + this.initialC + ")", this.c[this.initialC], false);
            this.c[this.initialC] = colorChooser.getColor();
            if (this.c[this.initialC] == null) {
                this.c[this.initialC] = this.b;
                this.finalC = -1;
                this.initialC = -1;
                return;
            }
            this.b = this.c[this.finalC];
            ColorChooser colorChooser2 = new ColorChooser("Final Entry (" + this.finalC + ")", this.c[this.finalC], false);
            this.c[this.finalC] = colorChooser2.getColor();
            if (this.c[this.finalC] == null) {
                this.c[this.finalC] = this.b;
                this.finalC = -1;
                this.initialC = -1;
                return;
            }
            this.colorRamp();
        }
        this.finalC = -1;
        this.initialC = -1;
        this.applyLUT();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        this.finalC = this.getMouseZone(this.x, this.y);
        IJ.showStatus("index=" + this.getIndex(this.finalC));
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        int n = this.getMouseZone(this.x, this.y);
        if (n < this.mapSize) {
            int n2 = this.reds[n] & 0xFF;
            int n3 = this.greens[n] & 0xFF;
            int n4 = this.blues[n] & 0xFF;
            IJ.showStatus("index=" + this.getIndex(n) + ", color=" + n2 + "," + n3 + "," + n4);
        } else {
            IJ.showStatus("");
        }
    }

    final String getIndex(int n) {
        if (this.bitDepth == 8) {
            return "" + n;
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        Calibration calibration = this.imp.getCalibration();
        d = calibration.getCValue(d);
        d2 = calibration.getCValue(d2);
        double d3 = d + (double)n / 255.0 * (d2 - d);
        int n2 = d2 - d < 100.0 ? 2 : 0;
        return n + " (" + IJ.d2s(d3, n2) + ")";
    }

    void open() {
        try {
            IJ.run("LUT... ");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.updateLut = true;
        this.repaint();
    }

    void updateLut() {
        IndexColorModel indexColorModel = (IndexColorModel)this.imp.getChannelProcessor().getColorModel();
        if (this.mapSize == 0) {
            return;
        }
        indexColorModel.getReds(this.reds);
        indexColorModel.getGreens(this.greens);
        indexColorModel.getBlues(this.blues);
        for (int i = 0; i < this.mapSize; ++i) {
            this.c[i] = new Color(this.reds[i] & 0xFF, this.greens[i] & 0xFF, this.blues[i] & 0xFF);
        }
    }

    void invert() {
        int n;
        byte[] byArray = new byte[this.mapSize];
        byte[] byArray2 = new byte[this.mapSize];
        byte[] byArray3 = new byte[this.mapSize];
        for (n = 0; n < this.mapSize; ++n) {
            byArray[n] = (byte)(this.reds[this.mapSize - n - 1] & 0xFF);
            byArray2[n] = (byte)(this.greens[this.mapSize - n - 1] & 0xFF);
            byArray3[n] = (byte)(this.blues[this.mapSize - n - 1] & 0xFF);
        }
        this.reds = byArray;
        this.greens = byArray2;
        this.blues = byArray3;
        for (n = 0; n < this.mapSize; ++n) {
            this.c[n] = new Color(this.reds[n] & 0xFF, this.greens[n] & 0xFF, this.blues[n] & 0xFF);
        }
        this.applyLUT();
        this.repaint();
    }

    void resize() {
        GenericDialog genericDialog = new GenericDialog("LUT Editor");
        genericDialog.addNumericField("Number of Colors:", this.mapSize, 0);
        genericDialog.addChoice("Scale Using:", choices, scaleMethod);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.cancelLUT();
            return;
        }
        int n = (int)genericDialog.getNextNumber();
        if (n < 2) {
            n = 2;
        }
        if (n > 256) {
            n = 256;
        }
        scaleMethod = genericDialog.getNextChoice();
        this.scale(this.reds, this.greens, this.blues, n);
        this.mapSize = n;
        for (int i = 0; i < this.mapSize; ++i) {
            this.c[i] = new Color(this.reds[i] & 0xFF, this.greens[i] & 0xFF, this.blues[i] & 0xFF);
        }
        this.applyLUT();
        this.repaint();
    }

    void scale(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        if (n == this.mapSize) {
            return;
        }
        if (n < this.mapSize || scaleMethod.equals(choices[0])) {
            this.scaleUsingReplication(byArray, byArray2, byArray3, n);
        } else if (scaleMethod.equals(choices[1])) {
            this.scaleUsingInterpolation(byArray, byArray2, byArray3, n);
        } else {
            this.scaleUsingSplineFitting(byArray, byArray2, byArray3, n);
        }
    }

    void scaleUsingReplication(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int n2;
        byte[] byArray4 = new byte[256];
        byte[] byArray5 = new byte[256];
        byte[] byArray6 = new byte[256];
        for (n2 = 0; n2 < this.mapSize; ++n2) {
            byArray4[n2] = byArray[n2];
            byArray5[n2] = byArray2[n2];
            byArray6[n2] = byArray3[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = (int)((double)n2 * ((double)this.mapSize / (double)n));
            byArray[n2] = byArray4[n3];
            byArray2[n2] = byArray5[n3];
            byArray3[n2] = byArray6[n3];
        }
    }

    void scaleUsingInterpolation(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int[] nArray = new int[this.mapSize];
        int[] nArray2 = new int[this.mapSize];
        int[] nArray3 = new int[this.mapSize];
        for (int i = 0; i < this.mapSize; ++i) {
            nArray[i] = byArray[i] & 0xFF;
            nArray2[i] = byArray2[i] & 0xFF;
            nArray3[i] = byArray3[i] & 0xFF;
        }
        double d = (double)(this.mapSize - 1) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            int n2 = (int)((double)i * d);
            int n3 = n2 + 1;
            if (n3 == this.mapSize) {
                n3 = this.mapSize - 1;
            }
            double d2 = (double)i * d - (double)n2;
            byArray[i] = (byte)((1.0 - d2) * (double)nArray[n2] + d2 * (double)nArray[n3]);
            byArray2[i] = (byte)((1.0 - d2) * (double)nArray2[n2] + d2 * (double)nArray2[n3]);
            byArray3[i] = (byte)((1.0 - d2) * (double)nArray3[n2] + d2 * (double)nArray3[n3]);
        }
    }

    void scaleUsingSplineFitting(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int[] nArray = new int[this.mapSize];
        int[] nArray2 = new int[this.mapSize];
        int[] nArray3 = new int[this.mapSize];
        for (int i = 0; i < this.mapSize; ++i) {
            nArray[i] = byArray[i] & 0xFF;
            nArray2[i] = byArray2[i] & 0xFF;
            nArray3[i] = byArray3[i] & 0xFF;
        }
        int[] nArray4 = new int[this.mapSize];
        for (int i = 0; i < this.mapSize; ++i) {
            nArray4[i] = (int)((double)i * (double)n / (double)(this.mapSize - 1));
        }
        SplineFitter splineFitter = new SplineFitter(nArray4, nArray, this.mapSize);
        SplineFitter splineFitter2 = new SplineFitter(nArray4, nArray2, this.mapSize);
        SplineFitter splineFitter3 = new SplineFitter(nArray4, nArray3, this.mapSize);
        for (int i = 0; i < n; ++i) {
            double d = Math.round(splineFitter.evalSpline(nArray4, nArray, this.mapSize, i));
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 255.0) {
                d = 255.0;
            }
            byArray[i] = (byte)d;
            d = Math.round(splineFitter2.evalSpline(nArray4, nArray2, this.mapSize, i));
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 255.0) {
                d = 255.0;
            }
            byArray2[i] = (byte)d;
            d = Math.round(splineFitter3.evalSpline(nArray4, nArray3, this.mapSize, i));
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 255.0) {
                d = 255.0;
            }
            byArray3[i] = (byte)d;
        }
    }

    public void cancelLUT() {
        if (this.mapSize == 0) {
            return;
        }
        this.origin.getReds(this.reds);
        this.origin.getGreens(this.greens);
        this.origin.getBlues(this.blues);
        this.mapSize = 256;
        this.applyLUT();
    }

    public void applyLUT() {
        byte[] byArray = this.reds;
        byte[] byArray2 = this.greens;
        byte[] byArray3 = this.blues;
        if (this.mapSize < 256) {
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            for (int i = 0; i < this.mapSize; ++i) {
                byArray[i] = this.reds[i];
                byArray2[i] = this.greens[i];
                byArray3[i] = this.blues[i];
            }
            this.scale(byArray, byArray2, byArray3, 256);
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        ImageProcessor imageProcessor = this.imp.getChannelProcessor();
        imageProcessor.setColorModel(indexColorModel);
        if (this.imp.isComposite()) {
            ((CompositeImage)this.imp).setChannelColorModel(indexColorModel);
        }
        if (this.imp.getStackSize() > 1 && !this.imp.isComposite()) {
            this.imp.getStack().setColorModel(indexColorModel);
        }
        this.imp.updateAndDraw();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.updateLut) {
            this.updateLut();
            this.updateLut = false;
        }
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (n >= this.mapSize) {
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(j * 12, i * 12, 12, 12);
                } else if (n <= this.finalC && n >= this.initialC || n >= this.finalC && n <= this.initialC) {
                    graphics.setColor(this.c[n].brighter());
                    graphics.fillRect(j * 12, i * 12, 12, 12);
                    graphics.setColor(Color.white);
                    graphics.drawRect(j * 12, i * 12, 12, 12);
                    graphics.setColor(Color.black);
                    graphics.drawLine(j * 12 + 12 - 1, i * 12, j * 12 + 12 - 1, i * 12 + 12);
                    graphics.drawLine(j * 12, i * 12 + 12 - 1, j * 12 + 12 - 1, i * 12 + 12 - 1);
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(this.c[n]);
                    graphics.fillRect(j * 12, i * 12, 12, 12);
                    graphics.setColor(Color.white);
                    graphics.drawRect(j * 12, i * 12, 11, 11);
                    graphics.setColor(Color.black);
                    graphics.drawLine(j * 12, i * 12, j * 12 + 12 - 1, i * 12);
                    graphics.drawLine(j * 12, i * 12, j * 12, i * 12 + 12 - 1);
                }
                ++n;
            }
        }
    }

    int getMapSize() {
        return this.mapSize;
    }
}

