/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CommandFinder
implements PlugIn,
ActionListener,
WindowListener,
KeyListener,
ItemListener,
MouseListener {
    int multiClickInterval;
    long lastClickTime = Long.MIN_VALUE;
    String lastClickedItem;
    JFrame d;
    JTextField prompt;
    JList completions;
    JScrollPane scrollPane;
    DefaultListModel completionsModel;
    JButton runButton;
    JButton closeButton;
    JButton exportButton;
    JCheckBox fullInfoCheckBox;
    JCheckBox closeCheckBox;
    Hashtable commandsHash;
    String[] commands;
    Hashtable listLabelToCommand;
    static boolean closeWhenRunning = Prefs.get("command-finder.close", true);

    public CommandFinder() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Integer n = (Integer)toolkit.getDesktopProperty("awt.multiClickInterval");
        this.multiClickInterval = n == null ? 300 : n;
    }

    protected String makeListLabel(String string, CommandAction commandAction, boolean bl) {
        if (bl) {
            String string2;
            String string3 = string;
            if (commandAction.menuLocation != null) {
                string3 = string3 + " (in " + commandAction.menuLocation + ")";
            }
            if (commandAction.classCommand != null) {
                string3 = string3 + " [" + commandAction.classCommand + "]";
            }
            if ((string2 = Menus.getJarFileForMenuEntry(string)) != null) {
                string3 = string3 + " {from " + string2 + "}";
            }
            return string3;
        }
        return string;
    }

    protected void populateList(String string) {
        boolean bl = this.fullInfoCheckBox.isSelected();
        String string2 = string.toLowerCase();
        this.completionsModel.removeAllElements();
        for (int i = 0; i < this.commands.length; ++i) {
            String string3;
            String string4 = this.commands[i];
            if (string4.length() == 0 || (string3 = string4.toLowerCase()).indexOf(string2) < 0) continue;
            CommandAction commandAction = (CommandAction)this.commandsHash.get(string4);
            String string5 = this.makeListLabel(string4, commandAction, bl);
            this.completionsModel.addElement(string5);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.runButton) {
            String string = (String)this.completions.getSelectedValue();
            if (string == null) {
                IJ.error("Please select a command to run");
                return;
            }
            this.runFromLabel(string);
        } else if (object == this.exportButton) {
            this.export();
        } else if (object == this.closeButton) {
            this.d.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.populateList(this.prompt.getText());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis();
        String string = (String)this.completions.getSelectedValue();
        long l2 = l - this.lastClickTime;
        if (l2 < (long)this.multiClickInterval && string != null && this.lastClickedItem != null && string.equals(this.lastClickedItem)) {
            this.runFromLabel(string);
        }
        this.lastClickTime = l;
        this.lastClickedItem = string;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    void export() {
        StringBuffer stringBuffer = new StringBuffer(5000);
        for (int i = 0; i < this.completionsModel.size(); ++i) {
            stringBuffer.append(i);
            stringBuffer.append("\t");
            stringBuffer.append((String)this.completionsModel.elementAt(i));
            stringBuffer.append("\n");
        }
        TextWindow textWindow = new TextWindow("ImageJ Menu Commands", " \tCommand", stringBuffer.toString(), 600, 500);
    }

    protected void runFromLabel(String string) {
        String string2 = (String)this.listLabelToCommand.get(string);
        CommandAction commandAction = (CommandAction)this.commandsHash.get(string2);
        IJ.showStatus("Running command " + commandAction.classCommand);
        IJ.doCommand(string2);
        closeWhenRunning = this.closeCheckBox.isSelected();
        if (closeWhenRunning) {
            this.d.dispose();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.completionsModel.getSize();
        Object object = keyEvent.getSource();
        if (n == 27) {
            this.d.dispose();
        } else if (object == this.prompt) {
            if (n == 10 && 1 == n2) {
                String string = (String)this.completionsModel.elementAt(0);
                this.runFromLabel(string);
            }
            int n3 = -1;
            if (n == 38) {
                n3 = this.completions.getSelectedIndex() - 1;
                if (n3 < 0) {
                    n3 = n2 - 1;
                }
            } else if (n == 40) {
                n3 = this.completions.getSelectedIndex() + 1;
                if (n3 >= n2) {
                    n3 = Math.min(n2 - 1, 0);
                }
            } else if (n == 34) {
                n3 = this.completions.getLastVisibleIndex();
            }
            if (n3 >= 0) {
                this.completions.requestFocus();
                this.completions.ensureIndexIsVisible(n3);
                this.completions.setSelectedIndex(n3);
            }
        } else if (n == 8) {
            this.prompt.requestFocus();
        } else if (object == this.completions) {
            if (n == 10) {
                String string = (String)this.completions.getSelectedValue();
                if (string != null) {
                    this.runFromLabel(string);
                }
            } else if (n == 38) {
                if (this.completions.getSelectedIndex() <= 0) {
                    this.completions.clearSelection();
                    this.prompt.requestFocus();
                }
            } else if (n == 40 && this.completions.getSelectedIndex() == n2 - 1) {
                this.completions.clearSelection();
                this.prompt.requestFocus();
            }
        } else if (object == this.runButton) {
            String string;
            if (n == 10 && (string = (String)this.completions.getSelectedValue()) != null) {
                this.runFromLabel(string);
            }
        } else if (object == this.closeButton && n == 10) {
            this.d.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void parseMenu(String string, Menu menu) {
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            MenuItem menuItem = menu.getItem(i);
            String string2 = menuItem.getLabel();
            if (menuItem instanceof Menu) {
                object = (Menu)menuItem;
                this.parseMenu(string + " > " + string2, (Menu)object);
                continue;
            }
            object = string2.trim();
            if (((String)object).length() == 0 || ((String)object).equals("-")) continue;
            CommandAction commandAction = (CommandAction)this.commandsHash.get(string2);
            if (commandAction == null) {
                this.commandsHash.put(string2, new CommandAction(null, menuItem, string));
            } else {
                commandAction.menuItem = menuItem;
                commandAction.menuLocation = string;
            }
            CommandAction commandAction2 = (CommandAction)this.commandsHash.get(string2);
        }
    }

    public void findAllMenuItems() {
        MenuBar menuBar = Menus.getMenuBar();
        int n = menuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            Menu menu = menuBar.getMenu(i);
            this.parseMenu(menu.getLabel(), menu);
        }
    }

    @Override
    public void run(String string) {
        Object object;
        Object object22;
        this.commandsHash = new Hashtable();
        Hashtable hashtable = (Hashtable)Menus.getCommands().clone();
        Set set = hashtable.keySet();
        for (Object object22 : set) {
            object = ((String)object22).trim();
            if (((String)object).length() <= 0 || ((String)object).equals("-")) continue;
            this.commandsHash.put(object22, new CommandAction((String)hashtable.get(object22), null, null));
        }
        this.findAllMenuItems();
        this.commands = this.commandsHash.keySet().toArray(new String[0]);
        Arrays.sort(this.commands);
        this.listLabelToCommand = new Hashtable();
        for (int i = 0; i < this.commands.length; ++i) {
            object22 = (CommandAction)this.commandsHash.get(this.commands[i]);
            this.listLabelToCommand.put(this.makeListLabel(this.commands[i], (CommandAction)object22, true), this.commands[i]);
            this.listLabelToCommand.put(this.makeListLabel(this.commands[i], (CommandAction)object22, false), this.commands[i]);
        }
        ImageJ imageJ = IJ.getInstance();
        this.d = new JFrame("Command Finder"){

            @Override
            public void setVisible(boolean bl) {
                if (bl) {
                    WindowManager.addWindow(this);
                }
                super.setVisible(bl);
            }

            @Override
            public void dispose() {
                WindowManager.removeWindow(this);
                super.dispose();
            }
        };
        object22 = this.d.getContentPane();
        ((Container)object22).setLayout(new BorderLayout());
        this.d.addWindowListener(this);
        this.fullInfoCheckBox = new JCheckBox("Show full information", false);
        this.fullInfoCheckBox.addItemListener(this);
        this.closeCheckBox = new JCheckBox("Close when running", closeWhenRunning);
        this.closeCheckBox.addItemListener(this);
        object = new JPanel();
        ((Container)object).add(new JLabel("Type part of a command:"));
        this.prompt = new JTextField("", 30);
        this.prompt.getDocument().addDocumentListener(new PromptDocumentListener());
        this.prompt.addKeyListener(this);
        ((Container)object).add(this.prompt);
        ((Container)object22).add((Component)object, "North");
        this.completionsModel = new DefaultListModel();
        this.completions = new JList(this.completionsModel);
        this.scrollPane = new JScrollPane(this.completions);
        this.completions.setSelectionMode(0);
        this.completions.setLayoutOrientation(0);
        this.completions.setVisibleRowCount(20);
        this.completions.addKeyListener(this);
        this.populateList("");
        ((Container)object22).add((Component)this.scrollPane, "Center");
        this.completions.addMouseListener(this);
        this.runButton = new JButton("Run");
        this.exportButton = new JButton("Export");
        this.closeButton = new JButton("Close");
        this.runButton.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.runButton.addKeyListener(this);
        this.closeButton.addKeyListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.fullInfoCheckBox);
        jPanel2.add(this.closeCheckBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.runButton);
        jPanel3.add(this.exportButton);
        jPanel3.add(this.closeButton);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        ((Container)object22).add((Component)jPanel, "South");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.d.pack();
        int n = this.d.getWidth();
        int n2 = this.d.getHeight();
        int n3 = (int)dimension.getWidth();
        int n4 = (int)dimension.getHeight();
        Point point = imageJ.getLocationOnScreen();
        int n5 = (int)point.getX() + 38;
        int n6 = (int)point.getY() + 84;
        if (n5 + n > n3) {
            n5 = n3 - n;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 + n2 > n4) {
            n6 = n4 - n2;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        this.d.setLocation(n5, n6);
        this.d.setVisible(true);
        this.d.toFront();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.d.dispose();
        Prefs.set("command-finder.close", closeWhenRunning);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    class PromptDocumentListener
    implements DocumentListener {
        PromptDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }
    }

    private static class LevenshteinPair
    implements Comparable {
        int index;
        int cost;

        LevenshteinPair(int n, int n2) {
            this.index = n;
            this.cost = n2;
        }

        public int compareTo(Object object) {
            return this.cost - ((LevenshteinPair)object).cost;
        }
    }

    class CommandAction {
        String classCommand;
        MenuItem menuItem;
        String menuLocation;

        CommandAction(String string, MenuItem menuItem, String string2) {
            this.classCommand = string;
            this.menuItem = menuItem;
            this.menuLocation = string2;
        }

        public String toString() {
            return "classCommand: " + this.classCommand + ", menuItem: " + this.menuItem + ", menuLocation: " + this.menuLocation;
        }
    }
}

