/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import java.awt.Point;

public class CompositeConverter
implements PlugIn {
    @Override
    public void run(String string) {
        String[] stringArray = new String[]{"Composite", "Color", "Grayscale"};
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus.isComposite()) {
            CompositeImage compositeImage = (CompositeImage)imagePlus;
            if (compositeImage.getMode() != 1) {
                compositeImage.setMode(1);
                compositeImage.updateAndDraw();
            }
            if (!IJ.isMacro()) {
                IJ.run("Channels Tool...");
            }
            return;
        }
        String string2 = stringArray[0];
        int n = imagePlus.getStackSize();
        int n2 = imagePlus.getNChannels();
        if (n2 == 1) {
            n2 = n;
            imagePlus.setDimensions(n2, 1, 1);
            if (n2 > 7) {
                string2 = stringArray[2];
            }
        }
        if (imagePlus.getBitDepth() == 24) {
            if (n > 1) {
                this.convertRGBToCompositeStack(imagePlus, string);
            } else {
                this.convertRGBToCompositeImage(imagePlus);
            }
            if (!IJ.isMacro()) {
                IJ.run("Channels Tool...");
            }
        } else if (n2 >= 2 || IJ.macroRunning() && n2 >= 1) {
            GenericDialog genericDialog = new GenericDialog("Make Composite");
            genericDialog.addChoice("Display Mode:", stringArray, string2);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            int n3 = genericDialog.getNextChoiceIndex();
            CompositeImage compositeImage = new CompositeImage(imagePlus, n3 + 1);
            compositeImage.show();
            imagePlus.hide();
            if (!IJ.isMacro()) {
                IJ.run("Channels Tool...");
            }
        } else {
            IJ.error("To create a composite, the current image must be\n a stack with at least 2 channels or be in RGB format.");
        }
    }

    void convertRGBToCompositeImage(ImagePlus imagePlus) {
        ImageWindow imageWindow = imagePlus.getWindow();
        Point point = imageWindow != null ? imageWindow.getLocation() : null;
        CompositeImage compositeImage = new CompositeImage(imagePlus, 1);
        if (point != null) {
            ImageWindow.setNextLocation(point);
        }
        compositeImage.show();
        imagePlus.hide();
        WindowManager.setCurrentWindow(compositeImage.getWindow());
    }

    void convertRGBToCompositeStack(ImagePlus imagePlus, String string) {
        Object object;
        Cloneable cloneable;
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        ImageStack imageStack = imagePlus.getStack();
        int n3 = imageStack.getSize();
        ImageStack imageStack2 = new ImageStack(n, n2);
        for (int i = 0; i < n3; ++i) {
            cloneable = (ColorProcessor)imageStack.getProcessor(1);
            imageStack.deleteSlice(1);
            object = new byte[n * n2];
            byte[] byArray = new byte[n * n2];
            byte[] byArray2 = new byte[n * n2];
            ((ColorProcessor)cloneable).getRGB((byte[])object, byArray, byArray2);
            imageStack2.addSlice(null, object);
            imageStack2.addSlice(null, byArray);
            imageStack2.addSlice(null, byArray2);
        }
        imagePlus.changes = false;
        ImageWindow imageWindow = imagePlus.getWindow();
        cloneable = imageWindow != null ? imageWindow.getLocation() : null;
        object = new ImagePlus(imagePlus.getTitle(), imageStack2);
        ((ImagePlus)object).setDimensions(3, (n3 *= 3) / 3, 1);
        int n4 = string != null && string.equals("color") ? 2 : 1;
        object = new CompositeImage((ImagePlus)object, n4);
        if (cloneable != null) {
            ImageWindow.setNextLocation((Point)cloneable);
        }
        ((ImagePlus)object).show();
        imagePlus.changes = false;
        imagePlus.close();
    }
}

