/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;

public class ContrastEnhancer
implements PlugIn,
Measurements {
    int max;
    int range;
    boolean classicEqualization;
    int stackSize;
    boolean updateSelectionOnly;
    boolean equalize;
    boolean normalize;
    boolean processStack;
    boolean useStackHistogram;
    boolean entireImage;
    static double saturated = 0.35;
    static boolean gEqualize;
    static boolean gNormalize;

    @Override
    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        this.stackSize = imagePlus.getStackSize();
        imagePlus.trimProcessor();
        if (!this.showDialog(imagePlus)) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            roi.endPaste();
        }
        if (this.stackSize == 1) {
            Undo.setup(6, imagePlus);
        } else {
            Undo.reset();
        }
        if (this.equalize) {
            this.equalize(imagePlus);
        } else {
            this.stretchHistogram(imagePlus, saturated);
        }
        if (this.equalize || this.normalize) {
            imagePlus.getProcessor().resetMinAndMax();
        }
        imagePlus.updateAndDraw();
    }

    boolean showDialog(ImagePlus imagePlus) {
        Roi roi;
        this.equalize = gEqualize;
        this.normalize = gNormalize;
        int n = imagePlus.getBitDepth();
        boolean bl = imagePlus.isComposite();
        if (bl) {
            this.stackSize = 1;
        }
        boolean bl2 = (roi = imagePlus.getRoi()) != null && roi.isArea() && !bl;
        GenericDialog genericDialog = new GenericDialog("Enhance Contrast");
        genericDialog.addNumericField("Saturated Pixels:", saturated, 1, 4, "%");
        if (n != 24 && !bl) {
            genericDialog.addCheckbox("Normalize", this.normalize);
        }
        if (bl2) {
            String string = n == 24 ? "Update Entire Image" : "Update All When Normalizing";
            genericDialog.addCheckbox(string, this.entireImage);
        }
        genericDialog.addCheckbox("Equalize Histogram", this.equalize);
        if (this.stackSize > 1) {
            if (!bl) {
                genericDialog.addCheckbox("Normalize_All " + this.stackSize + " Slices", this.processStack);
            }
            genericDialog.addCheckbox("Use Stack Histogram", this.useStackHistogram);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        saturated = genericDialog.getNextNumber();
        this.normalize = n != 24 && !bl ? genericDialog.getNextBoolean() : false;
        if (bl2) {
            this.entireImage = genericDialog.getNextBoolean();
            boolean bl3 = this.updateSelectionOnly = !this.entireImage;
            if (!this.normalize && n != 24) {
                this.updateSelectionOnly = false;
            }
        }
        this.equalize = genericDialog.getNextBoolean();
        this.processStack = this.stackSize > 1 ? genericDialog.getNextBoolean() : false;
        boolean bl4 = this.useStackHistogram = this.stackSize > 1 ? genericDialog.getNextBoolean() : false;
        if (saturated < 0.0) {
            saturated = 0.0;
        }
        if (saturated > 100.0) {
            saturated = 100.0;
        }
        if (this.processStack) {
            this.normalize = true;
        }
        gEqualize = this.equalize;
        gNormalize = this.normalize;
        return true;
    }

    public void stretchHistogram(ImagePlus imagePlus, double d) {
        ImageStatistics imageStatistics = null;
        if (this.useStackHistogram) {
            imageStatistics = new StackStatistics(imagePlus);
        }
        if (this.processStack) {
            ImageStack imageStack = imagePlus.getStack();
            for (int i = 1; i <= this.stackSize; ++i) {
                IJ.showProgress(i, this.stackSize);
                ImageProcessor imageProcessor = imageStack.getProcessor(i);
                imageProcessor.setRoi(imagePlus.getRoi());
                if (!this.useStackHistogram) {
                    imageStatistics = ImageStatistics.getStatistics(imageProcessor, 16, null);
                }
                this.stretchHistogram(imageProcessor, d, imageStatistics);
            }
        } else {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            imageProcessor.setRoi(imagePlus.getRoi());
            if (imageStatistics == null) {
                imageStatistics = ImageStatistics.getStatistics(imageProcessor, 16, null);
            }
            if (imagePlus.isComposite()) {
                this.stretchCompositeImageHistogram((CompositeImage)imagePlus, d, imageStatistics);
            } else {
                this.stretchHistogram(imageProcessor, d, imageStatistics);
            }
        }
    }

    public void stretchHistogram(ImageProcessor imageProcessor, double d) {
        this.useStackHistogram = false;
        this.stretchHistogram(new ImagePlus("", imageProcessor), d);
    }

    public void stretchHistogram(ImageProcessor imageProcessor, double d, ImageStatistics imageStatistics) {
        int n;
        int[] nArray = this.getMinAndMax(imageProcessor, d, imageStatistics);
        int n2 = nArray[1];
        if (n2 > (n = nArray[0])) {
            double d2 = imageStatistics.histMin + (double)n * imageStatistics.binSize;
            double d3 = imageStatistics.histMin + (double)n2 * imageStatistics.binSize;
            if (imageStatistics.histogram16 != null && imageProcessor instanceof ShortProcessor) {
                d2 = n;
                d3 = n2;
            }
            if (!this.updateSelectionOnly) {
                imageProcessor.resetRoi();
            }
            if (this.normalize) {
                this.normalize(imageProcessor, d2, d3);
            } else if (this.updateSelectionOnly) {
                ImageProcessor imageProcessor2 = imageProcessor.getMask();
                if (imageProcessor2 != null) {
                    imageProcessor.snapshot();
                }
                imageProcessor.setMinAndMax(d2, d3);
                if (imageProcessor2 != null) {
                    imageProcessor.reset(imageProcessor2);
                }
            } else {
                imageProcessor.setMinAndMax(d2, d3);
            }
        }
    }

    void stretchCompositeImageHistogram(CompositeImage compositeImage, double d, ImageStatistics imageStatistics) {
        int n;
        ImageProcessor imageProcessor = compositeImage.getProcessor();
        int[] nArray = this.getMinAndMax(imageProcessor, d, imageStatistics);
        int n2 = nArray[1];
        if (n2 > (n = nArray[0])) {
            double d2 = imageStatistics.histMin + (double)n * imageStatistics.binSize;
            double d3 = imageStatistics.histMin + (double)n2 * imageStatistics.binSize;
            if (imageStatistics.histogram16 != null && compositeImage.getBitDepth() == 16) {
                d2 = n;
                d3 = n2;
            }
            compositeImage.setDisplayRange(d2, d3);
        }
    }

    int[] getMinAndMax(ImageProcessor imageProcessor, double d, ImageStatistics imageStatistics) {
        int[] nArray = imageStatistics.histogram;
        if (imageStatistics.histogram16 != null && imageProcessor instanceof ShortProcessor) {
            nArray = imageStatistics.histogram16;
        }
        int n = nArray.length;
        int n2 = d > 0.0 ? (int)((double)imageStatistics.pixelCount * d / 200.0) : 0;
        int n3 = -1;
        boolean bl = false;
        int n4 = 0;
        int n5 = n - 1;
        do {
            boolean bl2 = bl = (n4 += nArray[++n3]) > n2;
        } while (!bl && n3 < n5);
        int n6 = n3;
        n3 = n;
        n4 = 0;
        do {
            boolean bl3 = bl = (n4 += nArray[--n3]) > n2;
        } while (!bl && n3 > 0);
        int n7 = n3;
        int[] nArray2 = new int[]{n6, n7};
        return nArray2;
    }

    void normalize(ImageProcessor imageProcessor, double d, double d2) {
        boolean bl = false;
        int n = 255;
        int n2 = 256;
        if (imageProcessor instanceof ShortProcessor) {
            n = 65535;
            n2 = 65536;
        } else if (imageProcessor instanceof FloatProcessor) {
            this.normalizeFloat(imageProcessor, d, d2);
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (double)i <= d ? 0 : ((double)i >= d2 ? n : (int)(((double)i - d) / (d2 - d) * (double)n));
        }
        this.applyTable(imageProcessor, nArray);
    }

    void applyTable(ImageProcessor imageProcessor, int[] nArray) {
        if (this.updateSelectionOnly) {
            ImageProcessor imageProcessor2 = imageProcessor.getMask();
            if (imageProcessor2 != null) {
                imageProcessor.snapshot();
            }
            imageProcessor.applyTable(nArray);
            if (imageProcessor2 != null) {
                imageProcessor.reset(imageProcessor2);
            }
        } else {
            imageProcessor.applyTable(nArray);
        }
    }

    void normalizeFloat(ImageProcessor imageProcessor, double d, double d2) {
        double d3 = d2 > d ? 1.0 / (d2 - d) : 1.0;
        int n = imageProcessor.getWidth() * imageProcessor.getHeight();
        float[] fArray = (float[])imageProcessor.getPixels();
        for (int i = 0; i < n; ++i) {
            double d4 = (double)fArray[i] - d;
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            if ((d4 *= d3) > 1.0) {
                d4 = 1.0;
            }
            fArray[i] = (float)d4;
        }
    }

    public void equalize(ImagePlus imagePlus) {
        if (imagePlus.getBitDepth() == 32) {
            IJ.showMessage("Contrast Enhancer", "Equalization of 32-bit images not supported.");
            return;
        }
        this.classicEqualization = IJ.altKeyDown();
        if (this.processStack) {
            ImageStack imageStack = imagePlus.getStack();
            for (int i = 1; i <= this.stackSize; ++i) {
                IJ.showProgress(i, this.stackSize);
                ImageProcessor imageProcessor = imageStack.getProcessor(i);
                this.equalize(imageProcessor);
            }
        } else {
            this.equalize(imagePlus.getProcessor());
        }
    }

    public void equalize(ImageProcessor imageProcessor) {
        int[] nArray = imageProcessor.getHistogram();
        imageProcessor.resetRoi();
        if (imageProcessor instanceof ShortProcessor) {
            this.max = 65535;
            this.range = 65535;
        } else {
            this.max = 255;
            this.range = 255;
        }
        double d = this.getWeightedValue(nArray, 0);
        for (int i = 1; i < this.max; ++i) {
            d += 2.0 * this.getWeightedValue(nArray, i);
        }
        double d2 = (double)this.range / (d += this.getWeightedValue(nArray, this.max));
        int[] nArray2 = new int[this.range + 1];
        nArray2[0] = 0;
        d = this.getWeightedValue(nArray, 0);
        for (int i = 1; i < this.max; ++i) {
            double d3 = this.getWeightedValue(nArray, i);
            nArray2[i] = (int)Math.round((d += d3) * d2);
            d += d3;
        }
        nArray2[this.max] = this.max;
        this.applyTable(imageProcessor, nArray2);
    }

    private double getWeightedValue(int[] nArray, int n) {
        int n2 = nArray[n];
        if (n2 < 2 || this.classicEqualization) {
            return n2;
        }
        return Math.sqrt(n2);
    }
}

