/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.DicomDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DICOM
extends ImagePlus
implements PlugIn {
    private boolean showErrors = true;
    private boolean gettingInfo;
    private BufferedInputStream inputStream;
    private String info;

    public DICOM() {
    }

    public DICOM(InputStream inputStream) {
        this(new BufferedInputStream(inputStream));
    }

    public DICOM(BufferedInputStream bufferedInputStream) {
        this.inputStream = bufferedInputStream;
    }

    @Override
    public void run(String string) {
        Object object;
        FileInfo fileInfo;
        DicomDecoder dicomDecoder;
        String string2;
        block23: {
            OpenDialog openDialog = new OpenDialog("Open Dicom...", string);
            String string3 = openDialog.getDirectory();
            string2 = openDialog.getFileName();
            if (string2 == null) {
                return;
            }
            dicomDecoder = new DicomDecoder(string3, string2);
            dicomDecoder.inputStream = this.inputStream;
            fileInfo = null;
            try {
                fileInfo = dicomDecoder.getFileInfo();
            }
            catch (IOException iOException) {
                object = iOException.getMessage();
                IJ.showStatus("");
                if (((String)object).indexOf("EOF") < 0 && this.showErrors) {
                    IJ.error("DicomDecoder", iOException.getClass().getName() + "\n \n" + (String)object);
                    return;
                }
                if (dicomDecoder.dicmFound() || !this.showErrors) break block23;
                object = "This does not appear to be a valid\nDICOM file. It does not have the\ncharacters 'DICM' at offset 128.";
                IJ.error("DicomDecoder", (String)object);
                return;
            }
        }
        if (this.gettingInfo) {
            this.info = dicomDecoder.getDicomInfo();
            return;
        }
        if (fileInfo != null && fileInfo.width > 0 && fileInfo.height > 0 && fileInfo.offset > 0) {
            FileOpener fileOpener = new FileOpener(fileInfo);
            object = fileOpener.open(false);
            ImageProcessor imageProcessor = ((ImagePlus)object).getProcessor();
            if (Prefs.openDicomsAsFloat) {
                imageProcessor = imageProcessor.convertToFloat();
                if (dicomDecoder.rescaleSlope != 1.0) {
                    imageProcessor.multiply(dicomDecoder.rescaleSlope);
                }
                if (dicomDecoder.rescaleIntercept != 0.0) {
                    imageProcessor.add(dicomDecoder.rescaleIntercept);
                }
                ((ImagePlus)object).setProcessor(imageProcessor);
            } else if (fileInfo.fileType == 1) {
                if (dicomDecoder.rescaleIntercept != 0.0 && dicomDecoder.rescaleSlope == 1.0) {
                    imageProcessor.add(dicomDecoder.rescaleIntercept);
                }
            } else if (dicomDecoder.rescaleIntercept != 0.0 && (dicomDecoder.rescaleSlope == 1.0 || fileInfo.fileType == 0)) {
                double[] dArray = new double[]{dicomDecoder.rescaleIntercept, dicomDecoder.rescaleSlope};
                ((ImagePlus)object).getCalibration().setFunction(0, dArray, "Gray Value");
            }
            if (dicomDecoder.windowWidth > 0.0) {
                double d = dicomDecoder.windowCenter - dicomDecoder.windowWidth / 2.0;
                double d2 = dicomDecoder.windowCenter + dicomDecoder.windowWidth / 2.0;
                if (Prefs.openDicomsAsFloat) {
                    d -= dicomDecoder.rescaleIntercept;
                    d2 -= dicomDecoder.rescaleIntercept;
                } else {
                    Calibration calibration = ((ImagePlus)object).getCalibration();
                    d = calibration.getRawValue(d);
                    d2 = calibration.getRawValue(d2);
                }
                imageProcessor.setMinAndMax(d, d2);
                if (IJ.debugMode) {
                    IJ.log("window: " + d + "-" + d2);
                }
            }
            if (((ImagePlus)object).getStackSize() > 1) {
                this.setStack(string2, ((ImagePlus)object).getStack());
            } else {
                this.setProcessor(string2, ((ImagePlus)object).getProcessor());
            }
            this.setCalibration(((ImagePlus)object).getCalibration());
            this.setProperty("Info", dicomDecoder.getDicomInfo());
            this.setFileInfo(fileInfo);
            if (string.equals("")) {
                this.show();
            }
        } else if (this.showErrors) {
            IJ.error("DicomDecoder", "Unable to decode DICOM header.");
        }
        IJ.showStatus("");
    }

    public void open(String string) {
        this.showErrors = false;
        this.run(string);
    }

    public String getInfo(String string) {
        this.showErrors = false;
        this.gettingInfo = true;
        this.run(string);
        return this.info;
    }

    void convertToUnsigned(ImagePlus imagePlus, FileInfo fileInfo) {
        int n;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        short[] sArray = (short[])imageProcessor.getPixels();
        int n2 = Integer.MAX_VALUE;
        for (n = 0; n < sArray.length; ++n) {
            int n3 = sArray[n] & 0xFFFF;
            if (n3 >= n2) continue;
            n2 = n3;
        }
        if (IJ.debugMode) {
            IJ.log("min: " + (n2 - 32768));
        }
        if (n2 >= 32768) {
            for (n = 0; n < sArray.length; ++n) {
                sArray[n] = (short)(sArray[n] - 32768);
            }
            imageProcessor.resetMinAndMax();
            Calibration calibration = imagePlus.getCalibration();
            calibration.setFunction(20, null, "Gray Value");
            fileInfo.fileType = 2;
        }
    }
}

