/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.io.FileInfo;
import ij.plugin.DicomDictionary;
import ij.util.Tools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

class DicomDecoder {
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int MODALITY = 524384;
    private static final int SLICE_THICKNESS = 1572944;
    private static final int SLICE_SPACING = 0x180088;
    private static final int IMAGER_PIXEL_SPACING = 1577316;
    private static final int SAMPLES_PER_PIXEL = 0x280002;
    private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
    private static final int PLANAR_CONFIGURATION = 2621446;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int WINDOW_CENTER = 2625616;
    private static final int WINDOW_WIDTH = 2625617;
    private static final int RESCALE_INTERCEPT = 2625618;
    private static final int RESCALE_SLOPE = 2625619;
    private static final int RED_PALETTE = 2626049;
    private static final int GREEN_PALETTE = 2626050;
    private static final int BLUE_PALETTE = 2626051;
    private static final int ICON_IMAGE_SEQUENCE = 0x880200;
    private static final int ITEM = -73728;
    private static final int ITEM_DELIMINATION = -73715;
    private static final int SEQUENCE_DELIMINATION = -73507;
    private static final int PIXEL_DATA = 2145386512;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static Properties dictionary;
    private String directory;
    private String fileName;
    private static final int ID_OFFSET = 128;
    private static final String DICM = "DICM";
    private BufferedInputStream f;
    private int location = 0;
    private boolean littleEndian = true;
    private int elementLength;
    private int vr;
    private static final int IMPLICIT_VR = 11565;
    private byte[] vrLetters = new byte[2];
    private int previousGroup;
    private String previousInfo;
    private StringBuffer dicomInfo = new StringBuffer(1000);
    private boolean dicmFound;
    private boolean oddLocations;
    private boolean bigEndianTransferSyntax = false;
    double windowCenter;
    double windowWidth;
    double rescaleIntercept;
    double rescaleSlope = 1.0;
    boolean inSequence;
    BufferedInputStream inputStream;
    String modality;
    static char[] buf8;
    char[] buf10;

    public DicomDecoder(String string, String string2) {
        Object object;
        this.directory = string;
        this.fileName = string2;
        String string3 = null;
        if (dictionary == null && IJ.getApplet() == null && ((File)(object = new File(string3 = Prefs.getHomeDir() + File.separator + "DICOM_Dictionary.txt"))).exists()) {
            try {
                dictionary = new Properties();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream((File)object));
                dictionary.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                if (IJ.debugMode) {
                    IJ.log("DicomDecoder: using " + dictionary.size() + " tag dictionary at " + string3);
                }
            }
            catch (Exception exception) {
                dictionary = null;
            }
        }
        if (dictionary == null) {
            object = new DicomDictionary();
            dictionary = ((DicomDictionary)object).getDictionary();
            if (IJ.debugMode) {
                IJ.log("DicomDecoder: " + string3 + " not found; using " + dictionary.size() + " tag built in dictionary");
            }
        }
    }

    String getString(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = this.f.read(byArray, i, n - i);
        }
        this.location += n;
        return new String(byArray);
    }

    int getByte() throws IOException {
        int n = this.f.read();
        if (n == -1) {
            throw new IOException("unexpected EOF");
        }
        ++this.location;
        return n;
    }

    int getShort() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        if (this.littleEndian) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    final int getInt() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    double getDouble() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        int n5 = this.getByte();
        int n6 = this.getByte();
        int n7 = this.getByte();
        int n8 = this.getByte();
        long l = 0L;
        if (this.littleEndian) {
            l += (long)n;
            l += (long)n2 << 8;
            l += (long)n3 << 16;
            l += (long)n4 << 24;
            l += (long)n5 << 32;
            l += (long)n6 << 40;
            l += (long)n7 << 48;
            l += (long)n8 << 56;
        } else {
            l += (long)n8;
            l += (long)n7 << 8;
            l += (long)n6 << 16;
            l += (long)n5 << 24;
            l += (long)n4 << 32;
            l += (long)n3 << 40;
            l += (long)n2 << 48;
            l += (long)n << 56;
        }
        return Double.longBitsToDouble(l);
    }

    float getFloat() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        int n5 = 0;
        if (this.littleEndian) {
            n5 += n;
            n5 = (int)((long)n5 + ((long)n2 << 8));
            n5 = (int)((long)n5 + ((long)n3 << 16));
            n5 = (int)((long)n5 + ((long)n4 << 24));
        } else {
            n5 += n4;
            n5 = (int)((long)n5 + ((long)n3 << 8));
            n5 = (int)((long)n5 + ((long)n2 << 16));
            n5 = (int)((long)n5 + ((long)n << 24));
        }
        return Float.intBitsToFloat(n5);
    }

    byte[] getLut(int n) throws IOException {
        if ((n & 1) != 0) {
            String string = this.getString(n);
            return null;
        }
        byte[] byArray = new byte[n /= 2];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(this.getShort() >>> 8);
        }
        return byArray;
    }

    int getLength() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        this.vr = (n << 8) + n2;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: 
            case 21844: {
                if (n3 == 0 || n4 == 0) {
                    return this.getInt();
                }
                this.vr = 11565;
                if (this.littleEndian) {
                    return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
                }
                return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: {
                if (this.littleEndian) {
                    return (n4 << 8) + n3;
                }
                return (n3 << 8) + n4;
            }
        }
        this.vr = 11565;
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    int getNextTag() throws IOException {
        int n = this.getShort();
        if (n == 2048 && this.bigEndianTransferSyntax) {
            this.littleEndian = false;
            n = 8;
        }
        int n2 = this.getShort();
        int n3 = n << 16 | n2;
        this.elementLength = this.getLength();
        if (this.elementLength == 13 && !this.oddLocations) {
            this.elementLength = 10;
        }
        if (this.elementLength == -1) {
            this.elementLength = 0;
            this.inSequence = true;
        }
        return n3;
    }

    FileInfo getFileInfo() throws IOException {
        FileInfo fileInfo = new FileInfo();
        int n = 16;
        fileInfo.fileFormat = 1;
        fileInfo.fileName = this.fileName;
        if (this.directory.indexOf("://") > 0) {
            URL uRL = new URL(this.directory + this.fileName);
            this.inputStream = new BufferedInputStream(uRL.openStream());
            fileInfo.inputStream = this.inputStream;
        } else if (this.inputStream != null) {
            fileInfo.inputStream = this.inputStream;
        } else {
            fileInfo.directory = this.directory;
        }
        fileInfo.width = 0;
        fileInfo.height = 0;
        fileInfo.offset = 0;
        fileInfo.intelByteOrder = true;
        fileInfo.fileType = 2;
        fileInfo.fileFormat = 6;
        int n2 = 1;
        int n3 = 0;
        String string = "";
        if (this.inputStream != null) {
            this.f = this.inputStream;
            this.f.mark(400000);
        } else {
            this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
        }
        if (IJ.debugMode) {
            IJ.log("");
            IJ.log("DicomDecoder: decoding " + this.fileName);
        }
        for (long i = 128L; i > 0L; i -= this.f.skip(i)) {
        }
        this.location += 128;
        if (!this.getString(4).equals(DICM)) {
            if (this.inputStream == null) {
                this.f.close();
            }
            if (this.inputStream != null) {
                this.f.reset();
            } else {
                this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
            }
            this.location = 0;
            if (IJ.debugMode) {
                IJ.log("DICM not found at offset 128; reseting to offset 0");
            }
        } else {
            this.dicmFound = true;
            if (IJ.debugMode) {
                IJ.log("DICM found at offset 128");
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        block24: while (bl) {
            int n4 = this.getNextTag();
            if ((this.location & 1) != 0) {
                this.oddLocations = true;
            }
            if (this.inSequence) {
                this.addInfo(n4, null);
                continue;
            }
            switch (n4) {
                case 131088: {
                    String string2 = this.getString(this.elementLength);
                    this.addInfo(n4, string2);
                    if (string2.indexOf("1.2.4") > -1 || string2.indexOf("1.2.5") > -1) {
                        this.f.close();
                        String string3 = "ImageJ cannot open compressed DICOM images.\n \n";
                        string3 = string3 + "Transfer Syntax UID = " + string2;
                        throw new IOException(string3);
                    }
                    if (string2.indexOf("1.2.840.10008.1.2.2") < 0) continue block24;
                    this.bigEndianTransferSyntax = true;
                    continue block24;
                }
                case 524384: {
                    this.modality = this.getString(this.elementLength);
                    this.addInfo(n4, this.modality);
                    continue block24;
                }
                case 0x280008: {
                    String string2 = this.getString(this.elementLength);
                    this.addInfo(n4, string2);
                    double d = this.s2d(string2);
                    if (!(d > 1.0)) continue block24;
                    fileInfo.nImages = (int)d;
                    continue block24;
                }
                case 0x280002: {
                    n2 = this.getShort();
                    this.addInfo(n4, n2);
                    continue block24;
                }
                case 2621444: {
                    string = this.getString(this.elementLength);
                    this.addInfo(n4, string);
                    continue block24;
                }
                case 2621446: {
                    n3 = this.getShort();
                    this.addInfo(n4, n3);
                    continue block24;
                }
                case 2621456: {
                    fileInfo.height = this.getShort();
                    this.addInfo(n4, fileInfo.height);
                    continue block24;
                }
                case 2621457: {
                    fileInfo.width = this.getShort();
                    this.addInfo(n4, fileInfo.width);
                    continue block24;
                }
                case 1577316: 
                case 2621488: {
                    String string4 = this.getString(this.elementLength);
                    this.getSpatialScale(fileInfo, string4);
                    this.addInfo(n4, string4);
                    continue block24;
                }
                case 1572944: 
                case 0x180088: {
                    String string5 = this.getString(this.elementLength);
                    fileInfo.pixelDepth = this.s2d(string5);
                    this.addInfo(n4, string5);
                    continue block24;
                }
                case 2621696: {
                    n = this.getShort();
                    if (n == 8) {
                        fileInfo.fileType = 0;
                    } else if (n == 32) {
                        fileInfo.fileType = 11;
                    }
                    this.addInfo(n4, n);
                    continue block24;
                }
                case 2621699: {
                    int n5 = this.getShort();
                    if (n5 == 1) {
                        fileInfo.fileType = 1;
                        bl2 = true;
                    }
                    this.addInfo(n4, n5);
                    continue block24;
                }
                case 2625616: {
                    String string6 = this.getString(this.elementLength);
                    int n6 = string6.indexOf(92);
                    if (n6 != -1) {
                        string6 = string6.substring(n6 + 1);
                    }
                    this.windowCenter = this.s2d(string6);
                    this.addInfo(n4, string6);
                    continue block24;
                }
                case 2625617: {
                    String string7 = this.getString(this.elementLength);
                    int n6 = string7.indexOf(92);
                    if (n6 != -1) {
                        string7 = string7.substring(n6 + 1);
                    }
                    this.windowWidth = this.s2d(string7);
                    this.addInfo(n4, string7);
                    continue block24;
                }
                case 2625618: {
                    String string8 = this.getString(this.elementLength);
                    this.rescaleIntercept = this.s2d(string8);
                    this.addInfo(n4, string8);
                    continue block24;
                }
                case 2625619: {
                    String string9 = this.getString(this.elementLength);
                    this.rescaleSlope = this.s2d(string9);
                    this.addInfo(n4, string9);
                    continue block24;
                }
                case 2626049: {
                    fileInfo.reds = this.getLut(this.elementLength);
                    this.addInfo(n4, this.elementLength / 2);
                    continue block24;
                }
                case 2626050: {
                    fileInfo.greens = this.getLut(this.elementLength);
                    this.addInfo(n4, this.elementLength / 2);
                    continue block24;
                }
                case 2626051: {
                    fileInfo.blues = this.getLut(this.elementLength);
                    this.addInfo(n4, this.elementLength / 2);
                    continue block24;
                }
                case 2145386512: {
                    if (this.elementLength != 0) {
                        fileInfo.offset = this.location;
                        this.addInfo(n4, this.location);
                        bl = false;
                        continue block24;
                    }
                    this.addInfo(n4, null);
                    continue block24;
                }
                case 2139619344: {
                    if (this.elementLength == 0) continue block24;
                    fileInfo.offset = this.location + 4;
                    bl = false;
                    continue block24;
                }
            }
            this.addInfo(n4, null);
        }
        if (fileInfo.fileType == 0 && fileInfo.reds != null && fileInfo.greens != null && fileInfo.blues != null && fileInfo.reds.length == fileInfo.greens.length && fileInfo.reds.length == fileInfo.blues.length) {
            fileInfo.fileType = 5;
            fileInfo.lutSize = fileInfo.reds.length;
        }
        if (fileInfo.fileType == 11 && bl2) {
            fileInfo.fileType = 3;
        }
        if (n2 == 3 && string.startsWith("RGB")) {
            if (n3 == 0) {
                fileInfo.fileType = 6;
            } else if (n3 == 1) {
                fileInfo.fileType = 7;
            }
        } else if (string.endsWith("1 ")) {
            fileInfo.whiteIsZero = true;
        }
        if (!this.littleEndian) {
            fileInfo.intelByteOrder = false;
        }
        if (IJ.debugMode) {
            IJ.log("width: " + fileInfo.width);
            IJ.log("height: " + fileInfo.height);
            IJ.log("images: " + fileInfo.nImages);
            IJ.log("bits allocated: " + n);
            IJ.log("offset: " + fileInfo.offset);
        }
        if (this.inputStream != null) {
            this.f.reset();
        } else {
            this.f.close();
        }
        return fileInfo;
    }

    String getDicomInfo() {
        String string = new String(this.dicomInfo);
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' || cArray[i] == '\n') continue;
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    void addInfo(int n, String string) throws IOException {
        String string2 = this.getHeaderInfo(n, string);
        if (this.inSequence && string2 != null && this.vr != 21329) {
            string2 = ">" + string2;
        }
        if (string2 != null && n != -73728) {
            int n2;
            this.previousGroup = n2 = n >>> 16;
            this.previousInfo = string2;
            this.dicomInfo.append(this.tag2hex(n) + string2 + "\n");
        }
        if (IJ.debugMode) {
            if (string2 == null) {
                string2 = "";
            }
            this.vrLetters[0] = (byte)(this.vr >> 8);
            this.vrLetters[1] = (byte)(this.vr & 0xFF);
            String string3 = new String(this.vrLetters);
            IJ.log("(" + this.tag2hex(n) + string3 + " " + this.elementLength + " bytes from " + (this.location - this.elementLength) + ") " + string2);
        }
    }

    void addInfo(int n, int n2) throws IOException {
        this.addInfo(n, Integer.toString(n2));
    }

    String getHeaderInfo(int n, String string) throws IOException {
        String string2;
        String string3;
        if (n == -73715 || n == -73507) {
            this.inSequence = false;
            if (!IJ.debugMode) {
                return null;
            }
        }
        if ((string3 = (String)dictionary.get(string2 = this.i2hex(n))) != null) {
            if (this.vr == 11565 && string3 != null) {
                this.vr = (string3.charAt(0) << 8) + string3.charAt(1);
            }
            string3 = string3.substring(2);
        }
        if (n == -73728) {
            return string3 != null ? string3 + ":" : null;
        }
        if (string != null) {
            return string3 + ": " + string;
        }
        switch (this.vr) {
            case 17988: {
                if (this.elementLength == 8) {
                    string = Double.toString(this.getDouble());
                    break;
                }
                for (int i = 0; i < this.elementLength; ++i) {
                    this.getByte();
                }
                break;
            }
            case 17996: {
                if (this.elementLength == 4) {
                    string = Float.toString(this.getFloat());
                    break;
                }
                for (int i = 0; i < this.elementLength; ++i) {
                    this.getByte();
                }
                break;
            }
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                string = this.getString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    string = Integer.toString(this.getShort());
                    break;
                }
                string = "";
                int n2 = this.elementLength / 2;
                for (int i = 0; i < n2; ++i) {
                    string = string + Integer.toString(this.getShort()) + " ";
                }
                break;
            }
            case 11565: {
                string = this.getString(this.elementLength);
                if (this.elementLength <= 44) break;
                string = null;
                break;
            }
            case 21329: {
                boolean bl;
                string = "";
                boolean bl2 = bl = (n >> 16 & 1) != 0;
                if (n != 0x880200 && !bl) break;
            }
            default: {
                for (long i = (long)this.elementLength; i > 0L; i -= this.f.skip(i)) {
                }
                this.location += this.elementLength;
                string = "";
            }
        }
        if (string != null && string3 == null && !string.equals("")) {
            return "---: " + string;
        }
        if (string3 == null) {
            return null;
        }
        return string3 + ": " + string;
    }

    String i2hex(int n) {
        for (int i = 7; i >= 0; --i) {
            DicomDecoder.buf8[i] = Tools.hexDigits[n & 0xF];
            n >>>= 4;
        }
        return new String(buf8);
    }

    String tag2hex(int n) {
        if (this.buf10 == null) {
            this.buf10 = new char[11];
            this.buf10[4] = 44;
            this.buf10[9] = 32;
        }
        int n2 = 8;
        while (n2 >= 0) {
            this.buf10[n2] = Tools.hexDigits[n & 0xF];
            n >>>= 4;
            if (--n2 != 4) continue;
            --n2;
        }
        return new String(this.buf10);
    }

    double s2d(String string) {
        Double d;
        if (string == null) {
            return 0.0;
        }
        if (string.startsWith("\\")) {
            string = string.substring(1);
        }
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void getSpatialScale(FileInfo fileInfo, String string) {
        double d = 0.0;
        double d2 = 0.0;
        int n = string.indexOf(92);
        if (n > 0) {
            d2 = this.s2d(string.substring(0, n));
            d = this.s2d(string.substring(n + 1));
        }
        if (d != 0.0 && d2 != 0.0) {
            fileInfo.pixelWidth = d;
            fileInfo.pixelHeight = d2;
            fileInfo.unit = "mm";
        }
    }

    boolean dicmFound() {
        return this.dicmFound;
    }

    static {
        buf8 = new char[8];
    }
}

