/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Duplicator
implements PlugIn,
TextListener {
    private static boolean duplicateStack;
    private boolean duplicateSubstack;
    private int first;
    private int last;
    private Checkbox checkbox;
    private TextField rangeField;
    private TextField[] rangeFields;
    private int firstC;
    private int lastC;
    private int firstZ;
    private int lastZ;
    private int firstT;
    private int lastT;

    @Override
    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        int n = imagePlus.getStackSize();
        String string2 = imagePlus.getTitle();
        String string3 = WindowManager.getUniqueName(string2);
        if (!IJ.altKeyDown() || n > 1) {
            if (imagePlus.isHyperStack() || imagePlus.isComposite()) {
                this.duplicateHyperstack(imagePlus, string3);
                return;
            }
            string3 = this.showDialog(imagePlus, "Duplicate...", "Title: ", string3);
        }
        if (string3 == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        ImagePlus imagePlus2 = this.duplicateSubstack && (this.first > 1 || this.last < n) ? this.run(imagePlus, this.first, this.last) : (duplicateStack || imagePlus.getStackSize() == 1 ? this.run(imagePlus) : this.duplicateImage(imagePlus));
        Calibration calibration = imagePlus2.getCalibration();
        if (roi != null && (calibration.xOrigin != 0.0 || calibration.yOrigin != 0.0)) {
            calibration.xOrigin -= (double)roi.getBounds().x;
            calibration.yOrigin -= (double)roi.getBounds().y;
        }
        imagePlus2.setTitle(string3);
        imagePlus2.show();
        if (roi != null && roi.isArea() && roi.getType() != 0 && roi.getBounds().width == imagePlus2.getWidth()) {
            imagePlus2.restoreRoi();
        }
    }

    public ImagePlus run(ImagePlus imagePlus) {
        Overlay overlay;
        Object object;
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp);");
        }
        if (imagePlus.getStackSize() == 1) {
            return this.duplicateImage(imagePlus);
        }
        Rectangle rectangle = null;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isArea()) {
            rectangle = roi.getBounds();
        }
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = null;
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            object = imageStack.getProcessor(i);
            ((ImageProcessor)object).setRoi(rectangle);
            object = ((ImageProcessor)object).crop();
            if (imageStack2 == null) {
                imageStack2 = new ImageStack(((ImageProcessor)object).getWidth(), ((ImageProcessor)object).getHeight(), imagePlus.getProcessor().getColorModel());
            }
            imageStack2.addSlice(imageStack.getSliceLabel(i), (ImageProcessor)object);
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack("DUP_" + imagePlus.getTitle(), imageStack2);
        object = imagePlus.getDimensions();
        imagePlus2.setDimensions((int)object[2], (int)object[3], (int)object[4]);
        if (imagePlus.isComposite()) {
            imagePlus2 = new CompositeImage(imagePlus2, 0);
            ((CompositeImage)imagePlus2).copyLuts(imagePlus);
        }
        if (imagePlus.isHyperStack()) {
            imagePlus2.setOpenAsHyperStack(true);
        }
        if ((overlay = imagePlus.getOverlay()) != null && !imagePlus.getHideOverlay()) {
            overlay = overlay.duplicate();
            if (rectangle != null) {
                overlay.translate(-rectangle.x, -rectangle.y);
            }
            imagePlus2.setOverlay(overlay);
        }
        return imagePlus2;
    }

    ImagePlus duplicateImage(ImagePlus imagePlus) {
        Object object;
        Object object2;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ImageProcessor imageProcessor2 = imageProcessor.crop();
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setProcessor("DUP_" + imagePlus.getTitle(), imageProcessor2);
        String string = (String)imagePlus.getProperty("Info");
        if (string != null) {
            imagePlus2.setProperty("Info", string);
        }
        if (imagePlus.getStackSize() > 1) {
            object2 = imagePlus.getStack();
            object = ((ImageStack)object2).getSliceLabel(imagePlus.getCurrentSlice());
            if (object != null && ((String)object).indexOf(10) > 0) {
                imagePlus2.setProperty("Info", object);
            }
            if (imagePlus.isComposite()) {
                LUT lUT = ((CompositeImage)imagePlus).getChannelLut();
                imagePlus2.getProcessor().setColorModel(lUT);
            }
        }
        if ((object2 = imagePlus.getOverlay()) != null && !imagePlus.getHideOverlay()) {
            object2 = ((Overlay)object2).duplicate();
            object = imageProcessor.getRoi();
            if (((Rectangle)object).x > 0 || ((Rectangle)object).y > 0) {
                ((Overlay)object2).translate(-((Rectangle)object).x, -((Rectangle)object).y);
            }
            imagePlus2.setOverlay((Overlay)object2);
        }
        return imagePlus2;
    }

    public ImagePlus run(ImagePlus imagePlus, int n, int n2) {
        boolean bl;
        Rectangle rectangle = null;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isArea()) {
            rectangle = roi.getBounds();
        }
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = null;
        for (int i = n; i <= n2; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            imageProcessor.setRoi(rectangle);
            imageProcessor = imageProcessor.crop();
            if (imageStack2 == null) {
                imageStack2 = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight(), imagePlus.getProcessor().getColorModel());
            }
            imageStack2.addSlice(imageStack.getSliceLabel(i), imageProcessor);
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack("DUP_" + imagePlus.getTitle(), imageStack2);
        int n3 = imageStack2.getSize();
        boolean bl2 = bl = imagePlus.getNFrames() == imagePlus.getStackSize();
        if (bl) {
            imagePlus2.setDimensions(1, 1, n3);
        } else {
            imagePlus2.setDimensions(1, n3, 1);
        }
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp, " + n + ", " + n2 + ");");
        }
        return imagePlus2;
    }

    public ImagePlus run(ImagePlus imagePlus, int n, int n2, int n3, int n4, int n5, int n6) {
        Cloneable cloneable;
        int n7;
        int n8;
        int n9;
        Rectangle rectangle = null;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isArea()) {
            rectangle = roi.getBounds();
        }
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = null;
        for (int i = n5; i <= n6; ++i) {
            for (n9 = n3; n9 <= n4; ++n9) {
                for (n8 = n; n8 <= n2; ++n8) {
                    n7 = imagePlus.getStackIndex(n8, n9, i);
                    cloneable = imageStack.getProcessor(n7);
                    String string = imageStack.getSliceLabel(n7);
                    cloneable.setRoi(rectangle);
                    cloneable = cloneable.crop();
                    if (imageStack2 == null) {
                        imageStack2 = new ImageStack(cloneable.getWidth(), cloneable.getHeight(), null);
                    }
                    imageStack2.addSlice(string, (ImageProcessor)cloneable);
                }
            }
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack("DUP_" + imagePlus.getTitle(), imageStack2);
        imagePlus2.setDimensions(n2 - n + 1, n4 - n3 + 1, n6 - n5 + 1);
        if (imagePlus.isComposite()) {
            n9 = ((CompositeImage)imagePlus).getMode();
            if (n2 > n) {
                imagePlus2 = new CompositeImage(imagePlus2, n9);
                n8 = 1;
                for (n7 = n; n7 <= n2; ++n7) {
                    cloneable = ((CompositeImage)imagePlus).getChannelLut(n7);
                    ((CompositeImage)imagePlus2).setChannelLut((LUT)cloneable, n8++);
                }
            } else if (n == n2) {
                LUT lUT = ((CompositeImage)imagePlus).getChannelLut(n);
                imagePlus2.getProcessor().setColorModel(lUT);
                imagePlus2.setDisplayRange(lUT.min, lUT.max);
            }
        }
        imagePlus2.setOpenAsHyperStack(true);
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp, " + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ", " + n6 + ");");
        }
        return imagePlus2;
    }

    String showDialog(ImagePlus imagePlus, String string, String string2, String string3) {
        String[] stringArray;
        int n = imagePlus.getStackSize();
        this.duplicateSubstack = n > 1 && (n == imagePlus.getNSlices() || n == imagePlus.getNFrames());
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addStringField(string2, string3, this.duplicateSubstack ? 15 : 20);
        if (n > 1) {
            stringArray = this.duplicateSubstack ? "Duplicate stack" : "Duplicate entire stack";
            genericDialog.addCheckbox((String)stringArray, duplicateStack || imagePlus.isComposite());
            if (this.duplicateSubstack) {
                genericDialog.setInsets(2, 30, 3);
                genericDialog.addStringField("Range:", "1-" + n);
                Vector vector = genericDialog.getStringFields();
                this.rangeField = (TextField)vector.elementAt(1);
                this.rangeField.addTextListener(this);
                this.checkbox = (Checkbox)genericDialog.getCheckboxes().elementAt(0);
            }
        } else {
            duplicateStack = false;
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        string = genericDialog.getNextString();
        if (n > 1) {
            duplicateStack = genericDialog.getNextBoolean();
            if (duplicateStack && this.duplicateSubstack) {
                stringArray = Tools.split(genericDialog.getNextString(), " -");
                double d = genericDialog.parseDouble(stringArray[0]);
                double d2 = stringArray.length == 2 ? genericDialog.parseDouble(stringArray[1]) : Double.NaN;
                this.first = Double.isNaN(d) ? 1 : (int)d;
                int n2 = this.last = Double.isNaN(d2) ? n : (int)d2;
                if (this.first < 1) {
                    this.first = 1;
                }
                if (this.last > n) {
                    this.last = n;
                }
                if (this.first > this.last) {
                    this.first = 1;
                    this.last = n;
                }
            } else {
                this.first = 1;
                this.last = n;
            }
        }
        return string;
    }

    void duplicateHyperstack(ImagePlus imagePlus, String string) {
        if ((string = this.showHSDialog(imagePlus, string)) == null) {
            return;
        }
        ImagePlus imagePlus2 = null;
        Roi roi = imagePlus.getRoi();
        if (!duplicateStack) {
            boolean bl;
            int n = imagePlus.getNChannels();
            boolean bl2 = bl = imagePlus.isComposite() && n == imagePlus.getStackSize();
            if (!bl && n > 1 && imagePlus.isComposite() && ((CompositeImage)imagePlus).getMode() == 1) {
                this.firstC = 1;
                this.lastC = n;
            } else {
                this.firstC = this.lastC = imagePlus.getChannel();
            }
            this.firstZ = this.lastZ = imagePlus.getSlice();
            this.firstT = this.lastT = imagePlus.getFrame();
        }
        if ((imagePlus2 = this.run(imagePlus, this.firstC, this.lastC, this.firstZ, this.lastZ, this.firstT, this.lastT)) == null) {
            return;
        }
        Calibration calibration = imagePlus2.getCalibration();
        if (roi != null && (calibration.xOrigin != 0.0 || calibration.yOrigin != 0.0)) {
            calibration.xOrigin -= (double)roi.getBounds().x;
            calibration.yOrigin -= (double)roi.getBounds().y;
        }
        imagePlus2.setTitle(string);
        imagePlus2.show();
        if (roi != null && roi.isArea() && roi.getType() != 0 && roi.getBounds().width == imagePlus2.getWidth()) {
            imagePlus2.restoreRoi();
        }
        if (IJ.isMacro() && imagePlus2.getWindow() != null) {
            IJ.wait(50);
        }
    }

    String showHSDialog(ImagePlus imagePlus, String string) {
        double d;
        double d2;
        int n = imagePlus.getNChannels();
        int n2 = imagePlus.getNSlices();
        int n3 = imagePlus.getNFrames();
        boolean bl = imagePlus.isComposite() && n == imagePlus.getStackSize();
        GenericDialog genericDialog = new GenericDialog("Duplicate");
        genericDialog.addStringField("Title:", string, 15);
        genericDialog.setInsets(12, 20, 8);
        genericDialog.addCheckbox("Duplicate hyperstack", duplicateStack || bl);
        int n4 = 0;
        if (n > 1) {
            genericDialog.setInsets(2, 30, 3);
            genericDialog.addStringField("Channels (c):", "1-" + n);
            ++n4;
        }
        if (n2 > 1) {
            genericDialog.setInsets(2, 30, 3);
            genericDialog.addStringField("Slices (z):", "1-" + n2);
            ++n4;
        }
        if (n3 > 1) {
            genericDialog.setInsets(2, 30, 3);
            genericDialog.addStringField("Frames (t):", "1-" + n3);
            ++n4;
        }
        Vector vector = genericDialog.getStringFields();
        this.rangeFields = new TextField[3];
        for (int i = 0; i < n4; ++i) {
            this.rangeFields[i] = (TextField)vector.elementAt(i + 1);
            this.rangeFields[i].addTextListener(this);
        }
        this.checkbox = (Checkbox)genericDialog.getCheckboxes().elementAt(0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        string = genericDialog.getNextString();
        duplicateStack = genericDialog.getNextBoolean();
        if (n > 1) {
            String[] stringArray = Tools.split(genericDialog.getNextString(), " -");
            d2 = genericDialog.parseDouble(stringArray[0]);
            d = stringArray.length == 2 ? genericDialog.parseDouble(stringArray[1]) : Double.NaN;
            this.firstC = Double.isNaN(d2) ? 1 : (int)d2;
            int n5 = this.lastC = Double.isNaN(d) ? this.firstC : (int)d;
            if (this.firstC < 1) {
                this.firstC = 1;
            }
            if (this.lastC > n) {
                this.lastC = n;
            }
            if (this.firstC > this.lastC) {
                this.firstC = 1;
                this.lastC = n;
            }
        } else {
            this.lastC = 1;
            this.firstC = 1;
        }
        if (n2 > 1) {
            String[] stringArray = Tools.split(genericDialog.getNextString(), " -");
            d2 = genericDialog.parseDouble(stringArray[0]);
            d = stringArray.length == 2 ? genericDialog.parseDouble(stringArray[1]) : Double.NaN;
            this.firstZ = Double.isNaN(d2) ? 1 : (int)d2;
            int n6 = this.lastZ = Double.isNaN(d) ? this.firstZ : (int)d;
            if (this.firstZ < 1) {
                this.firstZ = 1;
            }
            if (this.lastZ > n2) {
                this.lastZ = n2;
            }
            if (this.firstZ > this.lastZ) {
                this.firstZ = 1;
                this.lastZ = n2;
            }
        } else {
            this.lastZ = 1;
            this.firstZ = 1;
        }
        if (n3 > 1) {
            String[] stringArray = Tools.split(genericDialog.getNextString(), " -");
            d2 = genericDialog.parseDouble(stringArray[0]);
            d = stringArray.length == 2 ? genericDialog.parseDouble(stringArray[1]) : Double.NaN;
            this.firstT = Double.isNaN(d2) ? 1 : (int)d2;
            int n7 = this.lastT = Double.isNaN(d) ? this.firstT : (int)d;
            if (this.firstT < 1) {
                this.firstT = 1;
            }
            if (this.lastT > n3) {
                this.lastT = n3;
            }
            if (this.firstT > this.lastT) {
                this.firstT = 1;
                this.lastT = n3;
            }
        } else {
            this.lastT = 1;
            this.firstT = 1;
        }
        return string;
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        this.checkbox.setState(true);
    }
}

