/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.VirtualStack;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.FolderOpenerDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.DicomTools;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.io.File;

public class FolderOpener
implements PlugIn {
    private static String[] excludedTypes = new String[]{".txt", ".lut", ".roi", ".pty", ".hdr", ".java", ".ijm", ".py", ".js", ".bsh", ".xml"};
    private static boolean staticSortFileNames = true;
    private static boolean staticOpenAsVirtualStack;
    private boolean convertToRGB;
    private boolean sortFileNames = true;
    private boolean openAsVirtualStack;
    private double scale = 100.0;
    private int n;
    private int start;
    private int increment;
    private String filter;
    private boolean isRegex;
    private FileInfo fi;
    private String info1;
    private ImagePlus image;

    public static ImagePlus open(String string) {
        FolderOpener folderOpener = new FolderOpener();
        folderOpener.run(string);
        return folderOpener.image;
    }

    public ImagePlus openFolder(String string) {
        this.run(string);
        return this.image;
    }

    @Override
    public void run(String string) {
        Overlay overlay;
        boolean bl;
        Calibration calibration;
        double d;
        double d2;
        ImageStack imageStack;
        String string2;
        String string3;
        block77: {
            int n;
            String[] stringArray;
            string3 = null;
            if (string != null && !string.equals("")) {
                string3 = string;
            } else {
                Object object;
                if (!IJ.macroRunning()) {
                    this.sortFileNames = staticSortFileNames;
                    this.openAsVirtualStack = staticOpenAsVirtualStack;
                }
                string = null;
                stringArray = "Open Image Sequence...";
                string2 = Macro.getOptions();
                if (string2 != null && (string3 = Macro.getValue(string2, (String)stringArray, null)) != null && !((File)(object = new File(string3 = OpenDialog.lookupPathVariable(string3)))).isDirectory() && (((File)object).exists() || string3.lastIndexOf(".") > string3.length() - 5)) {
                    string3 = ((File)object).getParent();
                }
                if (string3 == null) {
                    if (Prefs.useFileChooser && !IJ.isMacOSX()) {
                        object = new OpenDialog((String)stringArray, string);
                        string3 = ((OpenDialog)object).getDirectory();
                        String string4 = ((OpenDialog)object).getFileName();
                        if (string4 == null) {
                            return;
                        }
                    } else {
                        string3 = IJ.getDirectory((String)stringArray);
                    }
                }
            }
            if (string3 == null) {
                return;
            }
            stringArray = new File(string3).list();
            if (stringArray == null) {
                return;
            }
            string2 = string3;
            if (string2.endsWith(File.separator) || string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if ((n = string2.lastIndexOf(File.separatorChar)) != -1) {
                string2 = string2.substring(n + 1);
            }
            if (string2.endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            IJ.register(FolderOpener.class);
            stringArray = this.trimFileList(stringArray);
            if (stringArray == null) {
                return;
            }
            if (IJ.debugMode) {
                IJ.log("FolderOpener: " + string3 + " (" + stringArray.length + " files)");
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            int n5 = 0;
            imageStack = null;
            d2 = Double.MAX_VALUE;
            d = -1.7976931348623157E308;
            calibration = null;
            bl = true;
            IJ.resetEscape();
            overlay = null;
            try {
                int n6;
                ImagePlus imagePlus;
                String[] stringArray2;
                int n7;
                for (n7 = 0; n7 < stringArray.length; ++n7) {
                    IJ.redirectErrorMessages();
                    stringArray2 = new Opener();
                    stringArray2.setSilentMode(true);
                    imagePlus = stringArray2.openImage(string3, stringArray[n7]);
                    if (imagePlus == null) continue;
                    n2 = imagePlus.getWidth();
                    n3 = imagePlus.getHeight();
                    n5 = imagePlus.getBitDepth();
                    this.fi = imagePlus.getOriginalFileInfo();
                    if (string == null) {
                        if (this.showDialog(imagePlus, stringArray)) break;
                        return;
                    }
                    this.n = stringArray.length;
                    this.start = 1;
                    this.increment = 1;
                    break;
                }
                if (n2 == 0) {
                    IJ.error("Import Sequence", "This folder does not appear to contain any TIFF,\nJPEG, BMP, DICOM, GIF, FITS or PGM files.");
                    return;
                }
                if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                    this.filter = null;
                }
                if (this.filter != null) {
                    n7 = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (this.isRegex && stringArray[i].matches(this.filter)) {
                            ++n7;
                            continue;
                        }
                        if (stringArray[i].indexOf(this.filter) >= 0) {
                            ++n7;
                            continue;
                        }
                        stringArray[i] = null;
                    }
                    if (n7 == 0) {
                        if (this.isRegex) {
                            IJ.error("Import Sequence", "None of the file names match the regular expression.");
                        } else {
                            IJ.error("Import Sequence", "None of the " + stringArray.length + " files contain\n the string '" + this.filter + "' in their name.");
                        }
                        return;
                    }
                    stringArray2 = new String[n7];
                    int n8 = 0;
                    for (n6 = 0; n6 < stringArray.length; ++n6) {
                        if (stringArray[n6] == null) continue;
                        stringArray2[n8++] = stringArray[n6];
                    }
                    stringArray = stringArray2;
                }
                if (this.sortFileNames) {
                    stringArray = this.sortFileList(stringArray);
                }
                if (this.n < 1) {
                    this.n = stringArray.length;
                }
                if (this.start < 1 || this.start > stringArray.length) {
                    this.start = 1;
                }
                if (this.start + this.n - 1 > stringArray.length) {
                    this.n = stringArray.length - this.start + 1;
                }
                n7 = 0;
                int n9 = 0;
                imagePlus = null;
                for (n6 = this.start - 1; n6 < stringArray.length; ++n6) {
                    Cloneable cloneable;
                    int n10;
                    Object object;
                    Object object2;
                    if (n9++ % this.increment != 0) continue;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages();
                    if (!this.openAsVirtualStack || imageStack == null) {
                        imagePlus = opener.openImage(string3, stringArray[n6]);
                    }
                    if (imagePlus != null && imageStack == null) {
                        n2 = imagePlus.getWidth();
                        n3 = imagePlus.getHeight();
                        n4 = imagePlus.getStackSize();
                        n5 = imagePlus.getBitDepth();
                        calibration = imagePlus.getCalibration();
                        if (this.convertToRGB) {
                            n5 = 24;
                        }
                        object2 = imagePlus.getProcessor().getColorModel();
                        if (this.openAsVirtualStack) {
                            imageStack = new VirtualStack(n2, n3, (ColorModel)object2, string3);
                            ((VirtualStack)imageStack).setBitDepth(n5);
                        } else {
                            imageStack = this.scale < 100.0 ? new ImageStack((int)((double)n2 * this.scale / 100.0), (int)((double)n3 * this.scale / 100.0), (ColorModel)object2) : new ImageStack(n2, n3, (ColorModel)object2);
                        }
                        this.info1 = (String)imagePlus.getProperty("Info");
                    }
                    if (imagePlus == null) continue;
                    if (imagePlus.getWidth() != n2 || imagePlus.getHeight() != n3) {
                        IJ.log(stringArray[n6] + ": wrong size; " + n2 + "x" + n3 + " expected, " + imagePlus.getWidth() + "x" + imagePlus.getHeight() + " found");
                        continue;
                    }
                    object2 = imagePlus.getTitle();
                    if (n4 == 1 && (object = (String)imagePlus.getProperty("Info")) != null) {
                        object2 = (String)object2 + "\n" + (String)object;
                    }
                    if (imagePlus.getCalibration().pixelWidth != calibration.pixelWidth) {
                        bl = false;
                    }
                    object = imagePlus.getStack();
                    Overlay overlay2 = imagePlus.getOverlay();
                    if (overlay2 != null && !this.openAsVirtualStack) {
                        if (overlay == null) {
                            overlay = new Overlay();
                        }
                        for (n10 = 0; n10 < overlay2.size(); ++n10) {
                            cloneable = overlay2.get(n10);
                            int n11 = ((Roi)cloneable).getPosition();
                            if (n11 == 0) {
                                ((Roi)cloneable).setPosition(n7 + 1);
                            }
                            overlay.add((Roi)cloneable);
                        }
                    }
                    for (n10 = 1; n10 <= n4; ++n10) {
                        cloneable = ((ImageStack)object).getProcessor(n10);
                        Object object3 = object2;
                        if (n4 > 1) {
                            String string5 = ((ImageStack)object).getSliceLabel(n10);
                            if (string5 != null) {
                                object3 = string5;
                            } else if (object3 != null && !((String)object3).equals("")) {
                                object3 = (String)object3 + ":" + n10;
                            }
                        }
                        int n12 = imagePlus.getBitDepth();
                        if (!this.openAsVirtualStack) {
                            if (this.convertToRGB) {
                                cloneable = ((ImageProcessor)cloneable).convertToRGB();
                                n12 = 24;
                            }
                            if (n12 != n5) {
                                if (n5 == 8) {
                                    cloneable = ((ImageProcessor)cloneable).convertToByte(true);
                                    n12 = 8;
                                } else if (n5 == 24) {
                                    cloneable = ((ImageProcessor)cloneable).convertToRGB();
                                    n12 = 24;
                                }
                            }
                            if (n12 != n5) {
                                IJ.log(stringArray[n6] + ": wrong bit depth; " + n5 + " expected, " + n12 + " found");
                                break;
                            }
                        }
                        if (n10 == 1) {
                            ++n7;
                        }
                        IJ.showStatus(n7 + "/" + this.n);
                        IJ.showProgress(n7, this.n);
                        if (this.scale < 100.0) {
                            cloneable = ((ImageProcessor)cloneable).resize((int)((double)n2 * this.scale / 100.0), (int)((double)n3 * this.scale / 100.0));
                        }
                        if (((ImageProcessor)cloneable).getMin() < d2) {
                            d2 = ((ImageProcessor)cloneable).getMin();
                        }
                        if (((ImageProcessor)cloneable).getMax() > d) {
                            d = ((ImageProcessor)cloneable).getMax();
                        }
                        if (this.openAsVirtualStack) {
                            if (n10 != 1) continue;
                            ((VirtualStack)imageStack).addSlice(stringArray[n6]);
                            continue;
                        }
                        imageStack.addSlice((String)object3, (ImageProcessor)cloneable);
                    }
                    if (n7 < this.n) {
                        if (!IJ.escapePressed()) continue;
                        IJ.beep();
                    }
                    break;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                IJ.outOfMemory("FolderOpener");
                if (imageStack == null) break block77;
                imageStack.trim();
            }
        }
        if (imageStack != null && imageStack.getSize() > 0) {
            ImagePlus imagePlus = new ImagePlus(string2, imageStack);
            if (imagePlus.getType() == 1 || imagePlus.getType() == 2) {
                imagePlus.getProcessor().setMinAndMax(d2, d);
            }
            if (this.fi == null) {
                this.fi = new FileInfo();
            }
            this.fi.fileFormat = 0;
            this.fi.fileName = "";
            this.fi.directory = string3;
            imagePlus.setFileInfo(this.fi);
            imagePlus.setOverlay(overlay);
            if (bl) {
                if (this.scale != 100.0 && calibration.scaled()) {
                    calibration.pixelWidth /= this.scale / 100.0;
                    calibration.pixelHeight /= this.scale / 100.0;
                }
                if (calibration.pixelWidth != 1.0 && calibration.pixelDepth == 1.0) {
                    calibration.pixelDepth = calibration.pixelWidth;
                }
                if (calibration.pixelWidth <= 1.0E-4 && calibration.getUnit().equals("cm")) {
                    calibration.pixelWidth *= 10000.0;
                    calibration.pixelHeight *= 10000.0;
                    calibration.pixelDepth *= 10000.0;
                    calibration.setUnit("um");
                }
                imagePlus.setCalibration(calibration);
            }
            if (this.info1 != null && this.info1.lastIndexOf("7FE0,0010") > 0) {
                imageStack = DicomTools.sort(imageStack);
                imagePlus.setStack(imageStack);
                double d3 = DicomTools.getVoxelDepth(imageStack);
                if (d3 > 0.0) {
                    if (IJ.debugMode) {
                        IJ.log("DICOM voxel depth set to " + d3 + " (" + calibration.pixelDepth + ")");
                    }
                    calibration.pixelDepth = d3;
                    imagePlus.setCalibration(calibration);
                }
            }
            if (imagePlus.getStackSize() == 1 && this.info1 != null) {
                imagePlus.setProperty("Info", this.info1);
            }
            if (string == null) {
                imagePlus.show();
            } else {
                this.image = imagePlus;
            }
        }
        IJ.showProgress(1.0);
    }

    boolean showDialog(ImagePlus imagePlus, String[] stringArray) {
        int n = stringArray.length;
        FolderOpenerDialog folderOpenerDialog = new FolderOpenerDialog("Sequence Options", imagePlus, stringArray);
        folderOpenerDialog.addNumericField("Number of images:", n, 0);
        folderOpenerDialog.addNumericField("Starting image:", 1.0, 0);
        folderOpenerDialog.addNumericField("Increment:", 1.0, 0);
        folderOpenerDialog.addNumericField("Scale images:", this.scale, 0, 4, "%");
        folderOpenerDialog.addStringField("File name contains:", "", 10);
        folderOpenerDialog.addStringField("or enter pattern:", "", 10);
        folderOpenerDialog.addCheckbox("Convert_to_RGB", this.convertToRGB);
        folderOpenerDialog.addCheckbox("Sort names numerically", this.sortFileNames);
        folderOpenerDialog.addCheckbox("Use virtual stack", this.openAsVirtualStack);
        folderOpenerDialog.addMessage("10000 x 10000 x 1000 (100.3MB)");
        folderOpenerDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/file.html#seq1");
        folderOpenerDialog.showDialog();
        if (folderOpenerDialog.wasCanceled()) {
            return false;
        }
        this.n = (int)folderOpenerDialog.getNextNumber();
        this.start = (int)folderOpenerDialog.getNextNumber();
        this.increment = (int)folderOpenerDialog.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        this.scale = folderOpenerDialog.getNextNumber();
        if (this.scale < 5.0) {
            this.scale = 5.0;
        }
        if (this.scale > 100.0) {
            this.scale = 100.0;
        }
        this.filter = folderOpenerDialog.getNextString();
        String string = folderOpenerDialog.getNextString();
        if (!string.equals("")) {
            this.filter = string;
            this.isRegex = true;
        }
        this.convertToRGB = folderOpenerDialog.getNextBoolean();
        this.sortFileNames = folderOpenerDialog.getNextBoolean();
        this.openAsVirtualStack = folderOpenerDialog.getNextBoolean();
        if (this.openAsVirtualStack) {
            this.scale = 100.0;
        }
        if (!IJ.macroRunning()) {
            staticSortFileNames = this.sortFileNames;
            staticOpenAsVirtualStack = this.openAsVirtualStack;
        }
        return true;
    }

    public String[] trimFileList(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith(".") || string.equals("Thumbs.db") || FolderOpener.excludedFileType(string)) {
                stringArray[i] = null;
                continue;
            }
            ++n;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = stringArray;
        if (n < stringArray.length) {
            stringArray2 = new String[n];
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray2[n2++] = stringArray[i];
            }
        }
        return stringArray2;
    }

    public static boolean excludedFileType(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < excludedTypes.length; ++i) {
            if (!string.endsWith(excludedTypes[i])) continue;
            return true;
        }
        return false;
    }

    public String[] sortFileList(String[] stringArray) {
        int n;
        int n2;
        int n3 = stringArray.length;
        boolean bl = true;
        int n4 = stringArray[0].length();
        for (n2 = 0; n2 < n3; ++n2) {
            if (stringArray[n2].length() == n4) continue;
            bl = false;
            break;
        }
        if (bl) {
            StringSorter.sort(stringArray);
            return stringArray;
        }
        n2 = 15;
        String[] stringArray2 = null;
        for (n = 0; n < n3; ++n) {
            int n5 = stringArray[n].length();
            String string = "";
            for (int i = 0; i < n5; ++i) {
                char c = stringArray[n].charAt(i);
                if (c < '0' || c > '9') continue;
                string = string + c;
            }
            if (stringArray2 == null) {
                stringArray2 = new String[n3];
            }
            if (string.length() == 0) {
                string = "aaaaaa";
            }
            string = "000000000000000" + string;
            string = string.substring(string.length() - n2);
            stringArray2[n] = string + stringArray[n];
        }
        if (stringArray2 != null) {
            StringSorter.sort(stringArray2);
            for (n = 0; n < n3; ++n) {
                stringArray2[n] = stringArray2[n].substring(n2);
            }
            return stringArray2;
        }
        StringSorter.sort(stringArray);
        return stringArray;
    }

    public void openAsVirtualStack(boolean bl) {
        this.openAsVirtualStack = bl;
    }

    public void sortFileNames(boolean bl) {
        this.sortFileNames = bl;
    }
}

