/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class ImageJ_Updater
implements PlugIn {
    @Override
    public void run(String string) {
        Object object;
        int n;
        File file;
        String string2;
        if (string.equals("menus")) {
            this.updateMenus();
            return;
        }
        if (IJ.getApplet() != null) {
            return;
        }
        URL uRL = this.getClass().getResource("/ij/IJ.class");
        String string3 = string2 = uRL == null ? null : uRL.toString().replaceAll("%20", " ");
        if (string2 == null || !string2.startsWith("jar:file:")) {
            this.error("Could not determine location of ij.jar");
            return;
        }
        int n2 = string2.indexOf(33);
        string2 = string2.substring(9, n2);
        if (IJ.debugMode) {
            IJ.log("Updater: " + string2);
        }
        if (!(file = new File(string2)).exists()) {
            this.error("File not found: " + file.getPath());
            return;
        }
        if (!file.canWrite()) {
            String string4 = "No write access: " + file.getPath();
            if (IJ.isVista()) {
                string4 = string4 + "\n \nOn Windows Vista, ImageJ must be installed in a directory that\nthe user can write to, such as \"Desktop\" or \"Documents\"";
            }
            this.error(string4);
            return;
        }
        String[] stringArray = this.openUrlAsList("http://imagej.nih.gov/ij/download/jars/list.txt");
        int n3 = stringArray.length + 2;
        String[] stringArray2 = new String[n3];
        String[] stringArray3 = new String[n3];
        String string5 = this.getUpgradeVersion();
        if (string5 == null) {
            return;
        }
        stringArray2[0] = "v" + string5;
        stringArray3[0] = "http://imagej.nih.gov/ij/upgrade/ij.jar";
        if (stringArray2[0] == null) {
            return;
        }
        for (n = 1; n < n3 - 1; ++n) {
            object = stringArray[n - 1];
            stringArray2[n] = ((String)object).substring(0, ((String)object).length() - 1);
            stringArray3[n] = "http://imagej.nih.gov/ij/download/jars/ij" + ((String)object).substring(1, 2) + ((String)object).substring(3, 6) + ".jar";
        }
        stringArray2[n3 - 1] = "daily build";
        stringArray3[n3 - 1] = "http://imagej.nih.gov/ij/ij.jar";
        n = this.showDialog(stringArray2);
        if (n == -1) {
            return;
        }
        if (!stringArray2[n].startsWith("daily") && stringArray2[n].compareTo("v1.39") < 0 && Menus.getCommands().get("ImageJ Updater") == null && !IJ.showMessageWithCancel("Update ImageJ", (String)(object = "This command is not available in versions of ImageJ prior\nto 1.39 so you will need to install the plugin version at\n<http://imagej.nih.gov/ij/plugins/imagej-updater.html>."))) {
            return;
        }
        object = this.getJar(stringArray3[n]);
        if (object == null) {
            this.error("Unable to download ij.jar from " + stringArray3[n]);
            return;
        }
        if (this.version().compareTo("1.37v") >= 0) {
            Prefs.savePreferences();
        }
        this.saveJar(file, (byte[])object);
        if (n < n3 - 1) {
            new File(IJ.getDirectory("macros") + "functions.html").delete();
        }
        System.exit(0);
    }

    int showDialog(String[] stringArray) {
        GenericDialog genericDialog = new GenericDialog("ImageJ Updater");
        genericDialog.addChoice("Upgrade To:", stringArray, stringArray[0]);
        String string = "You are currently running v" + this.version() + ".\n" + " \n" + "If you click \"OK\", ImageJ will quit\n" + "and you will be running the upgraded\n" + "version after you restart ImageJ.\n";
        genericDialog.addMessage(string);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return -1;
        }
        return genericDialog.getNextChoiceIndex();
    }

    String getUpgradeVersion() {
        String string = "http://imagej.nih.gov/ij/notes.html";
        String string2 = this.openUrlAsString(string, 20);
        if (string2 == null) {
            this.error("Unable to connect to http://imagej.nih.gov/ij. You\nmay need to use the Edit>Options>Proxy Settings\ncommand to configure ImageJ to use a proxy server.");
            return null;
        }
        int n = string2.indexOf("Version ");
        if (n == -1) {
            this.error("Release notes are not in the expected format");
            return null;
        }
        String string3 = string2.substring(n + 8, n + 13);
        return string3;
    }

    String openUrlAsString(String string, int n) {
        StringBuffer stringBuffer;
        try {
            String string2;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            stringBuffer = new StringBuffer();
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null && n2++ < n) {
                stringBuffer.append(string2 + "\n");
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            stringBuffer = null;
        }
        return stringBuffer != null ? new String(stringBuffer) : null;
    }

    byte[] getJar(String string) {
        byte[] byArray;
        boolean bl = this.version().compareTo("1.33u") >= 0;
        try {
            int n;
            URL uRL = new URL(string);
            IJ.showStatus("Connecting to http://imagej.nih.gov/ij");
            URLConnection uRLConnection = uRL.openConnection();
            int n2 = uRLConnection.getContentLength();
            if (n2 <= 0) {
                return null;
            }
            String string2 = string.endsWith("ij/ij.jar") ? "daily build" : "ij.jar";
            IJ.showStatus("Downloading ij.jar (" + IJ.d2s((double)n2 / 1048576.0, 1) + "MB)");
            InputStream inputStream = uRLConnection.getInputStream();
            byArray = new byte[n2];
            for (int i = 0; i < n2; i += n) {
                n = inputStream.read(byArray, i, n2 - i);
                if (n >= 0) continue;
                throw new EOFException();
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return byArray;
    }

    void saveJar(File file, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String[] openUrlAsList(String string) {
        Object[] objectArray;
        IJ.showStatus("Connecting to http://imagej.nih.gov/ij");
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            objectArray = new URL(string);
            InputStream inputStream = objectArray.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.equals("")) continue;
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        IJ.showStatus("");
        return objectArray;
    }

    String version() {
        String string = "";
        try {
            Class<ImageJ> clazz = ImageJ.class;
            Field field = clazz.getField("VERSION");
            string = (String)field.get(clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    boolean isMac() {
        String string = System.getProperty("os.name");
        return string.startsWith("Mac");
    }

    void error(String string) {
        IJ.error("ImageJ Updater", string);
    }

    void updateMenus() {
        if (IJ.debugMode) {
            long l = System.currentTimeMillis();
            Menus.updateImageJMenus();
            IJ.log("Refresh Menus: " + (System.currentTimeMillis() - l) + " ms");
        } else {
            Menus.updateImageJMenus();
        }
    }
}

