/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.plugin.TextReader;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class LutLoader
extends ImagePlus
implements PlugIn {
    private static String defaultDirectory = null;

    @Override
    public void run(String string) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.reds = new byte[256];
        fileInfo.greens = new byte[256];
        fileInfo.blues = new byte[256];
        fileInfo.lutSize = 256;
        int n = 0;
        if (string.equals("invert")) {
            this.invertLut();
            return;
        }
        if (string.equals("fire")) {
            n = this.fire(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("grays")) {
            n = this.grays(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("ice")) {
            n = this.ice(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("spectrum")) {
            n = this.spectrum(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("3-3-2 RGB")) {
            n = this.rgb332(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("red")) {
            n = this.primaryColor(4, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("green")) {
            n = this.primaryColor(2, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("blue")) {
            n = this.primaryColor(1, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("cyan")) {
            n = this.primaryColor(3, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("magenta")) {
            n = this.primaryColor(5, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("yellow")) {
            n = this.primaryColor(6, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("redgreen")) {
            n = this.redGreen(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        }
        if (n > 0) {
            if (n < 256) {
                this.interpolate(fileInfo.reds, fileInfo.greens, fileInfo.blues, n);
            }
            fileInfo.fileName = string;
            this.showLut(fileInfo, true);
            Menus.updateMenus();
            return;
        }
        OpenDialog openDialog = new OpenDialog("Open LUT...", string);
        fileInfo.directory = openDialog.getDirectory();
        fileInfo.fileName = openDialog.getFileName();
        if (fileInfo.fileName == null) {
            return;
        }
        if (this.openLut(fileInfo)) {
            this.showLut(fileInfo, string.equals(""));
        }
        IJ.showStatus("");
    }

    void showLut(FileInfo fileInfo, boolean bl) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            if (imagePlus.getType() == 4) {
                IJ.error("Color tables cannot be assiged to RGB Images.");
            } else {
                ImageProcessor imageProcessor = imagePlus.getChannelProcessor();
                IndexColorModel indexColorModel = new IndexColorModel(8, 256, fileInfo.reds, fileInfo.greens, fileInfo.blues);
                if (imagePlus.isComposite()) {
                    ((CompositeImage)imagePlus).setChannelColorModel(indexColorModel);
                } else {
                    imageProcessor.setColorModel(indexColorModel);
                }
                if (imagePlus.getStackSize() > 1) {
                    imagePlus.getStack().setColorModel(indexColorModel);
                }
                imagePlus.updateAndRepaintWindow();
            }
        } else {
            this.createImage(fileInfo, bl);
        }
    }

    void invertLut() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (imagePlus.getType() == 4) {
            IJ.error("RGB images do not use LUTs");
            return;
        }
        if (imagePlus.isComposite()) {
            CompositeImage compositeImage = (CompositeImage)imagePlus;
            LUT lUT = compositeImage.getChannelLut();
            if (lUT != null) {
                compositeImage.setChannelLut(lUT.createInvertedLut());
            }
        } else {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            imageProcessor.invertLut();
            if (imagePlus.getStackSize() > 1) {
                imagePlus.getStack().setColorModel(imageProcessor.getColorModel());
            }
        }
        imagePlus.updateAndRepaintWindow();
    }

    int fire(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[]{0, 0, 1, 25, 49, 73, 98, 122, 146, 162, 173, 184, 195, 207, 217, 229, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 35, 57, 79, 101, 117, 133, 147, 161, 175, 190, 205, 219, 234, 248, 255, 255, 255, 255};
        int[] nArray3 = new int[]{0, 61, 96, 130, 165, 192, 220, 227, 210, 181, 151, 122, 93, 64, 35, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 98, 160, 223, 255};
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
            byArray2[i] = (byte)nArray2[i];
            byArray3[i] = (byte)nArray3[i];
        }
        return nArray.length;
    }

    int grays(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)i;
            byArray2[i] = (byte)i;
            byArray3[i] = (byte)i;
        }
        return 256;
    }

    int primaryColor(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < 256; ++i) {
            if ((n & 4) != 0) {
                byArray[i] = (byte)i;
            }
            if ((n & 2) != 0) {
                byArray2[i] = (byte)i;
            }
            if ((n & 1) == 0) continue;
            byArray3[i] = (byte)i;
        }
        return 256;
    }

    int ice(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 19, 29, 50, 48, 79, 112, 134, 158, 186, 201, 217, 229, 242, 250, 250, 250, 250, 251, 250, 250, 250, 250, 251, 251, 243, 230};
        int[] nArray2 = new int[]{156, 165, 176, 184, 190, 196, 193, 184, 171, 162, 146, 125, 107, 93, 81, 87, 92, 97, 95, 93, 93, 90, 85, 69, 64, 54, 47, 35, 19, 0, 4, 0};
        int[] nArray3 = new int[]{140, 147, 158, 166, 170, 176, 209, 220, 234, 225, 236, 246, 250, 251, 250, 250, 245, 230, 230, 222, 202, 180, 163, 142, 123, 114, 106, 94, 84, 64, 26, 27};
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
            byArray2[i] = (byte)nArray2[i];
            byArray3[i] = (byte)nArray3[i];
        }
        return nArray.length;
    }

    int spectrum(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < 256; ++i) {
            Color color = Color.getHSBColor((float)i / 255.0f, 1.0f, 1.0f);
            byArray[i] = (byte)color.getRed();
            byArray2[i] = (byte)color.getGreen();
            byArray3[i] = (byte)color.getBlue();
        }
        return 256;
    }

    int rgb332(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)(i & 0xE0);
            byArray2[i] = (byte)(i << 3 & 0xE0);
            byArray3[i] = (byte)(i << 6 & 0xC0);
        }
        return 256;
    }

    int redGreen(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        for (n = 0; n < 128; ++n) {
            byArray[n] = (byte)(n * 2);
            byArray2[n] = 0;
            byArray3[n] = 0;
        }
        for (n = 128; n < 256; ++n) {
            byArray[n] = 0;
            byArray2[n] = (byte)(n * 2);
            byArray3[n] = 0;
        }
        return 256;
    }

    void interpolate(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray, 0, byArray4, 0, n);
        System.arraycopy(byArray2, 0, byArray5, 0, n);
        System.arraycopy(byArray3, 0, byArray6, 0, n);
        double d = (double)n / 256.0;
        for (int i = 0; i < 256; ++i) {
            int n2 = (int)((double)i * d);
            int n3 = n2 + 1;
            if (n3 == n) {
                n3 = n - 1;
            }
            double d2 = (double)i * d - (double)n2;
            byArray[i] = (byte)((1.0 - d2) * (double)(byArray4[n2] & 0xFF) + d2 * (double)(byArray4[n3] & 0xFF));
            byArray2[i] = (byte)((1.0 - d2) * (double)(byArray5[n2] & 0xFF) + d2 * (double)(byArray5[n3] & 0xFF));
            byArray3[i] = (byte)((1.0 - d2) * (double)(byArray6[n2] & 0xFF) + d2 * (double)(byArray6[n3] & 0xFF));
        }
    }

    boolean openLut(FileInfo fileInfo) {
        File file;
        boolean bl = fileInfo.url != null && !fileInfo.url.equals("");
        int n = 0;
        if (!bl && (n = (int)(file = new File(fileInfo.directory + fileInfo.fileName)).length()) > 10000) {
            this.error();
            return false;
        }
        int n2 = 0;
        try {
            if (n > 768) {
                n2 = this.openBinaryLut(fileInfo, bl, false);
            }
            if (n2 == 0 && (n == 0 || n == 768 || n == 970)) {
                n2 = this.openBinaryLut(fileInfo, bl, true);
            }
            if (n2 == 0 && n > 768) {
                n2 = this.openTextLut(fileInfo);
            }
            if (n2 == 0) {
                this.error();
            }
        }
        catch (IOException iOException) {
            IJ.error(iOException.getMessage());
        }
        return n2 == 256;
    }

    void error() {
        IJ.error("This is not an ImageJ or NIH Image LUT, a 768 byte \nraw LUT, or a LUT in text format.");
    }

    int openBinaryLut(FileInfo fileInfo, boolean bl, boolean bl2) throws IOException {
        InputStream inputStream = bl ? new URL(fileInfo.url + fileInfo.fileName).openStream() : new FileInputStream(fileInfo.directory + fileInfo.fileName);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = 256;
        if (!bl2) {
            int n2 = dataInputStream.readInt();
            if (n2 != 1229147980) {
                dataInputStream.close();
                return 0;
            }
            short s = dataInputStream.readShort();
            n = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            long l = dataInputStream.readLong();
            long l2 = dataInputStream.readLong();
            int n3 = dataInputStream.readInt();
        }
        dataInputStream.read(fileInfo.reds, 0, n);
        dataInputStream.read(fileInfo.greens, 0, n);
        dataInputStream.read(fileInfo.blues, 0, n);
        if (n < 256) {
            this.interpolate(fileInfo.reds, fileInfo.greens, fileInfo.blues, n);
        }
        dataInputStream.close();
        return 256;
    }

    int openTextLut(FileInfo fileInfo) throws IOException {
        TextReader textReader = new TextReader();
        textReader.hideErrorMessages();
        ImageProcessor imageProcessor = textReader.open(fileInfo.directory + fileInfo.fileName);
        if (imageProcessor == null) {
            return 0;
        }
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        if (n < 3 || n > 4 || n2 < 256 || n2 > 258) {
            return 0;
        }
        int n3 = n == 4 ? 1 : 0;
        int n4 = n2 > 256 ? 1 : 0;
        imageProcessor.setRoi(n3, n4, 3, 256);
        imageProcessor = imageProcessor.crop();
        for (int i = 0; i < 256; ++i) {
            fileInfo.reds[i] = (byte)imageProcessor.getPixelValue(0, i);
            fileInfo.greens[i] = (byte)imageProcessor.getPixelValue(1, i);
            fileInfo.blues[i] = (byte)imageProcessor.getPixelValue(2, i);
        }
        return 256;
    }

    void createImage(FileInfo fileInfo, boolean bl) {
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        ByteProcessor byteProcessor = LutLoader.createImage(indexColorModel);
        this.setProcessor(fileInfo.fileName, byteProcessor);
        if (bl) {
            this.show();
        }
    }

    public static IndexColorModel open(String string) throws IOException {
        return LutLoader.open(new FileInputStream(string));
    }

    public static IndexColorModel open(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        dataInputStream.read(byArray, 0, 256);
        dataInputStream.read(byArray2, 0, 256);
        dataInputStream.read(byArray3, 0, 256);
        dataInputStream.close();
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    public static ByteProcessor createImage(IndexColorModel indexColorModel) {
        int n;
        int n2 = 256;
        int n3 = 32;
        byte[] byArray = new byte[n2 * n3];
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3, byArray, indexColorModel);
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < n3; ++n) {
            byteProcessor.putRow(0, n, nArray, n2);
        }
        return byteProcessor;
    }
}

