/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.io.FileSaver;
import ij.plugin.PlugIn;
import ij.plugin.frame.LineWidthAdjuster;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;

public class Options
implements PlugIn {
    @Override
    public void run(String string) {
        if (string.equals("misc")) {
            this.miscOptions();
            return;
        }
        if (string.equals("line")) {
            this.lineWidth();
            return;
        }
        if (string.equals("io")) {
            this.io();
            return;
        }
        if (string.equals("conv")) {
            this.conversions();
            return;
        }
        if (string.equals("display")) {
            this.appearance();
            return;
        }
        if (string.equals("dicom")) {
            this.dicom();
            return;
        }
    }

    void miscOptions() {
        String string = IJ.isMacintosh() ? "command" : "control";
        GenericDialog genericDialog = new GenericDialog("Miscellaneous Options", IJ.getInstance());
        genericDialog.addStringField("Divide by zero value:", "" + FloatBlitter.divideByZeroValue, 10);
        genericDialog.addCheckbox("Use pointer cursor", Prefs.usePointerCursor);
        genericDialog.addCheckbox("Hide \"Process Stack?\" dialog", IJ.hideProcessStackDialog);
        genericDialog.addCheckbox("Require " + string + " key for shortcuts", Prefs.requireControlKey);
        genericDialog.addCheckbox("Move isolated plugins to Misc. menu", Prefs.moveToMisc);
        genericDialog.addCheckbox("Run single instance listener", Prefs.runSocketListener);
        genericDialog.addCheckbox("Debug mode", IJ.debugMode);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#misc");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string2 = genericDialog.getNextString();
        if (string2.equalsIgnoreCase("infinity") || string2.equalsIgnoreCase("infinite")) {
            FloatBlitter.divideByZeroValue = Float.POSITIVE_INFINITY;
        } else if (string2.equalsIgnoreCase("NaN")) {
            FloatBlitter.divideByZeroValue = Float.NaN;
        } else if (string2.equalsIgnoreCase("max")) {
            FloatBlitter.divideByZeroValue = Float.MAX_VALUE;
        } else {
            Float f;
            try {
                f = new Float(string2);
            }
            catch (NumberFormatException numberFormatException) {
                f = null;
            }
            if (f != null) {
                FloatBlitter.divideByZeroValue = f.floatValue();
            }
        }
        IJ.register(FloatBlitter.class);
        Prefs.usePointerCursor = genericDialog.getNextBoolean();
        IJ.hideProcessStackDialog = genericDialog.getNextBoolean();
        Prefs.requireControlKey = genericDialog.getNextBoolean();
        Prefs.moveToMisc = genericDialog.getNextBoolean();
        Prefs.runSocketListener = genericDialog.getNextBoolean();
        IJ.debugMode = genericDialog.getNextBoolean();
    }

    void lineWidth() {
        int n = (int)IJ.getNumber("Line Width:", Line.getWidth());
        if (n == Integer.MIN_VALUE) {
            return;
        }
        Line.setWidth(n);
        LineWidthAdjuster.update();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && imagePlus.isProcessor()) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            imageProcessor.setLineWidth(Line.getWidth());
            Roi roi = imagePlus.getRoi();
            if (roi != null && roi.isLine()) {
                imagePlus.draw();
            }
        }
    }

    void io() {
        GenericDialog genericDialog = new GenericDialog("I/O Options");
        genericDialog.addNumericField("JPEG quality (0-100):", FileSaver.getJpegQuality(), 0, 3, "");
        genericDialog.addNumericField("GIF and PNG transparent index:", Prefs.getTransparentIndex(), 0, 3, "");
        genericDialog.addStringField("File extension for tables:", Prefs.get("options.ext", ".txt"), 4);
        genericDialog.addCheckbox("Use JFileChooser to open/save", Prefs.useJFileChooser);
        if (!IJ.isMacOSX()) {
            genericDialog.addCheckbox("Use_file chooser to import sequences", Prefs.useFileChooser);
        }
        genericDialog.addCheckbox("Save TIFF and raw in Intel byte order", Prefs.intelByteOrder);
        genericDialog.setInsets(15, 20, 0);
        genericDialog.addMessage("Results Table Options");
        genericDialog.setInsets(3, 40, 0);
        genericDialog.addCheckbox("Copy_column headers", Prefs.copyColumnHeaders);
        genericDialog.setInsets(0, 40, 0);
        genericDialog.addCheckbox("Copy_row numbers", !Prefs.noRowNumbers);
        genericDialog.setInsets(0, 40, 0);
        genericDialog.addCheckbox("Save_column headers", !Prefs.dontSaveHeaders);
        genericDialog.setInsets(0, 40, 0);
        genericDialog.addCheckbox("Save_row numbers", !Prefs.dontSaveRowNumbers);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = (int)genericDialog.getNextNumber();
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        FileSaver.setJpegQuality(n);
        int n2 = (int)genericDialog.getNextNumber();
        Prefs.setTransparentIndex(n2);
        String string = genericDialog.getNextString();
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        Prefs.set("options.ext", string);
        Prefs.useJFileChooser = genericDialog.getNextBoolean();
        if (!IJ.isMacOSX()) {
            Prefs.useFileChooser = genericDialog.getNextBoolean();
        }
        Prefs.intelByteOrder = genericDialog.getNextBoolean();
        Prefs.copyColumnHeaders = genericDialog.getNextBoolean();
        Prefs.noRowNumbers = !genericDialog.getNextBoolean();
        Prefs.dontSaveHeaders = !genericDialog.getNextBoolean();
        Prefs.dontSaveRowNumbers = !genericDialog.getNextBoolean();
    }

    void conversions() {
        double[] dArray = ColorProcessor.getWeightingFactors();
        boolean bl = dArray[0] != 0.3333333333333333 || dArray[1] != 0.3333333333333333 || dArray[2] != 0.3333333333333333;
        GenericDialog genericDialog = new GenericDialog("Conversion Options");
        genericDialog.addCheckbox("Scale When Converting", ImageConverter.getDoScaling());
        String string = "Weighted RGB Conversions";
        if (bl) {
            string = string + " (" + IJ.d2s(dArray[0]) + "," + IJ.d2s(dArray[1]) + "," + IJ.d2s(dArray[2]) + ")";
        }
        genericDialog.addCheckbox(string, bl);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        ImageConverter.setDoScaling(genericDialog.getNextBoolean());
        Prefs.weightedColor = genericDialog.getNextBoolean();
        if (!Prefs.weightedColor) {
            ColorProcessor.setWeightingFactors(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
        } else if (Prefs.weightedColor && !bl) {
            ColorProcessor.setWeightingFactors(0.299, 0.587, 0.114);
        }
    }

    void appearance() {
        ImagePlus imagePlus;
        GenericDialog genericDialog = new GenericDialog("Appearance", IJ.getInstance());
        genericDialog.addCheckbox("Interpolate zoomed images", Prefs.interpolateScaledImages);
        genericDialog.addCheckbox("Open images at 100%", Prefs.open100Percent);
        genericDialog.addCheckbox("Black canvas", Prefs.blackCanvas);
        genericDialog.addCheckbox("No image border", Prefs.noBorder);
        genericDialog.addCheckbox("Use inverting lookup table", Prefs.useInvertingLut);
        genericDialog.addCheckbox("Antialiased tool icons", Prefs.antialiasedTools);
        genericDialog.addNumericField("Menu font size:", Menus.getFontSize(), 0, 3, "points");
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#appearance");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean bl = genericDialog.getNextBoolean();
        Prefs.open100Percent = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        boolean bl3 = genericDialog.getNextBoolean();
        boolean bl4 = genericDialog.getNextBoolean();
        boolean bl5 = genericDialog.getNextBoolean();
        boolean bl6 = bl5 != Prefs.antialiasedTools;
        Prefs.antialiasedTools = bl5;
        if (bl6) {
            Toolbar.getInstance().repaint();
        }
        int n = (int)genericDialog.getNextNumber();
        if (bl != Prefs.interpolateScaledImages) {
            Prefs.interpolateScaledImages = bl;
            imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.draw();
            }
        }
        if (bl2 != Prefs.blackCanvas) {
            ImageWindow imageWindow;
            Prefs.blackCanvas = bl2;
            imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null && (imageWindow = imagePlus.getWindow()) != null) {
                if (Prefs.blackCanvas) {
                    imageWindow.setForeground(Color.white);
                    imageWindow.setBackground(Color.black);
                } else {
                    imageWindow.setForeground(Color.black);
                    imageWindow.setBackground(Color.white);
                }
                imagePlus.repaintWindow();
            }
        }
        if (bl3 != Prefs.noBorder) {
            Prefs.noBorder = bl3;
            imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.repaintWindow();
            }
        }
        if (bl4 != Prefs.useInvertingLut) {
            this.invertLuts(bl4);
            Prefs.useInvertingLut = bl4;
        }
        if (n != Menus.getFontSize() && !IJ.isMacintosh()) {
            Menus.setFontSize(n);
            IJ.showMessage("Appearance", "Restart ImageJ to use the new font size");
        }
    }

    void invertLuts(boolean bl) {
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ImagePlus imagePlus = WindowManager.getImage(nArray[i]);
            if (imagePlus == null) {
                return;
            }
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (bl == imageProcessor.isInvertedLut() || imageProcessor.isColorLut()) continue;
            imageProcessor.invertLut();
            int n = imagePlus.getStackSize();
            if (n == 1) {
                imageProcessor.invert();
                continue;
            }
            ImageStack imageStack = imagePlus.getStack();
            for (int j = 1; j <= n; ++j) {
                imageStack.getProcessor(j).invert();
            }
            imageStack.setColorModel(imageProcessor.getColorModel());
        }
    }

    void dicom() {
        GenericDialog genericDialog = new GenericDialog("DICOM Options");
        genericDialog.addCheckbox("Open as 32-bit float", Prefs.openDicomsAsFloat);
        genericDialog.addMessage("Orthogonal Views");
        genericDialog.setInsets(5, 40, 0);
        genericDialog.addCheckbox("Rotate YZ", Prefs.rotateYZ);
        genericDialog.setInsets(0, 40, 0);
        genericDialog.addCheckbox("Flip XZ", Prefs.flipXZ);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        Prefs.openDicomsAsFloat = genericDialog.getNextBoolean();
        Prefs.rotateYZ = genericDialog.getNextBoolean();
        Prefs.flipXZ = genericDialog.getNextBoolean();
    }
}

