/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.macro.Interpreter;
import ij.plugin.OverlayLabels;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class OverlayCommands
implements PlugIn {
    private static int opacity = 100;
    private static Roi defaultRoi = new Roi(0, 0, 1, 1);

    @Override
    public void run(String string) {
        if (string.equals("add")) {
            this.addSelection();
        } else if (string.equals("image")) {
            this.addImage(false);
        } else if (string.equals("image-roi")) {
            this.addImage(true);
        } else if (string.equals("flatten")) {
            this.flatten();
        } else if (string.equals("hide")) {
            this.hide();
        } else if (string.equals("show")) {
            this.show();
        } else if (string.equals("remove")) {
            this.remove();
        } else if (string.equals("from")) {
            this.fromRoiManager();
        } else if (string.equals("to")) {
            this.toRoiManager();
        } else if (string.equals("options")) {
            this.options();
        }
    }

    void addSelection() {
        boolean bl;
        Object object;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        ImagePlus imagePlus = IJ.getImage();
        String string = Macro.getOptions();
        if (string != null && IJ.macroRunning() && string.indexOf("remove") != -1) {
            imagePlus.setOverlay(null);
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null && imagePlus.getOverlay() != null) {
            GenericDialog genericDialog = new GenericDialog("No Selection");
            genericDialog.addMessage("\"Overlay>Add\" requires a selection.");
            genericDialog.setInsets(15, 40, 0);
            genericDialog.addCheckbox("Remove existing overlay", false);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            if (genericDialog.getNextBoolean()) {
                imagePlus.setOverlay(null);
            }
            return;
        }
        if (roi == null) {
            IJ.error("This command requires a selection.");
            return;
        }
        roi = (Roi)roi.clone();
        Overlay overlay = imagePlus.getOverlay();
        if (!roi.isDrawingTool()) {
            if (roi.getStroke() == null) {
                roi.setStrokeWidth(defaultRoi.getStrokeWidth());
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && defaultRoi.getStrokeColor() != null) {
                roi.setStrokeColor(defaultRoi.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(defaultRoi.getFillColor());
            }
        }
        boolean bl5 = bl4 = defaultRoi.getPosition() != 0;
        if (bl4 && imagePlus.getStackSize() > 1) {
            if (imagePlus.isHyperStack() || imagePlus.isComposite()) {
                roi.setPosition(0, imagePlus.getSlice(), imagePlus.getFrame());
            } else {
                roi.setPosition(imagePlus.getCurrentSlice());
            }
        }
        int n = Line.getWidth();
        Rectangle rectangle = roi.getBounds();
        boolean bl6 = bl3 = (double)n > (double)Math.max(rectangle.width, rectangle.height) / 3.0;
        if (roi.getStroke() == null && n > 1 && !bl3) {
            roi.setStrokeWidth(Line.getWidth());
        }
        boolean bl7 = bl2 = roi instanceof PointRoi && ((PolygonRoi)roi).getNCoordinates() > 1;
        if ((IJ.altKeyDown() || IJ.macroRunning() && Macro.getOptions() != null) && !((RoiProperties)(object = new RoiProperties("Add to Overlay", roi))).showDialog()) {
            return;
        }
        object = roi.getName();
        boolean bl8 = bl = object != null && ((String)object).equals("new-overlay");
        if (overlay == null || bl) {
            overlay = OverlayLabels.createOverlay();
        }
        overlay.add(roi);
        defaultRoi = (Roi)roi.clone();
        defaultRoi.setPosition(bl4 ? 1 : 0);
        imagePlus.setOverlay(overlay);
        if (bl2 || roi instanceof ImageRoi || roi instanceof Arrow) {
            imagePlus.killRoi();
        }
        Undo.setup(7, imagePlus);
    }

    void addImage(boolean bl) {
        Object object;
        ImageObserver imageObserver;
        Object object2;
        int n;
        ImagePlus imagePlus = IJ.getImage();
        int[] nArray = WindowManager.getIDList();
        if (nArray == null || nArray.length < 2) {
            IJ.error("Add Image...", "The command requires at least two open images.");
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            ImagePlus imagePlus2 = WindowManager.getImage(nArray[n]);
            stringArray[n] = imagePlus2 != null ? imagePlus2.getTitle() : "";
        }
        n = 0;
        int n2 = 0;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isArea()) {
            Rectangle rectangle = roi.getBounds();
            n = rectangle.x;
            n2 = rectangle.y;
        }
        int n3 = 0;
        if (nArray.length == 2) {
            object2 = WindowManager.getImage(nArray[0]);
            imageObserver = WindowManager.getImage(nArray[1]);
            if (((ImagePlus)imageObserver).getWidth() < ((ImagePlus)object2).getWidth() && ((ImagePlus)imageObserver).getHeight() < ((ImagePlus)object2).getHeight()) {
                n3 = 1;
            }
        } else if (imagePlus.getID() == nArray[0]) {
            n3 = 1;
        }
        object2 = bl ? "Create Image ROI" : "Add Image...";
        imageObserver = new GenericDialog((String)object2);
        if (bl) {
            ((GenericDialog)imageObserver).addChoice("Image:", stringArray, stringArray[n3]);
        } else {
            ((GenericDialog)imageObserver).addChoice("Image to add:", stringArray, stringArray[n3]);
            ((GenericDialog)imageObserver).addNumericField("X location:", n, 0);
            ((GenericDialog)imageObserver).addNumericField("Y location:", n2, 0);
        }
        ((GenericDialog)imageObserver).addNumericField("Opacity (0-100%):", opacity, 0);
        ((GenericDialog)imageObserver).showDialog();
        if (((GenericDialog)imageObserver).wasCanceled()) {
            return;
        }
        n3 = ((GenericDialog)imageObserver).getNextChoiceIndex();
        if (!bl) {
            n = (int)((GenericDialog)imageObserver).getNextNumber();
            n2 = (int)((GenericDialog)imageObserver).getNextNumber();
        }
        opacity = (int)((GenericDialog)imageObserver).getNextNumber();
        ImagePlus imagePlus3 = WindowManager.getImage(nArray[n3]);
        if (nArray.length == 2) {
            object = WindowManager.getImage(nArray[0]);
            ImagePlus imagePlus4 = WindowManager.getImage(nArray[1]);
            if (imagePlus4.getWidth() < ((ImagePlus)object).getWidth() && imagePlus4.getHeight() < ((ImagePlus)object).getHeight()) {
                imagePlus = object;
                imagePlus3 = imagePlus4;
            }
        }
        if (imagePlus3 == imagePlus) {
            IJ.error("Add Image...", "Image to be added cannot be the same as\n\"" + imagePlus.getTitle() + "\".");
            return;
        }
        if (imagePlus3.getWidth() > imagePlus.getWidth() && imagePlus3.getHeight() > imagePlus.getHeight()) {
            IJ.error("Add Image...", "Image to be added cannnot be larger than\n\"" + imagePlus.getTitle() + "\".");
            return;
        }
        if (bl && n == 0 && n2 == 0) {
            n = imagePlus.getWidth() / 2 - imagePlus3.getWidth() / 2;
            n2 = imagePlus.getHeight() / 2 - imagePlus3.getHeight() / 2;
        }
        roi = new ImageRoi(n, n2, imagePlus3.getProcessor());
        roi.setName(imagePlus3.getShortTitle());
        if (opacity != 100) {
            ((ImageRoi)roi).setOpacity((double)opacity / 100.0);
        }
        if (bl) {
            imagePlus.setRoi(roi);
        } else {
            object = imagePlus.getOverlay();
            if (object == null) {
                object = new Overlay();
            }
            ((Overlay)object).add(roi);
            imagePlus.setOverlay((Overlay)object);
            Undo.setup(7, imagePlus);
        }
    }

    void hide() {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.setHideOverlay(true);
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager != null) {
            roiManager.runCommand("show none");
        }
    }

    void show() {
        RoiManager roiManager;
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.setHideOverlay(false);
        if (imagePlus.getOverlay() == null && (roiManager = RoiManager.getInstance()) != null && roiManager.getCount() > 1) {
            if (!IJ.isMacro()) {
                roiManager.toFront();
            }
            roiManager.runCommand("show all with labels");
        }
    }

    void remove() {
        RoiManager roiManager;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            imagePlus.setOverlay(null);
        }
        if ((roiManager = RoiManager.getInstance()) != null) {
            roiManager.runCommand("show none");
        }
    }

    void flatten() {
        int n;
        ImagePlus imagePlus = IJ.getImage();
        int n2 = n = imagePlus.isComposite() ? 0 : IJ.setupDialog(imagePlus, 0);
        if (n == 4096) {
            return;
        }
        if (n == 32) {
            this.flattenStack(imagePlus);
        } else {
            ImagePlus imagePlus2 = imagePlus.flatten();
            imagePlus2.setTitle(WindowManager.getUniqueName(imagePlus.getTitle()));
            imagePlus2.show();
        }
    }

    void flattenStack(ImagePlus imagePlus) {
        Overlay overlay = imagePlus.getOverlay();
        if (overlay == null || !IJ.isJava16() || imagePlus.getBitDepth() != 24) {
            IJ.error("Flatten Stack", "An overlay, Java 1.6 and an RGB image are required.");
            return;
        }
        ImageStack imageStack = imagePlus.getStack();
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            Roi[] roiArray = overlay.toArray();
            for (int j = 0; j < roiArray.length; ++j) {
                Roi roi = roiArray[j];
                int n = roi.getPosition();
                if (n != 0 && n != i) continue;
                imageProcessor.drawRoi(roi);
            }
        }
        imagePlus.setStack(imageStack);
        imagePlus.setOverlay(null);
    }

    void fromRoiManager() {
        ImagePlus imagePlus = IJ.getImage();
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager == null) {
            IJ.error("ROI Manager is not open");
            return;
        }
        Roi[] roiArray = roiManager.getRoisAsArray();
        if (roiArray.length == 0) {
            IJ.error("ROI Manager is empty");
            return;
        }
        Overlay overlay = OverlayLabels.createOverlay();
        for (int i = 0; i < roiArray.length; ++i) {
            Roi roi = (Roi)roiArray[i].clone();
            if (!Prefs.showAllSliceOnly) {
                roi.setPosition(0);
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && defaultRoi.getStrokeColor() != null) {
                roi.setStrokeColor(defaultRoi.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(defaultRoi.getFillColor());
            }
            overlay.add(roi);
        }
        imagePlus.setOverlay(overlay);
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas != null) {
            imageCanvas.setShowAllROIs(false);
        }
        roiManager.setEditMode(imagePlus, false);
        imagePlus.killRoi();
    }

    void toRoiManager() {
        ImagePlus imagePlus = IJ.getImage();
        Overlay overlay = imagePlus.getOverlay();
        if (overlay == null) {
            IJ.error("Overlay required");
            return;
        }
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager == null) {
            if (Macro.getOptions() != null && Interpreter.isBatchMode()) {
                roiManager = Interpreter.getBatchModeRoiManager();
            }
            if (roiManager == null) {
                Frame frame = WindowManager.getFrame("ROI Manager");
                if (frame == null) {
                    IJ.run("ROI Manager...");
                }
                if ((frame = WindowManager.getFrame("ROI Manager")) == null || !(frame instanceof RoiManager)) {
                    return;
                }
                roiManager = (RoiManager)frame;
            }
        }
        if (overlay.size() >= 4 && overlay.get(3).getPosition() != 0) {
            Prefs.showAllSliceOnly = true;
        }
        roiManager.runCommand("reset");
        for (int i = 0; i < overlay.size(); ++i) {
            roiManager.add(imagePlus, overlay.get(i), i);
        }
        roiManager.setEditMode(imagePlus, true);
        if (roiManager.getCount() == overlay.size()) {
            imagePlus.setOverlay(null);
        }
    }

    void options() {
        boolean bl;
        boolean bl2;
        int n;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Overlay overlay = null;
        Roi roi = null;
        if (imagePlus != null) {
            overlay = imagePlus.getOverlay();
            roi = imagePlus.getRoi();
            if (roi != null) {
                roi = (Roi)roi.clone();
            }
        }
        if (roi == null) {
            roi = defaultRoi;
        }
        if (roi == null) {
            n = imagePlus != null ? imagePlus.getWidth() : 512;
            roi = new Roi(0, 0, n / 4, n / 4);
        }
        if (!roi.isDrawingTool()) {
            if (roi.getStroke() == null) {
                roi.setStrokeWidth(defaultRoi.getStrokeWidth());
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && defaultRoi.getStrokeColor() != null) {
                roi.setStrokeColor(defaultRoi.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(defaultRoi.getFillColor());
            }
        }
        n = Line.getWidth();
        Rectangle rectangle = roi.getBounds();
        boolean bl3 = bl2 = (double)n > (double)Math.max(rectangle.width, rectangle.height) / 3.0;
        if (roi.getStroke() == null && n > 1 && !bl2) {
            roi.setStrokeWidth(Line.getWidth());
        }
        if (roi.getStrokeColor() == null) {
            roi.setStrokeColor(Roi.getColor());
        }
        boolean bl4 = bl = roi instanceof PointRoi && ((PolygonRoi)roi).getNCoordinates() > 1;
        if (bl) {
            roi.setStrokeColor(Color.red);
        }
        roi.setPosition(defaultRoi.getPosition());
        RoiProperties roiProperties = new RoiProperties("Overlay Options", roi);
        if (!roiProperties.showDialog()) {
            return;
        }
        defaultRoi = roi;
    }

    static {
        defaultRoi.setStrokeColor(Roi.getColor());
    }
}

