/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class OverlayLabels
implements PlugIn,
DialogListener {
    private static final String[] fontSizes = new String[]{"7", "8", "9", "10", "12", "14", "18", "24", "28", "36", "48", "72"};
    private static Overlay defaultOverlay = new Overlay();
    private ImagePlus imp;
    private Overlay overlay;
    private GenericDialog gd;
    private boolean showLabels;
    private boolean showNames;
    private boolean drawBackgrounds;
    private String colorName;
    private int fontSize;
    private boolean bold;

    @Override
    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        Overlay overlay = this.overlay = this.imp != null ? this.imp.getOverlay() : null;
        if (this.overlay == null) {
            this.overlay = defaultOverlay;
        }
        this.showDialog();
        if (!this.gd.wasCanceled()) {
            defaultOverlay.drawLabels(this.overlay.getDrawLabels());
            defaultOverlay.drawNames(this.overlay.getDrawNames());
            defaultOverlay.drawBackgrounds(this.overlay.getDrawBackgrounds());
            defaultOverlay.setLabelColor(this.overlay.getLabelColor());
            defaultOverlay.setLabelFont(this.overlay.getLabelFont());
        }
    }

    public void showDialog() {
        this.showLabels = this.overlay.getDrawLabels();
        this.showNames = this.overlay.getDrawNames();
        this.drawBackgrounds = this.overlay.getDrawBackgrounds();
        this.colorName = Colors.getColorName(this.overlay.getLabelColor(), "white");
        this.fontSize = 12;
        Font font = this.overlay.getLabelFont();
        if (font != null) {
            this.fontSize = font.getSize();
            this.bold = font.getStyle() == 1;
        }
        this.gd = new GenericDialog("Labels");
        this.gd.addChoice("Color:", Colors.colors, this.colorName);
        this.gd.addChoice("Font size:", fontSizes, "" + this.fontSize);
        this.gd.addCheckbox("Show labels", this.showLabels);
        this.gd.addCheckbox("Use names as labels", this.showNames);
        this.gd.addCheckbox("Draw backgrounds", this.drawBackgrounds);
        this.gd.addCheckbox("Bold", this.bold);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        boolean bl;
        if (genericDialog.wasCanceled()) {
            return false;
        }
        String string = this.colorName;
        boolean bl2 = this.showLabels;
        boolean bl3 = this.showNames;
        boolean bl4 = this.drawBackgrounds;
        boolean bl5 = this.bold;
        int n = this.fontSize;
        this.colorName = genericDialog.getNextChoice();
        this.fontSize = (int)Tools.parseDouble(genericDialog.getNextChoice(), 12.0);
        this.showLabels = genericDialog.getNextBoolean();
        this.showNames = genericDialog.getNextBoolean();
        this.drawBackgrounds = genericDialog.getNextBoolean();
        this.bold = genericDialog.getNextBoolean();
        boolean bl6 = !this.colorName.equals(string);
        boolean bl7 = this.fontSize != n;
        boolean bl8 = bl = this.showLabels != bl2 || this.showNames != bl3 || this.drawBackgrounds != bl4 || bl6 || bl7 || this.bold != bl5;
        if (bl) {
            Serializable serializable;
            if (this.showNames || bl6 || bl7) {
                this.showLabels = true;
                serializable = genericDialog.getCheckboxes();
                ((Checkbox)serializable.elementAt(0)).setState(true);
            }
            this.overlay.drawLabels(this.showLabels);
            this.overlay.drawNames(this.showNames);
            this.overlay.drawBackgrounds(this.drawBackgrounds);
            serializable = Colors.getColor(this.colorName, Color.white);
            this.overlay.setLabelColor((Color)serializable);
            if (bl7 || this.bold || this.bold != bl5) {
                this.overlay.setLabelFont(new Font("SansSerif", this.bold ? 1 : 0, this.fontSize));
            }
            if (this.imp != null && this.imp.getOverlay() != null) {
                this.imp.draw();
            }
        }
        return true;
    }

    static Overlay createOverlay() {
        return defaultOverlay.duplicate();
    }
}

