/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.GelAnalyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class PlotsCanvas
extends ImageCanvas {
    public static final int MAX_PEAKS = 200;
    double[] actual = new double[]{428566.0, 351368.0, 233977.0, 99413.0, 60057.0, 31382.0, 14531.0, 7843.0, 2146.0, 752.0, 367.0};
    double[] measured = new double[200];
    Rectangle[] rect = new Rectangle[200];
    int counter;
    ResultsTable rt;

    public PlotsCanvas(ImagePlus imagePlus) {
        super(imagePlus);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            return;
        }
        if (roi.getType() == 5) {
            Roi.setColor(Color.blue);
        } else {
            Roi.setColor(Color.yellow);
        }
        if (Toolbar.getToolId() != 8 || IJ.spaceBarDown()) {
            return;
        }
        if (IJ.shiftKeyDown()) {
            IJ.showMessage("Gel Analyzer", "Unable to measure area because shift key is down.");
            this.imp.killRoi();
            this.counter = 0;
            return;
        }
        ImageStatistics imageStatistics = this.imp.getStatistics();
        if (this.counter == 0) {
            this.rt = ResultsTable.getResultsTable();
            this.rt.reset();
        }
        double d = roi.getLength();
        String string = "";
        double d2 = Math.PI * 4 * ((double)imageStatistics.pixelCount / (d * d));
        if (d2 < 0.025) {
            string = " (error?)";
        }
        double d3 = (double)imageStatistics.pixelCount + d / 2.0;
        Calibration calibration = this.imp.getCalibration();
        d3 = d3 * calibration.pixelWidth * calibration.pixelHeight;
        this.rect[this.counter] = roi.getBounds();
        int n = calibration.scaled() ? 3 : 0;
        this.rt.incrementCounter();
        this.rt.addValue("Area", d3);
        this.rt.show("Results");
        this.measured[this.counter] = d3;
        if (this.counter < 200) {
            ++this.counter;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 5) {
            Undo.setup(1, this.imp);
            this.imp.getProcessor().snapshot();
            roi.drawPixels();
            this.imp.updateAndDraw();
            this.imp.killRoi();
        }
    }

    void reset() {
        this.counter = 0;
    }

    void labelPeaks() {
        this.imp.killRoi();
        double d = 0.0;
        for (int i = 0; i < this.counter; ++i) {
            d += this.measured[i];
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        imageProcessor.setFont(new Font("SansSerif", 0, 9));
        for (int i = 0; i < this.counter; ++i) {
            Rectangle rectangle = this.rect[i];
            String string = GelAnalyzer.labelWithPercentages ? IJ.d2s(this.measured[i] / d * 100.0, 2) : IJ.d2s(this.measured[i], 0);
            int n = imageProcessor.getStringWidth(string);
            int n2 = rectangle.x + rectangle.width / 2 - n / 2;
            int n3 = rectangle.y + rectangle.height * 3 / 4 + 9;
            int[] nArray = new int[n];
            imageProcessor.getRow(n2, n3, nArray, n);
            boolean bl = true;
            for (int j = 0; j < n; ++j) {
                if (nArray[j] == 255) continue;
                bl = false;
                break;
            }
            boolean bl2 = bl = bl && this.measured[i] > 500.0;
            if (rectangle.height >= GelAnalyzer.plotHeight - 11) {
                bl = true;
            }
            if (!bl) {
                n3 = rectangle.y - 2;
            }
            imageProcessor.drawString(string, n2, n3);
        }
        this.imp.updateAndDraw();
        this.displayPercentages();
        this.reset();
    }

    void displayPercentages() {
        int n;
        ResultsTable resultsTable = ResultsTable.getResultsTable();
        resultsTable.reset();
        double d = 0.0;
        for (n = 0; n < this.counter; ++n) {
            d += this.measured[n];
        }
        if (IJ.debugMode && this.counter == this.actual.length) {
            this.debug();
            return;
        }
        for (n = 0; n < this.counter; ++n) {
            double d2 = this.measured[n] / d * 100.0;
            resultsTable.incrementCounter();
            resultsTable.addValue("Area", this.measured[n]);
            resultsTable.addValue("Percent", d2);
        }
        resultsTable.show("Results");
    }

    void debug() {
        for (int i = 0; i < this.counter; ++i) {
            double d = this.actual[i] / this.actual[0] * 100.0;
            double d2 = this.measured[i] / this.measured[0] * 100.0;
            IJ.write(IJ.d2s(d, 4) + " " + IJ.d2s(d2, 4) + " " + IJ.d2s((d2 - d) / d2 * 100.0, 4));
        }
    }
}

