/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;

public class SimpleCommands
implements PlugIn {
    static String searchArg;
    private static String[] choices;
    private static int choiceIndex;

    @Override
    public void run(String string) {
        if (string.equals("search")) {
            this.search();
        } else if (string.equals("import")) {
            Opener.openResultsTable("");
        } else if (string.equals("rename")) {
            this.rename();
        } else if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("about")) {
            this.aboutPluginsHelp();
        } else if (string.equals("install")) {
            this.installation();
        } else if (string.equals("remove")) {
            this.removeStackLabels();
        }
    }

    void reset() {
        GenericDialog genericDialog = new GenericDialog("");
        genericDialog.addChoice("Reset:", choices, choices[choiceIndex]);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        choiceIndex = genericDialog.getNextChoiceIndex();
        switch (choiceIndex) {
            case 0: {
                this.unlock();
                break;
            }
            case 1: {
                this.resetClipboard();
                break;
            }
            case 2: {
                this.resetUndo();
            }
        }
    }

    void unlock() {
        ImagePlus imagePlus = IJ.getImage();
        boolean bl = imagePlus.lockSilently();
        if (bl) {
            IJ.showStatus("\"" + imagePlus.getTitle() + "\" is not locked");
        } else {
            IJ.showStatus("\"" + imagePlus.getTitle() + "\" is now unlocked");
            IJ.beep();
        }
        imagePlus.unlock();
    }

    void resetClipboard() {
        ImagePlus.resetClipboard();
        IJ.showStatus("Clipboard reset");
    }

    void resetUndo() {
        Undo.setup(0, null);
        IJ.showStatus("Undo reset");
    }

    void rename() {
        ImagePlus imagePlus = IJ.getImage();
        GenericDialog genericDialog = new GenericDialog("Rename");
        genericDialog.addStringField("Title:", imagePlus.getTitle(), 30);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        imagePlus.setTitle(genericDialog.getNextString());
    }

    void search() {
        searchArg = IJ.runMacroFile("ij.jar:Search", searchArg);
    }

    void installation() {
        String string = "http://imagej.nih.gov/ij/docs/install/";
        if (IJ.isMacintosh()) {
            string = string + "osx.html";
        } else if (IJ.isWindows()) {
            string = string + "windows.html";
        } else if (IJ.isLinux()) {
            string = string + "linux.html";
        }
        IJ.runPlugIn("ij.plugin.BrowserLauncher", string);
    }

    void aboutPluginsHelp() {
        IJ.showMessage("\"About Plugins\" Submenu", "Plugins packaged as JAR files can add entries\nto this submenu. There is an example at\n \nhttp://imagej.nih.gov/ij/plugins/jar-demo.html");
    }

    void removeStackLabels() {
        ImagePlus imagePlus = IJ.getImage();
        int n = imagePlus.getStackSize();
        if (n == 1) {
            IJ.error("Stack required");
        } else {
            ImageStack imageStack = imagePlus.getStack();
            for (int i = 1; i <= n; ++i) {
                imageStack.setSliceLabel(null, i);
            }
            imagePlus.repaintWindow();
        }
    }

    static {
        choices = new String[]{"Locked Image", "Clipboard", "Undo Buffer"};
        choiceIndex = 0;
    }
}

