/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class CalibrationBar
implements PlugInFilter {
    static final int BAR_LENGTH = 128;
    static final int BAR_THICKNESS = 12;
    static final int XMARGIN = 10;
    static final int YMARGIN = 10;
    static final int WIN_HEIGHT = 128;
    static final int BOX_PAD = 0;
    static final int LINE_WIDTH = 1;
    static int nBins = 256;
    static final String[] colors = new String[]{"White", "Light Gray", "Dark Gray", "Black", "Red", "Green", "Blue", "Yellow", "None"};
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static String fillColor = colors[0];
    static String textColor = colors[3];
    static String location = locations[0];
    static double zoom = 1.0;
    static int numLabels = 5;
    static int fontSize = 12;
    static int decimalPlaces = 0;
    ImagePlus imp;
    ImagePlus impOriginal;
    LiveDialog gd;
    ImageStatistics stats;
    Calibration cal;
    int[] histogram;
    LookUpTable lut;
    Image img;
    Button setup;
    Button redraw;
    Button insert;
    Button unInsert;
    Checkbox ne;
    Checkbox nw;
    Checkbox se;
    Checkbox sw;
    CheckboxGroup locGroup;
    Label value;
    Label note;
    int newMaxCount;
    boolean logScale;
    int win_width;
    int userPadding = 0;
    int fontHeight = 0;
    boolean boldText = false;
    Object backupPixels;
    byte[] byteStorage;
    int[] intStorage;
    short[] shortStorage;
    float[] floatStorage;
    String boxOutlineColor = colors[8];
    String barOutlineColor = colors[3];
    ImagePlus impData;
    ImageProcessor ip;
    String[] fieldNames = null;
    int insetPad;
    boolean decimalPlacesChanged;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        if (imagePlus != null) {
            this.imp = imagePlus;
            this.impData = imagePlus;
            if (imagePlus.getRoi() != null) {
                location = locations[4];
            }
        }
        return 143;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        double d;
        ImageCanvas imageCanvas = this.imp.getCanvas();
        double d2 = d = imageCanvas != null ? imageCanvas.getMagnification() : 1.0;
        if (zoom <= 1.0 && d < 1.0) {
            zoom = 1.0 / d;
        }
        this.ip = imageProcessor.duplicate().convertToRGB();
        this.impOriginal = this.imp;
        this.imp = new ImagePlus(this.imp.getTitle() + " with bar", this.ip);
        this.imp.setCalibration(this.impData.getCalibration());
        if (this.impOriginal.getRoi() != null) {
            this.imp.setRoi(this.impOriginal.getRoi());
        }
        this.imp.show();
        this.ip.snapshot();
        this.insetPad = this.imp.getWidth() / 50;
        if (this.insetPad < 4) {
            this.insetPad = 4;
        }
        this.updateColorBar();
        if (!this.showDialog()) {
            this.imp.hide();
            this.ip.reset();
            this.imp.updateAndDraw();
            return;
        }
        this.updateColorBar();
    }

    private void updateColorBar() {
        this.ip.reset();
        Roi roi = this.imp.getRoi();
        if (roi != null && location.equals(locations[4])) {
            Rectangle rectangle = roi.getBounds();
            this.drawColorBar(this.imp, rectangle.x, rectangle.y);
        } else if (location.equals(locations[3])) {
            this.drawColorBar(this.imp, this.insetPad, this.insetPad);
        } else if (location.equals(locations[0])) {
            this.calculateWidth();
            this.drawColorBar(this.imp, this.imp.getWidth() - this.insetPad - this.win_width, this.insetPad);
        } else if (location.equals(locations[2])) {
            this.drawColorBar(this.imp, this.insetPad, this.imp.getHeight() - (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - (int)((double)this.insetPad * zoom));
        } else if (location.equals(locations[1])) {
            this.calculateWidth();
            this.drawColorBar(this.imp, this.imp.getWidth() - this.win_width - this.insetPad, this.imp.getHeight() - (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - this.insetPad);
        }
        this.imp.updateAndDraw();
    }

    private boolean showDialog() {
        this.gd = new LiveDialog("Calibration Bar");
        this.gd.addChoice("Location:", locations, location);
        this.gd.addChoice("Fill Color: ", colors, fillColor);
        this.gd.addChoice("Label Color: ", colors, textColor);
        this.gd.addNumericField("Number of Labels:", numLabels, 0);
        this.gd.addNumericField("Decimal Places:", decimalPlaces, 0);
        this.gd.addNumericField("Font Size:", fontSize, 0);
        this.gd.addNumericField("Zoom Factor:", zoom, 1);
        this.gd.addCheckbox("Bold Text", this.boldText);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return false;
        }
        location = this.gd.getNextChoice();
        fillColor = this.gd.getNextChoice();
        textColor = this.gd.getNextChoice();
        numLabels = (int)this.gd.getNextNumber();
        decimalPlaces = (int)this.gd.getNextNumber();
        fontSize = (int)this.gd.getNextNumber();
        zoom = this.gd.getNextNumber();
        this.boldText = this.gd.getNextBoolean();
        return true;
    }

    public void verticalColorBar(ImageProcessor imageProcessor, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n7 = n3;
        int n8 = n4;
        int n9 = 0;
        ColorModel colorModel = this.lut.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            n9 = indexColorModel.getMapSize();
            byArray3 = new byte[n9];
            byArray2 = new byte[n9];
            byArray = new byte[n9];
            indexColorModel.getReds(byArray3);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray);
        } else {
            n9 = 256;
            byArray3 = new byte[n9];
            byArray2 = new byte[n9];
            byArray = new byte[n9];
            for (int i = 0; i < n9; ++i) {
                byArray3[i] = (byte)i;
                byArray2[i] = (byte)i;
                byArray[i] = (byte)i;
            }
        }
        double d = n9;
        int n10 = 0;
        ImageProcessor imageProcessor2 = this.impOriginal.getProcessor();
        if (imageProcessor2 instanceof ByteProcessor) {
            n6 = (int)imageProcessor2.getMin();
            if (n6 < 0) {
                n6 = 0;
            }
            if ((n5 = (int)imageProcessor2.getMax()) > 255) {
                n5 = 255;
            }
            d = n5 - n6 + 1;
            n10 = n6;
        }
        for (n6 = 0; n6 < (int)(128.0 * zoom); ++n6) {
            n5 = n10 + (int)Math.round((double)n6 * d / (128.0 * zoom));
            if (n5 >= n9) {
                n5 = n9 - 1;
            }
            imageProcessor.setColor(new Color(byArray3[n5] & 0xFF, byArray2[n5] & 0xFF, byArray[n5] & 0xFF));
            int n11 = (int)(128.0 * zoom) - n6 - 1;
            imageProcessor.drawLine(n, n11 + n2, n3 + n, n11 + n2);
        }
        Color color = this.getColor(this.barOutlineColor);
        if (color != null) {
            imageProcessor.setColor(color);
            imageProcessor.moveTo(n, n2);
            imageProcessor.lineTo(n + n7, n2);
            imageProcessor.lineTo(n + n7, n2 + n8);
            imageProcessor.lineTo(n, n2 + n8);
            imageProcessor.lineTo(n, n2);
        }
    }

    protected void drawColorBar(ImageProcessor imageProcessor, int n, int n2) {
        imageProcessor.setColor(Color.black);
        if (decimalPlaces == -1) {
            decimalPlaces = Analyzer.getPrecision();
        }
        int n3 = (int)(10.0 * zoom) + n;
        int n4 = (int)(10.0 * zoom) + n2;
        this.verticalColorBar(imageProcessor, n3, n4, (int)(12.0 * zoom), (int)(128.0 * zoom));
        this.drawText(imageProcessor, n3 + (int)(12.0 * zoom), n4, true);
        Color color = this.getColor(this.boxOutlineColor);
        if (color != null && !fillColor.equals("None")) {
            imageProcessor.setColor(color);
            imageProcessor.setLineWidth(1);
            imageProcessor.moveTo(n + 0, n2 + 0);
            imageProcessor.lineTo(n + this.win_width - 0, n2 + 0);
            imageProcessor.lineTo(n + this.win_width - 0, n2 + (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - 0);
            imageProcessor.lineTo(n + 0, n2 + (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - 0);
            imageProcessor.lineTo(n + 0, n2 + 0);
        }
    }

    int drawText(ImageProcessor imageProcessor, int n, int n2, boolean bl) {
        Color color = this.getColor(textColor);
        if (color == null) {
            return 0;
        }
        imageProcessor.setColor(color);
        double d = this.cal.getCValue(this.stats.histMin);
        double d2 = this.cal.getCValue(this.stats.histMax);
        double d3 = 128.0 * zoom;
        if (numLabels > 2) {
            d3 /= (double)(numLabels - 1);
        }
        int n3 = this.boldText ? 1 : 0;
        Font font = null;
        font = fontSize < 9 ? new Font("SansSerif", n3, 9) : new Font("SansSerif", n3, (int)((double)fontSize * zoom));
        imageProcessor.setFont(font);
        imageProcessor.setAntialiasedText(true);
        int n4 = 0;
        Image image = GUI.createBlankImage(128, 64);
        Graphics graphics = image.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.fontHeight = fontMetrics.getHeight();
        for (int i = 0; i < numLabels; ++i) {
            int n5;
            double d4 = (int)(10.0 * zoom + 128.0 * zoom - (double)i * d3 - 1.0);
            int n6 = (int)Math.round((double)n2 + 128.0 * zoom - (double)i * d3 - 1.0);
            Calibration calibration = this.impOriginal.getCalibration();
            ImageProcessor imageProcessor2 = this.impOriginal.getProcessor();
            double d5 = imageProcessor2.getMin();
            double d6 = imageProcessor2.getMax();
            if (imageProcessor2 instanceof ByteProcessor) {
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                if (d6 > 255.0) {
                    d6 = 255.0;
                }
            }
            double d7 = d5 + (d6 - d5) / (double)(numLabels - 1) * (double)i;
            if (calibration.calibrated()) {
                d7 = calibration.getCValue(d7);
                double d8 = calibration.getCValue(d5);
                double d9 = calibration.getCValue(d6);
                if (!(this.decimalPlacesChanged || decimalPlaces != 0 || (double)((int)d9) == d9 && (double)((int)d8) == d8)) {
                    decimalPlaces = 2;
                }
            }
            if (bl) {
                imageProcessor.drawString(this.d2s(d7), n + 5, n6 + this.fontHeight / 2);
            }
            if ((n5 = fontMetrics.stringWidth(this.d2s(d7))) <= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    String d2s(double d) {
        return IJ.d2s(d, decimalPlaces);
    }

    int getFontHeight() {
        Image image = GUI.createBlankImage(64, 64);
        Graphics graphics = image.getGraphics();
        int n = this.boldText ? 1 : 0;
        Font font = new Font("SansSerif", n, (int)((double)fontSize * zoom));
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return fontMetrics.getHeight();
    }

    Color getColor(String string) {
        Color color = Color.white;
        if (string.equals(colors[1])) {
            color = Color.lightGray;
        } else if (string.equals(colors[2])) {
            color = Color.darkGray;
        } else if (string.equals(colors[3])) {
            color = Color.black;
        } else if (string.equals(colors[4])) {
            color = Color.red;
        } else if (string.equals(colors[5])) {
            color = Color.green;
        } else if (string.equals(colors[6])) {
            color = Color.blue;
        } else if (string.equals(colors[7])) {
            color = Color.yellow;
        } else if (string.equals(colors[8])) {
            color = null;
        }
        return color;
    }

    void calculateWidth() {
        this.drawColorBar(this.imp, -1, -1);
    }

    public void drawColorBar(ImagePlus imagePlus, int n, int n2) {
        Roi roi = this.impOriginal.getRoi();
        if (roi != null) {
            this.impOriginal.killRoi();
        }
        this.stats = this.impOriginal.getStatistics(16, nBins);
        if (roi != null) {
            this.impOriginal.setRoi(roi);
        }
        this.histogram = this.stats.histogram;
        this.lut = this.impOriginal.createLut();
        this.cal = this.impOriginal.getCalibration();
        int n3 = this.drawText(this.ip, 0, 0, false);
        this.win_width = (int)(10.0 * zoom) + 5 + (int)(12.0 * zoom) + n3 + (int)(5.0 * zoom);
        if (n == -1 && n2 == -1) {
            return;
        }
        Color color = this.getColor(fillColor);
        if (color != null) {
            this.ip.setColor(color);
            this.ip.setRoi(n, n2, this.win_width, (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))));
            this.ip.fill();
        }
        this.ip.resetRoi();
        this.drawColorBar(this.ip, n, n2);
        imagePlus.updateAndDraw();
        this.ip.setColor(Color.black);
    }

    class LiveDialog
    extends GenericDialog {
        LiveDialog(String string) {
            super(string);
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (CalibrationBar.this.fieldNames == null) {
                CalibrationBar.this.fieldNames = new String[4];
                for (int i = 0; i < 4; ++i) {
                    CalibrationBar.this.fieldNames[i] = ((TextField)this.numberField.elementAt(i)).getName();
                }
            }
            TextField textField = (TextField)textEvent.getSource();
            String string = textField.getName();
            String string2 = textField.getText();
            if (string2.equals("")) {
                return;
            }
            int n = 0;
            boolean bl = false;
            if (string.equals(CalibrationBar.this.fieldNames[0])) {
                n = this.getValue(string2).intValue();
                if (n < 1) {
                    return;
                }
                bl = true;
                numLabels = n;
            } else if (string.equals(CalibrationBar.this.fieldNames[1])) {
                n = this.getValue(string2).intValue();
                if (n < 0) {
                    return;
                }
                bl = true;
                decimalPlaces = n;
                CalibrationBar.this.decimalPlacesChanged = true;
            } else if (string.equals(CalibrationBar.this.fieldNames[2])) {
                n = this.getValue(string2).intValue();
                if (n < 1) {
                    return;
                }
                bl = true;
                fontSize = n;
            } else if (string.equals(CalibrationBar.this.fieldNames[3])) {
                double d = 0.0;
                d = this.getValue("0" + string2);
                if (d <= 0.0) {
                    return;
                }
                bl = true;
                zoom = d;
            }
            if (bl) {
                CalibrationBar.this.updateColorBar();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            location = ((Choice)this.choice.elementAt(0)).getSelectedItem();
            fillColor = ((Choice)this.choice.elementAt(1)).getSelectedItem();
            textColor = ((Choice)this.choice.elementAt(2)).getSelectedItem();
            CalibrationBar.this.boldText = ((Checkbox)this.checkbox.elementAt(0)).getState();
            CalibrationBar.this.updateColorBar();
        }
    }
}

