/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.measure.CurveFitter;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class FractalBoxCounter
implements PlugInFilter {
    static String sizes = "2,3,4,6,8,12,16,32,64";
    static boolean blackBackground;
    int[] boxSizes;
    float[] boxCountSums;
    int maxBoxSize;
    int[] counts;
    Rectangle roi;
    int foreground;
    ImagePlus imp;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 129;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Fractal Box Counter", IJ.getInstance());
        genericDialog.addStringField("Box Sizes:", sizes, 20);
        genericDialog.addCheckbox("Black Background", blackBackground);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string = genericDialog.getNextString();
        blackBackground = genericDialog.getNextBoolean();
        if (string.equals("")) {
            return;
        }
        this.boxSizes = this.s2ints(string);
        if (this.boxSizes == null || this.boxSizes.length < 1) {
            return;
        }
        this.boxCountSums = new float[this.boxSizes.length];
        sizes = string;
        for (int i = 0; i < this.boxSizes.length; ++i) {
            this.maxBoxSize = Math.max(this.maxBoxSize, this.boxSizes[i]);
        }
        this.counts = new int[this.maxBoxSize * this.maxBoxSize + 1];
        this.imp.killRoi();
        if (!imageProcessor.isBinary()) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return;
        }
        this.foreground = blackBackground ? 255 : 0;
        if (imageProcessor.isInvertedLut()) {
            this.foreground = 255 - this.foreground;
        }
        this.doBoxCounts(imageProcessor);
        IJ.register(FractalBoxCounter.class);
    }

    public int[] s2ints(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                IJ.log("" + numberFormatException);
                return null;
            }
        }
        return nArray;
    }

    boolean FindMargins(ImageProcessor imageProcessor) {
        if (IJ.debugMode) {
            IJ.log("FindMargins");
        }
        int[] nArray = new int[256];
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        int n3 = -1;
        do {
            if (++n3 >= n) {
                IJ.error("No non-backround pixels found.");
                return false;
            }
            imageProcessor.setRoi(n3, 0, 1, n2);
        } while ((nArray = imageProcessor.getHistogram())[this.foreground] == 0);
        int n4 = -1;
        do {
            imageProcessor.setRoi(n3, ++n4, n - n3, 1);
        } while ((nArray = imageProcessor.getHistogram())[this.foreground] == 0);
        int n5 = n + 1;
        do {
            imageProcessor.setRoi(--n5 - 1, n4, 1, n2 - n4);
        } while ((nArray = imageProcessor.getHistogram())[this.foreground] == 0);
        int n6 = n2 + 1;
        do {
            imageProcessor.setRoi(n3, --n6 - 1, n5 - n3, 1);
        } while ((nArray = imageProcessor.getHistogram())[this.foreground] == 0);
        this.roi = new Rectangle(n3, n4, n5 - n3, n6 - n4);
        return true;
    }

    int count(int n, ImageProcessor imageProcessor) {
        int n2;
        int[] nArray = new int[256];
        int n3 = this.roi.x;
        int n4 = this.roi.y;
        int n5 = n <= this.roi.width ? n : this.roi.width;
        int n6 = n <= this.roi.height ? n : this.roi.height;
        int n7 = this.roi.x + this.roi.width;
        int n8 = this.roi.y + this.roi.height;
        int n9 = n * n;
        for (n2 = 1; n2 <= n9; ++n2) {
            this.counts[n2] = 0;
        }
        n2 = 0;
        do {
            imageProcessor.setRoi(n3, n4, n5, n6);
            nArray = imageProcessor.getHistogram();
            int n10 = nArray[this.foreground];
            this.counts[n10] = this.counts[n10] + 1;
            if ((n3 += n) + n < n7) continue;
            n5 = n7 - n3;
            if (n3 < n7) continue;
            n5 = n;
            n3 = this.roi.x;
            if ((n4 += n) + n >= n8) {
                n6 = n8 - n4;
            }
            int n11 = n2 = n4 >= n8 ? 1 : 0;
        } while (n2 == 0);
        int n12 = 0;
        for (int i = 1; i <= n9; ++i) {
            int n13 = this.counts[i];
            if (n13 == 0) continue;
            n12 += n13;
        }
        return n12;
    }

    double plot() {
        int n;
        int n2 = this.boxSizes.length;
        float[] fArray = new float[this.boxSizes.length];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = (float)Math.log(this.boxSizes[i]);
        }
        CurveFitter curveFitter = new CurveFitter(Tools.toDouble(fArray), Tools.toDouble(this.boxCountSums));
        curveFitter.doFit(0);
        double[] dArray = curveFitter.getParams();
        double d = -dArray[1];
        String string = "D=" + IJ.d2s(d, 4);
        float[] fArray2 = new float[100];
        float[] fArray3 = new float[100];
        double[] dArray2 = Tools.getMinMax(fArray);
        double d2 = dArray2[0];
        double d3 = dArray2[1];
        dArray2 = Tools.getMinMax(this.boxCountSums);
        double d4 = dArray2[0];
        double d5 = dArray2[1];
        double d6 = (d3 - d2) / 99.0;
        double d7 = d2;
        for (n = 0; n < 100; ++n) {
            fArray2[n] = (float)d7;
            d7 += d6;
        }
        for (n = 0; n < 100; ++n) {
            fArray3[n] = (float)curveFitter.f(dArray, fArray2[n]);
        }
        dArray2 = Tools.getMinMax(fArray3);
        d4 = Math.min(d4, dArray2[0]);
        d5 = Math.max(d5, dArray2[1]);
        Plot plot = new Plot("Plot", "log (box size)", "log (count)", fArray2, fArray3);
        plot.setLimits(d2, d3, d4, d5);
        plot.addPoints(fArray, this.boxCountSums, 0);
        plot.addLabel(0.8, 0.2, string);
        plot.show();
        return d;
    }

    void doBoxCounts(ImageProcessor imageProcessor) {
        if (!this.FindMargins(imageProcessor)) {
            return;
        }
        ResultsTable resultsTable = ResultsTable.getResultsTable();
        resultsTable.incrementCounter();
        resultsTable.setLabel(this.imp.getShortTitle(), resultsTable.getCounter() - 1);
        for (int i = 0; i < this.boxSizes.length; ++i) {
            int n = this.count(this.boxSizes[i], imageProcessor);
            resultsTable.addValue("C" + this.boxSizes[i], (double)n);
            this.boxCountSums[i] = (float)Math.log(n);
        }
        double d = this.plot();
        resultsTable.addValue("D", d);
        resultsTable.show("Results");
        this.imp.killRoi();
    }
}

