/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class GaussianBlur
implements ExtendedPlugInFilter,
DialogListener {
    private static double sigma = 2.0;
    private static boolean sigmaScaled = false;
    private int flags = 16777311;
    private ImagePlus imp;
    private boolean hasScale = false;
    private int nPasses = 1;
    private int nChannels = 1;
    private int pass;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (imagePlus != null && imagePlus.getRoi() != null) {
            Rectangle rectangle = imagePlus.getRoi().getBoundingRect();
            if (rectangle.y > 0 || rectangle.y + rectangle.height < imagePlus.getDimensions()[1]) {
                this.flags |= 0x4000;
            }
        }
        return this.flags;
    }

    @Override
    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        String string2 = Macro.getOptions();
        boolean bl = false;
        this.nChannels = imagePlus.getProcessor().getNChannels();
        if (string2 != null && string2.indexOf("radius=") >= 0) {
            bl = true;
            Macro.setOptions(string2.replaceAll("radius=", "sigma="));
        }
        GenericDialog genericDialog = new GenericDialog(string);
        sigma = Math.abs(sigma);
        genericDialog.addNumericField("Sigma (Radius)", sigma, 2);
        if (imagePlus.getCalibration() != null && !imagePlus.getCalibration().getUnits().equals("pixels")) {
            this.hasScale = true;
            genericDialog.addCheckbox("Scaled Units (" + imagePlus.getCalibration().getUnits() + ")", sigmaScaled);
        } else {
            sigmaScaled = false;
        }
        genericDialog.addPreviewCheckbox(plugInFilterRunner);
        genericDialog.addDialogListener(this);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return 4096;
        }
        if (bl) {
            sigma /= 2.5;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog(imagePlus, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        sigma = genericDialog.getNextNumber();
        if (sigma < 0.0 || genericDialog.invalidNumber()) {
            return false;
        }
        if (this.hasScale) {
            sigmaScaled = genericDialog.getNextBoolean();
        }
        return true;
    }

    @Override
    public void setNPasses(int n) {
        this.nPasses = 2 * this.nChannels * n;
        this.pass = 0;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        double d = sigmaScaled ? sigma / this.imp.getCalibration().pixelWidth : sigma;
        double d2 = sigmaScaled ? sigma / this.imp.getCalibration().pixelHeight : sigma;
        double d3 = imageProcessor instanceof ByteProcessor || imageProcessor instanceof ColorProcessor ? 0.002 : 2.0E-4;
        Rectangle rectangle = imageProcessor.getRoi();
        this.blurGaussian(imageProcessor, d, d2, d3);
    }

    public boolean blur(ImageProcessor imageProcessor, double d) {
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle.height != imageProcessor.getHeight() && imageProcessor.getMask() == null) {
            imageProcessor.snapshot();
        }
        this.blurGaussian(imageProcessor, 0.4 * d, 0.4 * d, 0.01);
        return true;
    }

    public void blurGaussian(ImageProcessor imageProcessor, double d, double d2, double d3) {
        if (this.nPasses <= 1) {
            this.nPasses = imageProcessor.getNChannels() * (d > 0.0 && d2 > 0.0 ? 2 : 1);
        }
        FloatProcessor floatProcessor = null;
        for (int i = 0; i < imageProcessor.getNChannels(); ++i) {
            floatProcessor = imageProcessor.toFloat(i, floatProcessor);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.blurFloat(floatProcessor, d, d2, d3);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            imageProcessor.setPixels(i, floatProcessor);
        }
        if (imageProcessor.getRoi().height != imageProcessor.getHeight() && d > 0.0 && d2 > 0.0) {
            GaussianBlur.resetOutOfRoi(imageProcessor, (int)Math.ceil(5.0 * d2));
        }
    }

    public void blurFloat(FloatProcessor floatProcessor, double d, double d2, double d3) {
        if (d > 0.0) {
            this.blur1Direction(floatProcessor, d, d3, true, (int)Math.ceil(5.0 * d2));
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (d2 > 0.0) {
            this.blur1Direction(floatProcessor, d2, d3, false, 0);
        }
    }

    public void blur1Direction(FloatProcessor floatProcessor, double d, double d2, boolean bl, int n) {
        Object object;
        int n2;
        final float[] fArray = (float[])floatProcessor.getPixels();
        int n3 = floatProcessor.getWidth();
        int n4 = floatProcessor.getHeight();
        Rectangle rectangle = floatProcessor.getRoi();
        final int n5 = bl ? n3 : n4;
        final int n6 = bl ? 1 : n3;
        final int n7 = bl ? n3 : 1;
        int n8 = (bl ? rectangle.y : rectangle.x) - n;
        final int n9 = n8 < 0 ? 0 : n8;
        int n10 = (bl ? rectangle.y + rectangle.height : rectangle.x + rectangle.width) + n;
        final int n11 = n10 > (bl ? n4 : n3) ? (bl ? n4 : n3) : n10;
        int n12 = bl ? rectangle.x : rectangle.y;
        int n13 = bl ? rectangle.x + rectangle.width : rectangle.y + rectangle.height;
        int n14 = Math.max((n11 - n9) / (100 / (this.nPasses > 0 ? this.nPasses : 1) + 1), 20);
        ++this.pass;
        if (this.pass > this.nPasses) {
            this.pass = 1;
        }
        final int n15 = Math.min(Prefs.getThreads(), n11 - n9);
        final Thread[] threadArray = new Thread[n15];
        final boolean bl2 = d > 8.5;
        final int n16 = bl2 ? Math.min((int)Math.floor(d / 4.0), n5) : 1;
        double d3 = bl2 ? Math.sqrt(d * d / (double)(n16 * n16) - 0.3333333333333333 - 0.25) : d;
        int n17 = bl2 ? (n5 + n16 - 1) / n16 + 6 : n5;
        float[][] fArray2 = this.makeGaussianKernel(d3, d2, n17);
        int n18 = fArray2[0].length * n16;
        int n19 = n12 - n18 < 0 ? 0 : n12 - n18;
        int n20 = n13 + n18 > n5 ? n5 : n13 + n18;
        final int n21 = bl2 ? (n20 - n19 + n16 - 1) / n16 + 6 : n5;
        final int n22 = n19 - 3 * n16;
        final float[] fArray3 = bl2 ? GaussianBlur.makeDownscaleKernel(n16) : null;
        float[] fArray4 = bl2 ? GaussianBlur.makeUpscaleKernel(n16) : null;
        for (int i = 0; i < n15; ++i) {
            n2 = i;
            final float[] fArray5 = new float[n21];
            object = bl2 ? new float[n21] : null;
            Thread thread = new Thread(new Runnable((float[])object, fArray2, fArray4, n12, n13, n19, n20){
                final /* synthetic */ float[] val$cache2;
                final /* synthetic */ float[][] val$gaussKernel;
                final /* synthetic */ float[] val$upscaleKernel;
                final /* synthetic */ int val$writeFrom;
                final /* synthetic */ int val$writeTo;
                final /* synthetic */ int val$readFrom;
                final /* synthetic */ int val$readTo;
                {
                    this.val$cache2 = fArray4;
                    this.val$gaussKernel = fArray52;
                    this.val$upscaleKernel = fArray6;
                    this.val$writeFrom = n112;
                    this.val$writeTo = n12;
                    this.val$readFrom = n13;
                    this.val$readTo = n14;
                }

                @Override
                public final void run() {
                    long l = System.currentTimeMillis();
                    boolean bl = Thread.currentThread() == threadArray[0];
                    int n = (n9 + n2) * n7;
                    int n23 = n9 + n2;
                    while (n23 < n11) {
                        long l2 = System.currentTimeMillis();
                        if (l2 - l > 110L) {
                            if (bl) {
                                GaussianBlur.this.showProgress((double)(n23 - n9) / (double)(n11 - n9));
                            }
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            l = l2;
                        }
                        if (bl2) {
                            GaussianBlur.downscaleLine(fArray, fArray5, fArray3, n16, n, n22, n5, n6, n21);
                            GaussianBlur.convolveLine(fArray5, this.val$cache2, this.val$gaussKernel, 0, n21, 1, n21 - 1, 0, 1);
                            GaussianBlur.upscaleLine(this.val$cache2, fArray, this.val$upscaleKernel, n16, n, n22, this.val$writeFrom, this.val$writeTo, n6);
                        } else {
                            int n3 = n + this.val$readFrom * n6;
                            int n4 = this.val$readFrom;
                            while (n4 < this.val$readTo) {
                                fArray5[n4] = fArray[n3];
                                ++n4;
                                n3 += n6;
                            }
                            GaussianBlur.convolveLine(fArray5, fArray, this.val$gaussKernel, this.val$readFrom, this.val$readTo, this.val$writeFrom, this.val$writeTo, n, n6);
                        }
                        n23 += n15;
                        n += n15 * n7;
                    }
                }
            }, "GaussianBlur-" + i);
            thread.setPriority(Thread.currentThread().getPriority());
            threadArray[n2] = thread;
            thread.start();
        }
        try {
            Thread[] threadArray2 = threadArray;
            n2 = threadArray2.length;
            for (int i = 0; i < n2; ++i) {
                object = threadArray2[i];
                if (object == null) continue;
                ((Thread)object).join();
            }
        }
        catch (InterruptedException interruptedException) {
            for (Thread thread : threadArray) {
                thread.interrupt();
            }
            try {
                for (Thread thread : threadArray) {
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException2) {
                // empty catch block
            }
            Thread.currentThread().interrupt();
        }
        this.showProgress(1.0);
    }

    private static final void downscaleLine(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 + n5 * (n3 - n * 3 / 2);
        int n8 = n2 + n5 * (n4 - 1);
        for (int i = -1; i <= n6; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n9 = 0;
            while (n9 < n) {
                float f4 = fArray[n7 < n2 ? n2 : (n7 > n8 ? n8 : n7)];
                f += f4 * fArray3[n9 + 2 * n];
                f2 += f4 * fArray3[n9 + n];
                f3 += f4 * fArray3[n9];
                ++n9;
                n7 += n5;
            }
            if (i > 0) {
                int n10 = i - 1;
                fArray2[n10] = fArray2[n10] + f;
            }
            if (i >= 0 && i < n6) {
                int n11 = i;
                fArray2[n11] = fArray2[n11] + f2;
            }
            if (i + 1 >= n6) continue;
            fArray2[i + 1] = f3;
        }
    }

    private static final float[] makeDownscaleKernel(int n) {
        float f;
        double d;
        int n2;
        int n3 = n * 3 / 2;
        float[] fArray = new float[3 * n];
        for (n2 = 0; n2 <= n / 2; ++n2) {
            d = (double)n2 / (double)n;
            fArray[n3 - n2] = f = (float)((0.75 - d * d) / (double)n);
            fArray[n3 + n2] = f;
        }
        for (n2 = n / 2 + 1; n2 < (n * 3 + 1) / 2; ++n2) {
            d = (double)n2 / (double)n;
            fArray[n3 - n2] = f = (float)((0.125 + 0.5 * (d - 1.0) * (d - 2.0)) / (double)n);
            fArray[n3 + n2] = f;
        }
        return fArray;
    }

    private static final void upscaleLine(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 + n6 * n4;
        int n8 = n4;
        while (n8 < n5) {
            int n9 = (n8 - n3 + n - 1) / n;
            int n10 = n - 1 - (n8 - n3 + n - 1) % n;
            fArray2[n7] = fArray[n9 - 2] * fArray3[n10] + fArray[n9 - 1] * fArray3[n10 + n] + fArray[n9] * fArray3[n10 + 2 * n] + fArray[n9 + 1] * fArray3[n10 + 3 * n];
            ++n8;
            n7 += n6;
        }
    }

    private static final float[] makeUpscaleKernel(int n) {
        float f;
        double d;
        int n2;
        float[] fArray = new float[4 * n];
        int n3 = 2 * n;
        fArray[0] = 0.0f;
        for (n2 = 0; n2 < n; ++n2) {
            d = (double)n2 / (double)n;
            fArray[n3 + n2] = f = (float)(0.6666666666666666 - d * d * (1.0 - 0.5 * d));
            fArray[n3 - n2] = f;
        }
        for (n2 = n; n2 < 2 * n; ++n2) {
            d = (double)n2 / (double)n;
            fArray[n3 + n2] = f = (float)((2.0 - d) * (2.0 - d) * (2.0 - d) / 6.0);
            fArray[n3 - n2] = f;
        }
        return fArray;
    }

    private static final void convolveLine(float[] fArray, float[] fArray2, float[][] fArray3, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = fArray.length;
        float f = fArray[0];
        float f2 = fArray[n8 - 1];
        float[] fArray4 = fArray3[0];
        float f3 = fArray4[0];
        float[] fArray5 = fArray3[1];
        int n9 = fArray4.length;
        int n10 = n9 < n8 ? n9 : n8;
        int n11 = n5 + n3 * n6;
        int n12 = n3;
        while (n12 < n10) {
            float f4 = fArray[n12] * f3;
            f4 += fArray5[n12] * f;
            if (n12 + n9 > n8) {
                f4 += fArray5[n8 - n12 - 1] * f2;
            }
            for (int i = 1; i < n9; ++i) {
                float f5 = 0.0f;
                if (n12 - i >= 0) {
                    f5 += fArray[n12 - i];
                }
                if (n12 + i < n8) {
                    f5 += fArray[n12 + i];
                }
                f4 += fArray4[i] * f5;
            }
            fArray2[n11] = f4;
            ++n12;
            n11 += n6;
        }
        int n13 = n7 = n8 - n9 < n4 ? n8 - n9 : n4;
        while (n12 < n7) {
            float f6 = fArray[n12] * f3;
            for (int i = 1; i < n9; ++i) {
                f6 += fArray4[i] * (fArray[n12 - i] + fArray[n12 + i]);
            }
            fArray2[n11] = f6;
            ++n12;
            n11 += n6;
        }
        while (n12 < n4) {
            float f7 = fArray[n12] * f3;
            if (n12 < n9) {
                f7 += fArray5[n12] * f;
            }
            if (n12 + n9 >= n8) {
                f7 += fArray5[n8 - n12 - 1] * f2;
            }
            for (int i = 1; i < n9; ++i) {
                float f8 = 0.0f;
                if (n12 - i >= 0) {
                    f8 += fArray[n12 - i];
                }
                if (n12 + i < n8) {
                    f8 += fArray[n12 + i];
                }
                f7 += fArray4[i] * f8;
            }
            fArray2[n11] = f7;
            ++n12;
            n11 += n6;
        }
    }

    public float[][] makeGaussianKernel(double d, double d2, int n) {
        double d3;
        int n2;
        int n3 = (int)Math.ceil(d * Math.sqrt(-2.0 * Math.log(d2))) + 1;
        if (n < 50) {
            n = 50;
        }
        if (n3 > n) {
            n3 = n;
        }
        float[][] fArray = new float[2][n3];
        for (int i = 0; i < n3; ++i) {
            fArray[0][i] = (float)Math.exp(-0.5 * (double)i * (double)i / d / d);
        }
        if (n3 < n && n3 > 3) {
            double d4;
            double d5 = Double.MAX_VALUE;
            n2 = n3;
            while (n2 > n3 / 2 && (d4 = Math.sqrt(fArray[0][--n2]) / (double)(n3 - n2)) < d5) {
                d5 = d4;
            }
            for (int i = n2 + 2; i < n3; ++i) {
                fArray[0][i] = (float)((double)((n3 - i) * (n3 - i)) * d5 * d5);
            }
        }
        if (n3 < n) {
            d3 = fArray[0][0];
            for (n2 = 1; n2 < n3; ++n2) {
                d3 += (double)(2.0f * fArray[0][n2]);
            }
        } else {
            d3 = d * Math.sqrt(Math.PI * 2);
        }
        double d6 = 0.5 + 0.5 * (double)fArray[0][0] / d3;
        for (int i = 0; i < n3; ++i) {
            double d7 = (double)fArray[0][i] / d3;
            fArray[0][i] = (float)d7;
            fArray[1][i] = (float)(d6 -= d7);
        }
        return fArray;
    }

    public static void resetOutOfRoi(ImageProcessor imageProcessor, int n) {
        Rectangle rectangle = imageProcessor.getRoi();
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        Object object = imageProcessor.getPixels();
        Object object2 = imageProcessor.getSnapshotPixels();
        int n4 = rectangle.y - n;
        if (n4 < 0) {
            n4 = 0;
        }
        int n5 = n4;
        int n6 = n2 * n5 + rectangle.x;
        while (n5 < rectangle.y) {
            System.arraycopy(object2, n6, object, n6, rectangle.width);
            ++n5;
            n6 += n2;
        }
        n5 = rectangle.y + rectangle.height + n;
        if (n5 > n3) {
            n5 = n3;
        }
        n6 = rectangle.y + rectangle.height;
        int n7 = n2 * n6 + rectangle.x;
        while (n6 < n5) {
            System.arraycopy(object2, n7, object, n7, rectangle.width);
            ++n6;
            n7 += n2;
        }
    }

    void showProgress(double d) {
        d = (double)(this.pass - 1) / (double)this.nPasses + d / (double)this.nPasses;
        IJ.showProgress(d);
    }
}

