/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.ImageCanvas;
import ij.plugin.filter.LutWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.IndexColorModel;

public class LutViewer
implements PlugInFilter {
    ImagePlus imp;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 399;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        int n;
        int n2;
        int n3;
        int n4 = 35;
        int n5 = 20;
        int n6 = 256;
        int n7 = 128;
        int n8 = 12;
        imageProcessor = this.imp.getChannelProcessor();
        IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        LookUpTable lookUpTable = new LookUpTable(indexColorModel);
        int n9 = lookUpTable.getMapSize();
        byte[] byArray = lookUpTable.getReds();
        byte[] byArray2 = lookUpTable.getGreens();
        byte[] byArray3 = lookUpTable.getBlues();
        boolean bl = lookUpTable.isGrayscale();
        int n10 = n6 + 2 * n4;
        int n11 = n7 + 3 * n5;
        Image image = IJ.getInstance().createImage(n10, n11);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n10, n11);
        graphics.setColor(Color.black);
        graphics.drawRect(n4, n5, n6, n7);
        double d = 256.0 / (double)n9;
        if (bl) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.red);
        }
        int n12 = n4;
        int n13 = n5 + n7 - (byArray[0] & 0xFF) / 2;
        for (n3 = 1; n3 < 256; ++n3) {
            n2 = n4 + n3;
            n = n5 + n7 - (byArray[(int)((double)n3 / d)] & 0xFF) / 2;
            graphics.drawLine(n12, n13, n2, n);
            n12 = n2;
            n13 = n;
        }
        if (!bl) {
            graphics.setColor(Color.green);
            n12 = n4;
            n13 = n5 + n7 - (byArray2[0] & 0xFF) / 2;
            for (n3 = 1; n3 < 256; ++n3) {
                n2 = n4 + n3;
                n = n5 + n7 - (byArray2[(int)((double)n3 / d)] & 0xFF) / 2;
                graphics.drawLine(n12, n13, n2, n);
                n12 = n2;
                n13 = n;
            }
        }
        if (!bl) {
            graphics.setColor(Color.blue);
            n12 = n4;
            n13 = n5 + n7 - (byArray3[0] & 0xFF) / 2;
            for (n3 = 1; n3 < 255; ++n3) {
                n2 = n4 + n3;
                n = n5 + n7 - (byArray3[(int)((double)n3 / d)] & 0xFF) / 2;
                graphics.drawLine(n12, n13, n2, n);
                n12 = n2;
                n13 = n;
            }
        }
        int n14 = n4;
        int n15 = n5 + n7 + 2;
        lookUpTable.drawColorBar(graphics, n14, n15, 256, n8);
        graphics.setColor(Color.black);
        graphics.drawString("0", n14 - 4, n15 += n8 + 15);
        graphics.drawString("" + (n9 - 1), n14 + n6 - 10, n15);
        graphics.drawString("255", 7, n5 + 4);
        graphics.dispose();
        ImagePlus imagePlus = new ImagePlus("Look-Up Table", image);
        new LutWindow(imagePlus, new ImageCanvas(imagePlus), imageProcessor);
    }
}

