/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class ThresholdToSelection
implements PlugInFilter {
    ImagePlus image;
    ImageProcessor ip;
    float min;
    float max;
    int w;
    int h;

    @Override
    public void run(ImageProcessor imageProcessor) {
        this.image.setRoi(this.convert(imageProcessor));
    }

    public static Roi run(ImagePlus imagePlus) {
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.image = imagePlus;
        return thresholdToSelection.convert(imagePlus.getProcessor());
    }

    public Roi convert(ImageProcessor imageProcessor) {
        this.ip = imageProcessor;
        this.min = (float)imageProcessor.getMinThreshold();
        this.max = (float)imageProcessor.getMaxThreshold();
        this.w = imageProcessor.getWidth();
        this.h = imageProcessor.getHeight();
        return this.getRoi();
    }

    final boolean selected(int n, int n2) {
        float f = this.ip.getf(n, n2);
        return f >= this.min && f <= this.max;
    }

    Roi getRoi() {
        IJ.showStatus("Converting threshold to selection");
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        int n = Math.max(this.h / 50, 1);
        boolean[] blArray = new boolean[this.w + 2];
        boolean[] blArray2 = new boolean[this.w + 2];
        Outline[] outlineArray = new Outline[this.w + 1];
        for (int i = 0; i <= this.h; ++i) {
            boolean[] blArray3 = blArray;
            blArray = blArray2;
            blArray2 = blArray3;
            for (int j = 0; j <= this.w; ++j) {
                int n2;
                blArray2[j + 1] = i < this.h && j < this.w ? this.selected(j, i) : false;
                if (blArray2[j + 1]) {
                    if (!blArray[j + 1]) {
                        if (outlineArray[j] == null) {
                            if (outlineArray[j + 1] == null) {
                                outlineArray[j + 1] = outlineArray[j] = new Outline();
                                outlineArray[j].push(j + 1, i);
                                outlineArray[j].push(j, i);
                            } else {
                                outlineArray[j] = outlineArray[j + 1];
                                outlineArray[j + 1] = null;
                                outlineArray[j].push(j, i);
                            }
                        } else if (outlineArray[j + 1] == null) {
                            outlineArray[j + 1] = outlineArray[j];
                            outlineArray[j] = null;
                            outlineArray[j + 1].shift(j + 1, i);
                        } else if (outlineArray[j + 1] == outlineArray[j]) {
                            arrayList.add(outlineArray[j].getPolygon());
                            outlineArray[j + 1] = null;
                            outlineArray[j] = null;
                        } else {
                            outlineArray[j].shift(outlineArray[j + 1]);
                            for (n2 = 0; n2 <= this.w; ++n2) {
                                if (n2 == j + 1 || outlineArray[n2] != outlineArray[j + 1]) continue;
                                outlineArray[n2] = outlineArray[j];
                                outlineArray[j + 1] = null;
                                outlineArray[j] = null;
                                break;
                            }
                            if (outlineArray[j] != null) {
                                throw new RuntimeException("assertion failed");
                            }
                        }
                    }
                    if (blArray2[j]) continue;
                    if (outlineArray[j] == null) {
                        throw new RuntimeException("assertion failed!");
                    }
                    outlineArray[j].push(j, i + 1);
                    continue;
                }
                if (blArray[j + 1]) {
                    if (outlineArray[j] == null) {
                        if (outlineArray[j + 1] == null) {
                            Outline outline = new Outline();
                            outlineArray[j + 1] = outline;
                            outlineArray[j] = outline;
                            outlineArray[j].push(j, i);
                            outlineArray[j].push(j + 1, i);
                        } else {
                            outlineArray[j] = outlineArray[j + 1];
                            outlineArray[j + 1] = null;
                            outlineArray[j].shift(j, i);
                        }
                    } else if (outlineArray[j + 1] == null) {
                        outlineArray[j + 1] = outlineArray[j];
                        outlineArray[j] = null;
                        outlineArray[j + 1].push(j + 1, i);
                    } else if (outlineArray[j + 1] == outlineArray[j]) {
                        arrayList.add(outlineArray[j].getPolygon());
                        outlineArray[j + 1] = null;
                        outlineArray[j] = null;
                    } else {
                        outlineArray[j].push(outlineArray[j + 1]);
                        for (n2 = 0; n2 <= this.w; ++n2) {
                            if (n2 == j + 1 || outlineArray[n2] != outlineArray[j + 1]) continue;
                            outlineArray[n2] = outlineArray[j];
                            outlineArray[j + 1] = null;
                            outlineArray[j] = null;
                            break;
                        }
                        if (outlineArray[j] != null) {
                            throw new RuntimeException("assertion failed");
                        }
                    }
                }
                if (!blArray2[j]) continue;
                if (outlineArray[j] == null) {
                    throw new RuntimeException("assertion failed");
                }
                outlineArray[j].shift(j, i + 1);
            }
            if ((i & n) != 0) continue;
            IJ.showProgress(i + 1, this.h + 1);
        }
        GeneralPath generalPath = new GeneralPath(0);
        for (int i = 0; i < arrayList.size(); ++i) {
            generalPath.append((Polygon)arrayList.get(i), false);
        }
        ShapeRoi shapeRoi = new ShapeRoi(generalPath);
        Roi roi = shapeRoi != null ? shapeRoi.shapeToRoi() : null;
        IJ.showProgress(1, 1);
        if (roi != null) {
            return roi;
        }
        return shapeRoi;
    }

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 141;
    }

    static class Outline {
        int[] x = new int[this.reserved];
        int[] y = new int[this.reserved];
        int first = 5;
        int last = 5;
        int reserved = 10;
        final int GROW = 10;

        private void needs(int n, int n2) {
            if (n > this.reserved || n2 > this.first) {
                if (n < this.reserved + 10 + 1) {
                    n = this.reserved + 10 + 1;
                }
                int[] nArray = new int[n];
                int[] nArray2 = new int[n];
                System.arraycopy(this.x, 0, nArray, n2, this.last);
                System.arraycopy(this.y, 0, nArray2, n2, this.last);
                this.x = nArray;
                this.y = nArray2;
                this.first += n2;
                this.last += n2;
                this.reserved = n;
            }
        }

        public void push(int n, int n2) {
            this.needs(this.last + 1, 0);
            this.x[this.last] = n;
            this.y[this.last] = n2;
            ++this.last;
        }

        public void shift(int n, int n2) {
            this.needs(this.last + 1, 10);
            --this.first;
            this.x[this.first] = n;
            this.y[this.first] = n2;
        }

        public void push(Outline outline) {
            int n = outline.last - outline.first;
            this.needs(this.last + n, 0);
            System.arraycopy(outline.x, outline.first, this.x, this.last, n);
            System.arraycopy(outline.y, outline.first, this.y, this.last, n);
            this.last += n;
        }

        public void shift(Outline outline) {
            int n = outline.last - outline.first;
            this.needs(this.last + n + 10, n + 10);
            this.first -= n;
            System.arraycopy(outline.x, outline.first, this.x, this.first, n);
            System.arraycopy(outline.y, outline.first, this.y, this.first, n);
        }

        public Polygon getPolygon() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this.first + 1;
            int n6 = this.first + 1;
            while (n6 + 1 < this.last) {
                n4 = this.x[n5] - this.x[n5 - 1];
                n3 = this.y[n5 + 1] - this.y[n5];
                n2 = this.x[n5 + 1] - this.x[n5];
                n = this.y[n5] - this.y[n5 - 1];
                if (n4 * n3 == n2 * n) {
                    --this.last;
                } else {
                    if (n6 != n5) {
                        this.x[n6] = this.x[n5];
                        this.y[n6] = this.y[n5];
                    }
                    ++n6;
                }
                ++n5;
            }
            n4 = this.x[n5] - this.x[n5 - 1];
            n3 = this.y[this.first] - this.y[n5];
            n2 = this.x[this.first] - this.x[n5];
            n = this.y[n5] - this.y[n5 - 1];
            if (n4 * n3 == n2 * n) {
                --this.last;
            } else {
                this.x[n6] = this.x[n5];
                this.y[n6] = this.y[n5];
            }
            int n7 = this.last - this.first;
            int[] nArray = new int[n7];
            int[] nArray2 = new int[n7];
            System.arraycopy(this.x, this.first, nArray, 0, n7);
            System.arraycopy(this.y, this.first, nArray2, 0, n7);
            return new Polygon(nArray, nArray2, n7);
        }

        public String toString() {
            String string = "(first:" + this.first + ",last:" + this.last + ",reserved:" + this.reserved + ":";
            if (this.last > this.x.length) {
                System.err.println("ERROR!");
            }
            for (int i = this.first; i < this.last && i < this.x.length; ++i) {
                string = string + "(" + this.x[i] + "," + this.y[i] + ")";
            }
            return string + ")";
        }
    }
}

