/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.io.OpenDialog;
import ij.measure.CurveFitter;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class Fitter
extends PlugInFrame
implements PlugIn,
ItemListener,
ActionListener {
    Choice fit;
    Button doIt;
    Button open;
    Button apply;
    Checkbox settings;
    String fitTypeStr = CurveFitter.fitList[0];
    TextArea textArea;
    double[] dx = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    double[] dy = new double[]{0.0, 0.9, 4.5, 8.0, 18.0, 24.0};
    double[] x;
    double[] y;
    static CurveFitter cf;
    static int fitType;
    static String equation;
    static final int USER_DEFINED = 100;

    public Fitter() {
        super("Curve Fitter");
        WindowManager.addWindow(this);
        Panel panel = new Panel();
        this.fit = new Choice();
        for (int i = 0; i < CurveFitter.fitList.length; ++i) {
            this.fit.addItem(CurveFitter.fitList[i]);
        }
        this.fit.addItem("*User-defined*");
        this.fit.addItemListener(this);
        panel.add(this.fit);
        this.doIt = new Button(" Fit ");
        this.doIt.addActionListener(this);
        panel.add(this.doIt);
        this.open = new Button("Open");
        this.open.addActionListener(this);
        panel.add(this.open);
        this.apply = new Button("Apply");
        this.apply.addActionListener(this);
        panel.add(this.apply);
        this.settings = new Checkbox("Show settings", false);
        panel.add(this.settings);
        this.add("North", panel);
        String string = "";
        for (int i = 0; i < this.dx.length; ++i) {
            string = string + IJ.d2s(this.dx[i], 2) + "  " + IJ.d2s(this.dy[i], 2) + "\n";
        }
        this.textArea = new TextArea("", 15, 30, 1);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        if (IJ.isLinux()) {
            this.textArea.setBackground(Color.white);
        }
        this.textArea.append(string);
        this.add("Center", this.textArea);
        this.pack();
        GUI.center(this);
        this.show();
        IJ.register(Fitter.class);
    }

    public void doFit(int n) {
        if (n >= CurveFitter.fitList.length) {
            n = 100;
        }
        fitType = n;
        if (!this.getData()) {
            return;
        }
        cf = new CurveFitter(this.x, this.y);
        if (n == 100) {
            String string = this.getEquation();
            if (string == null) {
                return;
            }
            int n2 = cf.doCustomFit(string, null, this.settings.getState());
            if (n2 == 0) {
                return;
            }
        } else {
            cf.doFit(n, this.settings.getState());
        }
        IJ.log(cf.getResultString());
        Fitter.plot(cf);
    }

    String getEquation() {
        GenericDialog genericDialog = new GenericDialog("Formula");
        genericDialog.addStringField("Formula:", equation, 38);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        equation = genericDialog.getNextString();
        return equation;
    }

    public static void plot(CurveFitter curveFitter) {
        double[] dArray = curveFitter.getXPoints();
        double[] dArray2 = curveFitter.getYPoints();
        double[] dArray3 = Tools.getMinMax(dArray);
        double d = dArray3[0];
        double d2 = dArray3[1];
        dArray3 = Tools.getMinMax(dArray2);
        double d3 = dArray3[0];
        double d4 = dArray3[1];
        float[] fArray = new float[100];
        float[] fArray2 = new float[100];
        double d5 = (d2 - d) / 99.0;
        double d6 = d;
        for (int i = 0; i < 100; ++i) {
            fArray[i] = (float)d6;
            d6 += d5;
        }
        double[] dArray4 = curveFitter.getParams();
        for (int i = 0; i < 100; ++i) {
            fArray2[i] = (float)curveFitter.f(dArray4, fArray[i]);
        }
        dArray3 = Tools.getMinMax(fArray2);
        d3 = Math.min(d3, dArray3[0]);
        d4 = Math.max(d4, dArray3[1]);
        Plot plot = new Plot(curveFitter.getFormula(), "X", "Y", fArray, fArray2);
        plot.setLimits(d, d2, d3, d4);
        plot.addPoints(dArray, dArray2, 0);
        double d7 = 0.1;
        double d8 = 0.085;
        plot.addLabel(0.02, d7, curveFitter.getName());
        plot.addLabel(0.02, d7 += d8, curveFitter.getFormula());
        d7 += d8;
        double[] dArray5 = curveFitter.getParams();
        int n = curveFitter.getNumParams();
        char c = 'a';
        for (int i = 0; i < n; ++i) {
            plot.addLabel(0.02, d7, c + "=" + IJ.d2s(dArray5[i], 4));
            d7 += d8;
            c = (char)(c + '\u0001');
        }
        plot.addLabel(0.02, d7, "R^2=" + IJ.d2s(curveFitter.getRSquared(), 3));
        d7 += d8;
        plot.show();
    }

    double sqr(double d) {
        return d * d;
    }

    boolean getData() {
        this.textArea.selectAll();
        String string = this.textArea.getText();
        string = this.zapGremlins(string);
        this.textArea.select(0, 0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        int n = stringTokenizer.countTokens();
        if (n < 4 || n % 2 != 0) {
            return false;
        }
        int n2 = n / 2;
        this.x = new double[n2];
        this.y = new double[n2];
        for (int i = 0; i < n2; ++i) {
            this.x[i] = this.getNum(stringTokenizer);
            this.y[i] = this.getNum(stringTokenizer);
        }
        return true;
    }

    void applyFunction() {
        if (cf == null) {
            IJ.error("No function available");
            return;
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (imagePlus.getTitle().startsWith("y=")) {
            IJ.error("First select the image to be transformed");
            return;
        }
        double[] dArray = cf.getParams();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = n * n2;
        float[] fArray = new float[n3];
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                float f = imageProcessor.getPixelValue(j, i);
                fArray[i * n + j] = (float)cf.f(dArray, f);
            }
        }
        FloatProcessor floatProcessor = new FloatProcessor(n, n2, fArray, imageProcessor.getColorModel());
        new ImagePlus(imagePlus.getTitle() + "-transformed", floatProcessor).show();
    }

    double getNum(StringTokenizer stringTokenizer) {
        Double d;
        String string = stringTokenizer.nextToken();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void open() {
        OpenDialog openDialog = new OpenDialog("Open Text File...", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        String string3 = string + string2;
        this.textArea.selectAll();
        this.textArea.setText("");
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string + string2));
            while ((string4 = bufferedReader.readLine()) != null && string4.length() <= 100) {
                this.textArea.append(string4 + "\n");
            }
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.fitTypeStr = this.fit.getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doIt) {
            this.doFit(this.fit.getSelectedIndex());
        } else if (actionEvent.getSource() == this.apply) {
            this.applyFunction();
        } else {
            this.open();
        }
    }

    String zapGremlins(String string) {
        char[] cArray = new char[string.length()];
        cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\n' || c == '\t' || c >= ' ' && c <= '\u007f') continue;
            ++n;
            cArray[i] = 32;
        }
        if (n > 0) {
            return new String(cArray);
        }
        return string;
    }

    static {
        equation = "y = a + b*x + c*x*x";
    }
}

