/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;

public class LineWidthAdjuster
extends PlugInFrame
implements PlugIn,
Runnable,
AdjustmentListener,
TextListener,
ItemListener {
    public static final String LOC_KEY = "line.loc";
    int sliderRange = 300;
    Scrollbar slider;
    int value;
    boolean setText;
    static LineWidthAdjuster instance;
    Thread thread;
    boolean done;
    TextField tf;
    Checkbox checkbox;

    public LineWidthAdjuster() {
        super("Line Width");
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.slider = new Scrollbar(0, Line.getWidth(), 1, 1, this.sliderRange + 1);
        this.slider.setFocusable(false);
        Panel panel = new Panel();
        int n = IJ.isMacOSX() ? 5 : 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = new Insets(n, 15, n, 5);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.slider, gridBagConstraints);
        panel.add(this.slider);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(n, 5, n, 15);
        this.tf = new TextField("" + Line.getWidth(), 4);
        this.tf.addTextListener(this);
        gridBagLayout.setConstraints(this.tf, gridBagConstraints);
        panel.add(this.tf);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(n, 25, n, 5);
        this.checkbox = new Checkbox("Spline Fit", this.isSplineFit());
        this.checkbox.addItemListener(this);
        panel.add(this.checkbox);
        this.add((Component)panel, "Center");
        this.slider.addAdjustmentListener(this);
        this.slider.setUnitIncrement(1);
        this.pack();
        Point point = Prefs.getLocation(LOC_KEY);
        if (point != null) {
            this.setLocation(point);
        } else {
            GUI.center(this);
        }
        this.setResizable(false);
        this.show();
        this.thread = new Thread((Runnable)this, "LineWidthAdjuster");
        this.thread.start();
        this.setup();
        this.addKeyListener(IJ.getInstance());
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.value = this.slider.getValue();
        this.setText = true;
        this.notify();
    }

    @Override
    public synchronized void textValueChanged(TextEvent textEvent) {
        int n = (int)Tools.parseDouble(this.tf.getText(), -1.0);
        if (n == -1) {
            return;
        }
        if (n < 0) {
            n = 1;
        }
        if (n != Line.getWidth()) {
            this.slider.setValue(n);
            this.value = n;
            this.notify();
        }
    }

    void setup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            LineWidthAdjuster lineWidthAdjuster = this;
            synchronized (lineWidthAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.done) {
                    return;
                }
                Line.setWidth(this.value);
                if (this.setText) {
                    this.tf.setText("" + this.value);
                }
                this.setText = false;
                LineWidthAdjuster.updateRoi();
            }
        }
    }

    private static void updateRoi() {
        Roi roi;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && (roi = imagePlus.getRoi()) != null && roi.isLine()) {
            roi.updateWideLine(Line.getWidth());
            imagePlus.draw();
            return;
        }
        if (Roi.previousRoi == null) {
            return;
        }
        int n = Roi.previousRoi.getImageID();
        if (n >= 0) {
            return;
        }
        imagePlus = WindowManager.getImage(n);
        if (imagePlus == null) {
            return;
        }
        Roi roi2 = imagePlus.getRoi();
        if (roi2 != null && roi2.isLine()) {
            roi2.updateWideLine(Line.getWidth());
            imagePlus.draw();
        }
    }

    boolean isSplineFit() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return false;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            return false;
        }
        if (!(roi instanceof PolygonRoi)) {
            return false;
        }
        return ((PolygonRoi)roi).isSplineFit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        LineWidthAdjuster lineWidthAdjuster = this;
        synchronized (lineWidthAdjuster) {
            this.notify();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        super.windowActivated(windowEvent);
        this.checkbox.setState(this.isSplineFit());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            this.checkbox.setState(false);
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null || !(roi instanceof PolygonRoi)) {
            this.checkbox.setState(false);
            return;
        }
        int n = roi.getType();
        if (n == 3 || n == 7) {
            this.checkbox.setState(false);
            return;
        }
        PolygonRoi polygonRoi = (PolygonRoi)roi;
        boolean bl2 = polygonRoi.isSplineFit();
        if (bl && !bl2) {
            polygonRoi.fitSpline();
            imagePlus.draw();
        } else if (!bl && bl2) {
            polygonRoi.removeSplineFit();
            imagePlus.draw();
        }
    }

    public static void update() {
        if (instance == null) {
            return;
        }
        LineWidthAdjuster.instance.checkbox.setState(instance.isSplineFit());
        int n = LineWidthAdjuster.instance.slider.getValue();
        int n2 = Line.getWidth();
        if (n2 != n && n2 <= 200) {
            LineWidthAdjuster.instance.slider.setValue(n2);
            LineWidthAdjuster.instance.tf.setText("" + n2);
        }
    }
}

