/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.plugin.frame.PlugInFrame;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;

public class MemoryMonitor
extends PlugInFrame {
    private static final int WIDTH = 250;
    private static final int HEIGHT = 90;
    private static final String LOC_KEY = "memory.loc";
    private static MemoryMonitor instance;
    private Image image;
    private Graphics2D g;
    private int frames;
    private double[] mem;
    private int index;
    private long value;
    private double defaultMax;
    private double max;
    private long maxMemory;

    public MemoryMonitor() {
        super("Memory");
        this.max = this.defaultMax = 1.849344E7;
        this.maxMemory = IJ.maxMemory();
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        instance = this;
        WindowManager.addWindow(this);
        this.setLayout(new BorderLayout());
        Canvas canvas = new Canvas();
        canvas.setSize(250, 90);
        this.add(canvas);
        this.setResizable(false);
        this.pack();
        Point point = Prefs.getLocation(LOC_KEY);
        if (point != null) {
            this.setLocation(point);
        } else {
            GUI.center(this);
        }
        this.image = this.createImage(250, 90);
        this.g = (Graphics2D)this.image.getGraphics();
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, 250, 90);
        this.g.setFont(new Font("SansSerif", 0, 12));
        Graphics graphics = canvas.getGraphics();
        graphics.drawImage(this.image, 0, 0, null);
        this.show();
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null) {
            this.addKeyListener(imageJ);
            canvas.addKeyListener(imageJ);
            canvas.addMouseListener(imageJ);
        }
        this.mem = new double[251];
        Thread.currentThread().setPriority(1);
        while (true) {
            this.updatePlot();
            this.addText();
            graphics.drawImage(this.image, 0, 0, null);
            IJ.wait(50);
            ++this.frames;
        }
    }

    void addText() {
        double d = (double)this.value / 1048576.0;
        String string = IJ.d2s(d, d > 50.0 ? 0 : 2) + "MB";
        if (this.maxMemory > 0L) {
            double d2 = this.value * 100L / this.maxMemory;
            string = string + " (" + (d2 < 1.0 ? "<1" : IJ.d2s(d2, 0)) + "%)";
        }
        this.g.drawString(string, 2, 15);
        String string2 = "" + WindowManager.getImageCount();
        this.g.drawString(string2, 250 - (5 + string2.length() * 8), 15);
    }

    void updatePlot() {
        int n;
        double d = IJ.currentMemory();
        if (this.frames % 10 == 0) {
            this.value = (long)d;
        }
        if (d > 0.86 * this.max) {
            this.max *= 2.0;
        }
        this.mem[this.index++] = d;
        if (this.index == this.mem.length) {
            this.index = 0;
        }
        double d2 = 0.0;
        for (n = 0; n < this.mem.length; ++n) {
            if (!(this.mem[n] > d2)) continue;
            d2 = this.mem[n];
        }
        if (d2 < this.defaultMax) {
            this.max = this.defaultMax * 2.0;
        }
        if (d2 < this.defaultMax / 2.0) {
            this.max = this.defaultMax;
        }
        if ((n = this.index + 1) == this.mem.length) {
            n = 0;
        }
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, 250, 90);
        this.g.setColor(Color.black);
        double d3 = 90.0 / this.max;
        int n2 = 0;
        int n3 = 90 - (int)(this.mem[n] * d3);
        int n4 = 1;
        while (n4 < 250) {
            if (++n == this.mem.length) {
                n = 0;
            }
            int n5 = 90 - (int)(this.mem[n] * d3);
            this.g.drawLine(n2, n3, n4, n5);
            n2 = n4++;
            n3 = n5;
        }
    }

    @Override
    public void close() {
        super.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
    }
}

