/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.plugin.DICOM;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import ij.util.Tools;

public class DicomTools {
    private static final int MAX_DIGITS = 5;
    private static String[] sliceLabels;

    public static ImageStack sort(ImageStack imageStack) {
        if (IJ.debugMode) {
            IJ.log("Sorting by DICOM image number");
        }
        if (imageStack.getSize() == 1) {
            return imageStack;
        }
        String[] stringArray = DicomTools.getSortStrings(imageStack, "0020,0013");
        if (stringArray == null) {
            return imageStack;
        }
        StringSorter.sort(stringArray);
        ImageStack imageStack2 = null;
        imageStack2 = imageStack.isVirtual() ? ((VirtualStack)imageStack).sortDicom(stringArray, sliceLabels, 5) : DicomTools.sortStack(imageStack, stringArray);
        return imageStack2 != null ? imageStack2 : imageStack;
    }

    private static ImageStack sortStack(ImageStack imageStack, String[] stringArray) {
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        ImageStack imageStack2 = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight(), imageProcessor.getColorModel());
        for (int i = 0; i < imageStack.getSize(); ++i) {
            int n = (int)Tools.parseDouble(stringArray[i].substring(stringArray[i].length() - 5), 0.0);
            if (n == 0) {
                return null;
            }
            imageStack2.addSlice(sliceLabels[n - 1], imageStack.getPixels(n));
        }
        imageStack2.update(imageStack.getProcessor(1));
        return imageStack2;
    }

    private static String[] getSortStrings(ImageStack imageStack, String string) {
        double d = DicomTools.getSeriesNumber(DicomTools.getSliceLabel(imageStack, 1));
        int n = imageStack.getSize();
        String[] stringArray = new String[n];
        sliceLabels = new String[n];
        for (int i = 1; i <= n; ++i) {
            String string2 = DicomTools.getSliceLabel(imageStack, i);
            if (string2 == null) {
                return null;
            }
            DicomTools.sliceLabels[i - 1] = string2;
            double d2 = DicomTools.getNumericTag(string2, string);
            if (Double.isNaN(d2)) {
                if (IJ.debugMode) {
                    IJ.log("  " + string + "  tag missing in slice " + i);
                }
                return null;
            }
            if (DicomTools.getSeriesNumber(string2) != d) {
                if (IJ.debugMode) {
                    IJ.log("  all slices must be part of the same series");
                }
                return null;
            }
            stringArray[i - 1] = DicomTools.toString(d2, 5) + DicomTools.toString(i, 5);
        }
        return stringArray;
    }

    private static String toString(double d, int n) {
        String string = "       " + IJ.d2s(d, 0);
        return string.substring(string.length() - 5);
    }

    private static String getSliceLabel(ImageStack imageStack, int n) {
        String string = imageStack.getSliceLabel(n);
        if ((string == null || string.length() < 100) && imageStack.isVirtual()) {
            String string2 = ((VirtualStack)imageStack).getDirectory();
            String string3 = ((VirtualStack)imageStack).getFileName(n);
            DICOM dICOM = new DICOM();
            string = dICOM.getInfo(string2 + string3);
            if (string != null) {
                string = string3 + "\n" + string;
            }
        }
        return string;
    }

    public static double getVoxelDepth(ImageStack imageStack) {
        if (imageStack.isVirtual()) {
            imageStack.getProcessor(1);
        }
        String string = DicomTools.getTag(imageStack.getSliceLabel(1), "0020,0032");
        String string2 = null;
        double d = -1.0;
        if (string != null) {
            String[] stringArray = string.split("\\\\");
            if (stringArray.length != 3) {
                return d;
            }
            double d2 = Double.parseDouble(stringArray[2]);
            if (imageStack.isVirtual()) {
                imageStack.getProcessor(imageStack.getSize());
            }
            if ((string2 = DicomTools.getTag(imageStack.getSliceLabel(imageStack.getSize()), "0020,0032")) == null) {
                return d;
            }
            stringArray = string2.split("\\\\");
            if (stringArray.length != 3) {
                return d;
            }
            double d3 = Double.parseDouble(stringArray[2]);
            d = Math.abs((d3 - d2) / (double)(imageStack.getSize() - 1));
        }
        if (IJ.debugMode) {
            IJ.log("DicomTools.getVoxelDepth: " + d + "  " + string + "  " + string2);
        }
        return d;
    }

    public static String getTag(ImagePlus imagePlus, String string) {
        ImageStack imageStack;
        String string2;
        String string3 = null;
        if (imagePlus.getStackSize() > 1 && (string2 = (imageStack = imagePlus.getStack()).getSliceLabel(imagePlus.getCurrentSlice())) != null && string2.indexOf(10) > 0) {
            string3 = string2;
        }
        if (string3 == null) {
            string3 = (String)imagePlus.getProperty("Info");
        }
        return DicomTools.getTag(string3, string);
    }

    private static double getSeriesNumber(String string) {
        double d = DicomTools.getNumericTag(string, "0020,0011");
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    private static double getNumericTag(String string, String string2) {
        String string3 = DicomTools.getTag(string, string2);
        if (string3 == null) {
            return Double.NaN;
        }
        int n = string3.indexOf("\\");
        if (n > 0) {
            string3 = string3.substring(0, n);
        }
        return Tools.parseDouble(string3);
    }

    private static String getTag(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return null;
        }
        if (string.charAt(n + 11) == '>' && (n = string.indexOf(string2, n + 10)) == -1) {
            return null;
        }
        if ((n = string.indexOf(":", n)) == -1) {
            return null;
        }
        int n2 = string.indexOf("\n", n);
        String string3 = string.substring(n + 1, n2);
        return string3;
    }
}

