/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Group;
import ec.Subpopulation;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class Population
implements Group {
    private static final long serialVersionUID = 1L;
    public Subpopulation[] subpops;
    public static final String P_SIZE = "subpops";
    public static final String P_SUBPOP = "subpop";
    public static final String P_DEFAULT_SUBPOP = "default-subpop";
    public static final String P_FILE = "file";
    public static final String NUM_SUBPOPS_PREAMBLE = "Number of Subpopulations: ";
    public static final String SUBPOP_INDEX_PREAMBLE = "Subpopulation Number: ";
    public boolean loadInds;
    public Parameter file;

    public Group emptyClone() {
        try {
            Population p = (Population)this.clone();
            p.subpops = new Subpopulation[this.subpops.length];
            for (int x = 0; x < this.subpops.length; ++x) {
                p.subpops[x] = (Subpopulation)this.subpops[x].emptyClone();
            }
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void clear() {
        for (int i = 0; i < this.subpops.length; ++i) {
            this.subpops[i].clear();
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        this.file = base.push(P_FILE);
        this.loadInds = state.parameters.exists(this.file, null);
        Parameter p = base.push(P_SIZE);
        int size = state.parameters.getInt(p, null, 1);
        if (size == 0) {
            state.output.fatal("Population size must be >0.\n", base.push(P_SIZE));
        }
        this.subpops = new Subpopulation[size];
        for (int x = 0; x < size; ++x) {
            int defaultSubpop;
            p = base.push(P_SUBPOP).push("" + x);
            if (!state.parameters.exists(p, null) && (defaultSubpop = state.parameters.getInt(p = base.push(P_DEFAULT_SUBPOP), null, 0)) >= 0) {
                state.output.warning("Using subpopulation " + defaultSubpop + " as the default for subpopulation " + x);
                p = base.push(P_SUBPOP).push("" + defaultSubpop);
            }
            this.subpops[x] = (Subpopulation)state.parameters.getInstanceForParameterEq(p, null, Subpopulation.class);
            this.subpops[x].setup(state, p);
            if (!this.loadInds || !this.subpops[x].loadInds) continue;
            state.output.fatal("Both a subpopulation and its parent population have been told to load from files.  This can't happen.  It's got to be one or the other.", base.push(P_FILE), null);
        }
    }

    public void populate(EvolutionState state, int thread) {
        if (this.loadInds) {
            InputStream stream = state.parameters.getResource(this.file, null);
            if (stream == null) {
                state.output.fatal("Could not load population from file", this.file);
            }
            try {
                this.readPopulation(state, new LineNumberReader(new InputStreamReader(stream)));
            }
            catch (IOException e) {
                state.output.fatal("An IOException occurred when trying to read from the file " + state.parameters.getString(this.file, null) + ".  The IOException was: \n" + e, this.file, null);
            }
        } else {
            for (int x = 0; x < this.subpops.length; ++x) {
                this.subpops[x].populate(state, thread);
            }
        }
    }

    public final void printPopulationForHumans(EvolutionState state, int log, int verbosity) {
        this.printPopulationForHumans(state, log);
    }

    public final void printPopulation(EvolutionState state, int log, int verbosity) {
        this.printPopulation(state, log);
    }

    public void printPopulationForHumans(EvolutionState state, int log) {
        state.output.println(NUM_SUBPOPS_PREAMBLE + this.subpops.length, log);
        for (int i = 0; i < this.subpops.length; ++i) {
            state.output.println(SUBPOP_INDEX_PREAMBLE + i, log);
            this.subpops[i].printSubpopulationForHumans(state, log);
        }
    }

    public void printPopulation(EvolutionState state, int log) {
        state.output.println(NUM_SUBPOPS_PREAMBLE + Code.encode(this.subpops.length), log);
        for (int i = 0; i < this.subpops.length; ++i) {
            state.output.println(SUBPOP_INDEX_PREAMBLE + Code.encode(i), log);
            this.subpops[i].printSubpopulation(state, log);
        }
    }

    public void printPopulation(EvolutionState state, PrintWriter writer) {
        writer.println(NUM_SUBPOPS_PREAMBLE + Code.encode(this.subpops.length));
        for (int i = 0; i < this.subpops.length; ++i) {
            writer.println(SUBPOP_INDEX_PREAMBLE + Code.encode(i));
            this.subpops[i].printSubpopulation(state, writer);
        }
    }

    public void readPopulation(EvolutionState state, LineNumberReader reader) throws IOException {
        int numSubpops = Code.readIntegerWithPreamble(NUM_SUBPOPS_PREAMBLE, state, reader);
        if (numSubpops != this.subpops.length) {
            state.output.fatal("On reading population from text stream, the number of subpopulations was wrong.");
        }
        for (int i = 0; i < this.subpops.length; ++i) {
            int j = Code.readIntegerWithPreamble(SUBPOP_INDEX_PREAMBLE, state, reader);
            if (j != i) {
                state.output.warnOnce("On reading population from text stream, some subpopulation indexes in the population did not match.");
            }
            this.subpops[i].readSubpopulation(state, reader);
        }
    }

    public void writePopulation(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.subpops.length);
        for (int i = 0; i < this.subpops.length; ++i) {
            this.subpops[i].writeSubpopulation(state, dataOutput);
        }
    }

    public void readPopulation(EvolutionState state, DataInput dataInput) throws IOException {
        int numSubpopulations = dataInput.readInt();
        if (numSubpopulations != this.subpops.length) {
            state.output.fatal("On reading subpopulation from binary stream, the number of subpopulations was wrong.");
        }
        for (int i = 0; i < this.subpops.length; ++i) {
            this.subpops[i].readSubpopulation(state, dataInput);
        }
    }
}

