/*
 * Decompiled with CFR 0.152.
 */
package ec.app.hiff;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.BitVectorIndividual;

public class HIFF
extends Problem
implements SimpleProblemForm {
    public static final String P_K = "k";
    public static final String P_P = "p";
    public static final String P_RC = "rc";
    int K;
    int P;
    int Rc;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.K = state.parameters.getInt(base.push(P_K), null, 0);
        if (this.K < 0) {
            state.output.fatal("k must be > 0", base.push(P_K));
        }
        this.P = state.parameters.getInt(base.push(P_P), null, 0);
        if (this.P < 0) {
            state.output.fatal("p must be > 0", base.push(P_P));
        }
        this.Rc = state.parameters.getInt(base.push(P_RC), null, 0);
        if (this.Rc < 0) {
            state.output.fatal("rc must be > 0", base.push(P_RC));
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        BitVectorIndividual ind2 = (BitVectorIndividual)ind;
        double[] genes = new double[ind2.genome.length];
        for (int i = 0; i < genes.length; ++i) {
            genes[i] = ind2.genome[i] ? 1 : 0;
        }
        double fitness = this.H(genes);
        ((SimpleFitness)ind2.fitness).setFitness(state, fitness, false);
        ind2.evaluated = true;
    }

    double H(double[] genes) {
        int i;
        double bonus = 1.0;
        double F = 0.0;
        int last = genes.length;
        for (i = 0; i < last; ++i) {
            F += this.f(genes[i]);
        }
        for (i = 1; i <= this.P; ++i) {
            last /= this.K;
            bonus *= (double)this.Rc;
            for (int j = 0; j < last; ++j) {
                genes[j] = this.t(genes, j * this.K);
                F += this.f(genes[j]) * bonus;
            }
        }
        return F;
    }

    double t(double[] transform, int first) {
        int s = 0;
        for (int i = first + 1; i < first + this.K; ++i) {
            if (transform[first] != transform[i]) continue;
            ++s;
        }
        if (s == this.K - 1) {
            return transform[first];
        }
        return -1.0;
    }

    double f(double b) {
        if (b != -1.0) {
            return 1.0;
        }
        return 0.0;
    }
}

