/*
 * Decompiled with CFR 0.152.
 */
package ec.app.twobox;

import ec.EvolutionState;
import ec.Individual;
import ec.app.twobox.TwoBoxData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class TwoBox
extends GPProblem
implements SimpleProblemForm {
    private static final long serialVersionUID = 1L;
    public static final String P_SIZE = "size";
    public static final String P_RANGE = "range";
    public int currentIndex;
    public int trainingSetSize;
    public int range;
    public double[] inputsl0;
    public double[] inputsw0;
    public double[] inputsh0;
    public double[] inputsl1;
    public double[] inputsw1;
    public double[] inputsh1;
    public double[] outputs;

    public final double func(double l0, double w0, double h0, double l1, double w1, double h1) {
        return l0 * w0 * h0 - l1 * w1 * h1;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.input instanceof TwoBoxData)) {
            state.output.fatal("GPData class must subclass from " + TwoBoxData.class, base.push("data"), null);
        }
        this.trainingSetSize = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (this.trainingSetSize < 1) {
            state.output.fatal("Training Set Size must be an integer greater than 0");
        }
        this.range = state.parameters.getInt(base.push(P_RANGE), null, 1);
        if (this.trainingSetSize < 1) {
            state.output.fatal("Range must be an integer greater than 0");
        }
        this.inputsl0 = new double[this.trainingSetSize];
        this.inputsw0 = new double[this.trainingSetSize];
        this.inputsh0 = new double[this.trainingSetSize];
        this.inputsl1 = new double[this.trainingSetSize];
        this.inputsw1 = new double[this.trainingSetSize];
        this.inputsh1 = new double[this.trainingSetSize];
        this.outputs = new double[this.trainingSetSize];
        for (int x = 0; x < this.trainingSetSize; ++x) {
            this.inputsl0[x] = state.random[0].nextInt(this.range) + 1;
            this.inputsw0[x] = state.random[0].nextInt(this.range) + 1;
            this.inputsh0[x] = state.random[0].nextInt(this.range) + 1;
            this.inputsl1[x] = state.random[0].nextInt(this.range) + 1;
            this.inputsw1[x] = state.random[0].nextInt(this.range) + 1;
            this.inputsh1[x] = state.random[0].nextInt(this.range) + 1;
            this.outputs[x] = this.func(this.inputsl0[x], this.inputsw0[x], this.inputsh0[x], this.inputsl1[x], this.inputsw1[x], this.inputsh1[x]);
            state.output.println("{" + this.inputsl0[x] + "," + this.inputsw0[x] + "," + this.inputsh0[x] + "," + this.inputsl1[x] + "," + this.inputsw1[x] + "," + this.inputsh1[x] + "," + this.outputs[x] + "},", 0);
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            TwoBoxData input = (TwoBoxData)this.input;
            int hits = 0;
            double sum = 0.0;
            for (int y = 0; y < this.trainingSetSize; ++y) {
                this.currentIndex = y;
                ((GPIndividual)ind).trees[0].child.eval(state, threadnum, input, this.stack, (GPIndividual)ind, this);
                double HIT_LEVEL = 0.01;
                double PROBABLY_ZERO = 1.11E-15;
                double BIG_NUMBER = 1.0E15;
                double result = Math.abs(this.outputs[y] - input.x);
                if (result < 1.11E-15) {
                    result = 0.0;
                }
                if (result > 1.0E15) {
                    result = 1.0E15;
                }
                if (result <= 0.01) {
                    ++hits;
                }
                sum += result;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, sum);
            f.hits = hits;
            ind.evaluated = true;
        }
    }
}

