/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class ReproductionPipeline
extends BreedingPipeline {
    public static final String P_REPRODUCE = "reproduce";
    public static final String P_MUSTCLONE = "must-clone";
    public static final int NUM_SOURCES = 1;
    public boolean mustClone;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_REPRODUCE);
    }

    public int numSources() {
        return 1;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.mustClone = state.parameters.getBoolean(base.push(P_MUSTCLONE), def.push(P_MUSTCLONE), false);
        if (this.likelihood != 1.0) {
            state.output.warning("ReproductionPipeline given a likelihood other than 1.0.  This is nonsensical and will be ignored.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (this.mustClone || this.sources[0] instanceof SelectionMethod) {
            for (int q = start; q < n + start; ++q) {
                inds[q] = (Individual)inds[q].clone();
            }
        }
        return n;
    }
}

