/*
 * Decompiled with CFR 0.152.
 */
package ec.display;

import ec.EvolutionState;
import ec.Setup;
import ec.Statistics;
import ec.display.chart.ChartableStatistics;
import ec.display.chart.StatisticsChartPaneTab;
import ec.util.Parameter;
import java.awt.Color;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class StatisticsChartPane
extends JTabbedPane
implements Setup {
    public int numCharts;

    public StatisticsChartPane() {
        this.initialize();
    }

    public StatisticsChartPane(int tabPlacement) {
        super(tabPlacement);
        this.initialize();
    }

    public StatisticsChartPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.initialize();
    }

    private void createCharts(Statistics statistics) {
        if (statistics instanceof ChartableStatistics) {
            ChartableStatistics chartStats = (ChartableStatistics)statistics;
            JFreeChart chart = chartStats.makeChart();
            chart.setBackgroundPaint(Color.white);
            ChartPanel chartPanel = new ChartPanel(chart);
            StatisticsChartPaneTab chartPaneTab = new StatisticsChartPaneTab(chartPanel);
            this.addTab("Chart " + this.numCharts++, chartPaneTab);
        }
        if (statistics.children != null) {
            for (int i = 0; i < statistics.children.length; ++i) {
                this.createCharts(statistics.children[i]);
            }
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        this.numCharts = 0;
        this.createCharts(state.statistics);
    }

    private void initialize() {
        this.setSize(300, 200);
        this.addContainerListener(new ContainerAdapter(){

            public void componentRemoved(ContainerEvent e) {
                StatisticsChartPane pane = (StatisticsChartPane)e.getSource();
                if (pane.getTabCount() < 1) {
                    pane.getParent().remove(pane);
                }
            }
        });
    }
}

