/*
 * Decompiled with CFR 0.152.
 */
package ec.display.chart;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import ec.display.StatisticsChartPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class StatisticsChartPaneTab
extends JPanel {
    private JPanel jPanel = null;
    private JButton printButton = null;
    private JButton closeButton = null;
    private final ChartPanel chartPane;

    public StatisticsChartPaneTab(ChartPanel chartPane) {
        this.chartPane = chartPane;
        this.initialize();
        this.add((Component)chartPane, "Center");
    }

    public StatisticsChartPaneTab(ChartPanel chartPane, boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.chartPane = chartPane;
        this.initialize();
        this.add((Component)chartPane, "Center");
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.add((Component)this.getJPanel(), "South");
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BoxLayout(this.jPanel, 0));
            this.jPanel.add(Box.createHorizontalGlue());
            this.jPanel.add((Component)this.getPrintButton(), null);
            this.jPanel.add((Component)this.getCloseButton(), null);
        }
        return this.jPanel;
    }

    private JButton getPrintButton() {
        if (this.printButton == null) {
            this.printButton = new JButton();
            this.printButton.setText("Export to PDF...");
            final JFreeChart chart = this.chartPane.getChart();
            this.printButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        int width = StatisticsChartPaneTab.this.chartPane.getWidth();
                        int height = StatisticsChartPaneTab.this.chartPane.getHeight();
                        FileDialog fileDialog = new FileDialog(new Frame(), "Export...", 1);
                        fileDialog.setDirectory(System.getProperty("user.dir"));
                        fileDialog.setFile("*.pdf");
                        fileDialog.setVisible(true);
                        String fileName = fileDialog.getFile();
                        if (fileName != null) {
                            if (!fileName.endsWith(".pdf")) {
                                fileName = fileName + ".pdf";
                            }
                            File f = new File(fileDialog.getDirectory(), fileName);
                            Document document = new Document(new Rectangle((float)width, (float)height));
                            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(f));
                            document.addAuthor("ECJ Console");
                            document.open();
                            PdfContentByte cb = writer.getDirectContent();
                            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
                            Graphics2D g2 = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
                            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(0.0, 0.0, width, height);
                            chart.draw(g2, rectangle2D);
                            g2.dispose();
                            cb.addTemplate(tp, 0.0f, 0.0f);
                            document.close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.printButton;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            final StatisticsChartPaneTab pane = this;
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StatisticsChartPane parent = (StatisticsChartPane)pane.getParent();
                    parent.removeTabAt(parent.indexOfComponent(pane));
                }
            });
        }
        return this.closeButton;
    }
}

