/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.Problem;
import ec.Prototype;
import ec.gp.ADF;
import ec.gp.ADFStack;
import ec.gp.ADM;
import ec.gp.GPData;
import ec.gp.GPDefaults;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.util.Parameter;

public class ADFContext
implements Prototype {
    public static final String P_ADFCONTEXT = "adf-context";
    public ADF adf;
    public GPData[] arguments = new GPData[0];

    public Parameter defaultBase() {
        return GPDefaults.base().push(P_ADFCONTEXT);
    }

    public Object clone() {
        try {
            ADFContext myobj = (ADFContext)super.clone();
            myobj.arguments = new GPData[this.arguments.length];
            for (int x = 0; x < myobj.arguments.length; ++x) {
                myobj.arguments[x] = (GPData)this.arguments[x].clone();
            }
            return myobj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void setup(EvolutionState state, Parameter base) {
    }

    public void evaluate(EvolutionState state, int thread, GPData input, ADFStack stack, GPIndividual individual, Problem problem, int argument) {
        if (argument >= this.adf.children.length || argument < 0) {
            individual.printIndividual(state, 0);
            state.output.fatal("Invalid argument number for " + this.adf.errorInfo());
        }
        if (!(this.adf instanceof ADM)) {
            this.arguments[argument].copyTo(input);
        } else {
            if (stack.moveOntoSubstack(1) != 1) {
                state.output.fatal("Substack prematurely empty for " + this.adf.errorInfo());
            }
            this.adf.children[argument].eval(state, thread, input, stack, individual, problem);
            if (stack.moveFromSubstack(1) != 1) {
                state.output.fatal("Stack prematurely empty for " + this.adf.errorInfo());
            }
        }
    }

    public final void prepareADF(ADF a, GPProblem problem) {
        if (a.children.length > this.arguments.length) {
            GPData[] newarguments = new GPData[a.children.length];
            System.arraycopy(this.arguments, 0, newarguments, 0, this.arguments.length);
            for (int x = this.arguments.length; x < newarguments.length; ++x) {
                newarguments[x] = (GPData)problem.input.clone();
            }
            this.arguments = newarguments;
        }
        this.adf = a;
    }

    public final void prepareADM(ADM a) {
        this.adf = a;
    }
}

