/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeSelector;
import ec.gp.GPTree;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;

public class SizeFairCrossoverPipeline
extends GPBreedingPipeline {
    private static final long serialVersionUID = 1L;
    public static final String P_NUM_TRIES = "tries";
    public static final String P_MAXDEPTH = "maxdepth";
    public static final String P_SIZEFAIR = "size-fair";
    public static final String P_TOSS = "toss";
    public static final String P_HOMOLOGOUS = "homologous";
    public static final int INDS_PRODUCED = 2;
    public static final int NUM_SOURCES = 2;
    public GPNodeSelector nodeselect1;
    public GPNodeSelector nodeselect2;
    public int tree1;
    public int tree2;
    public int numTries;
    public int maxDepth;
    public boolean tossSecondParent;
    public GPIndividual[] parents = new GPIndividual[2];
    public boolean homologous;

    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_SIZEFAIR);
    }

    public int numSources() {
        return 2;
    }

    public Object clone() {
        SizeFairCrossoverPipeline c = (SizeFairCrossoverPipeline)super.clone();
        c.nodeselect1 = (GPNodeSelector)this.nodeselect1.clone();
        c.nodeselect2 = (GPNodeSelector)this.nodeselect2.clone();
        c.parents = (GPIndividual[])this.parents.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        Parameter p = base.push("ns").push("0");
        Parameter d = def.push("ns").push("0");
        this.nodeselect1 = (GPNodeSelector)state.parameters.getInstanceForParameter(p, d, GPNodeSelector.class);
        this.nodeselect1.setup(state, p);
        p = base.push("ns").push("1");
        d = def.push("ns").push("1");
        if (state.parameters.exists(p, d) && state.parameters.getString(p, d).equals("same")) {
            this.nodeselect2 = (GPNodeSelector)this.nodeselect1.clone();
        } else {
            this.nodeselect2 = (GPNodeSelector)state.parameters.getInstanceForParameter(p, d, GPNodeSelector.class);
            this.nodeselect2.setup(state, p);
        }
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("GPCrossover Pipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        this.maxDepth = state.parameters.getInt(base.push(P_MAXDEPTH), def.push(P_MAXDEPTH), 1);
        if (this.maxDepth == 0) {
            state.output.fatal("GPCrossover Pipeline has an invalid maximum depth (it must be >= 1).", base.push(P_MAXDEPTH), def.push(P_MAXDEPTH));
        }
        this.tree1 = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree1 = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree1 == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
        this.tree2 = -1;
        if (state.parameters.exists(base.push("tree").push("1"), def.push("tree").push("1"))) {
            this.tree2 = state.parameters.getInt(base.push("tree").push("1"), def.push("tree").push("1"), 0);
            if (this.tree2 == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
        this.tossSecondParent = state.parameters.getBoolean(base.push(P_TOSS), def.push(P_TOSS), false);
        if (state.parameters.exists(base.push(P_HOMOLOGOUS), null)) {
            this.homologous = state.parameters.getBoolean(base.push(P_HOMOLOGOUS), null, false);
        }
    }

    public int typicalIndsProduced() {
        return this.tossSecondParent ? this.minChildProduction() : this.minChildProduction() * 2;
    }

    public boolean verifyPoints(GPInitializer initializer, GPNode inner1, GPNode inner2) {
        if (!inner1.swapCompatibleWith(initializer, inner2)) {
            return false;
        }
        return inner1.depth() + inner2.atDepth() <= this.maxDepth;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.typicalIndsProduced();
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, true);
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        int q = start;
        while (q < n + start) {
            int x;
            if (this.sources[0] == this.sources[1]) {
                this.sources[0].produce(2, 2, 0, subpopulation, this.parents, state, thread);
            } else {
                this.sources[0].produce(1, 1, 0, subpopulation, this.parents, state, thread);
                this.sources[1].produce(1, 1, 1, subpopulation, this.parents, state, thread);
            }
            if (this.tree1 != -1 && (this.tree1 < 0 || this.tree1 >= this.parents[0].trees.length)) {
                state.output.fatal("GP Crossover Pipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            if (this.tree2 != -1 && (this.tree2 < 0 || this.tree2 >= this.parents[1].trees.length)) {
                state.output.fatal("GP Crossover Pipeline attempted to fix tree.1 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            int t1 = 0;
            int t2 = 0;
            if (this.tree1 == -1 || this.tree2 == -1) {
                do {
                    t1 = this.tree1 == -1 ? (this.parents[0].trees.length > 1 ? state.random[thread].nextInt(this.parents[0].trees.length) : 0) : this.tree1;
                    if (this.tree2 == -1) {
                        if (this.parents[1].trees.length > 1) {
                            t2 = state.random[thread].nextInt(this.parents[1].trees.length);
                            continue;
                        }
                        t2 = 0;
                        continue;
                    }
                    t2 = this.tree2;
                } while (this.parents[0].trees[t1].constraints(initializer) != this.parents[1].trees[t2].constraints(initializer));
            } else {
                t1 = this.tree1;
                t2 = this.tree2;
                if (this.parents[0].trees[t1].constraints(initializer) != this.parents[1].trees[t2].constraints(initializer)) {
                    state.output.fatal("GP Crossover Pipeline's two tree choices are both specified by the user -- but their GPTreeConstraints are not the same");
                }
            }
            boolean res1 = false;
            boolean res2 = false;
            GPTree tree2 = this.parents[1].trees[t2];
            GPNode p1 = null;
            GPNode p2 = null;
            ArrayList nodeToSubtrees = new ArrayList();
            HashMap sizeToNodes = new HashMap();
            this.traverseTreeForDepth(tree2.child, nodeToSubtrees, sizeToNodes);
            Collections.sort(nodeToSubtrees, new Comparator(){

                public int compare(Object o1, Object o2) {
                    NodeInfo node1 = (NodeInfo)o1;
                    NodeInfo node2 = (NodeInfo)o2;
                    int comparison = 0;
                    if (node1.numberOfSubTreesBeneath > node2.numberOfSubTreesBeneath) {
                        comparison = 1;
                    } else if (node1.numberOfSubTreesBeneath < node2.numberOfSubTreesBeneath) {
                        comparison = -1;
                    } else if (node1.numberOfSubTreesBeneath == node2.numberOfSubTreesBeneath) {
                        comparison = 0;
                    }
                    return comparison;
                }
            });
            for (int x2 = 0; x2 < this.numTries; ++x2) {
                p1 = this.nodeselect1.pickNode(state, subpopulation, thread, this.parents[0], this.parents[0].trees[t1]);
                p2 = this.findFairSizeNode(nodeToSubtrees, sizeToNodes, p1, tree2, state, thread);
                res1 = this.verifyPoints(initializer, p2, p1);
                res2 = n - (q - start) < 2 || this.tossSecondParent ? true : this.verifyPoints(initializer, p1, p2);
                if (res1 && res2) break;
            }
            GPIndividual j1 = this.parents[0].lightClone();
            GPIndividual j2 = null;
            if (n - (q - start) >= 2 && !this.tossSecondParent) {
                j2 = this.parents[1].lightClone();
            }
            j1.trees = new GPTree[this.parents[0].trees.length];
            if (n - (q - start) >= 2 && !this.tossSecondParent) {
                j2.trees = new GPTree[this.parents[1].trees.length];
            }
            for (x = 0; x < j1.trees.length; ++x) {
                if (x == t1 && res1) {
                    j1.trees[x] = this.parents[0].trees[x].lightClone();
                    j1.trees[x].owner = j1;
                    j1.trees[x].child = this.parents[0].trees[x].child.cloneReplacing(p2, p1);
                    j1.trees[x].child.parent = j1.trees[x];
                    j1.trees[x].child.argposition = 0;
                    j1.evaluated = false;
                    continue;
                }
                j1.trees[x] = this.parents[0].trees[x].lightClone();
                j1.trees[x].owner = j1;
                j1.trees[x].child = (GPNode)this.parents[0].trees[x].child.clone();
                j1.trees[x].child.parent = j1.trees[x];
                j1.trees[x].child.argposition = 0;
            }
            if (n - (q - start) >= 2 && !this.tossSecondParent) {
                for (x = 0; x < j2.trees.length; ++x) {
                    if (x == t2 && res2) {
                        j2.trees[x] = this.parents[1].trees[x].lightClone();
                        j2.trees[x].owner = j2;
                        j2.trees[x].child = this.parents[1].trees[x].child.cloneReplacing(p1, p2);
                        j2.trees[x].child.parent = j2.trees[x];
                        j2.trees[x].child.argposition = 0;
                        j2.evaluated = false;
                        continue;
                    }
                    j2.trees[x] = this.parents[1].trees[x].lightClone();
                    j2.trees[x].owner = j2;
                    j2.trees[x].child = (GPNode)this.parents[1].trees[x].child.clone();
                    j2.trees[x].child.parent = j2.trees[x];
                    j2.trees[x].child.argposition = 0;
                }
            }
            inds[q] = j1;
            if (++q >= n + start || this.tossSecondParent) continue;
            inds[q] = j2;
            ++q;
        }
        return n;
    }

    protected GPNode findFairSizeNode(ArrayList nodeToSubtrees, HashMap sizeToNodes, GPNode parent1SelectedNode, GPTree tree2, EvolutionState state, int thread) {
        LinkedList listOfNodes;
        int l;
        int i;
        GPNode selectedNode = null;
        int parent1SubTrees = parent1SelectedNode.numNodes(2);
        int maxmatesublen = parent1SubTrees == 0 ? 0 : 2 * parent1SubTrees + 1;
        boolean[] mateSizeAvailable = new boolean[maxmatesublen + 1];
        for (i = 0; i < maxmatesublen; ++i) {
            mateSizeAvailable[i] = false;
        }
        for (i = 0; i < nodeToSubtrees.size(); ++i) {
            NodeInfo nodeInfo = (NodeInfo)nodeToSubtrees.get(i);
            int subtree = nodeInfo.numberOfSubTreesBeneath;
            if (subtree > maxmatesublen) continue;
            mateSizeAvailable[subtree] = true;
        }
        int countOfPositives = 0;
        int countOfNegatives = 0;
        int sumOfPositives = 0;
        int sumOfNegatives = 0;
        for (l = 1; l < parent1SubTrees; ++l) {
            if (!mateSizeAvailable[l]) continue;
            ++countOfNegatives;
            sumOfNegatives += parent1SubTrees - l;
        }
        for (l = parent1SubTrees + 1; l <= maxmatesublen; ++l) {
            if (!mateSizeAvailable[l]) continue;
            ++countOfPositives;
            sumOfPositives += l - parent1SubTrees;
        }
        int mateSublengthSelected = 0;
        if (sumOfPositives == 0 || sumOfNegatives == 0) {
            if (mateSizeAvailable[parent1SubTrees]) {
                mateSublengthSelected = parent1SubTrees;
            }
        } else {
            double pzero = mateSizeAvailable[parent1SubTrees] ? 1.0 / (double)parent1SubTrees : 0.0;
            double ppositive = (1.0 - pzero) / ((double)countOfPositives + (double)(countOfNegatives * sumOfPositives) / (double)sumOfNegatives);
            double pnegative = (1.0 - pzero) / ((double)countOfNegatives + (double)(countOfPositives * sumOfNegatives) / (double)sumOfPositives);
            double total = (double)countOfNegatives * pnegative + pzero + (double)countOfPositives * ppositive;
            RouletteWheelSelector wheel = new RouletteWheelSelector(maxmatesublen);
            for (l = 1; l < parent1SubTrees; ++l) {
                if (!mateSizeAvailable[l]) continue;
                wheel.add(pnegative, l);
            }
            if (mateSizeAvailable[parent1SubTrees]) {
                wheel.add(pzero, parent1SubTrees);
            }
            for (l = parent1SubTrees + 1; l <= maxmatesublen; ++l) {
                if (!mateSizeAvailable[l]) continue;
                wheel.add(ppositive, l);
            }
            mateSublengthSelected = wheel.roulette(state, thread);
        }
        if ((listOfNodes = (LinkedList)sizeToNodes.get(mateSublengthSelected)) == null) {
            state.output.fatal("In SizeFairCrossoverPipeline, nodes for tree length " + mateSublengthSelected + " is null, indicates some serious error");
        }
        int chosenNode = 0;
        if (!this.homologous) {
            chosenNode = state.random[thread].nextInt(listOfNodes.size());
        } else if (listOfNodes.size() > 1) {
            GPInitializer initializer = (GPInitializer)state.initializer;
            int currentMinDistance = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < listOfNodes.size(); ++i2) {
                GPNode selectedMateNode;
                GPNode currentMateNode = selectedMateNode = ((NodeInfo)listOfNodes.get((int)i2)).node;
                GPNode currentParent1Node = parent1SelectedNode;
                boolean foundAMatchInAncestor = false;
                int distance = 0;
                while (currentMateNode.parent != null && currentMateNode.parent instanceof GPNode && currentParent1Node.parent != null && currentParent1Node.parent instanceof GPNode && !foundAMatchInAncestor) {
                    GPNode parent1 = (GPNode)currentParent1Node.parent;
                    GPNode parent2 = (GPNode)currentMateNode.parent;
                    if (parent1.swapCompatibleWith(initializer, parent2)) {
                        foundAMatchInAncestor = true;
                        break;
                    }
                    currentMateNode = parent2;
                    currentParent1Node = parent1;
                    ++distance;
                }
                if (distance >= currentMinDistance) continue;
                currentMinDistance = distance;
                chosenNode = i2;
            }
        }
        NodeInfo nodeInfoSelected = (NodeInfo)listOfNodes.get(chosenNode);
        selectedNode = nodeInfoSelected.node;
        return selectedNode;
    }

    public void traverseTreeForDepth(GPNode node, ArrayList nodeToDepth, HashMap sizeToNodes) {
        GPNode[] children = node.children;
        NodeInfo nodeInfo = new NodeInfo(node, node.numNodes(2));
        nodeToDepth.add(nodeInfo);
        LinkedList<NodeInfo> listForSize = (LinkedList<NodeInfo>)sizeToNodes.get(nodeInfo.numberOfSubTreesBeneath);
        if (listForSize == null) {
            listForSize = new LinkedList<NodeInfo>();
            sizeToNodes.put(new Integer(nodeInfo.numberOfSubTreesBeneath), listForSize);
        }
        listForSize.add(nodeInfo);
        if (children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.traverseTreeForDepth(children[i], nodeToDepth, sizeToNodes);
            }
        }
    }

    static class NodeInfo {
        int numberOfSubTreesBeneath;
        GPNode node;

        public NodeInfo(GPNode node, int numberOfSubtrees) {
            this.node = node;
            this.numberOfSubTreesBeneath = numberOfSubtrees;
        }

        public void setSubtrees(int totalSubtrees) {
            this.numberOfSubTreesBeneath = totalSubtrees;
        }

        public int getSubtrees() {
            return this.numberOfSubTreesBeneath;
        }

        public GPNode getNode() {
            return this.node;
        }
    }

    static class RouletteWheelSelector {
        int[] length;
        double[] probability;
        int currentIndex = 0;
        int maxLength = 0;

        RouletteWheelSelector(int size) {
            this.length = new int[size];
            this.probability = new double[size];
        }

        public void add(double currentProbability, int currentLength) {
            this.length[this.currentIndex] = currentLength;
            this.probability[this.currentIndex] = currentProbability;
            ++this.currentIndex;
            if (currentLength > this.maxLength) {
                this.maxLength = currentLength;
            }
        }

        public int roulette(EvolutionState state, int thread) {
            int winner = 0;
            int selectedLength = 0;
            for (int i = 1; i < this.currentIndex; ++i) {
                int n = i;
                this.probability[n] = this.probability[n] + this.probability[i - 1];
            }
            int bot = 0;
            int top = this.currentIndex - 1;
            double f = state.random[thread].nextDouble() * this.probability[top];
            for (int loop = 0; loop < 20; ++loop) {
                int index = (top + bot) / 2;
                if (index > 0 && f < this.probability[index - 1]) {
                    top = index - 1;
                    continue;
                }
                if (f > this.probability[index]) {
                    bot = index + 1;
                    continue;
                }
                if (f == this.probability[index] && index + 1 < this.currentIndex) {
                    winner = index + 1;
                    break;
                }
                winner = index;
                break;
            }
            if (winner < 0 || winner >= this.currentIndex) {
                state.output.fatal("roulette() method  winner " + winner + " out of range 0..." + (this.currentIndex - 1));
                winner = 0;
            }
            if (this.length[winner] < 1 || this.length[winner] > this.maxLength) {
                state.output.fatal("roulette() method " + this.length[winner] + " is  out of range 1..." + this.maxLength);
                return this.maxLength;
            }
            selectedLength = this.length[winner];
            return selectedLength;
        }
    }
}

