/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.build;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeBuilder;
import ec.gp.GPNodeParent;
import ec.gp.GPType;
import ec.gp.build.GPBuildDefaults;
import ec.util.Parameter;

public class RandomBranch
extends GPNodeBuilder {
    public static final String P_RANDOMBRANCH = "random-branch";

    public Parameter defaultBase() {
        return GPBuildDefaults.base().push(P_RANDOMBRANCH);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!this.canPick()) {
            state.output.fatal("RandomBranch requires some kind of size distribution set, either with min-size/max-size, or with num-sizes.", base, this.defaultBase());
        }
    }

    public GPNode newRootedTree(EvolutionState state, GPType type, int thread, GPNodeParent parent, GPFunctionSet set, int argposition, int requestedSize) {
        if (requestedSize == -1) {
            return this.randomBranch(state, type, this.pickSize(state, thread), thread, parent, argposition, set);
        }
        if (requestedSize < 1) {
            state.output.fatal("ec.gp.build.RandomBranch requested to build a tree, but a requested size was given that is < 1.");
        }
        return this.randomBranch(state, type, requestedSize, thread, parent, argposition, set);
    }

    private GPNode randomBranch(EvolutionState state, GPType type, int maxLength, int thread, GPNodeParent parent, int argposition, GPFunctionSet set) {
        GPNode[] okayNonterms;
        int len;
        boolean triedTerminals = false;
        int t = type.type;
        GPNode[] terminals = set.terminals[t];
        GPNode[] nonterminals = set.nonterminals[t];
        GPNode[] nodes = set.nodes[t];
        if (nodes.length == 0) {
            this.errorAboutNoNodeWithType(type, state);
        }
        if (maxLength == 1 || this.warnAboutNonterminal(nonterminals.length == 0, type, false, state)) {
            triedTerminals = true;
            if (true && terminals.length != 0) {
                GPNode n = terminals[state.random[thread].nextInt(terminals.length)].lightClone();
                n.resetNode(state, thread);
                n.argposition = (byte)argposition;
                n.parent = parent;
                return n;
            }
        }
        if (triedTerminals) {
            this.warnAboutNoTerminalWithType(type, false, state);
        }
        if ((len = set.nonterminalsUnderArity[type.type].length - 1) > maxLength - 1) {
            len = maxLength - 1;
        }
        if ((okayNonterms = set.nonterminalsUnderArity[type.type][len]).length == 0) {
            if (terminals.length == 0) {
                this.errorAboutNoNodeWithType(type, state);
            }
            GPNode n = terminals[state.random[thread].nextInt(terminals.length)].lightClone();
            n.resetNode(state, thread);
            n.argposition = (byte)argposition;
            n.parent = parent;
            return n;
        }
        GPNode n = okayNonterms[state.random[thread].nextInt(okayNonterms.length)].lightClone();
        n.resetNode(state, thread);
        n.argposition = (byte)argposition;
        n.parent = parent;
        GPType[] childtypes = n.constraints((GPInitializer)((GPInitializer)state.initializer)).childtypes;
        for (int x = 0; x < childtypes.length; ++x) {
            n.children[x] = this.randomBranch(state, childtypes[x], (maxLength - 1) / childtypes.length, thread, n, x, set);
        }
        return n;
    }
}

