/*
 * Decompiled with CFR 0.152.
 */
package ec.parsimony;

import ec.EvolutionState;
import ec.Individual;
import ec.select.SelectDefaults;
import ec.select.TournamentSelection;
import ec.util.Parameter;

public class ProportionalTournamentSelection
extends TournamentSelection {
    public static final String P_PROPORTIONAL_TOURNAMENT = "proportional-tournament";
    public static final String P_PROBABILITY = "fitness-prob";
    public double fitnessPressureProb;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_PROPORTIONAL_TOURNAMENT);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.fitnessPressureProb = state.parameters.getDouble(base.push(P_PROBABILITY), def.push(P_PROBABILITY), 0.0);
        if (this.fitnessPressureProb < 0.0 || this.fitnessPressureProb > 1.0) {
            state.output.fatal("Probability must be between 0.0 and 1.0", base.push(P_PROBABILITY), def.push(P_PROBABILITY));
        }
    }

    public boolean betterThan(Individual first, Individual second, int subpopulation, EvolutionState state, int thread) {
        if (state.random[thread].nextBoolean(this.fitnessPressureProb)) {
            return first.fitness.betterThan(second.fitness);
        }
        return first.size() < second.size();
    }
}

