/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.select.FitProportionateSelection;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import ec.util.RandomChoice;

public class SigmaScalingSelection
extends FitProportionateSelection {
    public static final String P_SIGMA_SCALING = "sigma-scaling";
    public static final String P_SCALED_FITNESS_FLOOR = "scaled-fitness-floor";
    double fitnessFloor;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_SIGMA_SCALING);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.fitnessFloor = state.parameters.getDoubleWithDefault(base.push(P_SCALED_FITNESS_FLOOR), def.push(P_SCALED_FITNESS_FLOOR), 0.1);
        if (this.fitnessFloor < 0.0) {
            state.output.fatal("The scaled-fitness-floor must be a non-negative value.", base.push(P_SCALED_FITNESS_FLOOR), def.push(P_SCALED_FITNESS_FLOOR));
        }
    }

    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        int x;
        this.fitnesses = new double[s.population.subpops[subpopulation].individuals.length];
        double meanSum = 0.0;
        double squaredDeviationsSum = 0.0;
        for (x = 0; x < this.fitnesses.length; ++x) {
            this.fitnesses[x] = s.population.subpops[subpopulation].individuals[x].fitness.fitness();
            if (!(this.fitnesses[x] < 0.0)) continue;
            s.output.fatal("Discovered a negative fitness value.  SigmaScalingSelection requires that all fitness values be non-negative(offending subpopulation #" + subpopulation + ")");
        }
        for (x = 0; x < this.fitnesses.length; ++x) {
            meanSum += this.fitnesses[x];
        }
        double meanFitness = meanSum / (double)this.fitnesses.length;
        for (x = 0; x < this.fitnesses.length; ++x) {
            squaredDeviationsSum += Math.pow(this.fitnesses[x] - meanFitness, 2.0);
        }
        double sigma = Math.sqrt(squaredDeviationsSum / (double)(this.fitnesses.length - 1));
        for (x = 0; x < this.fitnesses.length; ++x) {
            this.fitnesses[x] = this.sigmaScaledValue(this.fitnesses[x], meanFitness, sigma, s);
            if (!(this.fitnesses[x] < this.fitnessFloor)) continue;
            this.fitnesses[x] = this.fitnessFloor;
        }
        RandomChoice.organizeDistribution(this.fitnesses, true);
    }

    private double sigmaScaledValue(double fitness, double meanFitness, double sigma, EvolutionState s) {
        if (sigma != 0.0) {
            return 1.0 + (fitness - meanFitness) / (2.0 * sigma);
        }
        return 1.0;
    }
}

