/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.Evaluator;
import ec.EvolutionState;
import ec.Fitness;
import ec.Individual;
import ec.Population;
import ec.Problem;
import ec.Subpopulation;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.util.ThreadPool;

public class SimpleEvaluator
extends Evaluator {
    public static final String P_CLONE_PROBLEM = "clone-problem";
    public static final String P_NUM_TESTS = "num-tests";
    public static final String P_MERGE = "merge";
    public static final String V_MEAN = "mean";
    public static final String V_MEDIAN = "median";
    public static final String V_BEST = "best";
    public static final String P_CHUNK_SIZE = "chunk-size";
    public static final String V_AUTO = "auto";
    public static final int MERGE_MEAN = 0;
    public static final int MERGE_MEDIAN = 1;
    public static final int MERGE_BEST = 2;
    public int numTests = 1;
    public int mergeForm = 0;
    public boolean cloneProblem;
    Object[] lock = new Object[0];
    int individualCounter = 0;
    int subPopCounter = 0;
    int chunkSize;
    public static final int C_AUTO = 0;
    public ThreadPool pool = new ThreadPool();
    Population oldpop = null;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.p_problem instanceof SimpleProblemForm)) {
            state.output.fatal("" + this.getClass() + " used, but the Problem is not of SimpleProblemForm", base.push("problem"));
        }
        this.cloneProblem = state.parameters.getBoolean(base.push(P_CLONE_PROBLEM), null, true);
        if (!this.cloneProblem && state.breedthreads > 1) {
            state.output.fatal("The Evaluator is not cloning its Problem, but you have more than one thread.", base.push(P_CLONE_PROBLEM));
        }
        this.numTests = state.parameters.getInt(base.push(P_NUM_TESTS), null, 1);
        if (this.numTests < 1) {
            this.numTests = 1;
        } else if (this.numTests > 1) {
            String m = state.parameters.getString(base.push(P_MERGE), null);
            if (m == null) {
                state.output.warning("Merge method not provided to SimpleEvaluator.  Assuming 'mean'");
            } else if (m.equals(V_MEAN)) {
                this.mergeForm = 0;
            } else if (m.equals(V_MEDIAN)) {
                this.mergeForm = 1;
            } else if (m.equals(V_BEST)) {
                this.mergeForm = 2;
            } else {
                state.output.fatal("Bad merge method: " + m, base.push(P_NUM_TESTS), null);
            }
        }
        if (!state.parameters.exists(base.push(P_CHUNK_SIZE), null)) {
            this.chunkSize = 0;
        } else if (state.parameters.getString(base.push(P_CHUNK_SIZE), null).equalsIgnoreCase(V_AUTO)) {
            this.chunkSize = 0;
        } else {
            this.chunkSize = state.parameters.getInt(base.push(P_CHUNK_SIZE), null, 1);
            if (this.chunkSize == 0) {
                state.output.fatal("Chunk Size must be either an integer >= 1 or 'auto'", base.push(P_CHUNK_SIZE), null);
            }
        }
    }

    void expand(EvolutionState state) {
        Population pop = (Population)state.population.emptyClone();
        for (int i = 0; i < pop.subpops.length; ++i) {
            pop.subpops[i].individuals = new Individual[this.numTests * state.population.subpops[i].individuals.length];
            for (int j = 0; j < state.population.subpops[i].individuals.length; ++j) {
                for (int k = 0; k < this.numTests; ++k) {
                    pop.subpops[i].individuals[this.numTests * j + k] = (Individual)state.population.subpops[i].individuals[j].clone();
                }
            }
        }
        this.oldpop = state.population;
        state.population = pop;
    }

    void contract(EvolutionState state) {
        Population pop = state.population;
        state.population = this.oldpop;
        for (int i = 0; i < pop.subpops.length; ++i) {
            Fitness[] fits = new Fitness[this.numTests];
            for (int j = 0; j < state.population.subpops[i].individuals.length; ++j) {
                for (int k = 0; k < this.numTests; ++k) {
                    fits[k] = pop.subpops[i].individuals[this.numTests * j + k].fitness;
                }
                if (this.mergeForm == 0) {
                    state.population.subpops[i].individuals[j].fitness.setToMeanOf(state, fits);
                } else if (this.mergeForm == 1) {
                    state.population.subpops[i].individuals[j].fitness.setToMedianOf(state, fits);
                } else {
                    state.population.subpops[i].individuals[j].fitness.setToBestOf(state, fits);
                }
                state.population.subpops[i].individuals[j].evaluated = true;
            }
        }
    }

    public void evaluatePopulation(EvolutionState state) {
        if (this.numTests > 1) {
            this.expand(state);
        }
        this.individualCounter = 0;
        this.subPopCounter = 0;
        if (state.evalthreads == 1) {
            int[] numinds = new int[state.population.subpops.length];
            int[] from = new int[numinds.length];
            for (int i = 0; i < numinds.length; ++i) {
                numinds[i] = state.population.subpops[i].individuals.length;
                from[i] = 0;
            }
            SimpleProblemForm prob = null;
            prob = this.cloneProblem ? (SimpleProblemForm)this.p_problem.clone() : (SimpleProblemForm)((Object)this.p_problem);
            this.evalPopChunk(state, numinds, from, 0, prob);
        } else {
            ThreadPool.Worker[] threads = new ThreadPool.Worker[state.evalthreads];
            for (int i = 0; i < threads.length; ++i) {
                SimpleEvaluatorThread run = new SimpleEvaluatorThread();
                run.threadnum = i;
                run.state = state;
                run.prob = (SimpleProblemForm)this.p_problem.clone();
                threads[i] = this.pool.start((Runnable)run, "ECJ Evaluation Thread " + i);
            }
            this.pool.joinAll();
        }
        if (this.numTests > 1) {
            this.contract(state);
        }
    }

    public boolean runComplete(EvolutionState state) {
        for (int x = 0; x < state.population.subpops.length; ++x) {
            for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                if (!state.population.subpops[x].individuals[y].fitness.isIdealFitness()) continue;
                return true;
            }
        }
        return false;
    }

    protected void evalPopChunk(EvolutionState state, int[] numinds, int[] from, int threadnum, SimpleProblemForm p) {
        ((Problem)((Object)p)).prepareToEvaluate(state, threadnum);
        Subpopulation[] subpops = state.population.subpops;
        int len = subpops.length;
        for (int pop = 0; pop < len; ++pop) {
            int fp = from[pop];
            int upperbound = fp + numinds[pop];
            Individual[] inds = subpops[pop].individuals;
            for (int x = fp; x < upperbound; ++x) {
                p.evaluate(state, inds[x], pop, threadnum);
            }
        }
        ((Problem)((Object)p)).finishEvaluating(state, threadnum);
    }

    int computeChunkSizeForSubpopulation(EvolutionState state, int subpop, int threadnum) {
        int numThreads = state.evalthreads;
        int individualsPerThread = state.population.subpops[subpop].individuals.length / numThreads;
        int slop = state.population.subpops[subpop].individuals.length - numThreads * individualsPerThread;
        if (threadnum >= slop) {
            return individualsPerThread;
        }
        return individualsPerThread + 1;
    }

    class SimpleEvaluatorThread
    implements Runnable {
        public int threadnum;
        public EvolutionState state;
        public SimpleProblemForm prob = null;

        SimpleEvaluatorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Subpopulation[] subpops = this.state.population.subpops;
            int[] numinds = new int[subpops.length];
            int[] from = new int[subpops.length];
            int count = 1;
            int start = 0;
            int subpop = 0;
            while (true) {
                Object[] objectArray = SimpleEvaluator.this.lock;
                // MONITORENTER : SimpleEvaluator.this.lock
                if (SimpleEvaluator.this.subPopCounter >= subpops.length) {
                    // MONITOREXIT : objectArray
                    return;
                }
                if (SimpleEvaluator.this.individualCounter >= subpops[SimpleEvaluator.this.subPopCounter].individuals.length) {
                    SimpleEvaluator.this.individualCounter = 0;
                    ++SimpleEvaluator.this.subPopCounter;
                    if (SimpleEvaluator.this.subPopCounter >= subpops.length) {
                        // MONITOREXIT : objectArray
                        return;
                    }
                }
                start = SimpleEvaluator.this.individualCounter;
                subpop = SimpleEvaluator.this.subPopCounter;
                count = SimpleEvaluator.this.chunkSize;
                if (count == 0) {
                    count = SimpleEvaluator.this.computeChunkSizeForSubpopulation(this.state, subpop, this.threadnum);
                }
                SimpleEvaluator.this.individualCounter += count;
                // MONITOREXIT : objectArray
                if (count >= subpops[subpop].individuals.length - start) {
                    count = subpops[subpop].individuals.length - start;
                }
                for (int i = 0; i < from.length; ++i) {
                    numinds[i] = 0;
                }
                numinds[subpop] = count;
                from[subpop] = start;
                SimpleEvaluator.this.evalPopChunk(this.state, numinds, from, this.threadnum, this.prob);
            }
        }
    }
}

