/*
 * Decompiled with CFR 0.152.
 */
package ec.steadystate;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.steadystate.SteadyStateBreeder;
import ec.steadystate.SteadyStateDefaults;
import ec.steadystate.SteadyStateEvaluator;
import ec.steadystate.SteadyStateExchangerForm;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Checkpoint;
import ec.util.Parameter;
import java.util.HashMap;

public class SteadyStateEvolutionState
extends EvolutionState {
    public static final String P_REPLACEMENT_PROBABILITY = "replacement-probability";
    public boolean generationBoundary;
    public int generationSize;
    public long evaluations;
    public double replacementProbability;
    int[] individualCount;
    HashMap[] individualHash;
    int whichSubpop;
    protected boolean firstTime;
    boolean justCalledPostEvaluationStatistics = false;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.breeder instanceof SteadyStateBreeder)) {
            state.output.error("You've chosen to use Steady-State Evolution, but your breeder is not of the class SteadyStateBreeder.", base);
        }
        if (!(this.evaluator instanceof SteadyStateEvaluator)) {
            state.output.error("You've chosen to use Steady-State Evolution, but your evaluator is not of the class SteadyStateEvaluator.", base);
        }
        if (!(this.exchanger instanceof SteadyStateExchangerForm)) {
            state.output.error("You've chosen to use Steady-State Evolution, but your exchanger does not implement the SteadyStateExchangerForm.", base);
        }
        this.checkStatistics(state, this.statistics, new Parameter("stat"));
        if (this.parameters.exists(SteadyStateDefaults.base().push(P_REPLACEMENT_PROBABILITY), null)) {
            this.replacementProbability = this.parameters.getDoubleWithMax(SteadyStateDefaults.base().push(P_REPLACEMENT_PROBABILITY), null, 0.0, 1.0);
            if (this.replacementProbability < 0.0) {
                state.output.error("Replacement probability must be between 0.0 and 1.0 inclusive.", SteadyStateDefaults.base().push(P_REPLACEMENT_PROBABILITY), null);
            }
        } else {
            this.replacementProbability = 1.0;
            state.output.message("Replacement probability not defined: using 1.0 (always replace)");
        }
    }

    void checkStatistics(EvolutionState state, Statistics stat, Parameter base) {
        if (!(stat instanceof SteadyStateStatisticsForm)) {
            state.output.warning("You've chosen to use Steady-State Evolution, but your statistics does not implement the SteadyStateStatisticsForm.", base);
        }
        for (int x = 0; x < stat.children.length; ++x) {
            if (stat.children[x] == null) continue;
            this.checkStatistics(state, stat.children[x], base.push("child").push("" + x));
        }
    }

    public void startFresh() {
        this.output.message("Setting up");
        this.setup(this, null);
        this.output.message("Initializing Generation 0");
        this.statistics.preInitializationStatistics(this);
        this.population = this.initializer.setupPopulation(this, 0);
        this.generationSize = 0;
        this.generationBoundary = false;
        this.firstTime = true;
        this.evaluations = 0L;
        this.whichSubpop = -1;
        this.individualHash = new HashMap[this.population.subpops.length];
        for (int i = 0; i < this.population.subpops.length; ++i) {
            this.individualHash[i] = new HashMap();
        }
        this.individualCount = new int[this.population.subpops.length];
        for (int sub = 0; sub < this.population.subpops.length; ++sub) {
            this.individualCount[sub] = 0;
            this.generationSize += this.population.subpops[sub].individuals.length;
        }
        if (this.numEvaluations > 0L && this.numEvaluations < (long)this.generationSize) {
            this.output.fatal("Number of evaluations desired is smaller than the initial population of individuals");
        }
        this.exchanger.initializeContacts(this);
        this.evaluator.initializeContacts(this);
    }

    public int evolve() {
        Individual ind;
        boolean partiallyFullSubpop;
        if (this.generationBoundary && this.generation > 0) {
            this.output.message("Generation " + this.generation + "\tEvaluations " + this.evaluations);
            this.statistics.generationBoundaryStatistics(this);
            this.statistics.postEvaluationStatistics(this);
            this.justCalledPostEvaluationStatistics = true;
        } else {
            this.justCalledPostEvaluationStatistics = false;
        }
        if (this.firstTime) {
            if (this.statistics instanceof SteadyStateStatisticsForm) {
                ((SteadyStateStatisticsForm)((Object)this.statistics)).enteringInitialPopulationStatistics(this);
            }
            this.statistics.postInitializationStatistics(this);
            ((SteadyStateBreeder)this.breeder).prepareToBreed(this, 0);
            ((SteadyStateEvaluator)this.evaluator).prepareToEvaluate(this, 0);
            this.firstTime = false;
        }
        this.whichSubpop = (this.whichSubpop + 1) % this.population.subpops.length;
        boolean bl = partiallyFullSubpop = this.individualCount[this.whichSubpop] < this.population.subpops[this.whichSubpop].individuals.length;
        if (((SteadyStateEvaluator)this.evaluator).canEvaluate()) {
            ind = null;
            int numDuplicateRetries = this.population.subpops[this.whichSubpop].numDuplicateRetries;
            for (int tries = 0; tries <= numDuplicateRetries; ++tries) {
                Object o;
                if (partiallyFullSubpop) {
                    ind = this.population.subpops[this.whichSubpop].species.newIndividual((EvolutionState)this, 0);
                } else {
                    ind = ((SteadyStateBreeder)this.breeder).breedIndividual(this, this.whichSubpop, 0);
                    this.statistics.individualsBredStatistics(this, new Individual[]{ind});
                }
                if (numDuplicateRetries < 1 || (o = this.individualHash[this.whichSubpop].get(ind)) != null) continue;
                this.individualHash[this.whichSubpop].put(ind, ind);
                break;
            }
            ((SteadyStateEvaluator)this.evaluator).evaluateIndividual(this, ind, this.whichSubpop);
        }
        if ((ind = ((SteadyStateEvaluator)this.evaluator).getNextEvaluatedIndividual()) != null) {
            int subpop = ((SteadyStateEvaluator)this.evaluator).getSubpopulationOfEvaluatedIndividual();
            if (partiallyFullSubpop) {
                int n = subpop;
                int n2 = this.individualCount[n];
                this.individualCount[n] = n2 + 1;
                this.population.subpops[subpop].individuals[n2] = ind;
                if (this.individualCount[subpop] == this.population.subpops[subpop].individuals.length && this.statistics instanceof SteadyStateStatisticsForm) {
                    ((SteadyStateStatisticsForm)((Object)this.statistics)).enteringSteadyStateStatistics(subpop, this);
                }
            } else {
                int deadIndividual = ((SteadyStateBreeder)this.breeder).deselectors[subpop].produce(subpop, this, 0);
                Individual deadInd = this.population.subpops[subpop].individuals[deadIndividual];
                if (ind.fitness.betterThan(deadInd.fitness) || this.random[0].nextDouble() < this.replacementProbability) {
                    this.population.subpops[subpop].individuals[deadIndividual] = ind;
                }
                this.individualHash[subpop].remove(deadInd);
                if (this.statistics instanceof SteadyStateStatisticsForm) {
                    ((SteadyStateStatisticsForm)((Object)this.statistics)).individualsEvaluatedStatistics(this, new Individual[]{ind}, new Individual[]{deadInd}, new int[]{subpop}, new int[]{deadIndividual});
                }
            }
            ++this.evaluations;
            this.generationBoundary = this.evaluations % (long)this.generationSize == 0L;
        } else {
            this.generationBoundary = false;
        }
        if (!partiallyFullSubpop && this.evaluator.runComplete(this) && this.quitOnRunComplete) {
            this.output.message("Found Ideal Individual");
            return 0;
        }
        if (this.numEvaluations > 0L && this.evaluations >= this.numEvaluations || this.numEvaluations <= 0L && this.generationBoundary && this.generation == this.numGenerations - 1) {
            if (this.generationBoundary) {
                ++this.generation;
            }
            return 1;
        }
        if (this.generationBoundary) {
            this.statistics.prePreBreedingExchangeStatistics(this);
            this.population = this.exchanger.preBreedingExchangePopulation(this);
            this.statistics.postPreBreedingExchangeStatistics(this);
            String exchangerWantsToShutdown = this.exchanger.runComplete(this);
            if (exchangerWantsToShutdown != null) {
                this.output.message(exchangerWantsToShutdown);
                return 0;
            }
            this.statistics.prePostBreedingExchangeStatistics(this);
            this.population = this.exchanger.postBreedingExchangePopulation(this);
            this.statistics.postPostBreedingExchangeStatistics(this);
            ++this.generation;
            if (this.checkpoint && this.generation % this.checkpointModulo == 0) {
                this.output.message("Checkpointing");
                this.statistics.preCheckpointStatistics(this);
                Checkpoint.setCheckpoint(this);
                this.statistics.postCheckpointStatistics(this);
            }
        }
        return 2;
    }

    public void finish(int result) {
        ((SteadyStateBreeder)this.breeder).finishPipelines(this);
        if (!this.justCalledPostEvaluationStatistics) {
            this.output.message("Generation " + this.generation + "\tEvaluations " + this.evaluations);
            this.statistics.postEvaluationStatistics(this);
        }
        this.statistics.finalStatistics(this, result);
        this.finisher.finishPopulation(this, result);
        this.exchanger.closeContacts(this, result);
        this.evaluator.closeContacts(this, result);
    }
}

