/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.EvolutionState;
import ec.util.DecodeReturn;
import java.io.IOException;
import java.io.LineNumberReader;

public class Code {
    public static String encode(boolean b) {
        return b ? "T" : "F";
    }

    public static String encode(byte b) {
        return "b" + Byte.toString(b) + "|";
    }

    public static String encode(char c) {
        if (c >= ' ' && c < '\u007f' && c != '\\' && c != '\'') {
            return "'" + String.valueOf(c) + "'";
        }
        if (c == '\b') {
            return "'\\b'";
        }
        if (c == '\n') {
            return "'\\n'";
        }
        if (c == '\t') {
            return "'\\t'";
        }
        if (c == '\'') {
            return "'\\''";
        }
        if (c == '\\') {
            return "'\\\\'";
        }
        if (c == '\u0000') {
            return "'\\\\0";
        }
        String s = Integer.toHexString(c);
        switch (s.length()) {
            case 1: {
                s = "'\\u000" + s + "'";
                break;
            }
            case 2: {
                s = "'\\u00" + s + "'";
                break;
            }
            case 3: {
                s = "'\\u0" + s + "'";
                break;
            }
            case 4: {
                s = "'\\u" + s + "'";
                break;
            }
            default: {
                throw new RuntimeException("Default case should never occur");
            }
        }
        return s;
    }

    public static String encode(short s) {
        return "s" + Short.toString(s) + "|";
    }

    public static String encode(int i) {
        return "i" + Integer.toString(i) + "|";
    }

    public static String encode(long l) {
        return "l" + Long.toString(l) + "|";
    }

    public static String encode(float f) {
        return "f" + Integer.toString(Float.floatToIntBits(f)) + "|" + String.valueOf(f) + "|";
    }

    public static String encode(double d) {
        return "d" + Long.toString(Double.doubleToLongBits(d)) + "|" + String.valueOf(d) + "|";
    }

    public static String encode(String s) {
        boolean inUnicode = false;
        int l = s.length();
        StringBuilder sb = new StringBuilder(l);
        sb.append("\"");
        block6: for (int x = 0; x < l; ++x) {
            char c = s.charAt(x);
            if (c >= ' ' && c < '\u007f' && c != '\\' && c != '\"') {
                if (inUnicode) {
                    sb.append("\\u");
                    inUnicode = false;
                }
                sb.append(c);
                continue;
            }
            if (c == '\b') {
                if (inUnicode) {
                    sb.append("\\u");
                    inUnicode = false;
                }
                sb.append("\\b");
                continue;
            }
            if (c == '\n') {
                if (inUnicode) {
                    sb.append("\\u");
                    inUnicode = false;
                }
                sb.append("\\n");
                continue;
            }
            if (c == '\t') {
                if (inUnicode) {
                    sb.append("\\u");
                    inUnicode = false;
                }
                sb.append("\\t");
                continue;
            }
            if (c == '\"') {
                if (inUnicode) {
                    sb.append("\\u");
                    inUnicode = false;
                }
                sb.append("\\\"");
                continue;
            }
            if (c == '\\') {
                if (inUnicode) {
                    sb.append("\\u");
                    inUnicode = false;
                }
                sb.append("\\\\");
                continue;
            }
            if (c == '\u0000') {
                if (inUnicode) {
                    sb.append("\\u");
                    inUnicode = false;
                }
                sb.append("\\0");
                continue;
            }
            if (!inUnicode) {
                sb.append("\\u");
                inUnicode = true;
            }
            String ss = Integer.toHexString(c);
            switch (ss.length()) {
                case 1: {
                    sb.append("000" + ss);
                    continue block6;
                }
                case 2: {
                    sb.append("00" + ss);
                    continue block6;
                }
                case 3: {
                    sb.append("0" + ss);
                    continue block6;
                }
                case 4: {
                    sb.append(ss);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Default case should never occur");
                }
            }
        }
        if (inUnicode) {
            sb.append("\\u");
        }
        sb.append("\"");
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static void decode(DecodeReturn d) {
        dat = d.data;
        len = d.data.length();
        for (x = d.pos; x < len && Character.isWhitespace(dat.charAt(x)); ++x) {
        }
        if (x == len) {
            d.type = (byte)-1;
            d.s = "Out of tokens";
            return;
        }
        switch (dat.charAt(x)) {
            case 't': {
                if (x + 3 < len && dat.charAt(x + 1) == 'r' && dat.charAt(x + 2) == 'u' && dat.charAt(x + 3) == 'e') {
                    d.type = 0;
                    d.l = 1L;
                    d.pos = x + 4;
                    return;
                }
                d.type = (byte)-1;
                d.s = "Expected a (true) boolean";
                return;
            }
            case 'T': {
                d.type = 0;
                d.l = 1L;
                d.pos = x + 1;
                return;
            }
            case 'F': {
                d.type = 0;
                d.l = 0L;
                d.pos = x + 1;
                return;
            }
            case 'f': {
                if (x + 4 < len && dat.charAt(x + 1) == 'a' && dat.charAt(x + 2) == 'l' && dat.charAt(x + 3) == 's' && dat.charAt(x + 4) == 'e') {
                    d.type = 0;
                    d.l = 0L;
                    d.pos = x + 5;
                    return;
                }
                readHuman = false;
                sf = null;
                initial = x + 1;
                while (x < len && dat.charAt(x) != '|') {
                    ++x;
                }
                if (x == initial) {
                    readHuman = true;
                }
                if (x >= len) {
                    d.type = (byte)-1;
                    d.s = "Expected a float";
                    return;
                }
                if (!readHuman) {
                    sf = dat.substring(initial, x);
                }
                initial2 = ++x;
                while (x < len && dat.charAt(x) != '|') {
                    ++x;
                }
                if (x >= len) {
                    d.type = (byte)-1;
                    d.s = "Expected a float";
                    return;
                }
                if (readHuman) {
                    sf = dat.substring(initial2, x);
                }
                try {
                    f = readHuman ? Float.parseFloat(sf) : Float.intBitsToFloat(Integer.parseInt(sf));
                }
                catch (NumberFormatException e) {
                    d.type = (byte)-1;
                    d.s = "Expected a float";
                    return;
                }
                d.type = (byte)6;
                d.d = f;
                d.pos = x + 1;
                return;
            }
            case 'd': {
                readHuman = false;
                sf = null;
                initial = x + 1;
                while (x < len && dat.charAt(x) != '|') {
                    ++x;
                }
                if (x == initial) {
                    readHuman = true;
                }
                if (x >= len) {
                    d.type = (byte)-1;
                    d.s = "Expected a double";
                    return;
                }
                if (!readHuman) {
                    sf = dat.substring(initial, x);
                }
                initial2 = ++x;
                while (x < len && dat.charAt(x) != '|') {
                    ++x;
                }
                if (x >= len) {
                    d.type = (byte)-1;
                    d.s = "Expected a double";
                    return;
                }
                if (readHuman) {
                    sf = dat.substring(initial2, x);
                }
                try {
                    f = readHuman ? Double.parseDouble(sf) : Double.longBitsToDouble(Long.parseLong(sf));
                }
                catch (NumberFormatException e) {
                    d.type = (byte)-1;
                    d.s = "Expected a double";
                    return;
                }
                d.type = (byte)7;
                d.d = f;
                d.pos = x + 1;
                return;
            }
            case 'b': {
                initial = x + 1;
                while (x < len && dat.charAt(x) != '|') {
                    ++x;
                }
                if (x >= len) {
                    d.type = (byte)-1;
                    d.s = "Expected a byte";
                    return;
                }
                sf = dat.substring(initial, x);
                try {
                    f = Byte.parseByte(sf);
                }
                catch (NumberFormatException e) {
                    d.type = (byte)-1;
                    d.s = "Expected a byte";
                    return;
                }
                d.type = 1;
                d.l = f;
                d.pos = x + 1;
                return;
            }
            case 's': {
                initial = x + 1;
                while (x < len && dat.charAt(x) != '|') {
                    ++x;
                }
                if (x >= len) {
                    d.type = (byte)-1;
                    d.s = "Expected a short";
                    return;
                }
                sf = dat.substring(initial, x);
                try {
                    f = Short.parseShort(sf);
                }
                catch (NumberFormatException e) {
                    d.type = (byte)-1;
                    d.s = "Expected a short";
                    return;
                }
                d.type = (byte)3;
                d.l = f;
                d.pos = x + 1;
                return;
            }
            case 'i': {
                initial = x + 1;
                while (x < len && dat.charAt(x) != '|') {
                    ++x;
                }
                if (x >= len) {
                    d.type = (byte)-1;
                    d.s = "Expected an int";
                    return;
                }
                sf = dat.substring(initial, x);
                try {
                    f = Integer.parseInt(sf);
                }
                catch (NumberFormatException e) {
                    d.type = (byte)-1;
                    d.s = "Expected an int";
                    return;
                }
                d.type = (byte)4;
                d.l = f;
                d.pos = x + 1;
                return;
            }
            case 'l': {
                initial = x + 1;
                while (x < len && dat.charAt(x) != '|') {
                    ++x;
                }
                if (x >= len) {
                    d.type = (byte)-1;
                    d.s = "Expected a long";
                    return;
                }
                sf = dat.substring(initial, x);
                try {
                    f = Long.parseLong(sf);
                }
                catch (NumberFormatException e) {
                    d.type = (byte)-1;
                    d.s = "Expected a long";
                    return;
                }
                d.type = (byte)5;
                d.l = f;
                d.pos = x + 1;
                return;
            }
            case '\"': {
                sb = new StringBuilder();
                inUnicode = false;
                ++x;
                while (x < len) {
                    c = dat.charAt(x);
                    if (c == '\"') {
                        if (inUnicode) {
                            d.type = (byte)-1;
                            d.s = "Forgot to terminate Unicode with a '\\u' in the string";
                            return;
                        }
                        d.type = (byte)8;
                        d.s = sb.toString();
                        d.pos = x + 1;
                        return;
                    }
                    if (c != '\\') ** GOTO lbl250
                    if (++x >= len) {
                        d.type = (byte)-1;
                        d.s = "Unterminated String";
                        return;
                    }
                    if (dat.charAt(x) != 'u' && inUnicode) {
                        d.type = (byte)-1;
                        d.s = "Escape character in Unicode sequence";
                        return;
                    }
                    switch (dat.charAt(x)) {
                        case 'u': {
                            inUnicode = inUnicode == false;
                            ** GOTO lbl266
                        }
                        case 'b': {
                            sb.append('\b');
                            ** GOTO lbl266
                        }
                        case 'n': {
                            sb.append('\n');
                            ** GOTO lbl266
                        }
                        case '\"': {
                            sb.append('\"');
                            ** GOTO lbl266
                        }
                        case '\'': {
                            sb.append('\'');
                            ** GOTO lbl266
                        }
                        case 't': {
                            sb.append('\t');
                            ** GOTO lbl266
                        }
                        case '\\': {
                            sb.append('\\');
                            ** GOTO lbl266
                        }
                        case '0': {
                            sb.append('\u0000');
                            ** GOTO lbl266
                        }
                        default: {
                            d.type = (byte)-1;
                            d.s = "Bad escape char in String";
                            return;
                        }
                    }
lbl250:
                    // 1 sources

                    if (inUnicode) {
                        if (x + 3 >= len) {
                            d.type = (byte)-1;
                            d.s = "Unterminated String";
                            return;
                        }
                        try {
                            sb.append((char)Integer.decode("0x" + c + dat.charAt(x + 1) + dat.charAt(x + 2) + dat.charAt(x + 3)).intValue());
                            x += 3;
                        }
                        catch (NumberFormatException e) {
                            d.type = (byte)-1;
                            d.s = "Bad Unicode in String";
                            return;
                        }
                    } else {
                        sb.append(c);
                    }
lbl266:
                    // 10 sources

                    ++x;
                }
                d.type = (byte)-1;
                d.s = "Unterminated String";
                return;
            }
            case '\'': {
                if (++x >= len) {
                    d.type = (byte)-1;
                    d.s = "Unterminated char";
                    return;
                }
                c = dat.charAt(x);
                if (c == 92) {
                    if (++x >= len) {
                        d.type = (byte)-1;
                        d.s = "Unterminated char";
                        return;
                    }
                    switch (dat.charAt(x)) {
                        case 'u': {
                            if (x + 4 >= len) {
                                d.type = (byte)-1;
                                d.s = "Unterminated char";
                                return;
                            }
                            try {
                                c = (char)Integer.decode("0x" + dat.charAt(x + 1) + dat.charAt(x + 2) + dat.charAt(x + 3) + dat.charAt(x + 4)).intValue();
                            }
                            catch (NumberFormatException e) {
                                d.type = (byte)-1;
                                d.s = "Bad Unicode in char";
                                return;
                            }
                            x += 5;
                            break;
                        }
                        case 'b': {
                            c = 8;
                            ++x;
                            break;
                        }
                        case 'n': {
                            c = 10;
                            ++x;
                            break;
                        }
                        case '\"': {
                            c = 34;
                            ++x;
                            break;
                        }
                        case '\'': {
                            c = 39;
                            ++x;
                            break;
                        }
                        case 't': {
                            c = 9;
                            ++x;
                            break;
                        }
                        case '\\': {
                            c = 92;
                            ++x;
                            break;
                        }
                        case '0': {
                            c = 0;
                            ++x;
                            break;
                        }
                        default: {
                            d.type = (byte)-1;
                            d.s = "Bad escape char in char";
                            return;
                        }
                    }
                    if (dat.charAt(x) != '\'') {
                        d.type = (byte)-1;
                        d.s = "Bad char";
                        return;
                    }
                    d.type = (byte)2;
                    d.l = c;
                    d.pos = x + 1;
                    return;
                }
                if (++x >= len) {
                    d.type = (byte)-1;
                    d.s = "Unterminated char";
                    return;
                }
                if (dat.charAt(x) != '\'') {
                    d.type = (byte)-1;
                    d.s = "Bad char";
                    return;
                }
                d.type = (byte)2;
                d.l = c;
                d.pos = x + 1;
                return;
            }
        }
        d.type = (byte)-1;
        d.s = "Unknown token";
    }

    public static DecodeReturn checkPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        int linenumber = 0;
        try {
            String s = "";
            while (s != null && s.trim().equals("")) {
                linenumber = reader.getLineNumber();
                s = reader.readLine();
            }
            if (s == null || !(s = s.trim()).startsWith(preamble)) {
                state.output.fatal("Line " + linenumber + " has a bad preamble.Expected '" + preamble + "'\n-->" + s);
            }
            DecodeReturn d = new DecodeReturn(s, preamble.length());
            d.lineNumber = linenumber;
            return d;
        }
        catch (IOException e) {
            state.output.fatal("On line " + linenumber + " an IO error occurred:\n\n" + e);
            return null;
        }
    }

    public static String readStringWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 8) {
            state.output.fatal("Line " + d.lineNumber + " has no string after preamble '" + preamble + "'\n-->" + d.data);
        }
        return d.s;
    }

    public static char readCharacterWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 2) {
            state.output.fatal("Line " + d.lineNumber + " has no character after preamble '" + preamble + "'\n-->" + d.data);
        }
        return (char)d.l;
    }

    public static byte readByteWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 1) {
            state.output.fatal("Line " + d.lineNumber + " has no byte after preamble '" + preamble + "'\n-->" + d.data);
        }
        return (byte)d.l;
    }

    public static short readShortWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 3) {
            state.output.fatal("Line " + d.lineNumber + " has no short after preamble '" + preamble + "'\n-->" + d.data);
        }
        return (short)d.l;
    }

    public static long readLongWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 5) {
            state.output.fatal("Line " + d.lineNumber + " has no long after preamble '" + preamble + "'\n-->" + d.data);
        }
        return d.l;
    }

    public static int readIntegerWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Line " + d.lineNumber + " has no integer after preamble '" + preamble + "'\n-->" + d.data);
        }
        return (int)d.l;
    }

    public static float readFloatWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 6) {
            state.output.fatal("Line " + d.lineNumber + " has no floating point number after preamble '" + preamble + "'\n-->" + d.data);
        }
        return (float)d.d;
    }

    public static double readDoubleWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 7) {
            state.output.fatal("Line " + d.lineNumber + " has no double floating point number after preamble '" + preamble + "'. -->" + d.data);
        }
        return d.d;
    }

    public static boolean readBooleanWithPreamble(String preamble, EvolutionState state, LineNumberReader reader) {
        DecodeReturn d = Code.checkPreamble(preamble, state, reader);
        Code.decode(d);
        if (d.type != 0) {
            state.output.fatal("Line " + d.lineNumber + " has no boolean value ('true' or 'false') after preamble '" + preamble + "'\n-->" + d.data);
        }
        return d.l != 0L;
    }
}

