/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.RandomChoiceChooser;
import ec.util.RandomChoiceChooserD;

public class RandomChoice {
    public static final int CHECKBOUNDARY = 8;

    public static void organizeDistribution(float[] probabilities) {
        RandomChoice.organizeDistribution(probabilities, false);
    }

    public static void organizeDistribution(float[] probabilities, boolean allowAllZeros) {
        int x;
        double sum = 0.0;
        if (probabilities.length == 0) {
            throw new ArithmeticException("Distribution has no elements");
        }
        for (x = 0; x < probabilities.length; ++x) {
            if ((double)probabilities[x] < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            sum += (double)probabilities[x];
        }
        if (sum == 0.0) {
            if (!allowAllZeros) {
                throw new ArithmeticException("Distribution has all zero probabilities");
            }
            for (x = 0; x < probabilities.length; ++x) {
                probabilities[x] = 1.0f;
            }
            sum = probabilities.length;
        }
        x = 0;
        while (x < probabilities.length) {
            int n = x++;
            probabilities[n] = (float)((double)probabilities[n] / sum);
        }
        sum = 0.0;
        for (x = 0; x < probabilities.length; ++x) {
            probabilities[x] = (float)(sum += (double)probabilities[x]);
        }
        for (x = probabilities.length - 1; x > 0 && probabilities[x] == probabilities[x - 1]; --x) {
            probabilities[x] = 1.0f;
        }
        probabilities[x] = 1.0f;
    }

    public static void organizeDistribution(double[] probabilities) {
        RandomChoice.organizeDistribution(probabilities, false);
    }

    public static void organizeDistribution(double[] probabilities, boolean allowAllZeros) {
        int x;
        double sum = 0.0;
        if (probabilities.length == 0) {
            throw new ArithmeticException("Distribution has no elements");
        }
        for (x = 0; x < probabilities.length; ++x) {
            if (probabilities[x] < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            sum += probabilities[x];
        }
        if (sum == 0.0) {
            if (!allowAllZeros) {
                throw new ArithmeticException("Distribution has all zero probabilities");
            }
            for (x = 0; x < probabilities.length; ++x) {
                probabilities[x] = 1.0;
            }
            sum = probabilities.length;
        }
        x = 0;
        while (x < probabilities.length) {
            int n = x++;
            probabilities[n] = probabilities[n] / sum;
        }
        sum = 0.0;
        for (x = 0; x < probabilities.length; ++x) {
            probabilities[x] = sum += probabilities[x];
        }
        for (x = probabilities.length - 1; x > 0 && probabilities[x] == probabilities[x - 1]; --x) {
            probabilities[x] = 1.0;
        }
        probabilities[x] = 1.0;
    }

    public static void organizeDistribution(Object[] objs, RandomChoiceChooser chooser) {
        RandomChoice.organizeDistribution(objs, chooser, false);
    }

    public static void organizeDistribution(Object[] objs, RandomChoiceChooser chooser, boolean allowAllZeros) {
        int x;
        double sum = 0.0;
        if (objs.length == 0) {
            throw new ArithmeticException("Distribution has no elements");
        }
        for (x = 0; x < objs.length; ++x) {
            if ((double)chooser.getProbability(objs[x]) < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            sum += (double)chooser.getProbability(objs[x]);
        }
        if (sum == 0.0) {
            if (!allowAllZeros) {
                throw new ArithmeticException("Distribution has all zero probabilities");
            }
            for (x = 0; x < objs.length; ++x) {
                chooser.setProbability(objs[x], 1.0f);
            }
            sum = objs.length;
        }
        for (x = 0; x < objs.length; ++x) {
            chooser.setProbability(objs[x], (float)((double)chooser.getProbability(objs[x]) / sum));
        }
        sum = 0.0;
        for (x = 0; x < objs.length; ++x) {
            chooser.setProbability(objs[x], (float)(sum += (double)chooser.getProbability(objs[x])));
        }
        for (x = objs.length - 1; x > 0 && chooser.getProbability(objs[x]) == chooser.getProbability(objs[x - 1]); --x) {
            chooser.setProbability(objs[x], 1.0f);
        }
        chooser.setProbability(objs[x], 1.0f);
    }

    public static void organizeDistribution(Object[] objs, RandomChoiceChooserD chooser) {
        RandomChoice.organizeDistribution(objs, chooser, false);
    }

    public static void organizeDistribution(Object[] objs, RandomChoiceChooserD chooser, boolean allowAllZeros) {
        int x;
        double sum = 0.0;
        if (objs.length == 0) {
            throw new ArithmeticException("Distribution has no elements");
        }
        for (x = 0; x < objs.length; ++x) {
            if (chooser.getProbability(objs[x]) < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            sum += chooser.getProbability(objs[x]);
        }
        if (sum == 0.0) {
            if (!allowAllZeros) {
                throw new ArithmeticException("Distribution has all zero probabilities");
            }
            for (x = 0; x < objs.length; ++x) {
                chooser.setProbability(objs[x], 1.0);
            }
            sum = objs.length;
        }
        for (x = 0; x < objs.length; ++x) {
            chooser.setProbability(objs[x], chooser.getProbability(objs[x]) / sum);
        }
        sum = 0.0;
        for (x = 0; x < objs.length; ++x) {
            chooser.setProbability(objs[x], sum += chooser.getProbability(objs[x]));
        }
        for (x = objs.length - 1; x > 0 && chooser.getProbability(objs[x]) == chooser.getProbability(objs[x - 1]); --x) {
            chooser.setProbability(objs[x], 1.0);
        }
        chooser.setProbability(objs[x], 1.0);
    }

    private static final int exemptZeroes(float[] probabilities, int index) {
        if (probabilities[index] == 0.0f) {
            while (index < probabilities.length - 1 && probabilities[index] == 0.0f) {
                ++index;
            }
        } else {
            while (index > 0 && probabilities[index] == probabilities[index - 1]) {
                --index;
            }
        }
        return index;
    }

    private static final int exemptZeroes(double[] probabilities, int index) {
        if (probabilities[index] == 0.0) {
            while (index < probabilities.length - 1 && probabilities[index] == 0.0) {
                ++index;
            }
        } else {
            while (index > 0 && probabilities[index] == probabilities[index - 1]) {
                --index;
            }
        }
        return index;
    }

    private static final int exemptZeroes(Object[] objs, RandomChoiceChooser chooser, int index) {
        if (chooser.getProbability(objs[index]) == 0.0f) {
            while (index < objs.length - 1 && chooser.getProbability(objs[index]) == 0.0f) {
                ++index;
            }
        } else {
            while (index > 0 && chooser.getProbability(objs[index]) == chooser.getProbability(objs[index - 1])) {
                --index;
            }
        }
        return index;
    }

    private static final int exemptZeroes(Object[] objs, RandomChoiceChooserD chooser, int index) {
        if (chooser.getProbability(objs[index]) == 0.0) {
            while (index < objs.length - 1 && chooser.getProbability(objs[index]) == 0.0) {
                ++index;
            }
        } else {
            while (index > 0 && chooser.getProbability(objs[index]) == chooser.getProbability(objs[index - 1])) {
                --index;
            }
        }
        return index;
    }

    public static int pickFromDistribution(float[] probabilities, float prob) {
        return RandomChoice.pickFromDistribution(probabilities, prob, 8);
    }

    public static int pickFromDistribution(float[] probabilities, float prob, int checkboundary) {
        if (prob < 0.0f || prob > 1.0f) {
            throw new ArithmeticException("Invalid probability for pickFromDistribution (must be 0.0<=x<=1.0)");
        }
        if (probabilities.length == 1) {
            return 0;
        }
        if (probabilities.length < checkboundary) {
            for (int x = 0; x < probabilities.length - 1; ++x) {
                if (!(probabilities[x] > prob)) continue;
                return RandomChoice.exemptZeroes(probabilities, x);
            }
            return RandomChoice.exemptZeroes(probabilities, probabilities.length - 1);
        }
        int top = probabilities.length - 1;
        int bottom = 0;
        while (top != bottom) {
            int cur = (top + bottom) / 2;
            if (probabilities[cur] > prob) {
                if (cur == 0 || probabilities[cur - 1] <= prob) {
                    return RandomChoice.exemptZeroes(probabilities, cur);
                }
                top = cur;
                continue;
            }
            if (cur == probabilities.length - 1) {
                return RandomChoice.exemptZeroes(probabilities, cur);
            }
            if (bottom == cur) {
                ++bottom;
                continue;
            }
            bottom = cur;
        }
        return RandomChoice.exemptZeroes(probabilities, bottom);
    }

    public static int pickFromDistribution(double[] probabilities, double prob) {
        return RandomChoice.pickFromDistribution(probabilities, prob, 8);
    }

    public static int pickFromDistribution(double[] probabilities, double prob, int checkboundary) {
        if (prob < 0.0 || prob > 1.0) {
            throw new ArithmeticException("Invalid probability for pickFromDistribution (must be 0.0<=x<=1.0)");
        }
        if (probabilities.length == 1) {
            return 0;
        }
        if (probabilities.length < checkboundary) {
            for (int x = 0; x < probabilities.length - 1; ++x) {
                if (!(probabilities[x] > prob)) continue;
                return RandomChoice.exemptZeroes(probabilities, x);
            }
            return RandomChoice.exemptZeroes(probabilities, probabilities.length - 1);
        }
        int top = probabilities.length - 1;
        int bottom = 0;
        while (top != bottom) {
            int cur = (top + bottom) / 2;
            if (probabilities[cur] > prob) {
                if (cur == 0 || probabilities[cur - 1] <= prob) {
                    return RandomChoice.exemptZeroes(probabilities, cur);
                }
                top = cur;
                continue;
            }
            if (cur == probabilities.length - 1) {
                return RandomChoice.exemptZeroes(probabilities, cur);
            }
            if (bottom == cur) {
                ++bottom;
                continue;
            }
            bottom = cur;
        }
        return RandomChoice.exemptZeroes(probabilities, bottom);
    }

    public static int pickFromDistribution(Object[] objs, RandomChoiceChooser chooser, float prob) {
        return RandomChoice.pickFromDistribution(objs, chooser, prob, 8);
    }

    public static int pickFromDistribution(Object[] objs, RandomChoiceChooser chooser, float prob, int checkboundary) {
        if (prob < 0.0f || prob > 1.0f) {
            throw new ArithmeticException("Invalid probability for pickFromDistribution (must be 0.0<=x<=1.0)");
        }
        if (objs.length == 1) {
            return 0;
        }
        if (objs.length < checkboundary) {
            for (int x = 0; x < objs.length - 1; ++x) {
                if (!(chooser.getProbability(objs[x]) > prob)) continue;
                return RandomChoice.exemptZeroes(objs, chooser, x);
            }
            return RandomChoice.exemptZeroes(objs, chooser, objs.length - 1);
        }
        int top = objs.length - 1;
        int bottom = 0;
        while (top != bottom) {
            int cur = (top + bottom) / 2;
            if (chooser.getProbability(objs[cur]) > prob) {
                if (cur == 0 || chooser.getProbability(objs[cur - 1]) <= prob) {
                    return RandomChoice.exemptZeroes(objs, chooser, cur);
                }
                top = cur;
                continue;
            }
            if (cur == objs.length - 1) {
                return RandomChoice.exemptZeroes(objs, chooser, cur);
            }
            if (bottom == cur) {
                ++bottom;
                continue;
            }
            bottom = cur;
        }
        return RandomChoice.exemptZeroes(objs, chooser, bottom);
    }

    public static int pickFromDistribution(Object[] objs, RandomChoiceChooserD chooser, double prob) {
        return RandomChoice.pickFromDistribution(objs, chooser, prob, 8);
    }

    public static int pickFromDistribution(Object[] objs, RandomChoiceChooserD chooser, double prob, int checkboundary) {
        if (prob < 0.0 || prob > 1.0) {
            throw new ArithmeticException("Invalid probability for pickFromDistribution (must be 0.0<=x<=1.0)");
        }
        if (objs.length == 1) {
            return 0;
        }
        if (objs.length < checkboundary) {
            for (int x = 0; x < objs.length - 1; ++x) {
                if (!(chooser.getProbability(objs[x]) > prob)) continue;
                return RandomChoice.exemptZeroes(objs, chooser, x);
            }
            return RandomChoice.exemptZeroes(objs, chooser, objs.length - 1);
        }
        int top = objs.length - 1;
        int bottom = 0;
        while (top != bottom) {
            int cur = (top + bottom) / 2;
            if (chooser.getProbability(objs[cur]) > prob) {
                if (cur == 0 || chooser.getProbability(objs[cur - 1]) <= prob) {
                    return RandomChoice.exemptZeroes(objs, chooser, cur);
                }
                top = cur;
                continue;
            }
            if (cur == objs.length - 1) {
                return RandomChoice.exemptZeroes(objs, chooser, cur);
            }
            if (bottom == cur) {
                ++bottom;
                continue;
            }
            bottom = cur;
        }
        return RandomChoice.exemptZeroes(objs, chooser, bottom);
    }
}

