/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.IntegerVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class LongVectorIndividual
extends VectorIndividual {
    public static final String P_LONGVECTORINDIVIDUAL = "long-vect-ind";
    public long[] genome;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_LONGVECTORINDIVIDUAL);
    }

    public Object clone() {
        LongVectorIndividual myobj = (LongVectorIndividual)super.clone();
        myobj.genome = (long[])this.genome.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!(this.species instanceof IntegerVectorSpecies)) {
            state.output.fatal("LongVectorIndividual requires an IntegerVectorSpecies", base, def);
        }
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        this.genome = new long[s.genomeSize];
    }

    long longFloor(double x) {
        long l = (long)x;
        if (x >= 0.0) {
            return l;
        }
        if (x < -9.223372036854776E18) {
            return Long.MIN_VALUE;
        }
        if ((double)l == x) {
            return l;
        }
        return l - 1L;
    }

    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        LongVectorIndividual i = (LongVectorIndividual)ind;
        int len = Math.min(this.genome.length, i.genome.length);
        if (len != this.genome.length || len != i.genome.length) {
            state.output.warnOnce("Genome lengths are not the same.  Vector crossover will only be done in overlapping region.");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    long tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 2: {
                int point = state.random[thread].nextInt(len / s.chunksize - 1) + 1;
                for (int x = 0; x < point * s.chunksize; ++x) {
                    long tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 4: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = state.random[thread].nextInt(len / s.chunksize);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    long tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 8: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = 0;
                while ((point0 = state.random[thread].nextInt(len / s.chunksize)) == point) {
                }
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    long tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < len / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        long tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
            case 256: {
                double alpha = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                double beta = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                for (int x = 0; x < len; ++x) {
                    long min = s.minGene(x);
                    long max = s.maxGene(x);
                    long t = this.longFloor(alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x] + 0.5);
                    long u = this.longFloor(beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x] + 0.5);
                    if (t < min || t > max || u < min || u > max) continue;
                    this.genome[x] = t;
                    i.genome[x] = u;
                }
                break;
            }
            case 512: {
                for (int x = 0; x < len; ++x) {
                    long u;
                    long max;
                    long min;
                    long t;
                    do {
                        double alpha = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        double beta = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        min = s.minGene(x);
                        max = s.maxGene(x);
                        t = this.longFloor(alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x] + 0.5);
                        u = this.longFloor(beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x] + 0.5);
                    } while (t < min || t > max || u < min || u > max);
                    this.genome[x] = t;
                    i.genome[x] = u;
                }
                break;
            }
        }
    }

    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new long[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((long[])pieces[x]).length;
        }
        int runningsum = 0;
        long[] newgenome = new long[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((long[])pieces[x]).length);
            runningsum += ((long[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    public long randomValueFromClosedInterval(long min, long max, MersenneTwisterFast random) {
        if (max - min < 0L) {
            long l = 0L;
            while ((l = random.nextLong()) < min || l > max) {
            }
            return l;
        }
        return min + random.nextLong(max - min + 1L);
    }

    public short randomValueFromClosedInterval(short min, short max, MersenneTwisterFast random) {
        if (max - min < 0) {
            short l = 0;
            while ((l = (short)random.nextInt()) < min || l > max) {
            }
            return l;
        }
        return (short)(min + random.nextInt(max - min + 1));
    }

    public void defaultMutate(EvolutionState state, int thread) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        block4: for (int x = 0; x < this.genome.length; ++x) {
            if (!state.random[thread].nextBoolean(s.mutationProbability(x))) continue;
            long old = this.genome[x];
            for (int retries = 0; retries < s.duplicateRetries(x) + 1; ++retries) {
                switch (s.mutationType(x)) {
                    case 0: {
                        this.genome[x] = this.randomValueFromClosedInterval(s.minGene(x), s.maxGene(x), state.random[thread]);
                        break;
                    }
                    case 1: {
                        long min = s.minGene(x);
                        long max = s.maxGene(x);
                        if (!s.mutationIsBounded(x)) {
                            max = Long.MAX_VALUE;
                            min = Long.MIN_VALUE;
                        }
                        do {
                            long n = state.random[thread].nextBoolean() ? 1L : -1L;
                            long g = this.genome[x];
                            if (n == 1L && g < max || n == -1L && g > min) {
                                this.genome[x] = g + n;
                                continue;
                            }
                            if ((n != -1L || g >= max) && (n != 1L || g <= min)) continue;
                            this.genome[x] = g - n;
                        } while (state.random[thread].nextBoolean(s.randomWalkProbability(x)));
                        break;
                    }
                    default: {
                        state.output.fatal("In LongVectorIndividual.defaultMutate, default case occurred when it shouldn't have");
                    }
                }
                if (this.genome[x] != old) continue block4;
            }
        }
    }

    public void reset(EvolutionState state, int thread) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = this.randomValueFromClosedInterval(s.minGene(x), s.maxGene(x), state.random[thread]);
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash << 1 | hash >>> 31;
        for (int x = 0; x < this.genome.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ (int)(this.genome[x] >>> 16 & 0xFFFFFFFFFFFFFFFFL) ^ (int)(this.genome[x] & 0xFFFFL);
        }
        return hash;
    }

    public String genotypeToStringForHumans() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.genome.length; ++i) {
            if (i > 0) {
                s.append(" ");
            }
            s.append(this.genome[i]);
        }
        return s.toString();
    }

    public String genotypeToString() {
        StringBuilder s = new StringBuilder();
        s.append(Code.encode(this.genome.length));
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(Code.encode(this.genome[i]));
        }
        return s.toString();
    }

    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Individual with genome:\n" + s + "\n... does not have an integer at the beginning indicating the genome count.");
        }
        int lll = (int)d.l;
        this.genome = new long[lll];
        for (int i = 0; i < this.genome.length; ++i) {
            Code.decode(d);
            this.genome[i] = d.l;
        }
    }

    public boolean equals(Object ind) {
        if (ind == null) {
            return false;
        }
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        LongVectorIndividual i = (LongVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j] == i.genome[j]) continue;
            return false;
        }
        return true;
    }

    public Object getGenome() {
        return this.genome;
    }

    public void setGenome(Object gen) {
        this.genome = (long[])gen;
    }

    public int genomeLength() {
        return this.genome.length;
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            dataOutput.writeLong(this.genome[x]);
        }
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new long[len];
        }
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = dataInput.readLong();
        }
    }

    public void clamp() {
        IntegerVectorSpecies _species = (IntegerVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            long minGene = _species.minGene(i);
            if (this.genome[i] < minGene) {
                this.genome[i] = minGene;
                continue;
            }
            long maxGene = _species.maxGene(i);
            if (this.genome[i] <= maxGene) continue;
            this.genome[i] = maxGene;
        }
    }

    public void setGenomeLength(int len) {
        long[] newGenome;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new long[len]).length ? this.genome.length : newGenome.length);
        this.genome = newGenome;
    }

    public boolean isInRange() {
        IntegerVectorSpecies _species = (IntegerVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            if (this.genome[i] >= _species.minGene(i) && this.genome[i] <= _species.maxGene(i)) continue;
            return false;
        }
        return true;
    }

    public double distanceTo(Individual otherInd) {
        if (!(otherInd instanceof LongVectorIndividual)) {
            return super.distanceTo(otherInd);
        }
        LongVectorIndividual other = (LongVectorIndividual)otherInd;
        long[] otherGenome = other.genome;
        double sumSquaredDistance = 0.0;
        for (int i = 0; i < other.genomeLength(); ++i) {
            double dist = (double)this.genome[i] - (double)otherGenome[i];
            sumSquaredDistance += dist * dist;
        }
        return StrictMath.sqrt(sumSquaredDistance);
    }
}

